/* Ngpaint Version 1.0
 * 
 * For Details look at 
 * http://www.geocities.com/SiliconValley/2926/txt/NGpaint.html
 *
 * 
 * ----------------------------------------
 * Sep 28 1999  - josef.chmel@gmx.de
 *
 * Initialization.
 * Sorry no comments in the moment.
 * Any suggestions, improvements or
 * some simpler code -> send it to me :-)
 * ----------------------------------------
 * Oct 01 1999 - josef.chmel@gmx.de
 * - error mailed from Frederic:
 *   In Ngtext.writeText() added an forgotten semicolon (;) for text export
 * 
 * - polylines implemented
 *
 * - error with negative coordinate corrected. See Ngparser.java
 * 
 * - drawing the width of lines changed. Now symmetric to the middle.
 *
 * - changed the ascii-output for negative coordinates.
 *
 * -> Version 0.9.1   
 * ----------------------------------------
 * Dec 06 1999 - josef.chmel@gmx.de
 * - Grid functionality
 * - Different font size: small, medium, large.
 * - Graphics for all buttons
 * - by import of NG-Text, delete the graphic at first
 * - Add after NG-Text the hint for newsgroups handling.
 *
 * -> Version 1.0
 * ----------------------------------------
 */

import java.lang.*;
import java.applet.*;
import java.awt.*;
import java.util.*;

//****************************************
public class Ngpaint extends Applet {    

    public TextArea textarea;
    public Panel ptop,  pcenter, pleft, pdraw;
    public GraphicButton gb;

    public java.util.Vector ngobjects;
        
    TextField textfield;

    public void init() {

	ngobjects = new java.util.Vector(100, 100);    

	this.setBackground(Color.lightGray);          
 	this.setFont(new Font("Courier", Font.PLAIN, 12));
 
	// Layout Manager
	this.setLayout(new BorderLayout(5, 5));

	textfield = new TextField(20);
	ptop = new Toolbar2(this, textfield);
	add("North", ptop);

	pleft = new Panel();
	add("West",pleft);
	pleft.add(new Toolbar1(this));
	
 	pcenter = new Panel();
	pcenter.setLayout(new BorderLayout());
	this.add("Center", pcenter);
	
	pdraw = new DrawPanel(textfield, ngobjects);
	pcenter.add("Center", pdraw);
	
	textarea = new TextArea();
	textarea.setText(Ngconst.startMessage);
	textarea.setFont(new Font("Courier", Font.PLAIN, 12));
	textarea.setEditable(true);
	pcenter.add("South", textarea);

	Ngconst.gridWidth = 0;
    }

    public void CmdText() {
	StringBuffer str = new StringBuffer();
        for(int i=0; i<ngobjects.size(); i++) {
	    ((Ngobject)ngobjects.elementAt(i)).writeText(str);
	}
	str.append(Ngconst.NGHint);
        textarea.setText(str.toString());
    }
 
    public void CmdGraphic() {
	// at first delete the elements, dont't add
	// the text elements as in version 0.9
	ngobjects.removeAllElements();
	String sourceText = textarea.getText();
        Ngparser parser = new Ngparser(sourceText, ngobjects);
        parser.parse();
        ( (DrawPanel) pdraw).refresh(); 	    
    }
    
    public void CmdAscii() {
	char asciiArea[][] = new char[Ngconst.ASCII_ROW][Ngconst.ASCII_COLUMN];
	StringBuffer str = new StringBuffer();

	// fill all with Blanks
	for(int i=0; i<asciiArea.length;i++)
	    for(int j=0; j<asciiArea[i].length; j++)
		asciiArea[i][j] = ' ';
	    
	//   all elements
	for(int i=0; i<ngobjects.size(); i++) {
	    ((Ngobject)ngobjects.elementAt(i)).writeAscii(asciiArea);
	}

	// text as last
	// ...

	// output
	for(int i=0; i<asciiArea.length;i++) {
	    str.append(new String(asciiArea[i]));
	    str.append("\n");
	}	    
	textarea.setText(str.toString());
    }

    public void CmdClear() {
	ngobjects.removeAllElements();
	( (DrawPanel) pdraw).refresh();	    
    }

    public void CmdRefresh() {
	( (DrawPanel) pdraw).refresh();
    }

    public void paint(Graphics g) {
	( (DrawPanel) pdraw).refresh();	
    }

    public void start() {
	( (DrawPanel) pdraw).refresh();	
    }


}


/*
 * The Draw Area
 */
//****************************************
class DrawPanel extends Panel {
    int last_x, last_y, last_drag_x, last_drag_y;
    Canvas canvas;
    Scrollbar hbar, vbar;
    int off_x, off_y;
    int canvas_width, canvas_height;
    
    TextField textfield;
    java.util.Vector ngobjects;

    Ngobject selected=null;
    Ngpolyline polyline=null;

    public DrawPanel(TextField tf, java.util.Vector ngobjects) {
	textfield = tf;
	this.ngobjects = ngobjects;
	setLayout(new BorderLayout(0, 0));
	canvas = new Canvas();
	hbar = new Scrollbar(Scrollbar.HORIZONTAL);
	vbar = new Scrollbar(Scrollbar.VERTICAL);
	this.add("Center", canvas);
	this.add("South", hbar);
        this.add("East", vbar);

    }

    public void paint(Graphics g) {
	Polygon p;
	int x[] = new int[4];
	int y[] = new int[4];
	int dx, dy, tan;
	int w=2;
	g = canvas.getGraphics();
        Ngobject ngo;

	// mark paint area
	g.setColor(Color.cyan);
	g.fillRect(-off_x,-off_y,320,200);

        for(int i = 0; i < ngobjects.size(); i++) {
            ngo = (Ngobject) ngobjects.elementAt(i);
	    g.setColor(Color.blue);
	    ngo.draw(g, off_x, off_y);
	}
    }	

    public void refresh() {
	this.update(canvas.getGraphics());	    
    }


    public boolean handleEvent(Event e) {

        if (e.target == hbar) {
            switch(e.id) {
            case Event.SCROLL_LINE_UP:  
            case Event.SCROLL_LINE_DOWN: 
            case Event.SCROLL_PAGE_UP:  
            case Event.SCROLL_PAGE_DOWN: 
            case Event.SCROLL_ABSOLUTE:  
		off_x = ((Integer)e.arg).intValue();    
		break;
            }
            this.update(canvas.getGraphics());
            return true;
        }
        else if (e.target == vbar) {
            switch(e.id) {
            case Event.SCROLL_LINE_UP:  
            case Event.SCROLL_PAGE_UP:  
            case Event.SCROLL_LINE_DOWN: 
            case Event.SCROLL_PAGE_DOWN: 
            case Event.SCROLL_ABSOLUTE:  
                off_y = ((Integer)e.arg).intValue();    
		break;
            }
            this.update(canvas.getGraphics());
            return true;
        }

        // If we didn't handle it above, pass it on to the superclass
        // handleEvent routine, which will check its type and call
        // the mouseDown(), mouseDrag(), and other methods.
        return super.handleEvent(e);
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        // do the real stuff
        super.reshape(x, y, width, height);
 // Update our scrollbar page size
        Dimension hbar_size = hbar.size();
        Dimension vbar_size = vbar.size();
        canvas_width = width-vbar_size.width;
        canvas_height = height-hbar_size.height;
        hbar.setValues(off_x, canvas_width, 0, 600);
        vbar.setValues(off_y, canvas_height, 0, 400);
        hbar.setPageIncrement(canvas_width/2);
        vbar.setPageIncrement(canvas_height/2);
        this.update(canvas.getGraphics());        
    }

       
    public boolean mouseDown(Event e, int x, int y)
     {
	Ngline l;
	Ngobject ngo;

	if(Ngconst.gridWidth != 0) {
	   x = x-x%Ngconst.gridWidth;
	   y = y-y%Ngconst.gridWidth;
	}

	Graphics g = canvas.getGraphics();

	switch (Ngconst.drawMode) {
	case Ngconst.MOVE:
	case Ngconst.DELETE:	    
	    // newer objects first
	    for(int i = ngobjects.size()-1; i>=0; i--) {
		ngo =  (Ngobject) ngobjects.elementAt(i);
		if(ngo.isHit(x+off_x, y+off_y)) {
		    ngo.select(true);
		    selected = ngo;
		    selected.draw(g, off_x, off_y);
		    break;
		}
	    }
	    break;
	case Ngconst.POLYLINE:
	    // new Polyline
	    if(last_x==x && last_y==y) {
		// ok, fini with this polyline 
		if(polyline != null) {
		    ngobjects.addElement(polyline);	    
		    polyline = null;
		    refresh();
		}
	    }
	    else if(polyline==null) {
		polyline = new Ngpolyline(x+off_x, y+off_y, 
					  Ngconst.lineWidth, Color.blue, Ngconst.lineMode);

	    }
		
	    // not ready, add still a line to the polyline
	    else if(polyline != null) {
		polyline.addLine(x+off_x, y+off_y);
		// 		    last_x=x; last_y=y;
	    }
	    break;

	}

	last_x = x; last_y = y;	    
	last_drag_x=x; last_drag_y=y;

        return true;
    }

    public boolean mouseUp(Event e, int x, int y)
    {
	Ngobject ngo=null;
	Ngline l;

	if(Ngconst.gridWidth != 0) {
	   x = x-x%Ngconst.gridWidth;
	   y = y-y%Ngconst.gridWidth;
	}
	
        Graphics g = canvas.getGraphics();

	// except for deleting and textinput and polyline, only if the mouse has moved
	if( (last_x != x) || (last_y != y) || 
	    (Ngconst.drawMode==Ngconst.DELETE) ||
	    (Ngconst.drawMode==Ngconst.TEXT) ||
	    (Ngconst.drawMode==Ngconst.POLYLINE)
	    ) {
 	    g.setColor(Color.blue);

	    switch (Ngconst.drawMode) {
	    case Ngconst.ARC:
		ngo = new Ngarc(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, false);
		break;

	    case Ngconst.FILLED_ARC:
		ngo = new Ngarc(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, true);
		break;
 
	    case Ngconst.CIRCLE:
		ngo = new Ngcircle(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, false);
		break;

	    case Ngconst.FILLED_CIRCLE:
		ngo = new Ngcircle(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, true);
		break;

	    case Ngconst.RECT:
		ngo = new Ngrect(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, false);
		break;

	    case Ngconst.TEXT:
		if(textfield.getText().length()>0) {
		    ngo = new Ngtext(x+off_x, y+off_y, 
				     textfield.getText(), Ngconst.lineWidth, Color.blue, Ngconst.fontSize);
		} else {
		    ngo = null;
		}		
		break;

	    case Ngconst.FILLED_RECT:
		ngo = new Ngrect(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, true);
		break;
 
	    case Ngconst.MOVE:
		ngo = null;
		if(selected != null) {
		    selected.move(last_x-x, last_y-y);
		    selected.select(false);
		    selected = null;
		    refresh();
		}
		break;

	    case Ngconst.DELETE:
		ngo = null;
		if(selected != null) {
		    // if cursor has moved, dont delete
		    if( (Math.abs(last_x-x)>2) || (Math.abs(last_y-y)>2) ) {
			selected.select(false);
			selected = null;
		    } else {
			ngobjects.removeElement(selected);
			selected = null;
		    }
		    refresh();
		}
		break;

	    case Ngconst.POLYLINE:
		break;		

	    case Ngconst.LINE:
		//default:
		ngo = new Ngline(last_x+off_x, last_y+off_y, 
				 x+off_x, y+off_y, Ngconst.lineWidth, Color.blue, Ngconst.lineMode);
		refresh();
		break;
	    }

	    if(ngo != null) {
		ngobjects.addElement(ngo);	    
		ngo.draw(g, off_x, off_y);
	    }
	}

	if(selected != null) {
	    selected.select(false);
	    selected.draw(g, off_x, off_y);
	    selected = null;
	}


        return true;
    }


    public boolean mouseDrag(Event e, int x, int y)
    {

	if(Ngconst.gridWidth != 0) {
	   x = x-x%Ngconst.gridWidth;
	   y = y-y%Ngconst.gridWidth;
	}

        Graphics g = canvas.getGraphics();
	g.setColor(Color.blue);
	Color bgcolor = getBackground();

	switch( Ngconst.drawMode ) {
	case Ngconst.MOVE: 	    
	    if(selected != null) {
		selected.move(last_x-x, last_y-y);
		last_x=x; last_y=y;
		repaint();
	    }
	    break;

	case Ngconst.ARC: 
	case Ngconst.FILLED_ARC: 	    
  	    Ngarc.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngarc.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    break;

	case Ngconst.CIRCLE: 
	case Ngconst.FILLED_CIRCLE: 
  	    Ngcircle.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngcircle.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    break;

	case Ngconst.RECT: 
	case Ngconst.FILLED_RECT:
  	    Ngrect.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngrect.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    break;

	case Ngconst.TEXT: 
  	    Ngtext.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngtext.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    break;

	    //case Ngconst.LINE:
	default:
  	    Ngline.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngline.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    break;
	}

	last_drag_x=x; last_drag_y=y;
	
        return true;
    }

    public boolean mouseMove(Event e, int x, int y)
    {
	if(Ngconst.gridWidth != 0) {
	   x = x-x%Ngconst.gridWidth;
	   y = y-y%Ngconst.gridWidth;
	}

        Graphics g = canvas.getGraphics();

	if((Ngconst.drawMode == Ngconst.POLYLINE) &&
	   polyline != null) {
	    g.setColor(Color.blue);
	    Color bgcolor = getBackground();

  	    Ngline.drawXOR(g, bgcolor, last_x, last_y, last_drag_x, last_drag_y);
  	    Ngline.drawXOR(g, bgcolor, last_x, last_y,  x, y);	    
	    
	    last_drag_x=x; last_drag_y=y;
	    
	    return true;
	}
	
	return false;
    }

}

//****************************************
abstract class Ngobject {

    boolean filled = false;
    boolean selected = false;

    public abstract void draw(Graphics g, int off_x, int off_y);
    public abstract boolean isHit(int x1, int y1);
    public abstract void select(boolean sel);
    public abstract void move(int dx, int dy);
    public abstract void writeText(StringBuffer str);
    public abstract void writeAscii(char asciiArea[][]);


    // Calculates Graphic-Coordinates to ASCII-Coordinates
    protected Point GtoA(int x, int y) {
	Point pt; 
	int i, j;

	// graphicsize= 320x200
	// textsize = 55x25
	i = x/Ngconst.ASCII_DX;
	j = y/Ngconst.ASCII_DY;

	// within the range of the array ?
	i = (i>=Ngconst.ASCII_COLUMN) ? Ngconst.ASCII_COLUMN-1 : i;
	i = (i<0) ? 0 : i;
	j = (j>=Ngconst.ASCII_ROW) ? Ngconst.ASCII_ROW-1 : j;
	j = (j<0) ? 0 : j;	

	return new Point(i,j);
    }

    // returns a char 
    protected char getSlopeChar(double tan) {
	if( (Math.abs(tan)>=2) ) 
	    return '|';
	else if( (tan>=-2) && (tan<=-0.5) )  
	    return '\\';
	else if( (tan>=-0.5) && (tan<=0.4) )  
	    return '-';
	else if( (tan>=0.4) && (tan<=2) )
	    return '/';
	else 
	    return '.';
    }
    
}

//****************************************
class Ngarc extends Ngobject {
    public int x1, y1, x2, y2;
    public int width;
    public Color color;
    public int startAngle=0;

    public Ngarc(int x1, int y1, int x2, int y2, int width, Color color, boolean filled) {
        this.x1 = x1; this.y1 = y1; this.x2 = x2; this.y2 = y2;
	this.width=width;
	this.color=color;	
	this.filled = filled;
    }

    public void writeText(StringBuffer str) {
	//A(t/s;0;Xc;Yc;X2;Y2);	
	if(filled) {
	    str.append("A("+width+";1;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
	} else {
	    str.append("A("+width+";0;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
	}
    }

    public void writeAscii(char asciiArea[][]) {
	int i, j, k, w, h, x, y, dx, dy, sx=-1, sy=1;
	double t;

	w = Math.abs(x2-x1);
	h = Math.abs(y2-y1);

	if(w==0 || h==0) return;

	// the center
	x = x1;
	y = y1;

	// 2. Quadrant
	if( (x2<=x1) && (y2<=y1) ) {
	    sx=-1; sy=-1;
	}
	// 3. Quadrant 
	else if ( (x2<=x1) && (y2>=y1) ) {
	    sx=-1; sy=1;
	}
	// 4. Quadrant
	else if ( (x2>=x1) && (y2>=y1) ) {
	    sx=1; sy=1;
	}
	// 1. Quadrant
	else {
	    sx=1; sy=-1;
	}

// 	for(k=0; k<w; k+=1) {
// 	    dy = (int) (((double)sy*h/w)*Math.sqrt(w*w-k*k));
	
	for(t=0.0; t<1.58; t+=0.01) {
	    dx = (int) (w*Math.cos(t));
	    dy = (int) (h*Math.sin(t));

	    if( ((x+sx*dx)>=0) && ((y+sy*dy)>=0) ) {
		i = GtoA(x+sx*dx,y+sy*dy).x;
		j = GtoA(x+sx*dx,y+sy*dy).y;
		asciiArea[j][i] = '+';		
	    }    
	}		
    }


    static void drawXOR(Graphics g, Color color, int x1, int y1, int x2, int y2) {

 	g.setXORMode(color);
	drawFullArg(g, Color.blue, x1, y1, x2, y2, 1, 0, 0, false);

    }

    public void draw(Graphics g, int off_x, int off_y) {	
	if(selected) {
	    drawFullArg(g, Color.red, x1, y1, x2, y2, width, off_x, off_y, filled);
	} else {
	    drawFullArg(g, color, x1, y1, x2, y2, width, off_x, off_y, filled);
	}
    }

    private static void drawFullArg(Graphics g, Color color, int x1, int y1, int x2, int y2,
				    int width, int off_x, int off_y, boolean filled) {

	int w, h, arcAngle=90, startAngle=0;
	
	g.setColor(color);		
 
	// 2. Quadrant
	if( (x2<=x1) && (y2<=y1) ) {
	    startAngle = 90;
	}
	// 3. Quadrant 
	else if ( (x2<=x1) && (y2>=y1) ) {
	    startAngle = 180;
	}
	// 4. Quadrant
	else if ( (x2>=x1) && (y2>=y1) ) {
	    startAngle =270;
	}
	// 1. Quadrant
	else {
	    startAngle = 0;
	}

	w = Math.abs(x2-x1);
	h = Math.abs(y2-y1);

	if(filled) {
	    g.fillArc(x1-w-off_x, y1-off_y-h, 
		       2*w, 2*h, startAngle, arcAngle);	

	} else {
	    for(int i=0; i<width; i++) {
		g.drawArc(x1-w+i-off_x, y1-off_y-h+i, 
			  2*w-2*i, 2*h-2*i, startAngle, arcAngle);	
	    }
	}
    }

    public boolean isHit(int xx1, int yy1) {
	Polygon p = new Polygon();
	    
	p.addPoint(x1, y1);
	p.addPoint(x1, y2);
	p.addPoint(x2, y2);
	p.addPoint(x2, y1);
	
	if( p.inside(xx1,yy1) ) {
	    return true;
	}
	
	return false;
    }

    public void select(boolean sel) {
	selected = sel;
    }

    public void move(int dx, int dy) {
	x1 -= dx;
	y1 -= dy;
	x2 -= dx;
	y2 -= dy;
    }

}


//****************************************
class Ngcircle extends Ngobject {
    public int x1, y1, x2, y2;
    public int width;
    public Color color;

    public Ngcircle(int x1, int y1, int x2, int y2, int width, Color color, boolean filled) {
        this.x1 = (x1<x2) ? x1 : x2; 
	this.y1 = (y1<y2) ? y1 : y2; 
	this.x2 = (x1<x2) ? x2 : x1; 
	this.y2 = (y1<y2) ? y2 : y1;

	this.width=width;
	this.color=color;	
	this.filled = filled;
    }

    public void writeText(StringBuffer str) {
	// E(t/s;F;X1;Y1;X2;Y2) 
	if(filled) {
	    str.append("E("+width+";F;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
	} else {
	    str.append("E("+width+";E;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 	    
	}
    }

    public void writeAscii(char asciiArea[][]) {
	int i, j, k, w, h, x, y, dx, dy, di, dj;
	double t;

	char c = '*';

	w = Math.abs(x2-x1)/2;
	h = Math.abs(y2-y1)/2;

	if(w==0 || h==0) return;

	// the center left
	x = x1+w; 
	y = y1+h;

	for(t=0.0; t<1.58; t+=0.01) {
	    dx = (int) (w*Math.cos(t));
	    dy = (int) (h*Math.sin(t));
	    
	    if( ((x+dx)>=0) && ((y+dy)>=0) ) {
		i = GtoA(x+dx, y+dy).x;
		j = GtoA(x+dx, y+dy).y;
		asciiArea[j][i] = c;		    
	    }

	    if( ((x+dx)>=0) && ((y-dy)>=0) ) {
		i = GtoA(x+dx, y+dy).x;
		j = GtoA(x+dx, y-dy).y;
		asciiArea[j][i] = c;		    
	    }

	    if( ((x-dx)>=0) && ((y-dy)>=0) ) {
		i = GtoA(x-dx, y-dy).x;
		j = GtoA(x+dx, y-dy).y;
		asciiArea[j][i] = c;		    
	    }

	    if( ((x-dx)>=0) && ((y+dy)>=0) ) {
		i = GtoA(x-dx, y-dy).x;
		j = GtoA(x-dx, y+dy).y;
		asciiArea[j][i] = c;		    
	    }
	}     	
    }


    static void drawXOR(Graphics g, Color color, int x1, int y1, int x2, int y2) {
	int xx1, xx2, yy1, yy2;

        xx1 = (x1<x2) ? x1 : x2; 
	yy1 = (y1<y2) ? y1 : y2; 
	xx2 = (x1<x2) ? x2 : x1; 
	yy2 = (y1<y2) ? y2 : y1;


 	g.setXORMode(color);
	g.drawOval(xx1, yy1, xx2-xx1, yy2-yy1);	
    }

    public void draw(Graphics g, int off_x, int off_y) {	

	if(selected) {
	    g.setColor(Color.red);
	}


	if(filled) {
	    g.fillOval(x1-off_x, y1-off_y, 
		       x2-x1, y2-y1);	

	} else {
	    for(int i=0; i<width; i++) {
		g.drawOval(x1-off_x+i, y1-off_y+i, 
			   x2-x1-2*i, y2-y1-2*i);	
	    }
	}
    }


    public boolean isHit(int xx1, int yy1) {
	Polygon p = new Polygon();
	    
	p.addPoint(x1-1, y1-1);
	p.addPoint(x1-1, y2+1);
	p.addPoint(x2+1, y2+1);
	p.addPoint(x2+1, y1-1);
	
	if( p.inside(xx1,yy1) ) {
	    return true;
	}
	
	return false;
    }

    public void select(boolean sel) {
	selected = sel;
    }

    public void move(int dx, int dy) {
	x1 -= dx;
	y1 -= dy;
	x2 -= dx;
	y2 -= dy;
    }

}


//****************************************
class Ngrect extends Ngobject {
    public int x1, y1, x2, y2;
    public int width;
    public Color color;

    public Ngrect(int x1, int y1, int x2, int y2, int width, Color color, boolean filled) {
        this.x1 = (x1<x2) ? x1 : x2; 
	this.y1 = (y1<y2) ? y1 : y2; 
	this.x2 = (x1<x2) ? x2 : x1; 
	this.y2 = (y1<y2) ? y2 : y1;
	this.width=width;
	this.color=color;	
	this.filled = filled;
    }

    public void writeText(StringBuffer str) {
	// R(t/s;F;X1;Y1;X2;Y2) 
	if(filled) {
	    str.append("R("+width+";F;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
	} else {
	    str.append("R("+width+";E;"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
	}
    }

    public void writeAscii(char asciiArea[][]) {
	int i, j, w, h, x, y;

	w =  x2-x1;
	h =  y2-y1;

	// horizontal Lines
	for(i=0; i<w; i+=Ngconst.ASCII_DX) {
	    if( ((x1+i)>=0) && (y1>=0)) {
		x = GtoA(x1+i,y1).x;
		y = GtoA(x1+i,y1).y;
		asciiArea[y][x] = '-';
	    }
	    if( ((x1+i)>=0) && (y2>=0)) {
		x = GtoA(x1+i,y1).x;
		y = GtoA(x1+i,y2).y;
		asciiArea[y][x] = '-';
	    }
	}

	// vertical Lines
	for(i=0; i<h; i+=Ngconst.ASCII_DY) {
	    if( ((x1)>=0) && ((y1+i)>=0)) {
		x = GtoA(x1,y1+i).x;
		y = GtoA(x1,y1+i).y;
		asciiArea[y][x] = '|';
	    }
	    if( ((x2)>=0) && ((y1+i)>=0)) {
		x = GtoA(x2,y1+i).x;
		y = GtoA(x1,y1+i).y;
		asciiArea[y][x] = '|';
	    }
	}


	
    }


    static void drawXOR(Graphics g, Color color, int x1, int y1, int x2, int y2) {
	int xx1, xx2, yy1, yy2;

        xx1 = (x1<x2) ? x1 : x2; 
	yy1 = (y1<y2) ? y1 : y2; 
	xx2 = (x1<x2) ? x2 : x1; 
	yy2 = (y1<y2) ? y2 : y1;

 	g.setXORMode(color);
	g.drawRect(xx1, yy1, xx2-xx1, yy2-yy1);	
    }


    public void draw(Graphics g, int off_x, int off_y) {	
	if(selected) {
	    g.setColor(Color.red);
	}

	if(filled) {
	    g.fillRect(x1-off_x, y1-off_y, 
		       x2-x1, y2-y1);	
	} else {
	    for(int i=0; i<width; i++) {
		g.drawRect(x1-off_x+i, y1-off_y+i, 
			   x2-x1-2*i, y2-y1-2*i);	
	    }
	}
    }

    public boolean isHit(int xx1, int yy1) {
	Polygon p = new Polygon();
	    
	p.addPoint(x1-1, y1-1);
	p.addPoint(x1-1, y2+1);
	p.addPoint(x2+1, y2+1);
	p.addPoint(x2+1, y1-1);
	
	if( p.inside(xx1,yy1) ) {
	    return true;
	}
	
	return false;
    }


    public void select(boolean sel) {
	selected = sel;
    }

    public void move(int dx, int dy) {
	x1 -= dx;
	y1 -= dy;
	x2 -= dx;
	y2 -= dy;
    }

}

//****************************************
class Ngpolyline extends Ngobject {
    public Vector lines;
    public int width;
    public Color color;

    public int style=Ngconst.LINE_NORMAL;

    private int xstart, ystart;

    public Ngpolyline(Vector points, int width, Color color, int style) {
	Point pt1, pt2;
	this.width=width;
	this.color=color;
	this.style=style;

	lines = new Vector(2);

	for(int i=0; i<points.size()-1; i++) {
	    pt1 = (Point)points.elementAt(i);
	    pt2 = (Point)points.elementAt(i+1);

	    lines.addElement(new Ngline(pt1.x, pt1.y, pt2.x, pt2.y, width, color, style) );
	}	
    }

    public Ngpolyline(int x1, int y1, int x2, int y2, int width, Color color, int style) {
	Point pt1, pt2;
	this.width=width;
	this.color=color;
	this.style=style;
	
	lines = new Vector(2);

	lines.addElement(new Ngline(x1, y1, x2, y2, width, color, style) );
    }

    // for a polyline, with one point
    public Ngpolyline(int x, int y, int width, Color color, int style) {
	this.width=width;
	this.color=color;
	this.style=style;
	xstart = x;
	ystart = y;
	lines = new Vector(2);

    }

    public void addLine(int x, int y) {
	Ngline line;
	
	// there are already lines
	if(lines.size()>0) {
	    line = (Ngline)lines.lastElement();
	    lines.addElement(new Ngline(line.x2, line.y2, x, y, width, color, style));
	}
	// the second point -> create the first line
	else {
	    lines.addElement(new Ngline(xstart, ystart, x, y, width, color, style));	    
	}
	
    }


    public void draw(Graphics g, int off_x, int off_y)
    {
	for(int i=0; i<lines.size(); i++) {
	    ((Ngline)lines.elementAt(i)).draw(g, off_x, off_y);
	}
    }

    public boolean isHit(int x1, int y1)
    {
	for(int i=0; i<lines.size(); i++) {
	    if(((Ngline)lines.elementAt(i)).isHit(x1, y1)) {
		return true;
	    }
	}
	return false;
    }

    public void select(boolean sel)
    {
	for(int i=0; i<lines.size(); i++) {
	    ((Ngline)lines.elementAt(i)).select(sel);
	}

    }

    public void move(int dx, int dy)
    {
	for(int i=0; i<lines.size(); i++) {
	    ((Ngline)lines.elementAt(i)).move(dx, dy);
	}

    }

    public void writeText(StringBuffer str)
    {
	Ngline l=null;

	// L(t/s;X1;Y1;X2;Y2;X3;Y3...) 
	String styleText = ""+width;           // ???
	
	if(style==Ngconst.LINE_DASH) styleText="DS";
	if(style==Ngconst.LINE_DOT) styleText="DT";
	if(style==Ngconst.LINE_DASHDOT) styleText="DD";	
	
 	str.append("L("+styleText); 
	
	for(int i=0; i<lines.size(); i++) {
	    l = (Ngline)lines.elementAt(i);
	    str.append(";"+l.x1+";"+l.y1); 
	}
	if(l != null) {
	    str.append(";"+l.x2+";"+l.y2);
	}
 	str.append(")\n"); 

    }

    public void writeAscii(char asciiArea[][])
    {
	for(int i=0; i<lines.size(); i++) {
	    ((Ngline)lines.elementAt(i)).writeAscii(asciiArea);
	}	
    }   

}

//****************************************
class Ngline extends Ngobject {
    public int x1, y1, x2, y2;
    public int width;
    public Color color;

    public int style=Ngconst.LINE_NORMAL;


    public Ngline(int x1, int y1, int x2, int y2, int width, Color color, int style) {
	this.x1 = x1; this.y1 = y1; this.x2 = x2; this.y2 = y2;
	if(style != Ngconst.LINE_NORMAL) {
	    this.width=1;
	} else {
	    this.width=width;
	}
	this.color=color;
	this.style=style;
    }


    public void writeText(StringBuffer str) {
	// L(t/s;X1;Y1;X2;Y2;X3;Y3...) 
	String styleText = ""+width;           // ???

	if(style==Ngconst.LINE_DASH) styleText="DS";
	if(style==Ngconst.LINE_DOT) styleText="DT";
	if(style==Ngconst.LINE_DASHDOT) styleText="DD";	

 	str.append("L("+styleText+";"+x1+";"+y1+";"+x2+";"+y2+")\n"); 
    }

    public void writeAscii(char asciiArea[][]) {
	double  dx, dy, l, tan;
	int n, xx1, yy1, xx2, yy2, w,h;

	w =  x2-x1;
	h =  y2-y1;
		
	// slope
	tan = (w==0) ? 1000 : ((double)-h/w);
	
	char c = getSlopeChar(tan);

	l =  Math.sqrt(w*w+h*h);
	n =  (int) l/(Ngconst.ASCII_DX);
	n = (n>0) ? n : 1;

	// with normal integer, to large error
	dx = ((double) w)/n;
	dy = ((double) h)/n;

	if( ((x1)>=0) && ((y1)>=0) ) {
	    asciiArea[GtoA(x1, y1).y][GtoA(x1, y1).x] = '-';	
	}

	for(int i=0; i<n; i++) {
	    xx1 = (int)(dx*i+x1);	
	    yy1 = (int)(dy*i+y1);
	    if( ((xx1)>=0) && ((yy1)>=0) ) {
		asciiArea[GtoA(xx1, yy1).y][GtoA(xx1, yy1).x] = c;	
	    }
	}	
	
    }


    public void draw(Graphics g, int off_x, int off_y) {	
	int dx, dy, w, h, sw, sh;

	w = (x2-x1);
	h = y2-y1;

	sw = (w<0) ? -1 : 1;
	sh = (h<0) ? -1 : 1;

	if(selected) {
	    g.setColor(Color.red);
	}

	
 	for(int i=0; i<=width/2; i++) {	    

	    dx = (int) ((i*h)/Math.sqrt(w*w+h*h)+sh*0.5);
	    dy = (int) ((i*w)/Math.sqrt(w*w+h*h)+sw*0.5);

	    switch(style) {
	    case Ngconst.LINE_DASH:
		drawDash(g, 10, x1-off_x-dx, y1-off_y+dy, 
			   x1-off_x-dx+w, y1-off_y+dy+h);
		if( (i!=width/2) || (width%2==1)) {
		    drawDash(g, 10, x1-off_x+dx, y1-off_y-dy, 
			     x1-off_x+dx+w, y1-off_y-dy+h);
		}
		break;
	    case Ngconst.LINE_DASHDOT:
		drawDashDot(g, 10, x1-off_x-dx, y1-off_y+dy, 
			   x1-off_x-dx+w, y1-off_y+dy+h);
		if( (i!=width/2) || (width%2==1)) {
		    drawDashDot(g, 10, x1-off_x+dx, y1-off_y-dy, 
				x1-off_x+dx+w, y1-off_y-dy+h);
		}
		break;
	    case Ngconst.LINE_DOT:
		drawDash(g, 3, x1-off_x-dx, y1-off_y+dy, 
			   x1-off_x-dx+w, y1-off_y+dy+h);
		if( (i!=width/2) || (width%2==1)) {
		    drawDash(g, 3, x1-off_x+dx, y1-off_y-dy, 
			     x1-off_x+dx+w, y1-off_y-dy+h);
		}
 		break;
	    case Ngconst.LINE_NORMAL:		
	    default:
		g.drawLine(x1-off_x-dx, y1-off_y+dy, 
			   x1-off_x-dx+w, y1-off_y+dy+h);
		if( (i!=width/2) || (width%2==1)) {
		    g.drawLine(x1-off_x+dx, y1-off_y-dy, 
			       x1-off_x+dx+w, y1-off_y-dy+h);
		}
		break;
	    }
	}
    }

    static void drawXOR(Graphics g, Color color, int x1, int y1, int x2, int y2) {
 	g.setXORMode(color);
	g.drawLine(x1, y1, x2, y2);	
    }

    private void drawDash(Graphics g, int dash, int x1, int y1, int x2, int y2) {
	double  dx, dy, l;
	int n, xx1, yy1, xx2, yy2, w,h;

	w =  x2-x1;
	h =  y2-y1;

	l =  Math.sqrt(w*w+h*h);
	n =  (int) l/(dash+width);
	n = (n>0) ? n : 1;

	// with normal integer, to large error
	dx = ((double) w)/n;
	dy = ((double) h)/n;

	for(int i=0; i<n; i+=2) {
	    xx1 = (int)(dx*i+x1);	yy1 = (int)(dy*i+y1);
	    xx2 = (int)(dx*(i+1)+x1); yy2 = (int)(dy*(i+1)+y1);
	    g.drawLine(xx1, yy1, xx2, yy2);
	}	
    }

    private void drawDashDot(Graphics g, int dash, int x1, int y1, int x2, int y2) {
	double  dx, dy, l;
	int n, xx1, yy1, xx2, yy2, w,h;

	w =  x2-x1;
	h =  y2-y1;

	l =  Math.sqrt(w*w+h*h);
	n =  (int) l/(dash+width);
	n = (n>0) ? n : 1;

	// with normal integer, to large error
	dx = ((double) w)/n;
	dy = ((double) h)/n;

	for(int i=0; i<n; i++) {
	    if((i%2)==0) {
		xx1 = (int)(dx*i+x1);	yy1 = (int)(dy*i+y1);
		xx2 = (int)(dx*(i+1)+x1); yy2 = (int)(dy*(i+1)+y1);
		g.drawLine(xx1, yy1, xx2, yy2);
	    } else {
		xx1 = (int)(dx*i+0.4*dx+x1);	yy1 = (int)(dy*i+0.4*dy+y1);
		xx2 = (int)(dx*(i+1)-0.4*dx+x1); yy2 = (int)(dy*(i+1)-0.4*dy+y1);
		g.drawLine(xx1, yy1, xx2, yy2);
	    
	    }
	}	
    }



    public boolean isHit(int xx1, int yy1) {
	int dx, dy, w, h;

	w = (x2-x1);
	h = y2-y1;
	
	// for better clicking, greater width
	int lw = (width<5) ? 5 : width;

	dx = (int) (lw*h/Math.sqrt(w*w+h*h));
	dy = (int) (lw*w/Math.sqrt(w*w+h*h));
	
	Polygon p = new Polygon();		

	p.addPoint(x1, y1);
	p.addPoint(x1-dx, y1+dy);
	p.addPoint(x2-dx, y2+dy);
	p.addPoint(x2, y2);
	
	if( p.inside(xx1,yy1) ) {
	    return true;
	}
	
	return false;
    }

    public void select(boolean sel) {
	selected = sel;
    }

    public void move(int dx, int dy) {
	x1 -= dx;
	y1 -= dy;
	x2 -= dx;
	y2 -= dy;
    }

}

//****************************************
class Ngtext extends Ngobject {
    public int x1, y1, x2, y2;
    public int width;
    public Color color;
    public String text;
    public String style;

    public Ngtext(int x1, int y1, String text, int width, Color color, String style) {
        this.x1 = x1;
	this.y1 = y1;
	this.x2 = x1+text.length()*8;
	this.y2 = y1-20;

	this.color=color;	
	this.text=text;
	this.style=style;

	if(style.equalsIgnoreCase("L")) {
	    this.width=16;
	} else if (style.equalsIgnoreCase("S")) {
	    this.width=10;
	} else {
	    this.width=12;
	}

    }

    public void writeText(StringBuffer str) {
	// T(sz;X1;Y1;"text to write")  	
	str.append("T("+style.toUpperCase()+";"+x1+";"+y1+";\""+text+"\")\n"); 
    }

    public void writeAscii(char asciiArea[][]) {
	int i, j, k;
	
	i = GtoA(x1,y1).x;
	j = GtoA(x1,y1).y;	
	for(k=0; k<text.length(); k++) {
	    if((k+i)>=Ngconst.ASCII_COLUMN)  
		break;
	    
	    asciiArea[j][k+i] = text.charAt(k);
	}	
    }


    static void drawXOR(Graphics g, Color color, int x1, int y1, int x2, int y2) {
	// not for text, to complicate in the moment
	
// 	int xx1, xx2, yy1, yy2;

//         xx1 = (x1<x2) ? x1 : x2; 
// 	yy1 = (y1<y2) ? y1 : y2; 
// 	xx2 = (x1<x2) ? x2 : x1; 
// 	yy2 = (y1<y2) ? y2 : y1;


//  	g.setXORMode(color);
// 	g.drawString("static text", xx1, yy1);	
    }

    public void draw(Graphics g, int off_x, int off_y) {	

	if(selected) {
	    g.setColor(Color.red);
	}

	g.setFont(new Font("Courier", Font.PLAIN, width));
	g.drawString(text, x1-off_x, y1-off_y);	
    }


    public boolean isHit(int xx1, int yy1) {
	Polygon p = new Polygon();
		
	p.addPoint(x1, y1);
	p.addPoint(x1, y2);
	p.addPoint(x2, y2);
	p.addPoint(x2, y1);
	
	if( p.inside(xx1,yy1) ) {
	    return true;
	}
	
	return false;
    }

    public void select(boolean sel) {
	selected = sel;
    }

    public void move(int dx, int dy) {
	x1 -= dx;
	y1 -= dy;
	x2 -= dx;
	y2 -= dy;
    }

}

 
//****************************************
class Toolbar1 extends Panel {
    Applet parentApplet;

    GraphicButton gbnormal, gbdummy, gbline, gbdash, gbdot, gbdashdot,
	gbrect, gbfilledrect, gbcircle, gbfilledcircle, gbarc,
	gbfilledarc, gbmove, gbdelete, gbtext, gbpoly, gbgrid;
    
    Choice ChoiceLineWidth;

    GraphicButton group1, group2;
    TextField gridTxt;

     
    // Konstruktor
    public Toolbar1(Applet a) {
	Image img;

	parentApplet =  a;

	setBackground(Color.lightGray);
	//setLayout(new GridLayout(0,2,5,5));	
	setLayout( new GridBagLayout());	

	// Line
 	img = a.getImage( parentApplet.getDocumentBase(),  "line.gif");
	gbline = new GraphicButton(img, "Line", Color.white);
	gbline.tag = Ngconst.LINE;
	gbline.raised=false;
	group2=gbline;
	add(gbline);   
	setMyLayout(this, gbline, 0,0, 1,1);
	

	// Width Compo-Box
	//gbnormal = new GraphicButton(img, "Normal", Color.white);
	ChoiceLineWidth = new Choice();
	for(int i=1; i<11; i++) {
	    ChoiceLineWidth.addItem(Integer.toString(i));
	}
	add(ChoiceLineWidth);
	setMyLayout(this, ChoiceLineWidth, 1,0, 1,1);


	// Rectangle
 	img = a.getImage( parentApplet.getDocumentBase(),  "rect.gif");
	gbrect = new GraphicButton(img, "Rect", Color.white);
	gbrect.tag = Ngconst.RECT;
	add(gbrect);   
	setMyLayout(this, gbrect, 0,1, 1,1);


	//  filled Rectangle
 	img = a.getImage( parentApplet.getDocumentBase(),  "fillrect.gif");
	gbfilledrect = new GraphicButton(img, "F. R.", Color.white);
	gbfilledrect.tag = Ngconst.FILLED_RECT;
	add(gbfilledrect);   
	setMyLayout(this, gbfilledrect, 1,1, 1,1);

	// Text
 	img = a.getImage( parentApplet.getDocumentBase(),  "text.gif");
	gbtext = new GraphicButton(img, "Text", Color.white);
	gbtext.tag = Ngconst.TEXT;
	add(gbtext);   
	setMyLayout(this, gbtext, 0,2, 1,1);


	// Polyline
 	img = a.getImage( parentApplet.getDocumentBase(),  "poly.gif");
	gbpoly = new GraphicButton(img, "Poly", Color.white);
	gbpoly.tag = Ngconst.POLYLINE;
	add(gbpoly);  
	setMyLayout(this, gbpoly, 1,2, 1,1);

	// Circle 
 	img = a.getImage( parentApplet.getDocumentBase(),  "circle.gif");
	gbcircle = new GraphicButton(img, "Circle", Color.white);
	gbcircle.tag = Ngconst.CIRCLE;
	add(gbcircle);   
	setMyLayout(this, gbcircle, 0,3, 1,1);


	// filled Circle
 	img = a.getImage( parentApplet.getDocumentBase(),  "fillcircle.gif");
	gbfilledcircle = new GraphicButton(img, "F. C.", Color.white);
	gbfilledcircle.tag = Ngconst.FILLED_CIRCLE;
	add(gbfilledcircle);   
	setMyLayout(this, gbfilledcircle, 1,3, 1,1);
	
	// Arc
 	img = a.getImage( parentApplet.getDocumentBase(),  "arc.gif");
	gbarc = new GraphicButton(img, "Arc", Color.white);
	gbarc.tag = Ngconst.ARC;
	add(gbarc);   
	setMyLayout(this, gbarc, 0,4, 1,1);


	// filled Arc
 	img = a.getImage( parentApplet.getDocumentBase(),  "fillarc.gif");
	gbfilledarc = new GraphicButton(img, "F. A.", Color.white);
	gbfilledarc.tag = Ngconst.FILLED_ARC;
	add(gbfilledarc);   
	setMyLayout(this, gbfilledarc, 1,4, 1,1);

	// Normale Line
 	img = a.getImage( parentApplet.getDocumentBase(),  "solid.gif");
	gbnormal = new GraphicButton(img, "Normal", Color.white);	
	gbnormal.tag = Ngconst.LINE_NORMAL;
	gbnormal.raised=false;
	group1=gbnormal;
	add(gbnormal);   
	setMyLayout(this, gbnormal, 0,5, 1,1);

	//----Line dash 
 	img = a.getImage( parentApplet.getDocumentBase(),  "dash.gif");
	gbdash = new GraphicButton(img, "Dash", Color.white);
	gbdash.tag = Ngconst.LINE_DASH;
	add(gbdash);   
	setMyLayout(this, gbdash, 1,5, 1,1);

	//--- Line dot
 	img = a.getImage( parentApplet.getDocumentBase(),  "dot.gif");
	gbdot = new GraphicButton(img, "Dot", Color.white);
	gbdot.tag = Ngconst.LINE_DOT;
	add(gbdot);   
	setMyLayout(this, gbdot, 0,6, 1,1);

	//-.-. Line dashdot
 	img = a.getImage( parentApplet.getDocumentBase(),  "dashdot.gif");
	gbdashdot = new GraphicButton(img, "DashDot", Color.white);
	gbdashdot.tag = Ngconst.LINE_DASHDOT;
	add(gbdashdot);   
	setMyLayout(this, gbdashdot, 1,6, 1,1);

	// Grid
 	img = a.getImage( parentApplet.getDocumentBase(),  "grid.gif");
	gbgrid = new GraphicButton(img, "Grid", Color.white);
	gbgrid.tag = Ngconst.GRID;
	add(gbgrid);   
	setMyLayout(this, gbgrid, 0,7, 1,1);

	// Grid Text
	gridTxt = new TextField("10",2);
	add(gridTxt);
	setMyLayout(this, gridTxt, 1,7,1,1);

	// Move
 	img = a.getImage( parentApplet.getDocumentBase(),  "move.gif");
	gbmove = new GraphicButton(img, "Move", Color.white);
	gbmove.tag = Ngconst.MOVE;
	add(gbmove);   
	setMyLayout(this, gbmove, 0,8, 1,1);

	// Delete
 	img = a.getImage( parentApplet.getDocumentBase(),  "delete.gif");
	gbdelete = new GraphicButton(img, "Delete", Color.white);
	gbdelete.tag = Ngconst.DELETE;
	add(gbdelete);   
	setMyLayout(this, gbdelete, 1,8, GridBagConstraints.REMAINDER,GridBagConstraints.REMAINDER);
    }

    static void setMyLayout(Container cont, Object comp, int x, int y, int w, int h) {
	GridBagLayout gbl = (GridBagLayout)cont.getLayout();
	GridBagConstraints c = new GridBagConstraints();

	c.fill = GridBagConstraints.NONE;
	c.gridx = x;
	c.gridy = y;
	c.gridwidth = w;
	c.gridheight = h;
	c.ipadx=3;
	c.ipady=3;
	gbl.setConstraints((Component)comp, c);
    }

 
    public boolean handleEvent(Event e) {
	GraphicButton gb;
	
	if(e.target instanceof GraphicButton) {
	    gb = (GraphicButton) e.target;
	    if(e.id == Event.MOUSE_DOWN) {
		// Gruppe 1
		switch(gb.tag) {
		case Ngconst.LINE_DASH:
		case Ngconst.LINE_DOT:
		case Ngconst.LINE_DASHDOT:
		case Ngconst.LINE_NORMAL:  
		    if(group1!=null) {
			group1.raised = true;
			group1.repaint();
		    }
		    gb.raised=false;
		    group1 = gb;
		    group1.repaint();
		    Ngconst.lineMode = gb.tag;
		    break;
		    
		case Ngconst.LINE:
		case Ngconst.RECT:
		case Ngconst.CIRCLE:
		case Ngconst.ARC:
		case Ngconst.FILLED_RECT:
		case Ngconst.FILLED_CIRCLE:
		case Ngconst.FILLED_ARC:
		case Ngconst.TEXT:
		case Ngconst.MOVE:
		case Ngconst.DELETE:
		case Ngconst.POLYLINE:
		    // Gruppe 2
		    if(group1!=null) {
			group2.raised = true;
			group2.repaint();
 		    }
		    gb.raised=false;
		    group2 = gb;
		    group2.repaint();
		    Ngconst.drawMode = gb.tag;
		    break;
		case Ngconst.GRID:
		    if(gb.raised==false) {
			gb.raised=true;
			Ngconst.gridEnable=false;
			Ngconst.gridWidth=0;
		    } else {
			gb.raised=false;
			Ngconst.gridEnable=true;
			try {
			    Ngconst.gridWidth=Integer.parseInt(gridTxt.getText());
			}
			catch(NumberFormatException e1) {
			    gridTxt.setText("0");
			}
		    }
		    gb.repaint();
		    break;
		}

		return true;
	    }
	    else if(e.id == Event.MOUSE_UP) {		   
		return true;
	    }
	}
	else if (e.target==ChoiceLineWidth) {
	    Ngconst.lineWidth = Integer.parseInt(ChoiceLineWidth.getSelectedItem());
	    return true;

	}
	else if (e.target==gridTxt) {
	    if(e.id == Event.KEY_RELEASE) {
		if(Ngconst.gridEnable) {
		    try {
			Ngconst.gridWidth=Integer.parseInt(gridTxt.getText());
		    }
		    catch(NumberFormatException e1) {
			gridTxt.setText("0");
		    }
		}
	    }
	}

	return super.handleEvent(e);
    }

}

//****************************************
class Toolbar2 extends Panel {
    Applet parentApplet;

    GraphicButton gbGraphic, gbText, gbAscii, gbClear, gbRefresh;
    TextField textfield;
    
    Choice ChoiceFontSize;

     
    // Konstruktor
    public Toolbar2(Applet a, TextField tf) {
	Image img;

	parentApplet =  a;
	textfield = tf;

	setBackground(Color.lightGray);

	// Graphic
 	img = a.getImage( parentApplet.getDocumentBase(),  "graphic.gif");
	gbGraphic = new GraphicButton(img, "Graphic", Color.white);
	gbGraphic.tag = Ngconst.CMD_GRAPHIC;
	gbGraphic.raised=true;
	add(gbGraphic);   	

	// Text
 	img = a.getImage( parentApplet.getDocumentBase(),  "text2.gif");
	gbText = new GraphicButton(img, "Rect", Color.white);
	gbText.tag = Ngconst.CMD_TEXT;
	add(gbText);   	

	//  Ascii
 	img = a.getImage( parentApplet.getDocumentBase(),  "ascii.gif");
	gbAscii = new GraphicButton(img, "F. R.", Color.white);
	gbAscii.tag = Ngconst.CMD_ASCII;
	add(gbAscii);   

	// Refresh
 	img = a.getImage( parentApplet.getDocumentBase(),  "refresh.gif");
	gbRefresh = new GraphicButton(img, "Poly", Color.white);
	gbRefresh.tag = Ngconst.CMD_REFRESH;
	add(gbRefresh);  

	// Clear
 	img = a.getImage( parentApplet.getDocumentBase(),  "clear.gif");
	gbClear = new GraphicButton(img, "Text", Color.white);
	gbClear.tag = Ngconst.CMD_CLEAR;
	add(gbClear);   

	// Input Text
	add(textfield);

	// Font Size Combo Box
	ChoiceFontSize = new Choice();
        ChoiceFontSize.addItem("Small");
        ChoiceFontSize.addItem("Medium");
        ChoiceFontSize.addItem("Large");
	add(ChoiceFontSize);	
	ChoiceFontSize.select(1);

    }

 
    public boolean handleEvent(Event e) {
	GraphicButton gb;
	
	if(e.target instanceof GraphicButton) {
	    gb = (GraphicButton) e.target;
	    if(e.id == Event.MOUSE_DOWN) {
		gb.raised=false;
		gb.repaint();
		return true;
	    }
	    else if(e.id == Event.MOUSE_UP) {
		gb.raised=true;
		gb.repaint();
		switch(gb.tag) {
		case Ngconst.CMD_GRAPHIC:
		    ((Ngpaint)parentApplet).CmdGraphic();
		    break;
		case Ngconst.CMD_TEXT:
		    ((Ngpaint)parentApplet).CmdText();
		    break;
		case Ngconst.CMD_ASCII:
		    ((Ngpaint)parentApplet).CmdAscii();
		    break;
		case Ngconst.CMD_CLEAR:
		    ((Ngpaint)parentApplet).CmdClear();
		    break;
		case Ngconst.CMD_REFRESH:
		    ((Ngpaint)parentApplet).CmdRefresh();
		    break;
		}

		return true;
	    }
	}
	else if (e.target==ChoiceFontSize) {
	    //Ngconst.fontSize = Integer.parseInt(ChoiceFontSize.getSelectedItem());

	    switch(ChoiceFontSize.getSelectedIndex()) {
	    case 0:
		Ngconst.fontSize = "S";
		break;
	    case 1:
		Ngconst.fontSize = "M";
		break;
	    case 2:
		Ngconst.fontSize = "L";
		break;		
	    }


	    return true;

	}

	return super.handleEvent(e);
    }

}

