/* Ngpaint Version 1.0
 * 
 * For Details look at 
 * http://www.geocities.com/SiliconValley/2926/txt/NGpaint.html
 *
 * 
 * ----------------------------------------
 * Sep 28 1999  - josef.chmel@gmx.de
 *
 * Initialization.
 * Sorry no comments in the moment.
 * Look in Ngpaint.java.
 * ----------------------------------------
 * Oct 01 1999 - josef.chmel@gmx.de
 * - reads now the minus sign (-) on numbers too.
 */


import java.awt.*;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.io.IOException;
import java.util.*;

//****************************************
class Ngparser {

    String parseString;
    Vector ngobjects;

    //----------------------------------------
    Ngparser(String parseString, Vector ngobjects) {
	this.parseString = parseString;
	this.ngobjects = ngobjects;
    }

    //----------------------------------------
    public void parse() {
	try {
	    StringBufferInputStream sbis = new StringBufferInputStream(parseString);
	    StreamTokenizer tokens = new StreamTokenizer(sbis);

	    Vector ngtokens = new Vector(10, 10);    	    

	    tokens.resetSyntax();
	    tokens.wordChars('0', '9');        // make digit chars word chars
	    tokens.wordChars('a', 'z');
	    tokens.wordChars('A', 'Z');
	    tokens.wordChars('-', '-');        // sign
	    tokens.eolIsSignificant(true);
	    tokens.quoteChar('"');             // " is quoted string delimiter
	    tokens.whitespaceChars(0, ' ');
	    tokens.lowerCaseMode(true);        // turn tokens to lowercase
	    int c;
	out:
	    while (true) {
		switch (c=tokens.nextToken()) {
		case StreamTokenizer.TT_EOF:
		    break out;
		case StreamTokenizer.TT_EOL:
		    checkTokens(ngtokens);
		    ngtokens.removeAllElements();
		    break;

		case StreamTokenizer.TT_WORD:
		    ngtokens.addElement(new String(tokens.sval));
		    break;

		case '"':
		    ngtokens.addElement(new String(tokens.sval));
		    break;

		default:
		}
	    }
        } catch (IOException e) {
	    e.printStackTrace();
        }


    }


    //----------------------------------------
    boolean checkTokens(Vector ngtokens) {
	String str; 
	
	// minimimum 3 arguments
	if(ngtokens.size()<3) return false;

	str = (String) ngtokens.elementAt(0);
	// Line; Polyline will be converted to many lines
	// L(t/s;X1;Y1;X2;Y2;X3;Y3...) 
	if(str.compareTo("l")==0) {
	    int x1,y1,x2,y2;
	    int width=1;
	    int lineStyle=Ngconst.LINE_NORMAL;

	    try {
		// minimum 6 arguments
		if(ngtokens.size() < 6) {return false;}

		// style: width, ds, dt, dd
		String style = (String)ngtokens.elementAt(1);
		if( (style.compareTo("ds")==0) ) {
		    lineStyle = Ngconst.LINE_DASH;
		}
		else if(style.compareTo("dt")==0) {
		    lineStyle = Ngconst.LINE_DOT;		    
		}
		else if(style.compareTo("dd")==0) {
		    lineStyle = Ngconst.LINE_DASHDOT;		    
		} else {
		    width = Integer.parseInt(style);
		}

		x1= Integer.parseInt((String)ngtokens.elementAt(2));
		y1= Integer.parseInt((String)ngtokens.elementAt(3));
		x2= Integer.parseInt((String)ngtokens.elementAt(4));
		y2= Integer.parseInt((String)ngtokens.elementAt(5));

		// Polyline
		if(ngtokens.size()>7) {
		    // ok, 1. line
		    Ngpolyline poly = new Ngpolyline(x1, y1, x2, y2, width, Color.blue, lineStyle);	    
		    for(int i=6; i<ngtokens.size()-1; i+=2) {
			// more! ok, create n. Line
			x2= Integer.parseInt((String)ngtokens.elementAt(i));
			y2= Integer.parseInt((String)ngtokens.elementAt(i+1));
			poly.addLine(x2, y2);
		    }
		    if(poly != null) {
			ngobjects.addElement(poly);
		    }
		} 
		// normal line
		else {
		    ngobjects.addElement(new Ngline(x1, y1, x2, y2, width, Color.blue, lineStyle));	    
		}

		
	    } catch (NumberFormatException e) {
		return false;
	    }
	}

	// Rect
	// R(t/s;f;X1;Y1;X2;Y2) 	
	else if(str.compareTo("r")==0) {
	    int x1,y1,x2,y2;
	    int width=1;
	    boolean filled=false;

	    try {
		// minimum 7 arguments
		if(ngtokens.size() < 7) {return false;}

		// style: width, ds, dt, dd
		String style = (String)ngtokens.elementAt(1);
		if( (style.compareTo("ds")==0) ||
		    (style.compareTo("dt")==0) ||
		    (style.compareTo("dd")==0) ) {
		    width=1;
		} else {
		    width = Integer.parseInt(style);
		}
		
		if( (((String)ngtokens.elementAt(2)).compareTo("f"))==0) {
		    filled=true;
		}     
		
		x1= Integer.parseInt((String)ngtokens.elementAt(3));
		y1= Integer.parseInt((String)ngtokens.elementAt(4));
		x2= Integer.parseInt((String)ngtokens.elementAt(5));
		y2= Integer.parseInt((String)ngtokens.elementAt(6));
		// ok, create Rect
		ngobjects.addElement(new Ngrect(x1, y1, x2, y2, width, Color.blue, filled));
		
	    } catch (NumberFormatException e) {
		return false;
	    }

	}
	// Ellipse or Circle
// E(t/s;f;X1;Y1;X2;Y2) 
	else if(str.compareTo("e")==0) {
	    int x1,y1,x2,y2;
	    int width=1;
	    boolean filled=false;

	    try {
		// minimum 7 arguments
		if(ngtokens.size() < 7) {return false;}

		// style: width, ds, dt, dd
		String style = (String)ngtokens.elementAt(1);
		if( (style.compareTo("ds")==0) ||
		    (style.compareTo("dt")==0) ||
		    (style.compareTo("dd")==0) ) {
		    width=1;
		} else {
		    width = Integer.parseInt(style);
		}
		
		if( (((String)ngtokens.elementAt(2)).compareTo("f"))==0) {
		    filled=true;
		}     
		
		x1= Integer.parseInt((String)ngtokens.elementAt(3));
		y1= Integer.parseInt((String)ngtokens.elementAt(4));
		x2= Integer.parseInt((String)ngtokens.elementAt(5));
		y2= Integer.parseInt((String)ngtokens.elementAt(6));
		// ok, create Rect
		ngobjects.addElement(new Ngcircle(x1, y1, x2, y2, width, Color.blue, filled));
		
	    } catch (NumberFormatException e) {
		return false;
	    }
	}


	// Arc
	// A(t/s;0;Xc;Yc;X2;Y2); 
	else if(str.compareTo("a")==0) {
	    int x1,y1,x2,y2;
	    int width=1;
	    boolean filled=false;

	    try {
		// minimum 7 arguments
		if(ngtokens.size() < 7) {return false;}

		// style: width, ds, dt, dd
		String style = (String)ngtokens.elementAt(1);
		if( (style.compareTo("ds")==0) ||
		    (style.compareTo("dt")==0) ||
		    (style.compareTo("dd")==0) ) {
		    width=1;
		} else {
		    width = Integer.parseInt(style);
		}
		
		if( (((String)ngtokens.elementAt(2)).compareTo("1"))==0) {
		    filled=true;
		}     
		
		x1= Integer.parseInt((String)ngtokens.elementAt(3));
		y1= Integer.parseInt((String)ngtokens.elementAt(4));
		x2= Integer.parseInt((String)ngtokens.elementAt(5));
		y2= Integer.parseInt((String)ngtokens.elementAt(6));
		// ok, create Rect
		ngobjects.addElement(new Ngarc(x1, y1, x2, y2, width, Color.blue, filled));
		
	    } catch (NumberFormatException e) {
		return false;
	    }

	}


	// Text
	// T(sz;X1;Y1;"text to write") 
	else if(str.compareTo("t")==0) {
	    int x1,y1;
	    int width=1;

	    try {
		// minimum 5 arguments
		if(ngtokens.size() < 5) {return false;}

		String style = (String)ngtokens.elementAt(1);
		x1= Integer.parseInt((String)ngtokens.elementAt(2));
		y1= Integer.parseInt((String)ngtokens.elementAt(3));
		String text = (String)ngtokens.elementAt(4);
		// ok, create Text
		ngobjects.addElement(new Ngtext(x1, y1, text, width, Color.blue, style));
		
	    } catch (NumberFormatException e) {
		return false;
	    }
	}


	return true;
    }

}
