program Calculator (input, output);
{ This program implements a three function calculator that operates on}
{  LargeInts.  This version implements addition only }

uses
  digunit, lrgunit;

const
  Sentinel = '=';     {this character is used to 'quit' the calculator}

type
  OpType = (Plus, Minus, Times, EndSignal);

var
  OldValue, NewValue: LargeInt;
  Op: OpType;

procedure GetOperator (var Op: OpType);
{ Pre: User is ready to enter Op                              }
{ Post: User has entered an appropriate value and Op holds the}
{       corresponding operator                                }

var
  Entry: char;

begin
  write('Enter operator + - * (= to quit): ');
  readln(Entry);
  while not (Entry in ['+', '-', '*', '=']) do
  begin
    writeln('Invalid operator.  Please re-enter');
    readln(Entry);
  end;
  case Entry of
    '+':
      Op := Plus;
    '-':
      Op := Minus;
    '*':
      Op := Times;
    Sentinel:
      Op := EndSignal;
  end;
end;

procedure Perform (Op: Optype; var NewValue: LargeInt;
                   var OldValue: LargeInt);
{ Pre: OldValue and NewValue are initialized;       }
{      Op is a binary operator                      }
{ Post: OldValue contains the result of applying Op }
{       to NewValue and OldValue                    }

begin
  case Op of
    Plus:
      LargeAdd(OldValue, NewValue, OldValue);
    Minus:
      LargeSubtract(OldValue, NewValue, OldValue);
    Times:
      LargeMultiply(OldValue, NewValue, OldValue);
  end;
end;

begin
  LargeConstruct(OldValue);
  LargeConstruct(NewValue);
  write('Enter starting value: ');
  LargeReadln(input, OldValue);
  write('----> ');
  LargeWrite(output, OldValue);
  writeln;
  GetOperator(Op);
  while Op <> EndSignal do
  begin
    write('Enter next value: ');
    LargeReadln(input, NewValue);
    Perform(Op, NewValue, OldValue);
    write('----> ');
    LargeWrite(output, OldValue);
    writeln;
    GetOperator(Op);
  end;
  LargeDestroy(OldValue);
  LargeDestroy(NewValue);
end.