{
  by eric mcdaniel summer '97

  language tp7.0

  lets you tell wether a key is down or not
  with boolean function kbrdobj.down(key#)
  (really you need to specify a variable of kbrdobj)
}

unit kbrd;

interface

uses dos;

type
    kbrdobj=object
       constructor init;
       destructor done;
       function down(b:byte):boolean;
    end;

var
   oldInt9:pointer;
   keys:array[0..255] of boolean;
   e0flag:byte;

implementation

{$f+}
procedure newInt9;interrupt;assembler;
asm
   cli                     {sets if=0 (interupts are disabled)}
   in al,$60               {al=scancode from keyboard port}
   cmp al,$e0              {? al=$e0}
   jne @@setscancode       {jmp if al<>$e0}
   mov [e0flag],128        {eoflag=128}
   mov al,20h              {al=$20}
   out 20h,al              {port[$20]=al (port[$20]=$20)}
   jmp @@exit              {jmp to end of proc}
@@setscancode:
   mov bl,al               {bl=al (bl=scancode)}
   and bl,127              {bl=bl mod 128}
   add bl,[e0flag]         {bl=bl+128}
   xor bh,bh               {bh=0}
   and al,128              {keep break bit, if set}
   xor al,128              {flip bit, 1 means pressed, 0 no}
   rol al,1                {move breakbit to bit 0}
   mov [offset keys+bx],al {keys[bx]=al}
   mov [e0flag],0          {eoflag=0}
   mov al,20h              {al=$20}
   out 20h,al              {port[$20=$20}
@@exit:
   sti                     {sets if=1 (interupts are enabled)}
end;
{$f-}

procedure setnewInt9;
begin
     getintvec($09,oldint9);         {save old int 09h}
     setintvec($09,addr(newint9));   {point to new interupt}
end;

procedure setoldint9;
begin
     setintvec($09,oldint9);         {point back to original interupt}
end;

constructor kbrdobj.init;
begin
     setnewint9;                      {point to new keyboard routine}
     fillchar(keys,256,0);            {clear the keys array}
end;

destructor kbrdobj.done;
begin
     setoldint9;                      {point back to original keyboard routine}
end;

function kbrdobj.down(b:byte):boolean;
begin
     if keys[b] then                  {if key[#] then # is pressed}
        down:=true                    {# refers to scancode}
     else
         down:=false;
end;

end.
