unit GFTXT3;

interface

type txtvideo=^txtv;
     txtv=array[0..64000] of byte;

{ Remove 9 bit from screen chars }
procedure SetCharWidth( hwidth : byte ); 

{ Init Mode }
procedure mode3G;

{ Return to Plain 80x25 }
procedure mode3;

{ Put a colored pixel }
procedure putpx(qx,qy,c:integer);

{ Remove a pixel }
procedure zappx(qx,qy,c:integer);

{ Hide Pixel }
procedure invpx(qx,qy,c:integer);

{ Put Colored pixel in Virtual Buffer }
procedure putpxV(qx,qy,c:integer;v:txtvideo);

{ Get Pixel Color }
function getpx(qx,qy:integer;var c:byte):boolean;

{ Get Pixel Color in Virtual Buffer }
function getpxV(qx,qy:integer;var c:byte;v:txtvideo):boolean;

{ Write a string to screen using TEXT Font stored in mem[ss:oo] }
procedure write3(x,y,c,ss,oo:word;s:string);

{ Write a string to vbuffer using TEXT Font stored in mem[ss:oo] }
procedure write3V(x,y,c,ss,oo:word;s:string;v:txtvideo);

implementation

uses dos;

procedure SetCharWidth( hwidth : byte );

var Regs : Registers;        { Processor registers for interrupt call }
    x    : byte;                        { Value for misc. output reg. }

begin
  if ( hwidth = 8 ) then Regs.BX := $0001     { BH = horiz. direction }
                    else Regs.BX := $0800;     { BL = seq. reg. value }

  x := port[ $3CC ] and not(4+8);                 { Toggle horizontal }
  if ( hwidth = 9 ) then                          { resolution from   }
    x := x or 4;                                  { 720 to 640 pixels }
  port[ $3C2 ] := x;

  Inline($FA);                     {CLI - Toggle sequencer from 8 to 9 pixels }
  portw[ $3C4 ] := $0100;
  portw[ $3C4 ] := $01 + Regs.BL shl 8;
  portw[ $3C4 ] := $0300;
  Inline($FB);  {STI}

  Regs.AX := $1000;
  Regs.BL := $13;
  intr( $10, Regs );
end;

procedure mode3g;
var m,n,sg,off:word;
    map:array[0..4096] of byte;
begin
 asm
  mov ax,3
  int $10
 end;
 SetCharWidth(8);
 m:=0;
 for n:=0 to 255 do
  begin
   map[m]:=n;
   map[m+1]:=n;
   m:=m+16;
  end;
 sg :=seg(map);
 off:=ofs(map[0]);
 asm
  pushf
  push ax
  push bx
  push cx
  push dx
  push bp
  push es
  mov ah,$11
  mov al,$0
  mov es,sg
  mov bp,off
  mov cx,256
  mov dx,0
  mov bl,0
  mov bh,16
  int $10
  pop es
  pop bp
  pop dx
  pop cx
  pop bx
  pop ax
  popf
 end;
 port[$3d4]:=9;        { Change }
 port[$3d5]:=64;       { Char Size to 1 & 400 lines }
 port[$3ce]:=6;        { Change }
 port[$3cf]:=6;        { to $0A000 for 64K video }
 fillchar(mem[$a000:0],64000,0);
 
end;

procedure mode3;
begin
 asm
  mov ax,3
  int $10
 end;
end;

procedure putpx(qx,qy,c:integer);
{ when color is 255 the procedure dont change present color }
var x,y,b,p,pb:integer;
begin
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=mem[$a000:x*2+y*160];
 if (p and pb)<>pb then p:=p+pb;
  if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160]:=p;
 if (c<>255) then
  if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160+1]:=c;
end;

procedure zappx(qx,qy,c:integer);
{ when color is 255 the procedure dont change present color }
var x,y,b,p,pb:integer;
begin
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=mem[$a000:x*2+y*160];
 if (p and pb)=pb then p:=p-pb;
 if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160]:=p;
 if (c<>255) then
  if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160+1]:=c;
end;

procedure invpx(qx,qy,c:integer);
{ when color is 255 the procedure dont change present color }
var x,y,b,p,pb:integer;
begin
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=mem[$a000:x*2+y*160];
 if (p and pb)=pb then p:=p-pb else p:=p+pb;
 if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160]:=p;
 if (c<>255) then
  if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then
mem[$a000:x*2+y*160+1]:=c;
end;


procedure putpxV(qx,qy,c:integer;v:txtvideo);
{ when color is 255 the procedure dont change present color }
var x,y,b,p,pb:integer;
begin
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=v^[x*2+y*160];
 if (p and pb)<>pb then p:=p+pb;
 if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then v^[x*2+y*160]:=p;
 if (c<>255) then
  if ((qx>=0) and (qx<640) and (qy>=0) and (qy<400)) then v^[x*2+y*160+1]:=c;
end;


function getpx(qx,qy:integer;var c:byte):boolean;
var x,y,b,p,pb:integer;
begin
 getpx:=false;
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=mem[$a000:x*2+y*160];
 c:=mem[$a000:x*2+y*160+1];
 if (p and pb)=pb then getpx:=true;
end;

function getpxV(qx,qy:integer;var c:byte;v:txtvideo):boolean;
var x,y,b,p,pb:integer;
begin
 getpxV:=false;
 x:=qx div 8;
 b:=qx mod 8;
 y:=qy;
 pb:=1 shl ((8 - b - 1));
 p:=v^[x*2+y*160];
 c:=v^[x*2+y*160+1];
 if (p and pb)=pb then getpxV:=true;
end;

procedure write3(x,y,c,ss,oo:word;s:string);
var n,w:word;
begin
 for n:=1 to length(s) do
  for w:=0 to 15 do
   begin
    mem[$a000:(x+n-1)*2+(y+w)*160]:=mem[ss:oo+(ord(s[n])*16)+w];
    if c<>255 then mem[$a000:(x+n-1)*2+(y+w)*160+1]:=c;
   end;
end;

procedure write3V(x,y,c,ss,oo:word;s:string;v:txtvideo);
var n,w:word;
begin
 for n:=1 to length(s) do
  for w:=0 to 15 do
   begin
    v^[(x+n-1)*2+(y+w)*160]:=mem[ss:oo+(ord(s[n])*16)+w];
    if c<>255 then v^[(x+n-1)*2+(y+w)*160+1]:=c;
   end;
end;

begin
end.

