unit Extens;

interface

function InitExtension : Boolean;
function FinishExtension : Boolean;
function VerifyKey( hId : Integer; key : integer) : Boolean;

implementation

uses SysUtils, WinTypes, WinProcs, Messages,
     icpas , {in 'f:\pascal\icpas.pas',}
     icpasi {in 'f:\pascal\icpasi'};

var
   icp : ICPAS_PICRecord;
   LastKey : integer;
   LastHID : integer;
   afa : ICPAS_TAppFuncArg;
   retRec : ICPAS_TReturnRec;


procedure SendKeyToApp( icp : ICPAS_PICRecord;
                  var pvar : array of ICPAS_StackRec); far;
begin
     PostMessage( LastHID, WM_CHAR, word(pvar[0].i), 0);
end;

function MyErrorFunc( ne : integer) : Boolean; far;
begin
     (* Here we can raise an exception *)
     (* if ne = someError then MyErrorFunc := False;*)
     MyErrorFunc := False;
     Abort;
end;

function InitExtension : Boolean;
begin
     Result := False;
     icp := ICPAS_Init;
     if icp = nil then Exit;

     ICPAS_InstallOnError(icp, MyErrorFunc);

     ICPAS_InstallAppVar(icp, 'lastkey   ', ICPAS_AppConst,
                              ICPAS_AppInteger, @LastKey);

     afa.n := SendKeyToApp;
     ICPAS_InstallAppProcArg( icp,
                              'procedure SendKey(i:integer);',
                              afa);

     ICPAS_CompileFile(icp, 'Extens.mac', 'tmp.err');
     ICPAS_RunInterpret(icp);
     Result := True;
end;

function FinishExtension : Boolean;
begin
     Result := ICPAS_QuitAndFree(icp);
end;

function VerifyKey( hId : Integer; key : integer) : Boolean;
begin
     while LastKey <> 0 do yield;
     LastKey := key;
     LastHID := hId;
     Result := ICPAS_CallFunc(icp, 'verifykey ', retRec);
     LastKey := 0;
end;

initialization
              icp := nil;
              LastKey := 0;
end.
