(*
This is an atempt to make a extension language for Delphi,
searching internet for such program I can't found anithing
for imediate and easy use ( ofcourse that I found TCL, LUA, ...,
but not yet adapted to use in Delphi, if somebody know one please
notyfy me mingole@redestb.es) but I found a program called pascals.pas
writed by Niklaus Wirth in 1976, see below.

(*author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76*)
(* updated 19.3.80, 22.4.81 msp uwa for cs101/200 *)

(*
So I get that file and did some investigation, changes and adaptations
and get a compiler and a interpreter for a subset of pascal language.
I think that it's near what I was looking for:

  - An extension language to embed in Delphi.
  - Reasonable easy to extend.
  - Easy to learn, it's pascal.
  - Full control over the process, full source code.

Ofcourse there are problems and I'm putting it in the net for people that
need it like me and people that can do some work and sugestions to
get it better.

    I'll apreciate sugestions and comments in Portuguese, Spanish or English
my Internet address is  mingole@resdestb.es , in TSTICPAS.PAS file I'll try
to explain how it works.
        The file list is:
            - ICPAS.PAS  : this file contain Interface routines.
            - ICPASI.PAS : this is the Interpret.
            - ICPASC.PAS : the compiler.
            - ICPASH.PAS : the internal header file.
            - PASTST.PAS : a modified version to test the compiler and
                           the interpret.
            - TSTICPAS.PAS : contain an poor example that
                             was compiled in TURBO PASCAL 7 and in
                             Delphi 1.0.
            - PASCALS.PAS : the original file from Niklaus Wirth,
                            I made some changes to compile it in
                            TURBO PASCAL 7, I include it for people
                            that want to study it and to compare
                            with the actual version.

(*
author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76

Reworked by: Domingo Alvarez Duarte, Madrid - Spain 06.01.97
             mingole@redestb.es

Version : 1.0
*)

unit ICPAS;

{$N+,E+}

interface

const
    ICPAS_AlfaSize      = 10;

type
    ICPAS_TBoolean       = Boolean;
    ICPAS_TChar          = char;
    ICPAS_TString        = string;
    ICPAS_TInteger       = Integer;
    ICPAS_TLongInt       = LongInt;
    ICPAS_TReal          = Double;       {Warning real is a double type}
    ICPAS_TDouble        = Double;       {in this implementation}

    ICPAS_TPBoolean      = ^ICPAS_TBoolean;
    ICPAS_TPChar         = ^ICPAS_TChar;
    ICPAS_TPString       = ^ICPAS_TString;
    ICPAS_TPInteger      = ^ICPAS_TInteger;
    ICPAS_TPLongInt      = ^ICPAS_TLongInt;
    ICPAS_TPReal         = ^ICPAS_TReal;
    ICPAS_TPDouble       = ^ICPAS_TDouble;
    ICPAS_TPText         = ^Text;

    ICPAS_PICRecord      = ^ICPAS_ICRecord;
    ICPAS_ICRecord       = record
                        Status     : integer;
    end;

    ICPAS_TTypes  = ( notyp,ints,longints,doubles,reals,bools,chars,strings,
                      arrays,records,texts (*,labels*));

    ICPAS_STRVar = record
                     needFree: ICPAS_TBoolean;
                     size : Byte;
                     s: ICPAS_TPString;
             end;

    ICPAS_StackRec = record case ICPAS_TTypes of
                  ints     : (i: integer);
                  longints : (l: ICPAS_TLongInt);
                  reals    : (r: ICPAS_TReal);
                  doubles  : (d: ICPAS_TDouble);
                  bools    : (b: ICPAS_TBoolean);
                  chars    : (c: ICPAS_TChar);
                  strings  : (s: ICPAS_STRVar);
                  texts    : (t: ICPAS_TPText);
              end;

    ICPAS_TAppFuncArg = record case ICPAS_TTypes of
                    notyp : ( n : procedure( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec);
                            );
                    bools : ( b : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TBoolean;
                            );
                    chars : ( c : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TChar;
                            );
                    strings : ( s : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TString;
                              );
                    ints : ( i : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TInteger;
                           );
                    longints : ( l : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TLongInt;
                               );
                    reals : ( r : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TReal;
                            );
                    doubles : ( d : function( icp : ICPAS_PICRecord;
                                      var pvar : array of ICPAS_StackRec)
                                      : ICPAS_TDouble;
                              );
    end;

    ICPAS_TPProc         = procedure;
    ICPAS_TPFuncBoolean  = function : ICPAS_TBoolean;
    ICPAS_TPFuncChar     = function : ICPAS_TChar;
    ICPAS_TPFuncString   = function : ICPAS_TString;
    ICPAS_TPFuncInt      = function : ICPAS_TInteger;
    ICPAS_TPFuncLongInt  = function : ICPAS_TLongInt;
    ICPAS_TPFuncReal     = function : ICPAS_TReal;
    ICPAS_TPFuncDouble   = function : ICPAS_TDouble;

    ICPAS_TPFuncOnError  = function(ne : integer) : ICPAS_TBoolean;
    ICPAS_TPFuncGetInputLn   = function( pf : ICPAS_TPText;
                                         var s : string) : ICPAS_TBoolean;
    ICPAS_TPFuncGetInputEof  = function(pf:ICPAS_TPText) : ICPAS_TBoolean;

    ICPAS_TAlfa   = packed array [1..ICPAS_AlfaSize] of char;

    ICPAS_TPReturnRec      = ^ICPAS_TReturnRec;
    ICPAS_TReturnRec      = record
          case typ : ICPAS_TTypes of
               bools    : (b: ICPAS_TBoolean);
               chars    : (c: ICPAS_TChar);
               ints     : (i: ICPAS_TInteger);
               longints : (l: ICPAS_TLongInt);
               reals    : (r: ICPAS_TReal);
               doubles  : (d: ICPAS_TDouble);
               strings  : (s: ICPAS_TString);
    end;

    ICPAS_APPTypes = (
                     ICPAS_AppNoTyp,
                     ICPAS_AppBoolean,
                     ICPAS_AppChar,
                     ICPAS_AppString,
                     ICPAS_AppInteger,
                     ICPAS_AppLongInt,
                     ICPAS_AppDouble
                     );

    ICPAS_APPObjects  = (
                       ICPAS_AppFunc,
                       ICPAS_AppProc,
                       ICPAS_AppVar,
                       ICPAS_AppConst
                       );


function ICPAS_Init : ICPAS_PICRecord;
function ICPAS_QuitAndFree( icp : ICPAS_PICRecord) : Boolean;
function ICPAS_CompileFile( icp : ICPAS_PICRecord;
                            const finput, foutput : string) : Boolean;
function ICPAS_Compile( icp : ICPAS_PICRecord) : Boolean;
function ICPAS_InstallAppVar( icp : ICPAS_PICRecord;
                              const x0 : ICPAS_TAlfa;
                              x1 : ICPAS_AppObjects;
                              x2 : ICPAS_AppTypes;
                              x3 : Pointer) : Boolean;
function ICPAS_InstallOnError( icp : ICPAS_PICRecord;
                               oe : ICPAS_TPFuncOnError) : Pointer;
function ICPAS_DuplicateHandle(icp: ICPAS_PICRecord) : ICPAS_PICRecord;
function ICPAS_InstallGetInputLn( icp : ICPAS_PICRecord;
                               gi : ICPAS_TPFuncGetInputLn) : Pointer;
function ICPAS_InstallGetInputEof( icp : ICPAS_PICRecord;
                               gie : ICPAS_TPFuncGetInputEof) : Pointer;
function ICPAS_InstallAppProcArg( icp: ICPAS_PICRecord;
                               s: string; p: ICPAS_TAppFuncArg) : Boolean;

implementation

uses ICPASH, ICPASC, ICPASI;

const
    ICPAS_AppToTypes: array [0..6] of ICPAS_TTypes =
                     (
                     notyp,     (*ICPAS_AppNoTyp*)
                     bools,     (*ICPAS_AppBoolean*)
                     chars,     (*ICPAS_AppChar*)
                     strings,   (*ICPAS_AppString*)
                     ints,      (*ICPAS_AppInteger*)
                     longInts,  (*ICPAS_AppLongInt*)
                     doubles    (*ICPAS_AppDouble*)
                     );

    ICPAS_AppToObjects: array [0..3] of ICPAS_TObject =
                        (
                        appfunc,        (*ICPAS_AppFunc*)
                        appproc,        (*ICPAS_AppProc*)
                        appvar,         (*ICPAS_AppVar*)
                        appconst        (*ICPAS_AppConst*)
                        );

function ICPAS_InstallAppProcArg( icp: ICPAS_PICRecord;
                               s: string; p: ICPAS_TAppFuncArg) : Boolean;
label
     InstallOk, InstallFail;
var
   picp : ICPAS_PICPrivateRecord;
   ad, ab : integer;
   it, it2 : ICPAS_IdTab;
begin
     if icp = nil then ICPAS_InstallAppProcArg := False
     else
     begin
          picp := ICPAS_PICPrivateRecord(icp);
          with picp^ do
          begin
               ICPAS_InstallAppProcArg := True;
               InAppDeclaration := 1;
               ad := IdxIdTab;
               ab := IdxBlockTab; (* for error to return old value *)
               it := PIdTab^[ad];
               it2 := PIdTab^[ad-1]; {this symbol is altered in block}
               PBlockTab^[1].last := PIdTab^[IdxIdTab].link;
               IdxIdTab := IdxIdTab -1;
               ll := length(s);
               cc := 0;
               InputLine := s;
               block( picp, blockbegsys+statbegsys, apptype,
                      ICPAS_ProgramLevel);
               PBlockTab^[IdxBlockTab-1] := PBlockTab^[IdxBlockTab];
               PIdTab^[ad-1] := it2; {this symbol is altered in block}
               Dec(IdxBlockTab);
               with PIdTab^[ad] do
               begin
                    ptr := @p.n;
                    normal := FromAppTrue;
                    ref := IdxBlockTab;
                    lev := 0;
                    if obj = funktion then obj := AppFuncArg
                    else obj := AppProcArg;
               end;

               Inc(IdxIdTab);
               if IdxIdTab >= (PIdTabSize -2) then GrowIdTab(picp);
               PIdTab^[IdxIdTab] := it;
               PIdTab^[IdxIdTab].link := ad;
               PrgBlkStart := IdxBlockTab + 1;
               with PBlockTab^[1] do
               begin
                    last := IdxIdTab; lastpar := 1;
                    psize := 0; vsize := 0
               end ;

               if errs <> [] then goto InstallOk;
InstallFail:
               ICPAS_InstallAppProcArg := False;
               IdxIdTab := ad;
               PIdTab^[ad] := it;
               PIdTab^[ad-1] := it2; {this symbol is altered in block}
               PBlockTab^[1].last := ad;
InstallOk:
               ch := ' ';
               ll := 0;
               cc := 0;
               InAppDeclaration := 0;
          end;
     end;
end;

function ICPAS_DuplicateHandle(icp: ICPAS_PICRecord) : ICPAS_PICRecord;
var
   picps, picpd : ICPAS_PICPrivateRecord;
   sizer, h1, h2 : integer;
   sptr : ICPAS_TPString;
label
     fail;
begin
     ICPAS_DuplicateHandle := nil;
     if (icp = nil) or (MaxAvail < sizeof(ICPAS_ICPrivateRecord)) then Exit;

     picps := ICPAS_PICPrivateRecord(icp);

     GetMem(picpd, sizeof(ICPAS_ICPrivateRecord));
     Move(picps^, picpd^, sizeof(ICPAS_ICPrivateRecord));
     with picpd^ do
     begin
          PIdTab        := nil;
          PArrayTab     := nil;
          PBlockTab     := nil;
          PStringTab    := nil;
          PCodeArray    := nil;
          PNConstArray  := nil;
          iv.stk        := nil;

          PIdTabSize := picps^.PIdTabSize;
          sizer := PIdTabSize * sizeof(ICPAS_IdTab);
          if MaxAvail < sizer then goto fail;
          GetMem(PIdTab, sizer);
          Move(picps^.PIdTab^, PIdTab^, sizer);

          PArrayTabSize := picps^.PArrayTabSize;
          sizer := PArrayTabSize * sizeof(ICPAS_ArrayTab);
          if MaxAvail < sizer then goto fail;
          GetMem(PArrayTab, sizer);
          Move(picps^.PArrayTab^, PArrayTab^, sizer);

          PBlockTabSize := picps^.PBlockTabSize;
          sizer := PBlockTabSize * sizeof(ICPAS_BlockTab);
          if MaxAvail < sizer then goto fail;
          GetMem(PBlockTab, sizer);
          Move(picps^.PBlockTab^, PBlockTab^, sizer);

          PStringTabSize := picps^.PStringTabSize;
          sizer := PStringTabSize * sizeof(char);
          if MaxAvail < sizer then goto fail;
          GetMem(PStringTab, sizer);
          Move(picps^.PStringTab^, PStringTab^, sizer);

          PCodeArraySize := picps^.PCodeArraySize;
          sizer := PCodeArraySize * sizeof(ICPAS_CodeArray);
          if MaxAvail < sizer then goto fail;
          GetMem(PCodeArray, sizer);
          Move(picps^.PCodeArray^, PCodeArray^, sizer);

          PNConstArraySize := picps^.PNConstArraySize;
          sizer := PNConstArraySize * sizeof(ICPAS_TNumConst);
          if MaxAvail < sizer then goto fail;
          GetMem(PNConstArray, sizer);
          Move(picps^.PNConstArray^, PNConstArray^, sizer);

          iv.PStackRecArraySize := picps^.iv.PStackRecArraySize;
          sizer := iv.PStackRecArraySize * Sizeof(ICPAS_StackRec);
          if MaxAvail < sizer then goto fail;
          GetMem(iv.stk, sizer);
          Move(picps^.iv.stk^, iv.stk^, sizer);

          (*Alloc memory for possible strings variables*)
          if iv.tsi > 0 then
          begin
            for h2 := 0 to 1 do {first clean all string variables pointers}
            begin
               for h1 := picps^.PBlockTab^[1].last to picps^.IdxIdTab do
               begin
                    with picps^.PIdTab^[h1] do
                    begin
                         if (typ = strings) and (normal = FromPrgTrue)
                            and (lev = ICPAS_ProgramLevel)
                            and (obj = variable) then
                         begin
                              with picps^.iv.stk^[adr] do
                              begin
                                   if r <> undefVal.r then
                                   begin
                                        if h2 <> 0 then
                                        begin
                                             if MaxAvail < s.size then
                                                goto fail;
                                             GetMem(sptr, s.size);
                                             sptr^ := s.s^;
                                             iv.stk^[adr].s := s;
                                             iv.stk^[adr].s.s := sptr;
                                        end
                                        else iv.stk^[adr].r := undefVal.r;
                                   end;
                              end;
                         end;
                    end;
               end;
            end;
          end;
     end;
     ICPAS_DuplicateHandle := ICPAS_PICRecord(picpd);
     Exit;
fail:
     ICPAS_QuitAndFree(ICPAS_PICRecord(picpd));
end;

function ICPAS_InstallOnError( icp : ICPAS_PICRecord;
                               oe : ICPAS_TPFuncOnError) : Pointer;
begin
     ICPAS_InstallOnError := nil;
     if icp = nil then Exit;
     with ICPAS_PICPrivateRecord(icp)^ do
     begin
          ICPAS_InstallOnError := @AppOnError;
          AppOnError := oe;
     end;
end;

function ICPAS_InstallGetInputLn( icp : ICPAS_PICRecord;
                               gi : ICPAS_TPFuncGetInputLn) : Pointer;
begin
     ICPAS_InstallGetInputLn := nil;
     if icp = nil then Exit;
     with ICPAS_PICPrivateRecord(icp)^ do
     begin
          ICPAS_InstallGetInputLn := @GetInputLn;
          GetInputLn := gi;
     end;
end;

function ICPAS_InstallGetInputEof( icp : ICPAS_PICRecord;
                               gie : ICPAS_TPFuncGetInputEof) : Pointer;
begin
     ICPAS_InstallGetInputEof := nil;
     if icp = nil then Exit;
     with ICPAS_PICPrivateRecord(icp)^ do
     begin
          ICPAS_InstallGetInputEof := @GetInputEof;
          GetInputEof := gie;
     end;
end;

function ICPAS_QuitAndFree( icp : ICPAS_PICRecord) : Boolean;
begin
     if icp = nil then ICPAS_QuitAndFree := False
     else
     begin
          with ICPAS_PICPrivateRecord(icp)^ do
          begin
               (*Free possible strings variables*)
               ICPAS_FreeStringVars(icp);
               {Warning some tabs begin with 0 or 1, attention to free}
               if PIdTab <> nil then
                  FreeMem(PIdTab, PIdTabSize * sizeof(ICPAS_IdTab));
               if PArrayTab <> nil then
                  FreeMem(PArrayTab, PArrayTabSize * sizeof(ICPAS_ArrayTab));
               if PBlockTab <> nil then
                  FreeMem(PBlockTab, PBlockTabSize * sizeof(ICPAS_BlockTab));
               if PStringTab <> nil then
                  FreeMem(PStringTab, PStringTabSize * sizeof(char));
               if PCodeArray <> nil then
                  FreeMem(PCodeArray, PCodeArraySize * sizeof(ICPAS_CodeArray));
               if PNConstArray <> nil then
                  FreeMem(PNConstArray, PNConstArraySize *
                                        sizeof(ICPAS_TNumConst));
               if iv.stk <> nil then
                  FreeMem(iv.stk, iv.PStackRecArraySize *
                                  Sizeof(ICPAS_StackRec));
          end;
          FreeMem(ICPAS_PICPrivateRecord(icp), sizeof(ICPAS_ICPrivateRecord));
          ICPAS_QuitAndFree := True;
     end;
end;

procedure enterBuiltin( picp : ICPAS_PICPrivateRecord);
var
   hix : integer;
begin
     with picp^ do
     begin
          while (IdxIdTab + nStdFunctions) >= (PIdTabSize -2) do
          begin
               GrowIdTab(picp);
               if Status <> 0 then Exit;
          end;
          for hix := 1 to nStdFunctions do
          begin
               IdxIdTab := IdxIdTab+1;   (*enter standard identifier*)
               with PIdTab^[IdxIdTab] do
               begin
                    name := ICPAS_StdFunctions[hix].x0;
                    link := IdxIdTab-1;
                    obj  := ICPAS_StdFunctions[hix].x1;
                    typ  := ICPAS_StdFunctions[hix].x2;
                    ref  := 0; normal := FromPrgTrue;
                    lev  := 0;
                    adr  := ICPAS_StdFunctions[hix].x3;
               end;
          end;
     end;
end (*enter*) ;

function ICPAS_Init : ICPAS_PICRecord;
var
   picp : ICPAS_PICPrivateRecord;
begin
     if MaxAvail < sizeof(ICPAS_ICPrivateRecord) then
        ICPAS_Init := nil
     else
     begin
          GetMem(picp, sizeof(ICPAS_ICPrivateRecord));
          with picp^ do
          begin
               Status := 0;
               WriteOut := False;
               AppOnError := nil;
               GetInputLn := GetInputLine;
               GetInputEof:= InputIsFinished;
               progname := BlankId;

               pinf := @input;
               pinfc := @input;
               poutf := @output;
               pouterr := @output;

               iv.PStackRecArraySize := 0;
               iv.stk := nil;

               PIdTabSize := 0;
               PIdTab := nil;
               GrowIdTab(picp);

               PArrayTabSize := 0;
               PArrayTab := nil;
               GrowArrayTab(picp);

               PBlockTabSize := 0;
               PBlockTab := nil;
               GrowBlockTab(picp);

               PStringTabSize := 0;
               PStringTab := nil;
               GrowStringTab(picp);

               PCodeArraySize := 0;
               PCodeArray := nil;
               GrowCodeArray(picp);

               PNConstArraySize := 0;
               PNConstArray := nil;
               GrowNConstArray(picp);

               constbegsys := [plus,minus,intcon,longintcon,doublecon,
                              realcon,charcon,stringcon,ident];
               typebegsys := [ident,arraysy,recordsy];
               blockbegsys := [constsy,typesy,(*labelsy,*)varsy,proceduresy,
                               functionsy,beginsy];
               facbegsys := [intcon,longintcon,doublecon,realcon,
                            charcon,stringcon,ident,lparent,notsy];
               statbegsys := [beginsy,ifsy,whilesy,repeatsy,forsy,casesy,
                             exitsy,breaksy,continuesy(*,gotosy*)];
               stantyps := [notyp,ints,longints,doubles,reals,bools,
                           chars,strings];
               lc := 0; ll := 0; cc := 0; ch := ' ';
               errpos := 0; errs := errs + [3];
               IdxIdTab := -1; IdxArrayTab := 0; IdxBlockTab := 1;
               IdxStringTab := 0; idxLastNConst := 0;
               display[0] := 1;
               iflag := false; oflag := false; skipflag := false;
               InAppDeclaration := 0;
               PrgBlkStart := 2;

               enterBuiltin(picp);
               if Status <> 0 then
               begin
                    ICPAS_QuitAndFree(ICPAS_PICRecord(picp));
                    ICPAS_Init := nil;
                    Exit;
               end;
               with PBlockTab^[ICPAS_ProgramLevel] do
               begin
                    last := IdxIdTab; lastpar := 1; psize := 0; vsize := 0;
               end ;
               Status := -1;
          end;
          ICPAS_Init := ICPAS_PICRecord(picp);
     end;
end;

function ICPAS_InstallAppVar( icp : ICPAS_PICRecord;
                              const x0 : ICPAS_TAlfa;
                              x1 : ICPAS_AppObjects;
                              x2 : ICPAS_AppTypes;
                              x3 : pointer) : Boolean;
var
   picp : ICPAS_PICPrivateRecord;
begin
     if icp = nil then ICPAS_InstallAppVar := False
     else
     begin
          picp := ICPAS_PICPrivateRecord(icp);
          with picp^ do
          begin
          if IdxIdTab >= (PIdTabSize -2) then GrowIdTab(picp);
          Inc(IdxIdTab);
          PIdTab^[IdxIdTab] := PIdTab^[IdxIdTab-1];
          PIdTab^[idxIdTab].link := IdxIdTab-1;
          with PIdTab^[IdxIdTab-1] do
          begin
               name := x0;
               link := IdxIdTab-2;
               obj := ICPAS_AppToObjects[ord(x1)];
               typ := ICPAS_AppToTypes[ord(x2)];
               ref := 0;
               normal := FromAppTrue;
               lev := 0;
               ptr := x3
          end;
          with PBlockTab^[1] do
          begin
               last := IdxIdTab; lastpar := 1; psize := 0; vsize := 0
          end ;
          end;
          ICPAS_InstallAppVar := True;
     end;
end;

function ICPAS_CompileFile( icp : ICPAS_PICRecord;
                        const finput, foutput : string) : Boolean;
var
   picp : ICPAS_PICPrivateRecord;
begin
     ICPAS_CompileFile := False;
     if icp = nil then Exit;
     picp := ICPAS_PICPrivateRecord(icp);
     with picp^ do
     begin
          WriteOut := False;
          Assign(Input, finput);
          Reset(Input);
          Assign(Output, foutput);
          Rewrite(Output);
          ICPAS_CompileFile := ICPAS_Compile(icp);
     end;
end;

function ICPAS_Compile( icp : ICPAS_PICRecord) : Boolean;
var
   picp : ICPAS_PICPrivateRecord;
begin
 ICPAS_Compile := False;
 if icp = nil then Exit;
 picp := ICPAS_PICPrivateRecord(icp);
 with picp^ do
 begin
     WriteOut := False;

     errs := [];
     Status := 0;

     insymbol(picp);
     if sy <> programsy then error(picp,3)
     else
     begin
          insymbol(picp);
          if id = TestPrgName then
          begin
               WriteOut := True;
               writeln(pouterr^, 'Printing compiler results');
          end;
          if sy <> ident then error(picp,2)
          else
          begin
               progname := id; insymbol(picp);
               if sy <> lparent then error(picp,9)
               else
               repeat
                     insymbol(picp);
                     if sy <> ident then error(picp,2)
                     else
                     begin
                          if id = InputId then iflag := true
                          else if id = OutputId then oflag := true
                                  else error(picp,0);
                          insymbol(picp);
                     end
               until sy <> comma;
               if sy = rparent then insymbol(picp) else error(picp,4);
               if not oflag then error(picp,20)
          end
     end ;

     (* parse prog body *)
     PrgBlkStart := IdxBlockTab + 1;
     block(picp,blockbegsys+statbegsys, progtype, ICPAS_ProgramLevel);

     if sy <> period then error(picp,22);
     emit(picp, PROGEND);  (*halt*)

     if progname = TestPrgName  then
        if WriteOut then  printTables(picp);

     if not (errs = []) then
     begin
          errorMsg(picp);
          errs := errs + [3];
          Status := -1;
          Exit;
     end;
     if WriteOut then writeln(pouterr^);
 ICPAS_Compile := True;
 end;
end;

end.