(*
This is an atempt to make a extension language for Delphi,
searching internet for such program I can't found anithing
for imediate and easy use ( ofcourse that I found TCL, LUA, ...,
but not yet adapted to use in Delphi, if somebody know one please
notyfy me mingole@redestb.es) but I found a program called pascals.pas
writed by Niklaus Wirth in 1976, see below.

(*author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76*)
(* updated 19.3.80, 22.4.81 msp uwa for cs101/200 *)

(*
So I get that file and did some investigation, changes and adaptations
and get a compiler and a interpreter for a subset of pascal language.
I think that it's near what I was looking for:

  - An extension language to embed in Delphi.
  - Reasonable easy to extend.
  - Easy to learn, it's pascal.
  - Full control over the process, full source code.

Ofcourse there are problems and I'm putting it in the net for people that
need it like me and people that can do some work and sugestions to
get it better.

    I'll apreciate sugestions and comments in Portuguese, Spanish or English
my Internet address is  mingole@resdestb.es , in TSTICPAS.PAS file I'll try
to explain how it works.
        The file list is:
            - ICPAS.PAS  : this file contain Interface routines.
            - ICPASI.PAS : this is the Interpret.
            - ICPASC.PAS : the compiler.
            - ICPASH.PAS : the internal header file.
            - PASTST.PAS : a modified version to test the compiler and
                           the interpret.
            - TSTICPAS.PAS : contain an poor example that
                             was compiled in TURBO PASCAL 7 and in
                             Delphi 1.0.
            - PASCALS.PAS : the original file from Niklaus Wirth,
                            I made some changes to compile it in
                            TURBO PASCAL 7, I include it for people
                            that want to study it and to compare
                            with the actual version.

(*
author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76

Reworked by: Domingo Alvarez Duarte, Madrid - Spain 06.01.97
             mingole@redestb.es

Version : 1.0
*)

unit ICPASI;

{$N+,E+}

interface

uses ICPAS, ICPASC;

function ICPAS_RunInterpret(icp : ICPAS_PICRecord) : Boolean;
function ICPAS_CallFunc( icp : ICPAS_PICRecord; const fn : ICPAS_TAlfa;
                         var rr : ICPAS_TReturnRec ) : Boolean;
procedure ICPAS_FreeStringVars(icp : ICPAS_PICRecord);

implementation

uses ICPASH;

const
     (* default field widths for write *)
     fld : array[1..6] of integer =
     (
         10, (*ints*)
         10, (*longints*)
         22, (*reals*)
         22, (*doubles*)
         4,  (*bools*)
         1   (*chars*)
     );

function GrowStack(picp : ICPAS_PICPrivateRecord) : Boolean;
var
   curSize, newSize : integer;
begin
     with picp^, picp^.iv do
     begin
           if PStackRecArraySize = 0 then (*start stack with min size*)
                newSize := (PBlockTab^[PrgBlkStart].vsize + 10) *
                           Sizeof(ICPAS_StackRec)
           else
               newSize := (PStackRecArraySize+ICPAS_StackRecArrayGrowStep) *
                          Sizeof(ICPAS_StackRec);
           curSize := PStackRecArraySize * Sizeof(ICPAS_StackRec);
           if (not ReallocMem(Pointer(stk), curSize, newSize)) or
              ((PStackRecArraySize+ICPAS_StackRecArrayGrowStep) >
              ICPAS_StackRecArrayMaxSize)
              then  GrowStack := False
           else
               GrowStack := True;
               if PStackRecArraySize = 0 then
                  PStackRecArraySize := PBlockTab^[PrgBlkStart].vsize + 10
               else
                   Inc(PStackRecArraySize, ICPAS_StackRecArrayGrowStep);
               stackSize := PStackRecArraySize -2;
               (*to prevent memory overwite in the top of stack*)
     end;
end;

function Interpret(picp : ICPAS_PICPrivateRecord) : Boolean;
  (*global PCodeArray^, PIdTab^, PBlockTab^*)
label
     98;   (*trap label*)
var
      ir: ICPAS_Order;      (*instruction buffer*)
      ps: (fin,run,caschk,divchk,inxchk,stkchk,linchk,lngchk,redchk);
      pcOnStart, lncnt, ocnt, blkcnt, chrcnt: integer;     (*counters*)
      h1,h2,h3,h4: integer;
      sptr : ICPAS_TPString;      (*for string manipulation*)
      strv1, strv2 : ICPAS_STRVar;
      stkv : ICPAS_StackRec;
                (*stk : ICPAS_PStackRecArray *)
                (*blockmark:              *)
                (*   stk[bi+0] = fct result  *)
                (*   stk[bi+1] = return adr  *)
                (*   stk[bi+2] = static link *)
                (*   stk[bi+3] = dynamic link*)
                (*   stk[bi+4] = table index *)

      function NotGrowStack : Boolean;
      begin
           if not GrowStack(picp) then
           begin
                NotGrowStack := True;
                ps := stkchk;
           end
           else NotGrowStack := False;
      end;

      procedure FreeStrVar( strv : ICPAS_STRVar);
      begin
           if strv.needFree then FreeMem(strv.s, strv.size);
      end;

      procedure FreeProcStrVar;
      var
         hix : Integer;
      begin
        with picp^, picp^.iv do
        begin
           if ir.y < IdxIdTab then
           begin
                h1 := PIdTab^[ir.y].lev+1;
                for hix := ir.y+1 to IdxIdTab do
                begin
                     with PIdTab^[hix] do
                     begin
                          if lev <> h1 then break;
                          if (typ = strings) and (obj = variable)
                             and (normal = FromPrgTrue) then
                          begin
                               with stk^[bi+adr].s do
                               begin
                                    if s <> nil then
                                       FreeMem(s, size);
                               end;
                          end;
                     end;
                end;
           end;
        end;
      end;

begin (*interpret*)
 with picp^, picp^.iv do
 begin
  bi := 0; display[1] := 0;
  ps := run;
  pcOnStart := pc; lncnt := 0; ocnt := 0; chrcnt := 0;

  repeat ir := PCodeArray^[pc]; Inc(pc); Inc(ocnt);
    case ir.f of
  ARGBYADDRESS: begin (*load address*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       stk^[tsi].i := display[ir.x] + ir.y
     end ;
  ARGBYVALUE: begin (*load value*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       stk^[tsi] := stk^[display[ir.x] + ir.y]
     end ;
  STRARGBYVALUE: begin (*load value*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       with stk^[display[ir.x] + ir.y].s do
       begin
            sptr := s;
            h1 := size;
       end;
       {Warning memory not available}
       with stk^[tsi].s do
       begin
            GetMem(s, h1);
            size := h1;
            Move(sptr^, s^, size);
            needFree := False;
       end;
     end ;
  APPARGBYADDRESS: begin (*load address*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       stk^[tsi].i := ir.y;
     end ;
  LOADINDIRECT: begin (*load indirect*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       stk^[tsi] := stk^[stk^[display[ir.x] + ir.y].i]
     end ;
  UPDDISPLAY: begin (*update display*)
       h1 := ir.y; h2 := ir.x; h3 := bi;
       repeat display[h1] := h3; Dec(h1); h3 := stk^[h3+2].i
       until h1 = h2
     end ;
  BUILTINFCT: case ir.y of
      0: stk^[tsi].i := abs(stk^[tsi].i);
      1: stk^[tsi].r := abs(stk^[tsi].r);
      2: stk^[tsi].i := sqr(stk^[tsi].i);
      3: stk^[tsi].r := sqr(stk^[tsi].r);
      4: stk^[tsi].b := odd(stk^[tsi].i);
      5: begin (* stk^[tsi].c := chr(stk^[tsi].i); *)
           if (stk^[tsi].i < 0) or (stk^[tsi].i > 256) then ps := inxchk
         end ;
      6: stk^[tsi].i := ord(stk^[tsi].i) ;
      7: stk^[tsi].i := succ(stk^[tsi].i);
      8: stk^[tsi].i := pred(stk^[tsi].i);
      ROUND_FUNCTION: stk^[tsi].i := round(stk^[tsi].r);
     TRUNC_FUNCTION: stk^[tsi].i := trunc(stk^[tsi].r);
     11: stk^[tsi].r := sin(stk^[tsi].r);
     12: stk^[tsi].r := cos(stk^[tsi].r);
     13: stk^[tsi].r := exp(stk^[tsi].r);
     14: stk^[tsi].r := ln(stk^[tsi].r);
     15: stk^[tsi].r := sqrt(stk^[tsi].r);
     16: stk^[tsi].r := arctan(stk^[tsi].r);
     17: begin Inc(tsi);
           if tsi > stacksize then if NotGrowStack then goto 98;
           stk^[tsi].b := eof(pinf^)
         end ;
     18: begin Inc(tsi);
           if tsi > stacksize then if NotGrowStack then goto 98;
           stk^[tsi].b := eoln(pinf^)
         end ;
     end ;
 STORESTD: begin (*store*) stk^[stk^[tsi-1].i] := stk^[tsi]; Dec(tsi, 2);
     end ;
 LITERAL: begin (*literal*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       stk^[tsi].i := ir.y
     end ;
 LOADCONST: begin (*load real*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       case ICPAS_TTypes(ir.x) of
         reals,doubles: stk^[tsi].r := PNConstArray^[ir.y].r;
         longints: stk^[tsi].l := PNConstArray^[ir.y].l;
         strings:
                 begin
                      with stk^[tsi].s do
                      begin
                           s := @PStringTab^[ir.y];
                           size := ord(s^[0])+1;
                           needFree := False;
                      end;
                 end;
       end;
     end ;
 APPVARCONST: begin (*load real*) Inc(tsi);
       if tsi > stacksize then if NotGrowStack then goto 98;
       case PIdTab^[ir.y].typ of
         ints: stk^[tsi].i := ICPAS_TPInteger(PIdTab^[ir.y].ptr)^;
         reals,doubles: stk^[tsi].r := ICPAS_TPReal(PIdTab^[ir.y].ptr)^;
         bools: stk^[tsi].b := ICPAS_TPBoolean(PIdTab^[ir.y].ptr)^;
         chars: stk^[tsi].i := ord(ICPAS_TPChar(PIdTab^[ir.y].ptr)^);
         longints: stk^[tsi].l := ICPAS_TPLongInt(PIdTab^[ir.y].ptr)^;
         strings:
           begin
                with stk^[tsi].s do
                begin
                     s := ICPAS_TPString(PIdTAb^[ir.y].ptr);
                     size := ord(s^[0])+1;
                     needFree := False;
                end;
           end;
       end;
     end ;
 INTTOLINT: begin (*longint*) h1 := tsi - ir.y; stk^[h1].l := stk^[h1].i
     end ;
 INTTOFLOAT: begin (*float*) h1 := tsi - ir.y; stk^[h1].r := stk^[h1].i
     end ;
 LINTTOFLOAT: begin (*LONGINT*) h1 := tsi - ir.y; stk^[h1].r := stk^[h1].l
     end ;
 EQLCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i = stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l = stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r = stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              = stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 NEQCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i <> stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l <> stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r <> stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              <> stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 LSSCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i < stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l < stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r < stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              < stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 LEQCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i <= stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l <= stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r <= stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              <= stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 GTRCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i > stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l > stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r > stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              > stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 GEQCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].b := stk^[tsi].i >= stk^[tsi+1].i;
                  longints:      stk^[tsi].b := stk^[tsi].l >= stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].b := stk^[tsi].r >= stk^[tsi+1].r;
                  strings:
                          begin
                               stk^[tsi].b := stk^[tsi].s.s^
                                              >= stk^[tsi+1].s.s^;
                               FreeStrVar(stk^[tsi].s);
                               FreeStrVar(stk^[tsi+1].s);
                          end;
                end;
     end ;
 (*GOTOADR: begin h1 := PIdTab^[ir.y].adr; if h1 <> 0 then pc := h1; end;*)
 JUMP: pc := ir.y;  (*jump*)
 JUMPINDIRECT: pc := PCodeArray^[ir.y].y; (*jump indirect*)
 JUMPCOND: begin (*conditional jump*)
       if not stk^[tsi].b then pc := ir.y;  Dec(tsi);
     end ;
 JUMPSWITCH: begin (*switch*) h1 := stk^[tsi].i; Dec(tsi);
       h2 := ir.y; h3 := 0;
       repeat if PCodeArray^[h2].f <> DONOTHING then
                begin h3 := 1; ps := caschk
                end else
              if PCodeArray^[h2].y = h1 then
                begin h3 := 1; pc := PCodeArray^[h2+1].y
                end else
              Inc(h2, 2);
       until h3 <> 0
     end ;
 FOR1UP: begin (*for1up*) h1 := stk^[tsi-1].i;
       if h1 <= stk^[tsi].i then stk^[stk^[tsi-2].i].i := h1 else
          begin Dec(tsi, 3); pc := ir.y
          end
     end ;
 FOR2UP: begin (*for2up*) h2 := stk^[tsi-2].i; h1 := stk^[h2].i + 1;
       if h1 <= stk^[tsi].i then
         begin stk^[h2].i := h1; pc := ir.y end
       else Dec(tsi, 3);
     end ;
 FOR1DOWN: begin (*for1down*) h1 := stk^[tsi-1].i;
       if h1 >= stk^[tsi].i then stk^[stk^[tsi-2].i].i := h1 else
          begin pc := ir.y; Dec(tsi, 3);
          end
     end ;
 FOR2DOWN: begin (*for2down*) h2 := stk^[tsi-2].i; h1 := stk^[h2].i - 1;
       if h1 >= stk^[tsi].i then
         begin stk^[h2].i := h1; pc := ir.y end
       else Dec(tsi, 3);
     end ;
 BREAKLOOP: begin (*break a loop*)
                 pc := PCodeArray^[ir.y].y;
                 Dec(tsi, 3);
            end;
 MARKSTACK: begin (*mark stack*)  h1 := PBlockTab^[PIdTab^[ir.y].ref].vsize;
       h2 := tsi+h1;
       {Warning }
       if h2 + ICPAS_CallSaveSize > stacksize then
          if NotGrowStack then goto 98;
       Inc(tsi, ICPAS_CallSaveSize);
       stk^[tsi-1].i := h1-1;
       stk^[tsi].i := ir.y;
       for h3 := tsi+1 to h2 do stk^[h3].r := undefval.r;
     end ;
 CALLPROC: begin (*call*) h1 := tsi - ir.y;  (*h1 points to base*)
       h2 := stk^[h1+4].i;            (*h2 points to PIdTab^*)
       h3 := PIdTab^[h2].lev; display[h3+1] := h1;
       h4 := stk^[h1+3].i + h1;
       stk^[h1].r := undefVal.r;
       stk^[h1+1].i := pc; stk^[h1+2].i := display[h3]; stk^[h1+3].i := bi;
       for h3 := tsi+1 to h4 do stk^[h3].r := undefval.r;
       bi := h1; tsi := h4; pc := PIdTab^[h2].adr
     end ;
 CALLAPPPROC:
     begin
          Inc(tsi);
          with PIdTab^[ir.y] do
          begin
            if obj = appproc then
            begin
                 ICPAS_TPProc(ptr);
                 Dec(tsi);
            end
            else
              case typ of
                   ints:  stk^[tsi].i :=
                            ICPAS_TPFuncInt(ptr);
                   reals,doubles: stk^[tsi].r :=
                            ICPAS_TPFuncReal(ptr);
                   bools: stk^[tsi].b :=
                            ICPAS_TPFuncBoolean(ptr);
                   chars: stk^[tsi].i :=
                            ord(ICPAS_TPFuncChar(ptr));
                   longints: stk^[tsi].l :=
                               ICPAS_TPFuncLongInt(ptr);
                   strings:
                     begin
                          {Warning memory not available}
                          GetMem(sptr, 256);
                          sptr^[0] := chr(255);
                          sptr^ := ICPAS_TPFuncString(ptr);
                          {Warning memory not available}
                          with stk^[tsi].s do
                          begin
                               size := ord(sptr^[0])+1;
                               GetMem(s, size);
                               Move(sptr^, s^, size);
                               needFree := True;
                          end;
                          FreeMem(sptr, 256);
                     end;
              end;
          end;
     end;
 CALLAPPPROC2:
     begin
          with PIdTab^[ir.y] do
          begin
               h1 := PBlockTab^[ref].lastpar;
               h2 := h1 - ir.y;
               case obj of
                    AppFuncArg:
                      begin
                           Dec(tsi, h2-1);
                           case typ of
                             ints:  stk^[tsi].i :=
                                    ICPAS_TAppFuncArg(ptr).i
                                    (ICPAS_PICRecord(picp), stk^[tsi]);
                             reals,doubles: stk^[tsi].r :=
                                    ICPAS_TAppFuncArg(ptr).d
                                    (ICPAS_PICRecord(picp), stk^[tsi]);
                             bools: stk^[tsi].b :=
                                    ICPAS_TAppFuncArg(ptr).b
                                    (ICPAS_PICRecord(picp), stk^[tsi]);
                             chars: stk^[tsi].i :=
                                    ord(ICPAS_TAppFuncArg(ptr).c
                                    (ICPAS_PICRecord(picp), stk^[tsi]));
                             longints: stk^[tsi].l :=
                                    ICPAS_TAppFuncArg(ptr).l
                                    (ICPAS_PICRecord(picp), stk^[tsi]);
                             strings:
                               begin
                                    {Warning memory not available}
                                    GetMem(sptr, 256);
                                    sptr^[0] := chr(255);
                                    sptr^ := ICPAS_TAppFuncArg(ptr).s
                                      (ICPAS_PICRecord(picp), stk^[tsi]);
                                    {Warning memory not available}
                                    with stkv.s do
                                    begin
                                         size := ord(sptr^[0])+1;
                                         GetMem(s, size);
                                         Move(sptr^, s^, size);
                                         needFree := True;
                                    end;
                                    FreeMem(sptr, 256);
                               end;
                           end;
                      end;
                    AppProcArg:
                      begin
                           Dec(tsi, h2);
                           ICPAS_TAppFuncArg(ptr).n
                              (ICPAS_PICRecord(picp), stk^[tsi+1]);
                      end;
               end;
              for h3 := ir.y +1 to h1 do
                  if PIdTab^[h3].typ = strings then
                  begin
                       {Warning when the first parameter is string}
                       FreeStrVar(stk^[tsi+(h3-ir.y)].s);
                  end;
              { if the first parameter was string and AppFunc returned
                a string }
              if typ = strings then stk^[tsi] := stkv;
          end;
     end;
 RECFLDSELECTOR: Inc(stk^[tsi].i, ir.y);   (*offset*)
 ARRAYINDEX: begin (*index1*) h1 := ir.y;      (*h1 points to PArrayTab^*)
       h2 := PArrayTab^[h1].low; h3 := stk^[tsi].i;
       if h3 < h2 then ps := inxchk else
       if h3 > PArrayTab^[h1].high then ps := inxchk
       else
       begin
            Dec(tsi);
            if ir.x = 1 then
               Inc(stk^[tsi].i, (h3-h2))
            else
                Inc(stk^[tsi].i, (h3-h2)*PArrayTab^[h1].elsize);
       end
     end ;
 STRINDEX: begin (*index1*) h1 := ir.y;      (*h1 points to strvar*)
       h2 := 1; h3 := stk^[tsi].i;
       if h3 < h2 then ps := inxchk else
       {Warning variable not initialized}
       if (stk^[h1].r = undefVal.r) or (h3 > ord(stk^[h1].s.s^[0])) then
          ps := inxchk
       else
       begin
            Dec(tsi);
            stk^[tsi].i := h3;
       end
     end ;
 APPSTRINDEX: begin (*index1*) h1 := ir.y;      (*h1 points to PidTab*)
       h2 := 0; h3 := stk^[tsi].i;
       if h3 < h2 then ps := inxchk else
       {Warning variable not initialized}
       if (h3 > ord(ICPAS_TPString(PIdTab^[h1].ptr)^[0])) then
          ps := inxchk
       else
       begin
            Dec(tsi);
            stk^[tsi].i := h3;
       end
     end ;
 LOADBLOCK: begin (*load block*) h1 := stk^[tsi].i; Dec(tsi);
       h2 := ir.y + tsi; if h2 > stacksize then if NotGrowStack then goto 98;
       while tsi < h2 do
         begin Inc(tsi); stk^[tsi] := stk^[h1]; Inc(h1)
         end
     end ;
 COPYBLOCK: begin (*copy block*) h1 := stk^[tsi-1].i;
       h2 := stk^[tsi].i; h3 := h1 + ir.y;
       while h1 < h3 do
         begin stk^[h1] := stk^[h2]; Inc(h1); Inc(h2)
         end ;
       Dec(tsi, 2);
     end ;
 PUSHFILEPTR:   (*file pointer for read and write*)
             begin
                  Inc(tsi);
                  if tsi > stacksize then if NotGrowStack then goto 98;
                  if ir.x = 0 then
                  begin
                        stk^[tsi].t := poutf;
                  end
                  else
                  begin
                       stk^[tsi].t := pinf;
                  end;
             end;
 READSTDPROC: begin (*read*)
       if eof(pinf^) then ps := redchk else
       begin
         with stk^[stk^[tsi-1].i] do
         begin
          case ICPAS_TTypes(ir.y) of
           ints: read(stk^[tsi].t^,i);
           longints: read(stk^[tsi].t^,l);
           reals,doubles: read(stk^[tsi].t^,r);
           chars:
                 begin
                      read(stk^[tsi].t^,c);
                      i := ord(c);
                 end;
          strings:
                  begin
                       {Warning memory not available}
                       GetMem(sptr, 256);
                       read(stk^[tsi].t^,sptr^);
                       s.size := ord(sptr^[0])+1;
                       GetMem(s.s, s.size);
                       Move(sptr^, s.s^, s.size);
                       s.needFree := False;
                       FreeMem(sptr, 256);
                  end;
          end ;
         end;
       end;
       Dec(tsi, 2);
     end ;
 WRITESTDPROC: begin (*write string*)
       Inc(chrcnt, stk^[tsi-1].i); if chrcnt > lineleng then ps := lngchk;
       write(stk^[tsi].t^, ICPAS_TPString(@PStringTab^[ir.y-1])^);
       Dec(tsi,2);
     end ;
 WRITE1STDPROC: begin (*write1*)
       if ICPAS_TTypes(ir.y) = strings then
          Inc(chrcnt,length(stk^[tsi-1].s.s^))
       else Inc(chrcnt, fld[ir.y]);
       if chrcnt > lineleng then ps := lngchk else
       begin
         with stk^[tsi-1] do
         begin
            case ICPAS_TTypes(ir.y) of
                 ints: write(stk^[tsi].t^, i: fld[ord(ints)]);
                 longints: write(stk^[tsi].t^, l: fld[ord(longints)]);
                 reals,doubles: write(stk^[tsi].t^, r: fld[ord(reals)]);
                 bools: write(stk^[tsi].t^, b: fld[ord(bools)]);
                 chars: write(stk^[tsi].t^, chr(i (*mod 64*)));
                 strings:
                         begin
                              write(stk^[tsi].t^, s.s^); {Warnign lineleng}
                              FreeStrVar(s);
                         end;
            end ;
         end;
       end;
       Dec(tsi,2);
     end ;
 WRITE2STDPROC: begin (*write2*)
       Inc(chrcnt, stk^[tsi-1].i);
       if chrcnt > lineleng then ps := lngchk else
       begin
         with stk^[tsi-2] do
         begin
            case ICPAS_TTypes(ir.y) of
                 ints: write(stk^[tsi].t^, i: stk^[tsi-1].i);
                 longints: write(stk^[tsi].t^, l: stk^[tsi-1].i);
                 reals,doubles: write(stk^[tsi].t^, r: stk^[tsi-1].i);
                 bools: write(stk^[tsi].t^, b: stk^[tsi-1].i);
                 chars: write(stk^[tsi].t^, i (*mod 64*): stk^[tsi-1].i);
                 strings:
                         begin
                              write(stk^[tsi].t^, s.s^ : stk^[tsi-1].i);
                              {Warnign lineleng}
                              FreeStrVar(s);
                         end;
            end ;
         end;
       end;
       Dec(tsi, 3);
     end ;
 PROGEND: ps := fin;
 EXITPROC: begin (*exit procedure*)
       FreeProcStrVar;
       tsi := bi-1; pc := stk^[bi+1].i; bi := stk^[bi+3].i;
     end ;
 EXITFUNC: begin (*exit function*)
       FreeProcStrVar;
       tsi := bi; pc := stk^[bi+1].i; bi := stk^[bi+3].i;
     end ;
 STDTYPE: stk^[tsi] := stk^[stk^[tsi].i];
 WRITEFMTSTDPROC: begin Inc(chrcnt, stk^[tsi-2].i);
       if chrcnt > lineleng then ps := lngchk else
          write(stk^[tsi].t^, stk^[tsi-3].r: stk^[tsi-2].i: stk^[tsi-1].i);
       Dec(tsi, 4);
     end ;
 STORESTRING: begin (*store*)
              h1 := stk^[tsi-1].i;
              with stk^[h1] do
              begin
                   if (r <> undefval.r) then
                   begin
                        FreeMem(s.s, s.size);
                   end;
              end;
              with stk^[tsi].s do
              begin
                   {Warning memory not available}
                   GetMem(sptr, size);
                   Move(s^, sptr^, size);
                   h2 := size;
                   FreeStrVar(stk^[tsi].s);
              end;
              with stk^[h1].s do
              begin
                   s := sptr;
                   size := h2;
                   if PIdTab^[ir.y].obj = variable then
                      needFree := False
                   else  needFree := True;
              end;
              Dec(tsi, 2);
     end ;
 STOREAPPSTRING: begin (*store*)
                 {Warning application should pass only string[255]}
              ICPAS_TPString(PIdTab^[ir.y].ptr)^ := stk^[tsi].s.s^;
              FreeStrVar(stk^[tsi].s);
              Dec(tsi, 2);
     end ;
 STORESTRCHAR: begin (*store*)
                     stk^[ir.y].s.s^[stk^[tsi-1].i] := chr(stk^[tsi].i);
                     Dec(tsi, 2);
     end ;
 STOREAPPSTRCHAR: begin (*store*)
         ICPAS_TPString(PIdTab^[ir.y].ptr)^[stk^[tsi-1].i] := chr(stk^[tsi].i);
         Dec(tsi, 2);
     end ;
 APPSTORESTD: begin (*store*)
              case PIdTab^[stk^[tsi-1].i].typ of
                ints: ICPAS_TPInteger(PIdTab^[stk^[tsi-1].i].ptr)^ := stk^[tsi].i;
                {Warning app should complain with real and double size}
                reals,doubles:
                    ICPAS_TPReal(PIdTab^[stk^[tsi-1].i].ptr)^ := stk^[tsi].r;
                longints:
                    ICPAS_TPLongInt(PIdTab^[stk^[tsi-1].i].ptr)^ := stk^[tsi].l;
                bools:
                    ICPAS_TPBoolean(PIdTab^[stk^[tsi-1].i].ptr)^ := stk^[tsi].b;
                chars:
                    ICPAS_TPChar(PIdTab^[stk^[tsi-1].i].ptr)^ := chr(stk^[tsi].i);
                strings:
                  begin
                    ICPAS_TPString(PIdTab^[stk^[tsi-1].i].ptr)^ := stk^[tsi].s.s^;
                    FreeStrVar(stk^[tsi].s);
                  end;
              end;
              Dec(tsi, 2);
     end ;
 INVERTSIGN: begin
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].i := - stk^[tsi].i;
                  longints:      stk^[tsi].l := - stk^[tsi].l;
                  reals,doubles: stk^[tsi].r := - stk^[tsi].r;
                end;
     end;
 TIMESCODE: begin
                 Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].i := stk^[tsi].i * stk^[tsi+1].i;
                  longints:      stk^[tsi].l := stk^[tsi].l * stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].r := stk^[tsi].r * stk^[tsi+1].r;
                end;
     end ;
 DIVCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          if stk^[tsi+1].i = 0 then ps := divchk
                                 else
                                     stk^[tsi].i := stk^[tsi].i div stk^[tsi+1].i;
                  longints:      if stk^[tsi+1].l = 0 then ps := divchk
                                 else
                                     stk^[tsi].l := stk^[tsi].l div stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].r := stk^[tsi].r / stk^[tsi+1].r;
                end;
     end ;
 PLUSCODE: begin
                Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].i := stk^[tsi].i + stk^[tsi+1].i;
                  longints:      stk^[tsi].l := stk^[tsi].l + stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].r := stk^[tsi].r + stk^[tsi+1].r;
                  strings:
                    begin
                         h1 := ord(stk^[tsi].s.s^[0]);
                         h2 := ord(stk^[tsi+1].s.s^[0]);
                         h3 := h1 + h2;
                         if h3 > 255 then h3 := 255;
                         {Warning memory not available}
                         GetMem(sptr, h3+1);
                         sptr^[0] := chr(h3);
                         Move( stk^[tsi].s.s^[1], sptr^[1], h1);
                         Move( stk^[tsi+1].s.s^[1], sptr^[h1+1], h3-h1);
                         FreeStrVar(stk^[tsi].s);
                         FreeStrVar(stk^[tsi+1].s);
                         stk^[tsi].s.s := sptr;
                         stk^[tsi].s.size := h3 + 1;
                         stk^[tsi].s.needFree := True;
                    end;
                end;
     end ;
 MINUSCODE: begin
                 Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          stk^[tsi].i := stk^[tsi].i - stk^[tsi+1].i;
                  longints:      stk^[tsi].l := stk^[tsi].l - stk^[tsi+1].l;
                  reals,doubles: stk^[tsi].r := stk^[tsi].r - stk^[tsi+1].r;
                end;
     end ;
 MODCODE: begin
               Dec(tsi);
                case ICPAS_TTypes(ir.y) of
                  ints:          if stk^[tsi+1].i = 0 then ps := divchk
                                 else
                                     stk^[tsi].i := stk^[tsi].i mod stk^[tsi+1].i;
                  longints:      if stk^[tsi+1].l = 0 then ps := divchk
                                 else
                                     stk^[tsi].l := stk^[tsi].l mod stk^[tsi+1].l;
                end;
     end ;
 NOTBOOL: stk^[tsi].b := not stk^[tsi].b;
 ORBOOL: begin Dec(tsi); stk^[tsi].b := stk^[tsi].b or stk^[tsi+1].b
     end ;
 ANDBOOL: begin Dec(tsi); stk^[tsi].b := stk^[tsi].b and stk^[tsi+1].b
     end ;
 READLNSTDPROC:
               begin
                    if eof(stk^[tsi].t^) then  ps := redchk
                    else readln(stk^[tsi].t^);
                    Dec(tsi);
               end;
 WRITELNSTDPROC:
                begin
                     writeln(stk^[tsi].t^) ;
                     Dec(tsi);
                     Inc(lncnt); chrcnt := 0;
                     if lncnt > linelimit then ps := linchk;
     end
    end (*case*) ;
  until ps <> run;

98: if ps <> fin then
  begin
    Interpret := False;
    Status := ord(ps);
    if WriteOut then
    begin
         writeln(pouterr^);
         write(pouterr^,'0halt at', pc:5, ' because of ');
         case ps of
              run:    writeln(pouterr^,'error (see dayfile)');
              caschk: writeln(pouterr^,'undefined case');
              divchk: writeln(pouterr^,'division by 0');
              inxchk: writeln(pouterr^,'invalid index');
              stkchk: writeln(pouterr^,'storage overflow');
              linchk: writeln(pouterr^,'too much output');
              lngchk: writeln(pouterr^,'line too long');
              redchk: writeln(pouterr^,'reading past end of file');
         end ;

         h1 := bi; blkcnt := 10;   (*post mortem dump*)
         repeat
               writeln(pouterr^); blkcnt := blkcnt - 1;
               if blkcnt = 0 then h1 := 0; h2 := stk^[h1+4].i;
               if h1<>0 then
               writeln( pouterr^, ' ', PIdTab^[h2].name, ' called at',
                        stk^[h1+1].i: 5);
               h2 := PBlockTab^[PIdTab^[h2].ref].last;
               while h2 <> 0 do
               with PIdTab^[h2] do
               begin
                    if obj in [variable, appvar] then
                    if typ in stantyps then
                    begin write( pouterr^,'    ', name, ' = ');
                    if normal = FromPrgTrue then
                    h3 := h1+adr else h3 := stk^[h1+adr].i;
                    if stk^[h3].r = undefval.r then
                       writeln( pouterr^,' undefined')
                    else case typ of
                         ints:  writeln( pouterr^,stk^[h3].i);
                         longints:  writeln( pouterr^,stk^[h3].l);
                         reals,doubles: writeln( pouterr^,stk^[h3].r);
                         bools: writeln( pouterr^,stk^[h3].b);
                         chars: writeln( pouterr^,chr(stk^[h3].i (*mod 64*)));
                         strings: writeln( pouterr^,stk^[h3].s.s^);
                         end
                    end ;
                    h2 := link
               end ;
               h1 := stk^[h1+3].i
         until h1 < 0;
    end;
  end
  else  Interpret := True;

  if WriteOut then
  begin
       writeln( pouterr^);
       writeln( pouterr^,ocnt, ' steps')
  end;
 end;
end (*interpret*) ;

procedure ICPAS_FreeStringVars(icp : ICPAS_PICRecord);
var
   h1 : integer;
begin
     with ICPAS_PICPrivateRecord(icp)^, ICPAS_PICPrivateRecord(icp)^.iv do
     begin
          (*Free possible strings variables*)
          if PIdTab = nil then Exit;
          for h1 := PBlockTab^[1].last to IdxIdTab do
          begin
               with PIdTab^[h1] do
               begin
                    if (typ = strings) and (normal = FromPrgTrue)
                       and (lev = ICPAS_ProgramLevel)
                       and (obj = variable) then
                    begin
                         with stk^[adr] do
                         begin
                              if r <> undefVal.r then
                              begin
                                   FreeMem( s.s, s.size);
                                   r := undefVal.r;
                              end;
                         end;
                    end;
               end;
          end;
     end;
end;

function ICPAS_RunInterpret(icp : ICPAS_PICRecord) : Boolean;
var
   picp : ICPAS_PICPrivateRecord;
   h1 : integer;
begin
     ICPAS_RunInterpret := False;
     picp := ICPAS_PICPrivateRecord(icp);
     with picp^, picp^.iv do
     begin
          if Status <> 0 then Exit;
          (*stack initialization*)
          if stk = nil then if not GrowStack(picp) then Exit;
          (*stack initialization*)
          stk^[1].i := 0; stk^[2].i := 0; stk^[3].i := -1;
          stk^[4].i := PBlockTab^[1].last;
          tsi := PBlockTab^[PrgBlkStart].vsize - 1;
          pc := PIdTab^[stk^[4].i].adr;
          for h1:=ICPAS_DxSize to tsi do stk^[h1].r:=undefval.r;

          ICPAS_RunInterpret := Interpret(picp);

          (*Free possible strings variables*)
          ICPAS_FreeStringVars(icp);
     end;
end;

function ICPAS_CallFunc( icp : ICPAS_PICRecord; const fn : ICPAS_TAlfa;
                         var rr : ICPAS_TReturnRec ) : Boolean;
var
   i, x, savelc : integer;
   picp : ICPAS_PICPrivateRecord;

   procedure callFunc;
   begin
        with picp^ do
        begin
             savelc := lc;
             emit1(picp,MARKSTACK, x);
             emit1(picp,CALLPROC, PBlockTab^[PIdTab^[x].ref].psize-1);
             emit(picp,PROGEND);
             lc := savelc;
             iv.pc := lc;
             ICPAS_CallFunc := Interpret(picp);
             if PIdTab^[x].obj = funktion then
             begin
               rr.typ := PIdTab^[x].typ;
               with iv.stk^[iv.tsi] do
               begin
                  case rr.typ of
                       bools : rr.b := b;
                       chars : rr.c := chr(i);
                       ints  : rr.i := i;
                       longints  : rr.l := l;
                       reals  : rr.r := r;
                       doubles  : rr.d := d;
                       strings  :
                                begin
                                     rr.s := s.s^;
                                     if s.needFree then
                                        FreeMem(s.s, s.size);
                                end;
                  end;
               end;
               Dec(iv.tsi);
             end;
        end;
   end;
begin
     ICPAS_CallFunc := False;
     picp := ICPAS_PICPrivateRecord(icp);
     with picp^, picp^.iv do
     begin
          display[ICPAS_ProgramLevel] := PrgBlkStart;
          x := locId(picp, ICPAS_ProgramLevel, fn);
          if x <> 0 then
          begin
               case PIdTab^[x].obj of
                 funktion:
                   begin
                        callFunc;
                   end;
                 prozedure:
                   begin
                        callFunc;
                   end;
               end;
          end;
     end;
end;

end.