{ ************************ DOVENV.PAS *************************

  TDOSEnvironment is a drop in component that gets DOS
  environment variables by name.

  Use it by dropping it on your form. Whenever you want a DOS
  environment variable, simply call the GetVariable function
  by passing the name of the variable in a pascal string to
  the function. The function returns the variable's value
  as a pascal string. If the variable value is longer than
  255 characters, you will get back only the first 255
  characters. If there is no variable by that name, an empty
  string is returned.

  *************************************************************}

unit Dosenv;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TDOSEnvironment = class(TComponent)
  public
    { Public declarations }
    function GetVariable(const VariableName: string): string;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDOSEnvironment]);
end;

function TDOSEnvironment.GetVariable(const VariableName: string): string;
var
  APChar, VPChar: PChar;
begin
  GetMem(VPChar, Length(VariableName) + 1);
  StrPCopy(VPChar, VariableName);
  try
    APChar:=GetDOSEnvironment;
    while not ((APChar^ = #1) or (StrLIComp(APChar, VPChar, (StrScan(APChar, '=') - APChar)) = 0)) do
      Inc(APChar, StrLen(APChar) + 1);
  finally
    FreeMem(VPChar, Length(VariableName) + 1);
  end;
  if APChar^ = #1 then
    Result:=''
  else
    Result:=Copy(StrPas(APChar), (StrScan(APChar, '=') - APChar) + 2, 255);
end;

end.

