program monopoly;

{MOO COW Monopoly - Copyright (1997) MOO COW Inc.  All Rights Reserved}

{Ken Hoetmer}
{R.R.#1
 Alhambra, AB
 T0M 0C0
 CANADA}

{This monopoly game is a copy of the original Parker Bros. Game.  The
programmer reserves the right to leave the country should Parker Brothers
decide to file a $12 million lawsuit.  Any reference to actual street names
is merely coincidental.  This game was created by Ken Hoetmer, any other
version looking vaguely similar to MOO COW Monopoly can and will be sued.
The programmer reserves the right to call upon the MOO COW gods to strike
down any person trying to copy and/or steal the game.  This game is not
the finished version.  You may buy properties and charge rent, but there
are no extra charges for full streets, community chest and chance do not
work, and neither do the tax squares.}

Uses Crt;

const
     b = chr(219);
     l = chr(179);
     playerchar : array[1..2] of char = (chr(2),chr(157));
     d = chr(17);
     e = chr(16);

var
   index,playernum,
   roll,doubles,multiply        : shortint;
   spot,dice,times              : array[1..2] of shortint;
   owner                        : array[1..40] of char;
   c,start                      : char;
   Property                     : array[1..2] of string[30];
   money                        : array[1..2] of longint;
   count,pay                    : longint;
   rent,cost                    : array[1..40] of integer;


{-------------- Procedure Draw Board ----------------------------------}

{This procedure is approximately 456.345322 lines long.  If you get confused
you are not alone.  This procedure will draw the whole game board on the
screen, including all the little colored blocks, the lines, the corners, the
prices, Jail, Free Parking, and anything else that you see on the screen when
the game begins}

Procedure Draw_Board;

Begin

{---- Draw Background and Title Bar --------}

     window (1,1,80,25); textbackground (cyan); clrscr;
     textcolor (Black);
     writeln ('             MOO COW Monopoly - Created by Sir Kenneth Hoetmer');
     window (3,2,70,24); textbackground (white); clrscr;

{---- Draw Black Horizontal and Vertical Lines ---------}

     textcolor (black);
     gotoxy (1,5);
     for index := 17 to 69 do write (chr(196));
     gotoxy (1,19);
     for index := 17 to 69 do write (chr(196));
     index := 16;
     while index < 66 do begin
           index := index + 4;
           gotoxy (index,5); write (chr(193));
           gotoxy (index,19); write (chr(194));
     end;
     for index := 1 to 23 do begin
         gotoxy (16,index); write (l);
         gotoxy (52,index); write (l);
     end;

{------- Write in Corner characters ---------------}

     index := 1;
     while index < 20 do begin
           index := index + 2;
           gotoxy (16,index); write (chr(180));
           gotoxy (52,index); write (chr(195));
     end;
     index := 1;
     while index < 21 do begin
           index := index + 2;
           gotoxy (1,index);  for count := 1 to 15 do write (chr(196));
           gotoxy (53,index); for count := 1 to 16 do write (chr(196));
     end;
     index := 16;
     while index < 51 do begin
           index := index + 4;
           for count := 1 to 4 do begin
               gotoxy (index,count);    write (l);
               gotoxy (index,count+19); write (l);
           end;
     end;
     window (3,2,70,24);
            gotoxy (52,3);  write (chr(195));
            gotoxy (52,21); write (chr(195));
            gotoxy (16,5);  write (chr(197));
            gotoxy (16,19); write (chr(197));
            gotoxy (52,5);  write (chr(197));
            gotoxy (52,19); write (chr(197));

{------- Draw in colored blocks above the Properties --------------}

     window (15,21,55,21);
            textcolor (lightmagenta); write (b,b,b);    {St. Charles Place}
            textcolor (black);    write (l);            {line}
            textcolor (cyan);     write (b,b,b);        {Connecticut Ave}
            textcolor (black);    write (l);
            textcolor (cyan);     write (b,b,b);        {Vermont}
            textcolor (black);    write (l);
            textcolor (red);      write (' ? ');        {Chance}
            textcolor (black);    write (l);
            textcolor (cyan);     write (b,b,b);        {Oriental}
            textcolor (black);    write (l,' ',chr(206),' ',l,'Inc',l);
            textcolor (magenta);  write (b,b,b);        {Baltic}
            textcolor (black);    write (l,'Com',l);    {Community Chest}
            textcolor (magenta);  write (b,b,b);        {Understand Yet?}
            textcolor (black);     write (l);

{-----Draw in Bottom Row Prices, Headings, etc ---------------}

     window (51,24,53,24); textbackground (white); clrscr;
            textcolor (black); write ('60');
     window (43,24,45,24); textbackground (white); clrscr;
            write ('60');
     window (55,23,70,24);
            write ('GO - Collect 200');
     window (9,23,17,23); textbackground (black); clrscr;
            textcolor (white); write ('    Jail');
     window (3,23,8,23); textbackground (white); clrscr;
            textcolor (black); write (' Just');
     window (31,24,39,24); textbackground (white); clrscr;
            write ('100',chr(179),'200',chr(179));
     window (27,22,31,22);
            textcolor (black); write ('Cha',l);
     window (39,22,43,22);
            write ('Tax',l);
     window (47,22,51,22);
            write ('Cst',l);
     window (19,24,27,24); textbackground (white); clrscr;
            write ('120',chr(179),'100',chr(179));
     window (8,24,17,24);
            write ('Visiting');

{----- Draw in Free Parking Window ------------------}

     window (3,2,17,3); textcolor (lightred);
            writeln ('    Free'); write ('   Parking');

{----- Draw in Go to Jail Window ----------------------}

     window (55,2,70,2); textcolor (black);
            write ('   GO to Jail');

{----- Draw in Left side Property windows -------------}

     window (15,17,19,17); textcolor (lightmagenta);
            write (b,b,b);                         {Virginia Avenue}
            textcolor (black); write (l);
     window (15,15,19,15); textcolor (lightmagenta);
            write (b,b,b);                         {States Avenue}
            textcolor (black); write (l);
     window (15,13,17,13); textbackground (white); clrscr;
            write (' ',chr(206));                  {Penn. Railroad}
     window (15,11,19,11); clrscr;
            textcolor (brown); write (b,b,b);      {St. James Place}
            textcolor (black); write (l);
     window (12,9,19,9); clrscr;
            write ('ComCst',l);                    {Guess}
     window (15,5,19,5); clrscr;
            textcolor (brown); write (b,b,b);      {New York Ave.}
            textcolor (black); write (l);
     window (15,7,19,7);
            textcolor (brown); write (b,b,b);      {Tennesee Ave.}
            textcolor (black); write (l);
     window (15,19,17,19); textbackground (white); clrscr;
            textcolor (darkgray); write (' ',chr(234)); {Electric Company}

{----- Draw in Left side Property Prices --------------}

     window (4,5,7,5);
            write ('200');
     window (4,7,7,7);
            write ('180');
     window (4,11,7,11);
            write ('180');
     window (4,13,7,13);
            write ('200');
     window (4,15,7,15);
            write ('160');
     window (4,17,7,17);
            write ('140');
     window (4,19,7,19);
            write ('150');
     window (4,21,7,21);
            write ('140');

{----- Draw in Top Property Blocks, Symbols, etc --------------}

     window (19,5,58,5);
{Kentucky}  textcolor (lightred);   write (b,b,b);
            textcolor (black); write (l);
{Chance}    textcolor (magenta);  write (' ? ');
            textcolor (black); write (l);
{Indiana}   textcolor (lightred);   write (b,b,b);
            textcolor (black); write (l);
{Illinois}  textcolor (lightred);   write (b,b,b);
{B&O RR}    textcolor (black); write (l,' ',chr(206),' ',l);
{Atlantic}  textcolor (yellow);write (b,b,b);
            textcolor (black); write (l);
{Ventnor}   textcolor (yellow);write (b,b,b);
            textcolor (black); write (l);
{WaterWorks}textcolor (blue);  write (' ',chr(226),' ');
            textcolor (black); write (l);
{M.Gardens} textcolor (yellow);write (b,b,b);
            textcolor (black); write (l);
{Pacific}   textcolor (green); write (b,b,b);

{----- Draw in Top Row Prices -----------------------------}

     window (19,2,55,2); textcolor (black);
            write ('220',l,'   ',l,'220',l,'240',l,'200',l,'260',l,'260',
                  l,'150',l,'280',l);

{----- Chance Heading ------------------------}

     window (23,4,27,4);
            write ('Cha');

{----- Draw in Right Side Property Blocks & Symbols ----------------}

     window (55,7,58,7);  textcolor (green);
            write (b,b,b);                    {N.Carolina}
     window (55,9,61,9);  textcolor (black);
            write ('ComCst');                 {Community Chest}
     window (55,11,58,11);textcolor (green);
            write (b,b,b);                    {Pennsylvania Ave.}
     window (55,13,58,13);textcolor (black);
            write (' ',chr(206),' ');         {Short Line}
     window (55,15,61,15);textcolor (brown);
            write (' ? ');                    {Probably Chance}
            textcolor (black); write ('Cha');
     window (55,17,58,17);textcolor (blue);
            write (b,b,b);                    {Park Place}
     window (55,21,58,21);
            write (b,b,b);                    {Boardwalk}
     window (55,19,61,19); textcolor (black);
            write ('LuxTax');                 {Luxury Tax}

{----- Draw in Right Side Prices ------------------------}

     window (67,5,70,5);
            write ('300');
     window (67,7,70,7);
            write ('300');
     window (67,11,70,11);
            write ('320');
     window (67,13,70,13);
            write ('200');
     window (67,17,70,17);
            write ('350');
     window (67,21,70,21);
            write ('400');

{----- Draw in Community Chest Cards --------------------}

     window (21,8,29,12); textcolor (yellow);
            for count := 1 to 18 do write (b);

{---------- Chance Cards -------------------------------}

     window (43,17,51,21);textcolor (red);
            for count := 1 to 18 do write (b);

{---------- Center Text Window ----------------------------}

     window (26,11,47,15); textcolor (black);
            for count := 1 to 21 do write (chr(196));
            gotoxy (1,5);
            for count := 1 to 21 do write (chr(196));
            for count := 2 to 4 do begin
                gotoxy (1,count);
                write (chr(179));
                gotoxy (21,count);
                write (chr(179));
            end;
            gotoxy (1,1);
            write (chr(218));
            gotoxy (1,5); write (chr(192));
            gotoxy (21,5); write (chr(217));
            gotoxy (21,1); write (chr(191));

{-------- Draw in Bottom Command Bar --------------------------}

     window (1,25,80,25);
     textbackground (cyan); clrscr; textcolor (black);
            write ('    F1-Properties   F2-Use Jail Card   F3-Houses   F4-Mortgage');

end;        {Procedure Draw Board}

{------------ Procedure Show Money ----------------------------}

Procedure Show_money;

{This Procedure will draw windows on the right side of the board.
It will display each character's current money}

Begin        {Procedure Show Money}

     textcolor (black);
     window (71,5,80,9);textbackground (cyan); clrscr;
     writeln (' Player 1');
     write ('$',money[1]:8);
     window (71,10,80,14); textbackground (cyan); clrscr;
     writeln (' Player 2');
     write ('$',money[2]:8);

end;         {Procedure Show Money}

{--------- Procedure Spend Money --------------------------------}

Procedure spend_money(var total,spend:longint);

{This Procedure will be called when a player buys property, pays rent,
or has to spend money in any other way.  It will prompt the player to
mortgage if he runs out of money}

begin        {Procedure Spend Money}

     if total > spend then begin
        total := total - spend;
        show_money;
     end

{If out of money then prompt to mortgage}

     else begin
          clrscr;
          writeln('Not Enough Dough');
          write ('Press F4 to mortgage');
          repeat
                c:= readkey;
          until ord(c) = 062;
     end;

end;            {Procedure Spend Money}

{----------- Procedure Set Properties ---------------------------}

Procedure Set_properties;

{This procedure will be called at the start of the program to set
the property owners to zero, and to set the initial costs and rents}

Begin        {Procedure Set Properties}

     for count := 1 to 40 do owner[count] := 'c';
     owner[2] := 'x';    owner[4] := 'x';
     owner[7] := 'x';    owner[10] := 'x';
     owner[17] := 'x';   owner[22] := 'x';
     owner[33] := 'x';   owner[36] := 'x';
     owner[30] := 'x';   owner[38] := 'x';
     owner[20] := 'x';   owner[40] := 'x';
     cost[1] := 60;        cost[3] := 60;
     cost[5] := 200;       cost[6] := 100;
     cost[8] := 100;       cost[9] := 120;
     cost[11] := 140;      cost[12] := 150;
     cost[13] := 140;      cost[14] := 160;
     cost[15] := 200;      cost[16] := 180;
     cost[18] := 180;      cost[19] := 200;
     cost[21] := 220;      cost[23] := 220;
     cost[24] := 240;      cost[25] := 200;
     cost[26] := 260;      cost[27] := 240;
     cost[28] := 150;      cost[29] := 280;
     cost[31] := 300;      cost[32] := 300;
     cost[34] := 320;      cost[35] := 200;
     cost[37] := 350;      cost[39] := 400;
         rent[1] := 2;    rent[3] := 4;
         rent[5] := 25;   rent[6] := 6;
         rent[8] := 6;    rent[9] := 8;
         rent[11]:= 10;   rent[13]:= 10;
         rent[14]:= 12;   rent[15] := 25;
         rent[16]:= 14;   rent[18] := 14;
         rent[19]:= 16;   rent[21] := 18;
         rent[23]:= 18;   rent[24] := 20;
         rent[25] := 25;  rent[26] := 22;
         rent[27] := 22;  rent[29] := 24;
         rent[31] := 26;  rent[32] := 26;
         rent[34] := 28;  rent[35] := 25;
         rent[37] := 35;  rent[39] := 40;

end;         {Procedure Set Properties}

{-------------- Procedure Property Owned ---------------------}

Procedure Property_owned;

{This procedure will be called after every roll to see who owns the property
the player landed on.  If it is unowned, the player will be prompted to buy,
if it's owned by the other player, rent will be paid}

Begin         {Procedure Property Owned}

{------ If the property is unowned then prompt the player to Buy --------}

     if owner[spot[playernum]] = 'c' then begin
        window (27,12,45,14); clrscr;
        if playernum = 1 then textcolor (blue)
        else textcolor (red);
        write (' Unowned Property      F8 to buy      Else press <Enter>');
        repeat
              start := readkey;
        until (start = chr(13)) or (ord(start) = 066);
        if ord(start) = 066 then begin
           owner[spot[playernum]] := chr(playernum+48);
           count := cost[spot[playernum]];
           spend_money(money[playernum],count);
           show_money;
        end;
     end;

{------ If the property is owned by the other player then pay rent ------}

     if playernum = 1 then count := 2
     else count := 1;
     if owner[spot[playernum]] = chr(count+48) then begin

{If the property is Electric Company or Water Works then calculate Rent}

        if (spot[playernum] = 12) or (spot[playernum] = 28) then begin
           if owner[12] = owner[28] then multiply := 10
           else multiply := 4;
           rent[spot[playernum]] := roll * multiply;
        end;
        window (27,12,45,14); clrscr;
        if playernum = 1 then textcolor (blue)
        else textcolor (red);
        write ('Property Owned P-',count);
        write ('   Pay $',rent[spot[playernum]],' Rent');
        write ('       Press <Enter>');
        repeat
              start := readkey;
        until (start = chr(13)) or (ord(start) = 062);
        pay := rent[spot[playernum]];
        spend_money(money[playernum],pay);
        money[count] := money[count] + pay;
        show_money;
     end;

end;            {Procedure Property Owned}

{-------------- Procedure Go to Jail -----------------------------}

Procedure Go_to_Jail;

{This procedure will be called when the player has to go to Jail.
It will draw the player in the jail in blinking font.}

Begin           {Procedure Go to Jail}

     window (9,23,12,23);textbackground (black); clrscr;
     window (10,23,12,23);

{---- Draw if it's player 1 in Jail ------------}

     if playernum = 1 then begin
        if (property[2] = 'Jail') and (property[1] = 'Jail') then begin
           textcolor (red + blink); write (playerchar[2]);
           textcolor (lightblue+ blink); write (playerchar[1]);
        end
        else begin
             if property[1] = 'Jail' then begin
                textcolor (lightblue+blink); write (playerchar[1]);
             end;
             if property[2] = 'Jail' then begin
                textcolor (red+blink); write (playerchar[2]);
             end;
        end;
     end

{------ Draw if it's player 2 in jail ------------}

     else begin
          if (property[1] = 'Jail') and (property[2] = 'Jail') then begin
             textcolor (lightblue+ blink); write (playerchar[1]);
             textcolor (red + blink); write (playerchar[2]);
          end
          else begin
               if property[2] = 'Jail' then begin
                  textcolor (red+blink); write (playerchar[2]);
               end;
               if property[1] = 'Jail' then begin
                  textcolor (lightblue+blink); write (playerchar[1]);
               end;
          end;
     end;
     property[playernum] := 'Jail';

end;       {Procedure Go to Jail}

{------- Procedure Roll Dice ----------------------}

Procedure Roll_dice(r : shortint);

{This procedure will be called on each turn to choose two random numbers that
will simulate a dice roll.  It contains procedures that draw the dots on the
dice.  It will also tell if there is a player in jail, and will prompt him
to either choose to roll or pay $50 to get out of jail.  It will make him
pay $50 if he's been in jail for already three turns}

Label Get_out_of_Jail,Start_Roll;

{------------ Procedure Draw Dice -----------------------}

Procedure draw_dice;

{------------ Procedure Draw 1 --------------------------}

procedure Draw_1;

Begin
     gotoxy (4,2);
     write (d,e);
end;

{----------- Procedure Draw 2 ----------------------------}

Procedure draw_2;

Begin
     gotoxy (2,1); write (d,e);
     gotoxy (6,3); write (d,e);
end;

{----------- Procedure Draw 3 -----------------------------}

Procedure draw_3;

Begin
     gotoxy (2,1); write (d,e);
     gotoxy (6,3); write (d,e);
     gotoxy (4,2); write (d,e);
end;

{---------- Procedure Draw 4 -------------------------------}

Procedure draw_4;

begin
     gotoxy (2,1); write (d,e);
     gotoxy (6,1); write (d,e);
     gotoxy (2,3); write (d,e);
     gotoxy (6,3); write (d,e);
end;

{---------- Procedure Draw 5 -----------------------------------}

Procedure Draw_5;

Begin
     gotoxy (2,1); write (d,e);
     gotoxy (6,1); write (d,e);
     gotoxy (2,3); write (d,e);
     gotoxy (6,3); write (d,e);
     gotoxy (4,2); write (chr(17),chr(16));
end;

{---------- Procedure Draw 6 ------------------------------------}

Procedure draw_6;

Begin
     gotoxy (2,1); write (d,e);
     gotoxy (6,1); write (d,e);
     gotoxy (2,3); write (d,e);
     gotoxy (6,3); write (d,e);
     gotoxy (4,1); write (d,e);
     gotoxy (4,3); write (d,e);
end;

{---------------- Main Procedure Draw Dice --------------------------}

{This procedure is imbedded in the roll dice procedure. It is called to draw
the dice on the screen.  It contains imbedded procedures to draw each of the
possible numbers on the dice.}

Begin              {Procedure Draw Dice}

{--- Draw Dice 1 ---}

     window (27,12,34,14);
     textbackground (black);clrscr;
     textcolor (white);
     case dice[1] of
              1 : draw_1;
              2 : draw_2;
              3 : draw_3;
              4 : draw_4;
              5 : draw_5;
              6 : draw_6;
     end;

{--- Draw Dice 2 ---}

     window (38,12,45,14);
     textbackground (black);clrscr;
     textcolor (white);
     case dice[2] of
              1 : draw_1;
              2 : draw_2;
              3 : draw_3;
              4 : draw_4;
              5 : draw_5;
              6 : draw_6;
     end;
     textbackground (white);

end;                {Procedure Draw Dice}

{----------- Procedure Roll Dice --------------------------------}

Begin                  {Procedure Roll Dice}

Start_Roll:

{----- Write the prompt to Roll - Color Blue - player 1, red - player 2 ---}

      window (27,12,45,14);textbackground (white);clrscr;
      if r = 1 then textcolor (blue)
      else textcolor (red);
      writeln ('     Player ',r);

{------- If he's been in Jail for three turns then make him pay $50 -----}

      if times[playernum] = 3 then begin
         times[playernum] := 0;
         write ('Three turns in Jail');
         write ('    Pay $50');
         write ('          Press <Enter>');
         repeat
               start := readkey;
         until start = chr(13);
         goto Get_out_of_Jail;
      end;

{---- Write the Prompt to Roll ---------------------}

      write (' <Enter> to roll');

{----- If the player is in Jail then add the option to pay $50 --------}

      if property[playernum] = 'Jail' then begin
         inc(times[playernum]);
         write ('     F10 to pay $50');
         repeat
               start := readkey;
         until (start = chr(13)) or (ord(start) = 068);

{----- Bring the player out of Jail if he pays $50 -----------------}

         if ord(start) = 068 then begin
Get_out_of_Jail:
            times[playernum] := 0;
            count := 50;
            spend_money(money[playernum],count);

{----- Draw the player on Just visiting ------------------------}

            window (4,24,6,24); textbackground (white); clrscr;
            if playernum = 1 then textcolor (blue)
            else textcolor (red);
            write (playerchar[playernum]);
            property[playernum] := 'Just Visiting';
            spot[playernum] := 10;
            start := chr(13);

{----- Clear the jail -------------------------------------}

            window (10,23,12,23); textbackground (black); clrscr;

{----- If the other player is in jail then draw him back in ----------}

            if playernum = 2 then count := 1
            else count := 2;
            if property[count] = 'Jail' then begin
               if count = 1 then begin
                textcolor (lightblue+blink); write (playerchar[1]);
               end;
               if count = 2 then begin
                   textcolor (red+blink); write (playerchar[2]);
               end;
            end;        {if property[count] = 'Jail'}

            goto start_roll;
         end;
      end        {if ord(start) = 068}

{---- If he chooses not to pay $50 then wait to press <Enter> -------}

      else begin

           repeat
                 start := readkey;
           until start = chr(13);
           if property[playernum] = 'Jail' then delay(1500);
      end;

{If he presses <Enter> then roll the dice}
{Whether he's in Jail or not}

      if start = chr(13) then begin
         randomize;
         dice[1] := trunc(random(6)) + 1;
         dice[2] := trunc(random(6)) + 1;
         window (27,12,45,14);textbackground (white);clrscr;
         draw_dice;

{------- If he rolls doubles then give him another turn ------------}

         if dice[1] = dice[2] then begin
            if r = 1 then r := 2
            else r := 1;
         end;
         roll := dice[1] + dice[2];
         window (35,12,35,14);
         delay(200);
      end;           {If start = chr(13)}

end;                 {Procedure Roll Dice}

{---------- Procedure Find Spot ---------------------------------}

Procedure find_Spot(p : shortint);

{This procedure will determine the position of the player on the screen by
finding the square number the player is on.
It will draw the window required for that square.}

Begin            {Procedure Find Spot}

     case spot[p] of
          0 : window (62,24,64,24);
          1 : window (51,23,53,23);
          2 : window (47,23,49,23);
          3 : window (43,23,45,23);
          4 : window (39,23,41,23);
          5 : window (35,23,37,23);
          6 : window (31,23,33,23);
          7 : window (27,23,29,23);
          8 : window (23,23,25,23);
          9 : window (19,23,21,23);
          10: window (4,24,6,24);
          11: window (8,21,10,21);
          12: window (8,19,10,19);
          13: window (8,17,10,17);
          14: window (8,15,10,15);
          15: window (8,13,10,13);
          16: window (8,11,10,11);
          17: window (8,9,10,9);
          18: window (8,7,10,7);
          19: window (8,5,10,5);
          20: window (12,2,14,2);
          21: window (19,3,21,3);
          22: window (23,3,25,3);
          23: window (27,3,29,3);
          24: window (31,3,33,3);
          25: window (35,3,37,3);
          26: window (39,3,41,3);
          27: window (43,3,45,3);
          28: window (47,3,49,3);
          29: window (51,3,53,3);
          30 :window (62,3,64,3);
          31 :window (62,5,64,5);
          32 :window (62,7,64,7);
          33 :window (62,9,64,9);
          34 :window (62,11,64,11);
          35 :window (62,13,64,13);
          36 :window (62,15,64,15);
          37 :window (62,17,64,17);
          38 :window (62,19,64,19);
          39 :window (62,21,64,21);
     end;
     textbackground(white); clrscr;
end;            {Procedure Find Spot}

{--------- Procedure Property Name -------------------------}

Procedure Property_name;

{This procedure will use the square number that the player is on to
determine the name of the property he's on. It will also write the property
name on the inside of the playing board, on the top and bottom of the
inside square.}

Begin         {Procedure Property Name}

     case spot[playernum] of
          0 : property[playernum] := 'Go';
          1 : property[playernum] := 'Mediterranean Avenue';
          2,17,33 : property[playernum] := 'Community Chest';
          3 : property[playernum] := 'Baltic Avenue';
          4 : property[playernum] := 'Income Tax';
          5 : property[playernum] := 'Reading Railroad';
          6 : property[playernum] := 'Oriental Avenue';
          7,22,36 : property[playernum] := 'Chance';
          8 : property[playernum] := 'Vermont Avenue';
          9 : property[playernum] := 'Connecticut Avenue';
          10: property[playernum] := 'Visiting Jail';
          11: property[playernum] := 'St. Charles Place';
          12: property[playernum] := 'Electric Company';
          13: property[playernum] := 'States Avenue';
          14: property[playernum] := 'Virginia Avenue';
          15: property[playernum] := 'Pennsylvania Avenue';
          16: property[playernum] := 'St. James Place';
          18: property[playernum] := 'Tennessee Avenue';
          19: property[playernum] := 'New York Avenue';
          20: property[playernum] := 'Free Parking';
          21: property[playernum] := 'Kentucky Avenue';
          23: property[playernum] := 'Indiana Avenue';
          24: property[playernum] := 'Illinois Avenue';
          25: property[playernum] := 'B. & O. Railroad';
          26: property[playernum] := 'Atlantic Avenue';
          27: property[playernum] := 'Ventnor Avenue';
          28: property[playernum] := 'Water Works';
          29: property[playernum] := 'Marvin Gardens';
          30: property[playernum] := 'Go to Jail';
          31: property[playernum] := 'Pacific Avenue';
          32: property[playernum] := 'North Carolina Avenue';
          34: property[playernum] := 'Pennsylvania Avenue';
          35: property[playernum] := 'Short Line';
          37: property[playernum] := 'Park Place';
          38: property[playernum] := 'Luxury Tax';
          39: property[playernum] := 'Boardwalk';
          -23:property[playernum] := 'Jail';
     end;

{---- Write the property name on the board - Inside middle square --------}

     if playernum = 1 then window (20,7,53,7)
     else window (20,19,53,19);
     clrscr; textcolor (darkgray);
     write ('Player ',playernum,' - ',property[playernum]);

end;       {Procedure Property Name}

{------ Procedure Player Turn -----------------------------}

Procedure Player_turn (var m : shortint);

{This Procedure will be called to begin each player's turn. It will call
the roll dice procedure, calculate where the player will end up, and show
the player moving there.}

Begin             {Procedure Player Turn}

     roll_dice(m);

{---- Find where he's moving to ---------------------}

     count := spot[m] + roll;
     if count > 39 then count := count - 40;

{--- If the player is in jail and rolls doubles then let him out of Jail -}

     if property[m] = 'Jail' then begin
              if dice[1] = dice[2] then begin
                 spot[m] := 10;
                 property_name;
                 textbackground (white);
                 go_to_Jail;
                 textbackground (white);
                 times[playernum] := 0;
                 count := spot[m] + roll;
              end
              else count := spot[m];
     end;

{----- Draw the player in each next square until he reaches the final one --}

     while spot[m] <> count do begin

{---- Do if the characters aren't on the same square --------------------}

           if spot[1] <> spot[2] then begin
              find_spot(m);
              clrscr;
           end
           else begin
                find_spot(m);
                clrscr;

{---- Determine which player # and then choose character and number -----}

                if m = 2 then begin
                   textcolor (blue); write (playerchar[1]);
                end;
                if m = 1 then begin
                   textcolor (red); write (playerchar[2]);
                end;
           end;
           spot[m] := spot[m] + 1;

{----- Go around the corner of the board - Past Go -------------}

           if spot[m] > 39 then spot[m] := spot[m] - 40;
           if spot[m] = 0 then begin
              money[m] := money[m] + 200;
              show_money;                  {Collect $200}
              textbackground(white);
           end;

{---- Find the property name and spot -------------------------}

           property_name;
           find_spot(m);

{---- Draw both players on the same square if they're on the same spot ---}

           if spot[1] = spot[2] then begin
              if m = 2 then begin
                 textcolor (blue); write (playerchar[1]);
                 textcolor (red); write (playerchar[2]);
              end;
              if m = 1 then begin
                 textcolor (red); write (playerchar[2]);
                 textcolor (blue); write (playerchar[1]);
              end;
              delay (200);
              if spot[m] <> count then clrscr;

{---- Draw the original player back on as the second player leaves -----}

              if (m = 1) and (spot[m] <> count) then begin
                 textcolor (red); write (playerchar[2]);
              end;
              if (m = 2) and (spot[m] <> count) then begin
                   textcolor (blue); write (playerchar[1]);
              end;
           end

{--- If they aren't on the same spot then write the character --------}

           else begin
                if m = 1 then textcolor (blue)
                else textcolor (red);
                write (playerchar[m]);
                delay (200);
           end;
     end;

{----- If they land on Go to Jail then send them to Jail ---------------}

     if property[m] = 'Go to Jail' then begin
        if m = 1 then count := 2
        else count := 1;
        find_spot(count);
        if count = 1 then textcolor (blue)
        else textcolor (red);
        write (playerchar[count]);
        find_spot(m);
        clrscr;
        dice[1] := 1; dice[2] := 4;
        spot[m] := -23;
        textbackground (white); clrscr;
        property_name;
        go_to_jail;
     end;

{---- If They roll 3 doubles in a row then send them to Jail -----------}

     window (27,12,45,14);
     if dice[1] = dice[2] then begin
        doubles := doubles + 1;
        if doubles = 3 then begin
           doubles := 0;
           dice[1] := 3; dice[2] := 1;
           spot[m] := -23;
           find_spot(m);
           textbackground (white); clrscr;
           property_name;
           Go_to_Jail;
        end;
     end
     else doubles := 0;

{---- Call Property Owned procedure to prompt to buy or pay rent, etc ---}

     property_owned;

{---- If they roll doubles then give the player another turn --------}


     if dice[1] = dice[2] then begin
        if m = 1 then m := 2
        else m := 1;
     end;
     if (property[2] = 'Jail') and (property[1] <> 'Jail') then begin
        find_spot(1);
        textcolor(blue);
        write (playerchar[1]);
     end;
end;               {Procedure Player Turn}

Begin       {Main}

{----- Reset Variables ---------------}

     spot[1] := 0;  spot[2] := 0;
     times[1] := 0; times[2] := 0;
     doubles := 0;

{----- Draw the board and set rent, cost and money variables -------}

     draw_board;
     set_properties;
     money[1] := 1500;
     money[2] := 1500;
     Show_money;

{----- Do player turns until Ctrl-Break - C never equals 'y' ---------}

     repeat
         for playernum := 1 to 2 do player_turn(playernum);
         doubles := 0;
     until c = 'y';

end.          {MAIN}

{Ken Hoetmer}