{ This unit was written by Patrick Kooman, 1997.}
unit large_ch;

interface

uses crt;

const
    chars : array [1..36,1..8,1..8] of byte =
 (((0,0,0,2,2,0,0,0), { 'A' }
   (0,0,2,1,1,1,0,0),
   (0,2,1,1,0,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,2,2,1,1),
   (2,1,1,1,1,1,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,0,0,1,1)),

  ((2,2,2,2,2,2,0,0), { 'B' }
   (2,1,1,1,1,1,1,0),
   (2,1,0,0,0,0,2,1),
   (2,1,2,2,2,2,2,1),
   (2,1,1,1,1,1,1,0),
   (2,1,0,0,0,0,2,1),
   (2,1,2,2,2,2,2,1),
   (0,1,1,1,1,1,1,0)),

  ((0,0,2,2,2,2,0,0), { 'C' }
   (0,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,0,1,1),
   (2,1,1,0,0,2,2,0),
   (2,1,1,0,0,0,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,2,2,2,0,0,0), { 'D' }
   (2,1,1,1,1,1,0,0),
   (2,1,1,0,0,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,2,1,1,0),
   (0,1,1,1,1,1,0,0)),

  ((2,2,2,2,2,2,2,0), { 'E' }
   (2,1,1,1,1,1,1,1),
   (2,1,0,0,0,0,0,0),
   (2,1,2,2,2,2,2,0),
   (2,1,1,1,1,1,1,1),
   (2,1,0,0,0,0,0,0),
   (2,1,2,2,2,2,2,0),
   (0,1,1,1,1,1,1,1)),

  ((2,2,2,2,2,2,2,0), { 'F' }
   (2,1,1,1,1,1,1,1),
   (2,1,0,0,0,0,0,0),
   (2,1,2,2,2,2,2,0),
   (2,1,1,1,1,1,1,1),
   (2,1,0,0,0,0,0,0),
   (2,1,0,0,0,0,0,0),
   (0,1,0,0,0,0,0,0)),

  ((0,0,2,2,2,2,0,0), { 'G' }
   (0,2,1,1,1,1,1,0),
   (2,1,1,0,0,0,1,1),
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,2,2,2,0),
   (2,1,1,0,2,1,1,1),
   (2,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,0,0,0,2,2,0), { 'H' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,2,2,1,1),
   (2,1,1,1,1,1,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,0,0,1,1)),

  ((0,2,2,2,2,2,2,0), { 'I' }
   (0,2,1,1,1,1,1,1),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,2,2,2,1,1,0,0),
   (0,0,1,1,1,1,1,1)),

  ((0,0,0,2,2,2,2,0), { 'J' }
   (0,0,0,2,1,1,1,1),
   (0,0,0,0,1,1,1,1),
   (0,0,0,0,0,2,1,1),
   (2,2,0,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,0,0,0,0,2,0), { 'K' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,2,1,1,0),
   (2,1,1,2,1,1,0,0),
   (2,1,1,1,1,0,0,0),
   (2,1,1,0,1,1,0,0),
   (2,1,1,0,0,1,1,0),
   (0,1,1,0,0,0,1,1)),

  ((2,2,0,0,0,0,0,0), { 'L' }
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,0,0,0,0),
   (2,1,1,2,2,2,2,0),
   (0,1,1,1,1,1,1,1)),

  ((2,2,0,0,0,2,2,0), { 'M' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,1,0,1,1,1),
   (2,1,1,1,1,1,1,1),
   (2,1,1,0,1,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,0,0,1,1)),

  ((2,2,0,0,0,2,2,0), { 'N' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,1,0,2,1,1),
   (2,1,1,1,1,2,1,1),
   (2,1,1,0,1,1,1,1),
   (2,1,1,0,0,1,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,0,0,1,1)),

  ((0,2,2,2,2,2,0,0), { 'O' }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,2,2,2,2,0,0), { 'P' }
   (2,1,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,2,2,1,1),
   (2,1,1,1,1,1,1,0),
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,0,0,0,0),
   (0,1,1,0,0,0,0,0)),

  ((0,2,2,2,2,2,0,0), { 'Q' }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,0,2,1,1),
   (2,1,1,2,1,2,1,1),
   (2,1,1,2,1,1,1,1),
   (2,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,2,2,2,2,0,0), { 'R' }
   (2,1,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,2,2,1,1),
   (2,1,1,1,1,1,1,0),
   (2,1,1,0,0,1,1,0),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,0,0,1,1)),

  ((0,2,2,2,2,2,2,0), { 'S' }
   (2,2,1,1,1,1,1,1),
   (2,1,1,0,0,0,0,0),
   (0,1,1,2,2,2,0,0),
   (0,0,1,1,1,1,1,0),
   (0,0,0,0,0,2,1,1),
   (2,2,2,2,2,2,1,1),
   (0,1,1,1,1,1,1,0)),

  ((0,2,2,2,2,2,2,0), { 'T' }
   (0,0,1,1,1,1,1,1),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,0,1,1,0,0)),

  ((2,2,0,0,0,2,2,0), { 'U' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,0,0,0,2,2,0), { 'V' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,0,2,2,1,1),
   (0,0,1,1,2,1,1,0),
   (0,0,0,1,1,1,0,0)),

  ((2,2,0,0,0,2,2,0), { 'W' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,2,0,2,1,1),
   (2,1,1,2,1,2,1,1),
   (2,1,1,1,1,1,1,1),
   (2,1,1,1,0,1,1,1),
   (0,1,1,0,0,0,1,1)),

  ((2,2,0,0,0,0,2,0), { 'X' }
   (0,1,1,0,0,2,1,1),
   (0,0,1,1,2,1,1,0),
   (0,0,0,1,1,1,0,0),
   (0,0,0,2,1,0,0,0),
   (0,0,2,1,1,1,0,0),
   (0,2,1,1,0,1,1,0),
   (0,1,1,0,0,0,1,1)),

  ((2,2,0,0,0,2,2,0), { 'Y' }
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,1),
   (0,0,0,0,0,2,1,1),
   (2,2,2,2,2,1,1,0),
   (2,1,1,1,1,1,0,0)),

  ((2,2,2,2,2,2,2,0), { 'Z' }
   (2,1,1,1,1,1,1,1),
   (0,0,0,0,2,1,1,0),
   (0,0,0,2,1,1,0,0),
   (0,0,2,1,1,0,0,0),
   (0,2,1,1,0,0,0,0),
   (2,1,1,2,2,2,2,0),
   (0,1,1,1,1,1,1,1)),

  ((0,2,2,2,2,2,0,0), { 0 }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((0,0,2,2,2,0,0,0), { 1 }
   (0,2,2,1,1,1,0,0),
   (0,0,1,1,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,0,0,2,1,1,0,0),
   (0,2,2,2,1,1,0,0),
   (0,0,1,1,1,1,1,1)),

  ((2,2,2,2,2,2,0,0), { 2 }
   (0,1,1,1,1,1,1,0),
   (0,0,0,0,0,2,1,1),
   (0,2,2,2,2,2,1,1),
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,0,0,0),
   (0,1,1,2,2,2,2,0),
   (0,0,1,1,1,1,1,1)),

  ((2,2,2,2,2,2,0,0), { 3 }
   (0,1,1,1,1,1,1,0),
   (0,0,0,0,0,2,1,1),
   (0,2,2,2,2,2,1,1),
   (0,0,1,1,1,1,1,0),
   (0,0,0,0,0,2,1,1),
   (2,2,2,2,2,2,1,1),
   (0,1,1,1,1,1,1,0)),

  ((2,2,0,0,0,0,0,0), { 4 }
   (2,1,1,0,0,0,0,0),
   (2,1,1,0,2,2,0,0),
   (2,1,1,0,2,1,1,0),
   (2,1,1,2,2,1,1,0),
   (0,1,1,1,1,1,1,1),
   (0,0,0,0,2,1,1,0),
   (0,0,0,0,0,1,1,0)),

  ((0,2,2,2,2,2,2,0), { 5 }
   (2,2,1,1,1,1,1,1),
   (2,1,1,0,0,0,0,0),
   (2,1,1,2,2,2,2,0),
   (0,0,1,1,1,1,1,0),
   (0,0,0,0,0,0,1,1),
   (2,2,2,2,2,2,1,1),
   (0,1,1,1,1,1,1,0)),

  ((0,2,2,2,2,2,0,0), { 6 }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,0,1,1),
   (2,1,1,2,2,2,0,0),
   (2,1,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((2,2,2,2,2,2,2,0), { 7 }
   (0,1,1,1,1,1,1,1),
   (0,0,0,0,0,2,1,1),
   (0,0,0,0,2,1,1,0),
   (0,0,0,2,1,1,0,0),
   (0,0,2,1,1,0,0,0),
   (0,0,2,1,1,0,0,0),
   (0,0,0,1,1,0,0,0)),

  ((0,2,2,2,2,2,0,0), { 8 }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)),

  ((0,2,2,2,2,2,0,0), { 9 }
   (2,2,1,1,1,1,1,0),
   (2,1,1,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,1),
   (2,2,0,0,0,2,1,1),
   (0,1,1,2,2,2,1,1),
   (0,0,1,1,1,1,1,0)));

procedure Putpixel (Y,X : Integer; Col : byte; where : word);
procedure WriteLargeChar (Y,X,col_for,col_back : integer;
                         line : string;where:word;shadow,large:boolean);

implementation

procedure Putpixel (Y,X : Integer; Col : Byte; where : word);
begin
  mem [where:X+(Y*320)]:=Col;
end;

procedure WriteLargeChar (Y,X,col_for,col_back : integer;
                         line : string;where:word;
                         shadow, large : boolean);

var              { Allemaal bytes.}
   i,
   loop1,
   loop2,
   number,
   L,
   start,
   tmpY,
   color : byte;
begin
   tmpY := y;
   L := length (line);
   for loop1 := 1 to L do         { Upcase characters. }
      line [loop1] := upcase (line [loop1]);
   i := 0;
   while i < L do
   begin
      inc (i);
      if shadow then    { the first colum of an array includes shadow-pixels.}
         start := 1
      else
         start := 2;    { If you don't want shadow, this colum will be passed.}
      for loop1 := start to 8 do
      begin
         for loop2 := start to 8 do
         begin
            if line [i] in ['A'..'Z',' '] then
               number := chars [ord (line [i])-64,loop1,loop2]
               { For example, when you put a 'C', the ASCII-value is
                 67. You decreas this value by 64 and you'll get 3.
                 This is correct because the 'C' is at the third position
                 in the array CHARS.}
            else
             { Do the same to reach the arrays for the numbers.}
               number := chars [ord (line [i]) -21,loop1,loop2];
            if number = 1 then { Forground-color.}
               color := col_for
            else
            if (number = 2) and shadow then { Shadow-color.}
               color := col_back
            else
               number := 0; { No color.}
            if number in [1..2] then
            begin
               putpixel (y+loop1,x+loop2,color,where);  { One pixel.}
               if large then
               begin    { If you put a large char, it is blown up here.}
                  putpixel (y+1+loop1,x+loop2,color,where);
                  putpixel (y+loop1,x+1+loop2,color,where);
                  putpixel (y+1+loop1,x+1+loop2,color,where)
               end
            end
         end;
         if large then
            inc (y);
      end;
      if large then inc (X,10)
      else inc (X,9);
      if large then y := tmpY;
   end
end;

begin
end.





