{ This unit was written by Patrick Kooman, 1997.}
unit small_ch;

interface

const SmallChars : array [1..44,1..5,1..5] of byte =
     (((0,1,1,1,0),
       (1,0,0,0,1),
       (1,1,1,1,1),
       (1,0,0,0,1),
       (1,0,0,0,1)),

      ((1,1,1,1,0),
       (1,0,0,0,1),
       (1,1,1,1,0),
       (1,0,0,0,1),
       (1,1,1,1,0)),

      ((0,1,1,1,1),
       (1,0,0,0,0),
       (1,0,0,0,0),
       (1,0,0,0,0),
       (0,1,1,1,1)),

      ((1,1,1,1,0),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,1,1,1,0)),

      ((1,1,1,1,1),
       (1,0,0,0,0),
       (1,1,1,1,0),
       (1,0,0,0,0),
       (1,1,1,1,1)),

      ((1,1,1,1,1),
       (1,0,0,0,0),
       (1,1,1,1,0),
       (1,0,0,0,0),
       (1,0,0,0,0)),

      ((0,1,1,1,1),
       (1,0,0,0,0),
       (1,0,1,1,1),
       (1,0,0,0,1),
       (0,1,1,1,0)),

      ((1,0,0,0,1),
       (1,0,0,0,1),
       (1,1,1,1,1),
       (1,0,0,0,1),
       (1,0,0,0,1)),

      ((0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0)),

      ((0,0,0,1,0),
       (0,0,0,1,0),
       (0,0,0,1,0),
       (1,0,0,1,0),
       (0,1,1,0,0)),

      ((1,0,0,1,0),
       (1,0,1,0,0),
       (1,1,0,0,0),
       (1,0,1,0,0),
       (1,0,0,1,0)),

      ((0,1,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (0,1,1,1,1)),

      ((1,0,0,0,1),
       (1,1,0,1,1),
       (1,0,1,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1)),

      ((1,0,0,0,1),
       (1,1,0,0,1),
       (1,0,1,0,1),
       (1,0,0,1,1),
       (1,0,0,0,1)),

      ((0,1,1,1,0),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (0,1,1,1,0)),

      ((1,1,1,1,0),
       (1,0,0,0,1),
       (1,1,1,1,0),
       (1,0,0,0,0),
       (1,0,0,0,0)),

      ((0,1,1,1,0),
       (1,0,0,0,1),
       (1,0,1,0,1),
       (1,0,0,1,1),
       (0,1,1,1,0)),

      ((1,1,1,1,0),
       (1,0,0,0,1),
       (1,1,1,1,0),
       (1,0,1,0,0),
       (1,0,0,1,0)),

      ((0,1,1,1,1),
       (1,0,0,0,0),
       (0,1,1,1,0),
       (0,0,0,0,1),
       (1,1,1,1,0)),

      ((1,1,1,1,1),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0)),

      ((1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (0,1,1,1,0)),

      ((1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (0,1,0,1,0),
       (0,0,1,0,0)),

      ((1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,1,0,1),
       (1,1,0,1,1),
       (1,0,0,0,1)),

      ((1,0,0,0,1),
       (0,1,0,1,0),
       (0,0,1,0,0),
       (0,1,0,1,0),
       (1,0,0,0,1)),

      ((1,0,0,0,1),
       (1,0,0,0,1),
       (0,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,0)),

      ((1,1,1,1,1),
       (0,0,0,1,0),
       (0,0,1,0,0),
       (0,1,0,0,0),
       (1,1,1,1,1)),

      ((1,1,1,1,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,0,0,0,1),
       (1,1,1,1,1)),

      ((0,1,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,1,1,1,0)),

      ((1,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,1),
       (1,0,0,0,0),
       (1,1,1,1,1)),

      ((1,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,1)),

      ((1,0,0,0,0),
       (1,0,0,0,0),
       (1,0,0,1,0),
       (1,1,1,1,1),
       (0,0,0,1,0)),

      ((1,1,1,1,1),
       (1,0,0,0,0),
       (1,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,1)),

      ((1,1,1,1,1),
       (1,0,0,0,0),
       (1,1,1,1,1),
       (1,0,0,0,1),
       (1,1,1,1,1)),

      ((0,1,1,1,1),
       (0,0,0,1,0),
       (0,0,1,0,0),
       (0,0,1,0,0),
       (0,0,1,0,0)),

      ((1,1,1,1,1),
       (1,0,0,0,1),
       (1,1,1,1,1),
       (1,0,0,0,1),
       (1,1,1,1,1)),

      ((1,1,1,1,1),
       (1,0,0,0,1),
       (1,1,1,1,1),
       (0,0,0,0,1),
       (1,1,1,1,1)),

      ((0,0,0,0,0),
       (0,0,0,0,0),
       (0,0,0,0,0),
       (0,0,0,0,0),
       (1,0,0,0,0)),

      ((0,0,0,0,0),
       (0,0,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (1,0,0,0,0)),

      ((0,0,0,0,0),
       (1,0,0,0,0),
       (0,0,0,0,0),
       (1,0,0,0,0),
       (0,0,0,0,0)),

      ((0,0,1,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (0,0,1,0,0)),

      ((1,0,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (0,1,0,0,0),
       (1,0,0,0,0)),

      ((0,1,1,0,0),
       (1,0,0,1,0),
       (0,0,1,0,0),
       (0,0,0,0,0),
       (0,0,1,0,0)),

      ((0,0,0,0,1),
       (0,0,0,1,0),
       (0,0,1,0,0),
       (0,1,0,0,0),
       (1,0,0,0,0)),

      ((0,1,1,1,0),
       (0,1,1,1,0),
       (0,0,1,0,0),
       (0,0,0,0,0),
       (0,0,1,0,0)));

procedure WriteSmallChar (pY, pX : integer; color : byte; S : string);

implementation

procedure Putpixel (Y,X : Integer; Col : Byte);
begin
  mem [$a000:X+(Y*320)]:=Col;
end;

procedure WriteSmallChar (pY, pX : integer; color : byte; S : string);

var
   i,
   pos,
   loop1,
   loop2,
   delta  : byte; 
 { Delta is uses to make the right space between characters. For example:
   after a normal character you make more space then after a '('.}
   Y,X : integer;
begin
   Y := pY;
   X := pX;
   for i := 1 to length (S) do
     S [i] := upcase (S [i]);   { Upcase the given string.}
   for i := 1 to length (S) do  
   begin
      if S[i] in ['A'..'Z',' '] then
      begin
         pos := ord (S[i])-64;  { See 'Large_ch.pas' to see why this is.}
         if S[i] = ' ' then
            delta := 4          { 4 pixels space after a ' '.}
         else
            delta := 7          { 7 pixels space after a characters.}
      end
      else
      if S[i] in ['0'..'9'] then
      begin
         pos := ord (S[i])-21;  { See 'Large_ch.pas' to see why this is.}
         delta := 7
      end
      else
      case S[i] of
        '.' : begin
                 pos := 37;     { Pos referes to the position in the array of characters.}
                 delta := 5     { Here you see the different delta's.}
              end;
        ',' : begin
                 pos := 38;
                 delta := 2
              end;
        ':' : begin
                 pos := 39;
                 delta := 3
              end;
        '(' : begin
                 pos := 40;
                 delta := 5
              end;
        ')' : begin
                 pos := 41;
                 delta := 7
              end;
        '?' : begin
                 pos := 42;
                 delta := 2
              end;
        '/' : begin
                 pos := 43;
                 delta := 7
              end;
        '!' : begin
                 pos := 44;
                 delta := 4
              end
        end;
        if S[i] <> ' ' then
        begin
           for loop1 := 1 to 5 do
              for loop2 := 1 to 5 do
                 if SmallChars [pos,loop1,loop2] <> 0 then
                    putpixel (Y+loop1,X+loop2,color)
        end;
           inc (X,delta) { Makes the space after the character.}
   end
end;

begin
end.


