program ldir;

{ Testprogram for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ LDIR is an alternative for NDIR, showing the use of the
  ScanDirectoryEntry function. }

uses nwMisc,nwBindry,nwFile;

Function GetEntryAttributeString(Attr:Longint):string;
Var res:string;
begin
if (Attr and A_DIRECTORY)=0
 then res:=' RwSAXHSyTPCDR '
 else res:=' -----HSy-P-DR ';
if (Attr and A_HIDDEN)=0 then res[7]:='-';
if (Attr and A_SYSTEM)=0 then begin res[8]:='-';res[9]:='-'; end;
if (Attr and A_RENAME_INHIBIT)=0 then res[14]:='-';
if (Attr and A_DELETE_INHIBIT)=0 then res[13]:='-';
if (Attr and A_PURGE)=0 then res[11]:='-';
if (Attr and A_DIRECTORY)=0
 then begin
      if ((Attr and A_READ_ONLY)>0) then res[3]:='o';
      if (Attr and A_EXECUTE_ONLY)=0 then res[6]:='-';
      if (Attr and A_NEEDS_ARCHIVED)=0 then res[5]:='-';
      if (Attr and A_SHAREABLE)=0 then res[4]:='-';
      if (Attr and A_TRANSACTIONAL)=0 then res[10]:='-';
      if (Attr and A_COPY_INHIBIT)=0 then res[12]:='-';
      end;
GetEntryAttributeString:=res;
end;

Var DirHandle:Byte;
    DirPath:String;
    SequenceNumber:Byte;
    TrusteeInfo: TtrusteeInformation;

    t:Byte;
    ObjName:string;
    ObjType:word;
    ObjId:Longint;
    DH,EffRights:byte;

    EntryName:string;
    SearchFlags:Longint;
    EntryId:Longint;
    Entry:Tentry;
    s,s1:string;

    p:byte;
    OwnerName:string;
    OwnerType:word;

    entry2:Tentry;
begin

DirHandle:=0;

if ParamCount>0
 then s:=paramStr(1)
 else s:='.';

IF NOT GetTrueEntryName(s,DirPath)
 then begin
      writeln('Error resolving given filename (err: 0-',nwfile.result,')');
      halt(1);
      end;

if pos(':',DirPath)=2
 then begin
      writeln('You cannot use this program on a local drive.');
      halt(1);
      end;

{ ok. Try to separate EntryName from path }

p:=ord(DirPath[0]);
while (p>0) and (DirPath[p]<>'\') do dec(p);

s:=copy(DirPath,p+1,255);
if (pos('.',s)>0) or (pos('*',s)>0) or (pos('?',s)>0)
 then begin { last part is definately a filename }
      EntryName:=s;
      DirPath[0]:=chr(p-1);
      IF NOT AllocTemporaryDirHandle(31,0,DirPath,DH,EffRights)
       then begin
            writeln('Could not locate directory (err: 1-',nwfile.result,')');
            halt(1);
            end;
      end
 else begin
      IF AllocTemporaryDirHandle(31,0,DirPath,DH,EffRights) { assume it's a path}
       then begin
            { whole thing appears to be a path.. }
            EntryName:='*';
            end
       else begin
            { whoops.. not a path, but a filename without an extension }
            EntryName:=s;
            DirPath[0]:=chr(p-1);
            IF NOT AllocTemporaryDirHandle(31,0,DirPath,DH,EffRights)
             then begin
                  writeln('Could not locate directory (err: 2-',nwfile.result,')');
                  halt(1);
                  end;
            end;
      end;


writeln('EntryName         Size Flags           EntryID  Creation        Owner');
writeln('------------+---------+---------------+--------+---------------+----------');

SearchFlags:=$ef; { all NON directories, i.e. all files }
EntryId:=-1;

While ScanDirectoryEntry(DH,EntryName,SearchFlags,EntryID,Entry)
 do begin
  s:=entry.EntryName;
    p:=pos('.',s);
    if p=0
     then begin
          s:=s+'               ';
          s[0]:=#12;
          end
     else begin
          s1:=copy(s,1,p-1)+'           ';
          s1[0]:=#8;
          s:=s1+copy(s,p,255)+'  ';
          s[0]:=#12;
          end;
    write(s);
    write(entry.FileSize:10);
    s:=GetEntryAttributeString(entry.Attributes);
    write(' F',s);
    write(HexStr(entryId,8));

    NovTime2String(entry.CreationTime,s);
    delete(s,1,5);dec(s[0],3);
    delete(s,8,2);
    s[3]:='-';s[7]:='-';
    write(' ',s);

    GetBinderyObjectName(entry.OwnerId,OwnerName,OwnerType);
    s:=ownerName+'         ';
    s[0]:=#10; write(' ',s);
    writeln;

    end;

if nwFile.result<>$FF { no more matching entries }
 then writeln('Error scanning directory information (err : 3-',nwfile.result,')');


{-- As an extra gimmick: if you DEFINE ShowScan, salvagable files will
 also be shown.. }

{$IFDEF ShowScan}

{ Scan salvagable files.. }
EntryId:=-1;

WHILE ScanSalvagableFiles(DH,EntryId,Entry)
 do begin
    s:=entry.EntryName;
    p:=pos('.',s);
    if p=0
     then begin
          s:=s+'               ';
          s[0]:=#12;
          end
     else begin
          s1:=copy(s,1,p-1)+'           ';
          s1[0]:=#8;
          s:=s1+copy(s,p,255)+'  ';
          s[0]:=#12;
          end;
    write(s);
    write(entry.FileSize:10);
    s:=GetEntryAttributeString(entry.Attributes);
    write(' S',s);
    write(HexStr(entryId,8));

    NovTime2String(entry.CreationTime,s);
    delete(s,1,5);dec(s[0],3);
    delete(s,8,2);
    s[3]:='-';s[7]:='-';
    write(' ',s);

    GetBinderyObjectName(entry.OwnerId,OwnerName,OwnerType);
    s:=ownerName+'         ';
    s[0]:=#10; write(' ',s);

    writeln;

    end;
If nwFile.result<>$FF { normal iteration end }
 then writeln('Error using ScanSalvagableFiles.');

{$ENDIF}

{------------------ show subdir info }

SearchFlags:=$3f;
EntryId:=-1;

While ScanDirectoryEntry(DH,EntryName,SearchFlags,EntryID,Entry)
 do begin
   s:=entry.EntryName;
    p:=pos('.',s);
    if p=0
     then begin
          s:=s+'               ';
          s[0]:=#11;
          end
     else begin
          delete(s,p,1);
          s:=s+'            ';
          s[0]:=#11;
          end;
    write('\',s);

    write(0:10); { filesize }

    s:=GetEntryAttributeString(entry.Attributes);
    write(' D',s);
    write(HexStr(entryId,8));

    NovTime2String(entry.CreationTime,s);
    delete(s,1,5);dec(s[0],3);
    delete(s,8,2);
    s[3]:='-';s[7]:='-';
    write(' ',s);

    GetBinderyObjectName(entry.OwnerId,OwnerName,OwnerType);
    s:=ownerName+'         ';
    s[0]:=#12; write(' ',s);
    writeln;
    end;
if nwFile.result<>$FF { no more matching entries }
 then writeln('Error scanning directory information (err : 4-',nwfile.result,')');

DeallocateDirHandle(DH);
end.