Program tstentry;

{ Example for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following nwFile calls:

  AllocPermanentDirHandle
  CreateDirectory
  DeallocateDirHandle
  RenameDirectory
  ScanDirRestrictions
  SetDirectoryHandle
  SetDirRestriction

}
uses nwMisc,nwFile;

Var DirHandle:Byte;
    NumberOfEntries:Byte;
    RestrInfo:TdirRestrList;
    t,EffRights:Byte;

begin


AllocPermanentDirHandle(7,0,'SYS:',DirHandle,EffRights);

IF NOT CreateDirectory(DirHandle,'NWTP',$FF)
 then writeln('Error using CreateDirectory, err# ',nwFile.result);

SetDirectoryHandle(DirHandle,'NWTP',DirHandle);

IF NOT SetDirRestriction(DirHandle,4096) { 4096 blocks = 16 Mb }
 then writeln('Error using SetDirRestriction, err# ',nwFile.result);

IF NOT ScanDirRestrictions(DirHandle,NumberOfEntries,RestrInfo)
 then writeln('Error calling ScanDirRestrictions:',nwFile.result);
writeln(NumberOfEntries);
For t:=1 to NumberOfEntries
 do begin
    writeln;
    writeln('Level      :',RestrInfo[t].level);
    writeln('MaxBlocks  :',HexStr(RestrInfo[t].MaxBlocks,8));
    writeln('AvailBlocks:',HexStr(RestrInfo[t].AvailableBlocks,8));
    end;
writeln('------');

IF NOT CreateDirectory(DirHandle,'TEST',$FF)
 then writeln('Error using CreateDirectory, err# ',nwFile.result);

IF NOT RenameDirectory(DirHandle,'TEST','TESTDIR')
 then writeln('Error using RenameDirectory, err# ',nwFile.result);


IF NOT SetDirectoryHandle(DirHandle,'TESTDIR',DirHandle)
  then writeln('Error using SetDirectoryHandle, err# ',nwFile.result)
  else writeln('SetDirHandle: ok');

IF NOT SetDirRestriction(DirHandle,8192)
 then writeln('Error using SetDirRestriction, err# ',nwFile.result);

IF NOT ScanDirRestrictions(DirHandle,NumberOfEntries,RestrInfo)
 then writeln('Error calling ScanDirRestrictions:',nwFile.result);
writeln(NumberOfEntries);
For t:=1 to NumberOfEntries
 do begin
    writeln;
    writeln('Level      :',RestrInfo[t].level);
    writeln('MaxBlocks  :',HexStr(RestrInfo[t].MaxBlocks,8));
    writeln('AvailBlocks:',HexStr(RestrInfo[t].AvailableBlocks,8));
    end;

writeln('<Return> to continue...........');
readln;

SetDirRestriction(DirHandle,0);

SetDirectoryHandle(0,'SYS:NWTP',DirHandle);
IF Not DeleteDirectory(DirHandle,'TESTDIR')
 then writeln('Error using DeleteDirectory, err#', nwFile.result);

{SetDirRestriction(DirHandle,0);}

SetDirectoryHandle(0,'SYS:',DirHandle);
IF Not DeleteDirectory(DirHandle,'NWTP')
 then writeln('Error using DeleteDirectory, err#', nwFile.result);


DeallocateDirHandle(DirHandle);

end.