Program Test_Host_for_TCP_Unit;
{Run as a Finger daemon to test the TCP unit.
 (Wait for Connections on Port 79 and reply to them.)
 This is a an example of an Internet 'Host' program
 with full error checking.}
Uses Wincrt,TCP,WinProcs{GetTickCount for the delay loop};
Const CRLF=#13#10;
Var Connection:TCP_Handle;
    Message:String;
    Status:TCP_Status;
    Pause:LongInt;
    ConnectionCount:Integer;
Begin
  WindowOrg.X:=0;WindowOrg.Y:=0;
  ConnectionCount:=0;
  If not OpenTCP(Connection,79,'')
   Then WriteLn('Connection failed to open.  Error: ',
                                   Connection^.WinSockError)
   Else Repeat
      ClrScr;
      WriteLn;
      WriteLn('Simple TCP Finger Daemon demonstration.');
      WriteLn;
      WriteLn('Opened as the Finger Port (79) on ',
                              Connection^.LocalName,'.');
      WriteLn;
      WriteLn('Waiting for a connection.');
      WriteLn('(Press any key to exit.)');
      Repeat
        Pause:=GetTickCount+500; {A half second delay}
        Repeat {Wait} Until Pause<GetTickCount;
        Status:=CheckTCP(Connection);
        CursorTo(0,9);ClrEol;
        WriteLn('TCP Status: ',StatusName[Status]);
      Until (Status=TCP_Ready)or (Status=TCP_Active) or keypressed;
      If Not Keypressed then begin
        Inc(ConnectionCount);
        WriteLn('Connection #',ConnectionCount,' opened.');
        Message:='Non-Empty';
        If Status=TCP_Active Then
          If WriteTCP(Connection,'Welcome to the TCP Unit Test Host.'+CRLF)
            Then WriteLn('Welcome Message Sent.')
            Else WriteLn('Error sending welcome message.'); 
        While Length(Message)>0 do begin
          ClrEol;
          If ReadTCP(Connection,Message)
            Then Begin
              If Length(Message)=0
                Then WriteLn('Connection #',ConnectionCount,' closed.')
                Else Begin
                  WriteLn('Connection #',ConnectionCount,' sent: ',Message);
                  ClrEol;
                  If WriteTCP(Connection,'You sent: "'+Message+'"'+
                                         '  And I sent it back.'+CRLF)
                    Then WriteLn('Message replied.')
                    Else WriteLn('Connection failed during the write.');
                end
            end
            Else WriteLn('Connection #',ConnectionCount,
                         ' failed during the read.');
        end
      end;
  Until KeyPressed;
  If CloseTCP(Connection)=0
    Then WriteLn('Connection closed.')
    Else WriteLn('Error closing connection.');
  WriteLn;
  WriteLn('Press any key to close this window.');
  ReadKey;
  DoneWinCrt;
end.
    