UNIT FMVoice;

{

      Unit: FMVoice
   Sprache: TurboPASCAL + integrierter Assembler
     Autor: Stephan Weinberger
            (C) 1994 synthesis design

}

INTERFACE

USES Dos,Crt,Objects,Memory;

CONST
  FMAdressPort     = $388;                  {Adlib Adressen                 }
  FMDataPort       = $389;

CONST
  NNoNote          = 255;
  NNoteOff         = 254;
  NPatBreak        = 253;
  NSetSpeed        = 252;

  ENoEffekt        = 0;  {+}                {Effekte                        }
  EPatBreak        = 1;  {+}
  ESetSpeed        = 2;  {+}
  EPortToNote      = 3;  {+}
  EPortUp          = 4;  {+}
  EPortDown        = 5;  {+}
  EVolumeUp        = 6;  {+}
  EVolumeDown      = 7;  {+}
  EPort_VSlideUp   = 8;  {+}
  EPort_VSlideDn   = 9;  {+}
  EVibrato         = 10; {+}
  EVibr_VSlideUp   = 11; {+}
  EVibr_VSlideDn   = 12; {+}
  EPatternDelay    = 13; {+}
  ESetVolume       = 14; {+}

CONST
  NoteNames        : ARRAY[0..11] OF STRING[2] =
                     ('C-','C#','D-','D#','E-','F-','F#',
                      'G-','G#','A-','A#','H-');
  EffShort         : ARRAY[0..14] OF STRING[3] =
                     ('---','BRK','SPE','PTO','PUP','PDN','VUP','VDN','PVU',
                      'PVD','VIB','VVU','VVD','DEL','VOL');
  EffNames         : ARRAY[0..14] OF STRING[8] =
                     ('        ','PatBreak','SetSpeed','PortaToN',' PortaUp',
                      ' PortaDn','VSlideUp','VSlideDn','Port+VUp','Port+VDn',
                      ' Vibrato','Vibr+VUp','Vibr+VDn','PatDelay','  Volume');
CONST
  AdlibPresent     : BOOLEAN = FALSE;       {Adlib vorhanden ?              }
  FMMusicPlay      : BOOLEAN = FALSE;       {Musik wird gespielt ?          }
  FMMusicLoop      : BOOLEAN = FALSE;       {Musik endlos wiederholen ?     }
  FMMusicPause     : BOOLEAN = FALSE;       {Pause ?                        }
  FMNoteDelay      : BYTE    = 12;          {wieviele Timerschritte pro Note}
  FMSongTempo      : BYTE    = 96;          {Standardfrequenz in Hz         }

TYPE
  pFMInstr         = ^tFMInstr;
  tFMInstr         = OBJECT                 {ein FM-Instrument              }
    Name           : STRING[30];
    INSTR1mod      : BYTE;
    INSTR1tr       : byte;
    INSTR2mod      : byte;
    INSTR2tr       : byte;
    INSTRAttDecMod : byte;
    INSTRAttDecTr  : byte;
    INSTRSusRelMod : byte;
    INSTRSusRelTr  : byte;
    INSTRVerzMod   : byte;
    INSTRVerzTr    : byte;
    INSTRRueck     : byte;
    INSTRNothing   : array[47..51] of byte;
  END;

TYPE
  pFMSong          = ^tFMSong;
  tFMSong          = OBJECT(TObject)
    Arrangement    : PCollection;           {Abfolge der Patterns im Stck  }
    Patterns       : PCollection;
    Instruments    : ARRAY[1..51] OF pFMInstr;
    SongTitle      : STRING[40];
    SongAuthor     : STRING[40];
    MMSVersion     : WORD;
    CONSTRUCTOR      INIT;
    DESTRUCTOR       DONE;                                      VIRTUAL;
    FUNCTION         LadeSong(S: PStream): INTEGER;
    FUNCTION         SpeichereSong(S: PStream): INTEGER;
    PROCEDURE        InitInstrument(Nr: BYTE);
  END;

VAR
  FMSong           : pFMSong;

TYPE
  tNote           = RECORD                  {eine Note im Pattern           }
    Wert          : BYTE;
    Instrument    : BYTE;
    Effekt        : BYTE;
    EWert         : BYTE;
  END;

  tPatType        = RECORD
    Noten         : ARRAY[1..9,1..64] OF tNote;
    Name          : STRING[30];
  END;

  pTrack          = ^tTrack;                {eine Spur im Pattern           }
  tTrack          = OBJECT(TObject)
    Noten         : ARRAY[1..64] OF tNote;
  END;

  pPattern        = ^tPattern;              {ein Pettern                    }
  tPattern        = OBJECT(TObject)
    Name          : STRING[30];
    Spuren        : ARRAY[1..9] OF pTrack;
    Bearbeitung   : BOOLEAN;
    CONSTRUCTOR     Init;
    DESTRUCTOR      Done;                             Virtual;
  END;

VAR
  FMPattern        : pPattern;              {einzelnes Pattern              }

TYPE
  ChannelType     = ARRAY[1..9] OF BYTE;

  ChStatusType    = RECORD                  {Status der 9 Kanle/Spuren     }
    VolBar        : ChannelType;
    Laut          : ChannelType;
    Effekt        : ChannelType;
    Wert          : ChannelType;
    Instr         : ChannelType;
    OpValue       : ARRAY[1..9] OF WORD;
    CurrNoteNum   : ARRAY[1..9] OF WORD;
    ActualPattern : BYTE;
    ActualNote    : BYTE;
    UpDate        : BOOLEAN;
    EWert         : ChannelType;
  END;

TYPE
  InstSettingType = RECORD                  {Grundeinst. des Instruments    }
    Op1,Op2,Scal1,
    Scal2         : ChannelType;
    FM            : ARRAY[1..9] OF BOOLEAN;
  END;

VAR
  InstSetting     : InstSettingType;        {Settings der Instrumente       }
  FMChannelStatus : ChStatusType;
  FMMusicCounter  : BYTE;
  FMPatternCounter: BYTE;
  FMNoteCounter   : BYTE;

PROCEDURE FMEnableTimer;                    {Timer einschalten              }
PROCEDURE FMDisableTimer;                   {Timer rcksetzen auf 18.2 Hz   }
PROCEDURE FMSetTimerFreq(Frequency: WORD);  {Timerfrequenz setzen           }

PROCEDURE FMWriteReg(Reg, Data: BYTE);      {Adlib-Register schreiben       }
FUNCTION  FMReadStatus: BYTE;               {Adlib-Statusregister lesen     }
PROCEDURE FMReset;                          {Adlib rcksetzen               }
PROCEDURE FMInit;                           {Initialisieren                 }

PROCEDURE FMNoteOn(Kanal,Wert,Laut: BYTE);  {Note einschalten,0=laut        }
PROCEDURE FMNoteOff(Kanal: BYTE);           {Note ausschalten               }
PROCEDURE FMNoteFineOn(Kanal: BYTE; Num: WORD; Laut: BYTE);
                                            {Num: Bit 0-11  -> NoteNum
                                                  Bit 12-15 -> Oktave       }
FUNCTION  FMGetNoteFineNum(Wert: BYTE): WORD;
PROCEDURE FMPortaUp(Kanal: BYTE);
PROCEDURE FMPortaDown(Kanal: BYTE);
PROCEDURE FMVibrato(Kanal: BYTE);
PROCEDURE FMVibr_VSlideUp(Kanal: BYTE);
PROCEDURE FMVibr_VSlideDn(Kanal: BYTE);
PROCEDURE FMPortToNote(Kanal: BYTE);
PROCEDURE FMPort_VSlideUp(Kanal: BYTE);
PROCEDURE FMPort_VSlideDn(Kanal: BYTE);
PROCEDURE FMVolumeDown(Kanal: BYTE);
PROCEDURE FMVolumeUp(Kanal: BYTE);
PROCEDURE FMSetVolume(Kanal: BYTE; Laut: INTEGER);    {0=leise}

PROCEDURE FMSetInstrument(Kanal,Inst: BYTE);{Instrument setzen   }

PROCEDURE FMStartMusic;                     {Wiedergabe starten             }
PROCEDURE FMStopMusic;                      {Wiedergabe stoppen             }
PROCEDURE FMPauseMusic;                     {Pause/Wiedergabe               }

IMPLEMENTATION

{---------------------------------------}

CONSTRUCTOR tFMSong.INIT;
VAR
  A      : BYTE;
BEGIN
  INHERITED INIT;
  Patterns:=NEW(PCollection,Init(100,20));
  Arrangement:=NEW(PCollection,Init(200,20));
  FOR A:=1 TO 50 DO
    BEGIN
      Instruments[A]:=NEW(pFMInstr);
      InitInstrument(A);
    END;
  SongTitle:='';
  SongAuthor:='';
  FMSongTempo:=96;
  MMSVersion:=$0100;
END;

DESTRUCTOR tFMSong.DONE;
VAR
  A      : BYTE;
BEGIN
  Arrangement^.DeleteAll;
  Patterns^.FreeAll;
  Dispose(Arrangement,DONE);
  Dispose(Patterns,DONE);
  FOR A:=1 TO 50 DO
    Dispose(Instruments[A]);
  INHERITED DONE;
END;

{
  Rckgabe: S^.Status
            -255: Kein MMS
            -254: Nicht genug Speicher
            -253: Falsche MM-Version
}
FUNCTION tFMSong.LadeSong;
VAR
  St     : STRING[23];
  X,A,C,
  Y,Z    : WORD;
  P      : pPattern;
  S1     : STRING[31];
  N      : tNote;
BEGIN
  FMSong^.Arrangement^.DeleteAll;
  FMSong^.Patterns^.FreeAll;
  S^.Read(St,23);
  IF St<>'MMS - SteWeiMusicMaker' THEN
    BEGIN
      LadeSong:=-255;
      EXIT;
    END;
  S^.Read(MMSVersion,2);
  IF MMSVersion<>$0100 THEN
    BEGIN
      LadeSong:=-253;
      EXIT;
    END;

  S^.Read(SongTitle,41);
  S^.Read(SongAuthor,41);
  S^.Read(FMSongTempo,2);

  FOR X:=1 TO 50 DO
    S^.Read(Instruments[X]^,42);

  S^.Read(C,2);
  FOR X:=1 TO C DO
    BEGIN
      IF MemAvail<LowMemSize THEN
        BEGIN
          Patterns^.FreeAll;
          LadeSong:=-254;
          Exit;
        END;
      P:=NEW(pPattern,Init);
      S^.Read(S1,31);
      P^.Name:=S1;
      FOR Y:=1 TO 64 DO
        FOR Z:=1 TO 9 DO
          BEGIN
            S^.Read(N,4);
            P^.Spuren[Z]^.Noten[Y]:=N;
          END;
        Patterns^.Insert(P);
    END;

  S^.Read(A,2);
  FOR X:=1 TO A DO
    BEGIN
      S^.Read(C,2);
      Arrangement^.Insert(FMSong^.Patterns^.At(C));
    END;
  LadeSong:=S^.Status;
END;

FUNCTION tFMSong.SpeichereSong;
VAR
  St     : STRING[23];
  X,Y,Z,I: INTEGER;
  P      : pPattern;
  N      : tNote;
BEGIN
  St:='MMS - SteWeiMusicMaker';
  S^.Write(St,23);
  S^.Write(MMSVersion,2);
  S^.Write(SongTitle,41);
  S^.Write(SongAuthor,41);
  S^.Write(FMSongTempo,2);

  FOR X:=1 TO 50 DO
    S^.Write(Instruments[X]^,42);

  S^.Write(Patterns^.Count,2);
  FOR X:=0 TO Patterns^.Count-1 DO
    BEGIN
      P:=Patterns^.At(X);
      S^.Write(P^.Name,31);
      FOR Y:=1 TO 64 DO
        FOR Z:=1 TO 9 DO
          BEGIN
            N:=P^.Spuren[Z]^.Noten[Y];
            S^.Write(N,4);
          END;
    END;

  S^.Write(Arrangement^.Count,2);
  FOR X:=0 TO Arrangement^.Count-1 DO
    BEGIN
      P:=Arrangement^.At(X);
      I:=Patterns^.IndexOf(P);
      S^.Write(I,2);
    END;
  SpeichereSong:=S^.Status;
END;

PROCEDURE tFMSong.InitInstrument;
BEGIN
  WITH Instruments[Nr]^ DO
    BEGIN
      Name:='';
      INSTR1mod:=0;
      INSTR1tr:=0;
      INSTR2mod:=0;
      INSTR2tr:=0;
      INSTRAttDecMod:=0;
      INSTRAttDecTr:=0;
      INSTRSusRelMod:=0;
      INSTRSusRelTr:=0;
      INSTRVerzMod:=0;
      INSTRVerzTr:=0;
      INSTRRueck:=0;
    END;
END;

{---------------------------------------}

CONST
  OpOffset : ARRAY[1..9] OF BYTE  =(0,1,2,8,9,$A,$10,$11,$12);
                                            {Offsets der 9 Operatoren       }
  NoteNum  : ARRAY[0..12] OF WORD =($16B,$181,$198,$1B0,$1CA,$1E5,$202,
                                    $220,$241,$263,$287,$2AE,$2D9);
                                            {Noten fr Operatoren           }
  TimerHz  : WORD    = 0;                   {aktuelle Frequenz des Timers   }
  TimerVal : WORD    = $FFFF;               {Schritte des Timers(von 1.1MHz)}

  IntInstalled  : BOOLEAN = FALSE;          {neuer TimerIntHandler ?        }
  Int8Handler   : POINTER = NIL;            {neuer TimerIntHandler          }
  PeriodicProc  : POINTER = NIL;            {wird von IntHandler aufgerufen }

VAR
  OldExit          : POINTER;               {alte EXIT-Prozedur             }
  OldInt8          : POINTER;               {alter TimerInt-Handler         }
  TimerCounter     : WORD;                  {Zhler fr TimerIntHandler     }
  OldInst          : ARRAY[1..9] OF BYTE;
  VibFakt          : ARRAY[1..9] OF SHORTINT;
  PortFakt         : ARRAY[1..9] OF SHORTINT;
  PortHelp         : ARRAY[1..9] OF WORD;
  PortHelp2        : ARRAY[1..9] OF BYTE;

FUNCTION GetRealFreq(Hz: WORD) : WORD;
  VAR
    i    : WORD;
    NHz1 : WORD;
    NHz2 : WORD;
  BEGIN
    IF Hz = 0 THEN Hz := 1;
    i := 1193180 DIV Hz;

    NHz1 := 1193180 DIV  i;
    NHz2 := 1193180 DIV (i + 1);
    IF ABS(INTEGER(NHz1 - Hz)) > ABS(INTEGER(NHz2 - Hz)) THEN NHz1 := NHz2;

    GetRealFreq := NHz1;
  END;

PROCEDURE CalcTimerData(Hz: WORD);
BEGIN
  Hz := GetRealFreq(Hz);
  IF Hz = 0 THEN
    TimerVal := $FFFF
  ELSE
    TimerVal := 1193180 DIV Hz;

  TimerHz := Hz;
END;

PROCEDURE OriginalHwTimer; ASSEMBLER;
  ASM
        MOV     AL,54       { Selct timer 0, secuential access and contnuous mode. }
        OUT     43h,AL
        XOR     AL,AL       { Set the counter to 0 (65536). }
        OUT     40h,AL      { Lower byte of the counter.    }
        OUT     40h,AL      { Higher byte.                  }
  END;


PROCEDURE SetHwTimer(value: WORD); ASSEMBLER; {HW-Timer-Frequenz setzen}
  ASM
        MOV     AL,54      
        OUT     43h,AL
        MOV     AX,value
        OUT     40h,AL      
        XCHG    AH,AL
        OUT     40h,AL     
  END;


PROCEDURE RestoreTimer;                     {Standard Timer wiederherstellen}
  BEGIN
    IF IntInstalled THEN
      BEGIN
        SetIntVec(8, OldInt8);
        OriginalHwTimer;
        IntInstalled := FALSE;
      END;
  END;

PROCEDURE InitTimer;                        {neuen TimerIntHandler setzen   }
  BEGIN
    IF NOT IntInstalled THEN
      BEGIN
        IntInstalled := TRUE;
        IF (Int8Handler<>NIL) AND (PeriodicProc<>NIL) THEN
          SetIntVec(8, Int8Handler);
      END;

    SetHwTimer(TimerVal);
  END;




{---------- tPattern ------------}

CONSTRUCTOR tPattern.Init;
VAR
  X,Y    : BYTE;
  S      : pTrack;
  N      : tNote;
BEGIN
  TObject.Init;
  N.Instrument:=0;
  N.Wert:=255;
  N.Effekt:=0;
  N.EWert:=0;
  FOR X:=1 TO 9 DO
    BEGIN
      S:=NEW(pTrack,INIT);
      FOR Y:=1 TO 64 DO
        S^.Noten[Y]:=N;
      Spuren[X]:=S;
    END;
  Bearbeitung:=FALSE;
END;

DESTRUCTOR tPattern.Done;
VAR
  X      : INTEGER;
BEGIN
  FOR X:=1 TO 9 DO
    Dispose(Spuren[X],DONE);
  INHERITED Done;
END;

{--------------------------------}

PROCEDURE FMWriteReg(Reg, Data: BYTE); ASSEMBLER;
ASM
  push   ax
  push   dx
  mov    al,Reg
  mov    dx,FMAdressPort
  out    dx,al
  in     al,dx                              {Warten !                       }
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  mov    dx,FMDataPort
  mov    al,Data
  out    dx,al
  mov    dx,FMAdressPort
  in     al,dx                              {Warten !                       }
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  pop    dx
  pop    ax
END;

FUNCTION FMReadStatus: BYTE;
BEGIN
  FMReadStatus:=PORT[FMAdressPort];
END;

PROCEDURE FMReset;
VAR
  X      : BYTE;
BEGIN
  FOR X:=1 TO 245 DO                        {Quick'n'Dirty-Methode:         }
    FMWriteReg(X,0);                        {in alle FM-Register 0 schreiben}
  FMWriteReg(1,32);                         {Waveform-vernderung erlauben  }
  FMMusicPlay:=FALSE;
  FMMusicPause:=FALSE;
  FMMusicCounter:=0;
  FMPatternCounter:=0;
  FMNoteCounter:=0;
  FMNoteDelay:=12;
  FOR X:=1 TO 9 DO
    BEGIN
      FMChannelStatus.VolBar[X]:=0;
      FMChannelStatus.Laut[X]:=0;
      FMChannelStatus.Effekt[X]:=0;
      FMChannelStatus.Wert[X]:=NNoNote;
      FMChannelStatus.Instr[X]:=0;
      OldInst[X]:=0;
      VibFakt[X]:=1;
    END;
  FMChannelStatus.ActualPattern:=0;
  FMChannelStatus.ActualNote:=0;
  FMChannelStatus.UpDate:=TRUE;
END;

PROCEDURE FMInit;
VAR
  A,B    : BYTE;
BEGIN
  FMReset;
  FMWriteReg(4,$60);                        {Adlib-Erkennung                }
  FMWriteReg(4,$80);
  A:=FMReadStatus;
  FMWriteReg(2,$FF);
  FMWriteReg(4,$21);
  Delay(1);
  B:=FMReadStatus;
  FMWriteReg(4,$60);
  FMWriteReg(4,$80);
  IF (A AND $E0=0) AND (B AND $E0=$C0) THEN
    AdlibPresent:=TRUE;
  FMReset;
END;

PROCEDURE FMSetInstrument;
BEGIN
  WITH FMSong^.Instruments[Inst]^ DO
    BEGIN
      FMWriteReg($20+OpOffset[Kanal],INSTR1Mod);
      FMWriteReg($23+OpOffset[Kanal],INSTR1Tr);
      FMWriteReg($40+OpOffset[Kanal],INSTR2Mod);
      FMWriteReg($43+OpOffset[Kanal],INSTR2Tr);
      FMWriteReg($60+OpOffset[Kanal],INSTRAttDecMod);
      FMWriteReg($63+OpOffset[Kanal],INSTRAttDecTr);
      FMWriteReg($80+OpOffset[Kanal],INSTRSusRelMod);
      FMWriteReg($83+OpOffset[Kanal],INSTRSusRelTr);
      FMWriteReg($C0+Kanal-1,INSTRRueck);
      FMWriteReg($E0+OpOffset[Kanal],INSTRVerzMod);
      FMWriteReg($E3+OpOffset[Kanal],INSTRVerzTr);
      InstSetting.Op1[Kanal]:=INSTR2Mod AND $3F;
      InstSetting.Op2[Kanal]:=INSTR2Tr AND $3F;
      InstSetting.Scal1[Kanal]:=INSTR2Mod AND $C0;
      InstSetting.Scal2[Kanal]:=INSTR2Tr AND $C0;
      InstSetting.FM[Kanal]:=INSTRRueck AND 1=0;
    END;
  FMChannelStatus.Instr[Kanal]:=Inst;
END;

FUNCTION FMGetNoteFineNum;
BEGIN
  FMGetNoteFineNum:=((Wert DIV 12-1) SHL 12)+NoteNum[Wert MOD 12];
END;

PROCEDURE FMNoteOn;
VAR
  NotenWert  : WORD;
BEGIN
  NotenWert:=FMGetNoteFineNum(Wert);
  FMNoteFineOn(Kanal,NotenWert,Laut);
  FMChannelStatus.Wert[Kanal]:=Wert;
END;

PROCEDURE FMNoteFineOn;
VAR
  Wert   : BYTE;
BEGIN
  Wert:=Num SHR 12;
  FMChannelStatus.CurrNoteNum[Kanal]:=Num;
  IF InstSetting.FM[Kanal]=TRUE THEN
    BEGIN
      FMWriteReg($43+OpOffset[Kanal],InstSetting.Scal2[Kanal]+Laut);
    END
  ELSE
    BEGIN
      FMWriteReg($40+OpOffset[Kanal],InstSetting.Scal1[Kanal]+Laut);
      FMWriteReg($43+OpOffset[Kanal],InstSetting.Scal2[Kanal]+Laut);
    END;
  FMWriteReg($A0+Kanal-1,BYTE(Num AND $00FF));
  FMWriteReg($B0+Kanal-1,Wert SHL 2+
    BYTE((Num AND $0FFF) SHR 8)+$20);
  FMChannelStatus.Laut[Kanal]:=63-Laut;
  FMChannelStatus.VolBar[Kanal]:=63-Laut;
END;

PROCEDURE FMNoteOff;
VAR
  NotenWert   : WORD;
BEGIN
  FMWriteReg($B0+Kanal-1,0);
  FMChannelStatus.Effekt[Kanal]:=ENoEffekt;
  FMChannelStatus.Wert[Kanal]:=NNoNote;
  FMChannelStatus.Laut[Kanal]:=0;
  FMChannelStatus.VolBar[Kanal]:=0;
  FMChannelStatus.CurrNoteNum[Kanal]:=0;
END;

PROCEDURE FMPortaUp;
VAR
  Num    : WORD;
BEGIN
  Num:=FMChannelStatus.CurrNoteNum[Kanal]+FMChannelStatus.EWert[Kanal];
  IF (Num AND $0FFF)>=NoteNum[12] THEN
    Num:=(Num AND $F000)+(1 SHL 12)+NoteNum[0];
  FMNoteFineOn(Kanal,Num,63-FMChannelStatus.Laut[Kanal]);
END;

PROCEDURE FMPortaDown;
VAR
  Num    : WORD;
BEGIN
  Num:=FMChannelStatus.CurrNoteNum[Kanal]-FMChannelStatus.EWert[Kanal];
  IF (Num AND $0FFF)<=NoteNum[0] THEN
    Num:=(Num AND $F000)-(1 SHL 12)+NoteNum[12];
  FMNoteFineOn(Kanal,Num,63-FMChannelStatus.Laut[Kanal]);
END;

PROCEDURE FMVolumeDown;
BEGIN
  FMSetVolume(Kanal,FMChannelStatus.Laut[Kanal]-FMChannelStatus.EWert[Kanal]);
END;

PROCEDURE FMVolumeUp;
BEGIN
  FMSetVolume(Kanal,FMChannelStatus.Laut[Kanal]+FMChannelStatus.EWert[Kanal]);
END;

PROCEDURE FMVibrato;
VAR
  Num    : WORD;
BEGIN
  Num:=FMChannelStatus.CurrNoteNum[Kanal]+FMChannelStatus.EWert[Kanal]*VibFakt[Kanal];
  FMNoteFineOn(Kanal,Num,63-FMChannelStatus.Laut[Kanal]);
END;

PROCEDURE FMVibr_VSlideUp;
BEGIN
  FMVolumeUp(Kanal);
  FMVibrato(Kanal);
END;

PROCEDURE FMVibr_VSlideDn;
BEGIN
  FMVolumeDown(Kanal);
  FMVibrato(Kanal);
END;

PROCEDURE FMPortToNote;
BEGIN
  IF Abs(FMChannelStatus.CurrNoteNum[Kanal]-PortHelp[Kanal])<FMChannelStatus.EWert[Kanal] THEN
    BEGIN
      FMNoteFineOn(Kanal,PortHelp[Kanal],63-FMChannelStatus.Laut[Kanal]);
      FMChannelStatus.Effekt[Kanal]:=ENoEffekt;
      FMChannelStatus.Wert[Kanal]:=PortHelp2[Kanal];
      EXIT;
    END;
  IF PortFakt[Kanal]=1 THEN
    FMPortaUp(Kanal)
  ELSE
    FMPortaDown(Kanal);
  FMChannelStatus.Wert[Kanal]:=PortHelp2[Kanal];
END;

PROCEDURE FMPort_VSlideUp;
BEGIN
  FMVolumeUp(Kanal);
  FMPortToNote(Kanal);
END;

PROCEDURE FMPort_VSlideDn;
BEGIN
  FMVolumeDown(Kanal);
  FMPortToNote(Kanal);
END;

PROCEDURE FMEnableTimer;
BEGIN
  InitTimer;
END;

PROCEDURE FMDisableTimer;
BEGIN
  RestoreTimer;
END;

PROCEDURE FMSetTimerFreq;
BEGIN
  CalcTimerData(Frequency);
END;

PROCEDURE FMSetVolume;
VAR
  L      : BYTE;
BEGIN
  L:=Laut;
  IF Laut<0 THEN
    L:=0;
  IF Laut>63 THEN
    L:=63;
  IF InstSetting.FM[Kanal]=TRUE THEN
    BEGIN
      FMWriteReg($43+OpOffset[Kanal],InstSetting.Scal2[Kanal]+63-L);
    END
  ELSE
    BEGIN
      FMWriteReg($40+OpOffset[Kanal],InstSetting.Scal1[Kanal]+63-L);
      FMWriteReg($43+OpOffset[Kanal],InstSetting.Scal2[Kanal]+63-L);
    END;
  FMChannelStatus.Laut[Kanal]:=L;
  FMChannelStatus.VolBar[Kanal]:=L;
END;

PROCEDURE MusicPlayer;                      {eigentliche Abspielroutine     }
VAR
  X      : BYTE;
  N      : tNote;
BEGIN
  IF FMMusicPlay AND NOT FMMusicPause THEN
    BEGIN
      FMChannelStatus.UpDate:=TRUE;
      FOR X:=1 TO 9 DO
        IF FMChannelStatus.VolBar[X]>0 THEN
          DEC(FMChannelStatus.VolBar[X]);
      INC(FMMusicCounter);
      IF FMMusicCounter=FMNoteDelay THEN
        BEGIN
          FMChannelStatus.ActualPattern:=FMPatternCounter;
          FMChannelStatus.ActualNote:=FMNoteCounter;
          FMMusicCounter:=0;
          INC(FMNoteCounter);
          IF FMNoteCounter>64 THEN
            BEGIN
              FMNoteCounter:=1;
              INC(FMPatternCounter);
              IF FMPatternCounter>FMSong^.Arrangement^.Count-1 THEN
                BEGIN
                  FMPatternCounter:=0;
                  IF NOT FMMusicLoop THEN
                    BEGIN
                      FMStopMusic;
                      EXIT;
                    END;
                END;
            END;
        END;
      IF FMMusicCounter MOD 4 = 0 THEN
        BEGIN
          FOR X:=1 TO 9 DO
            BEGIN
              CASE FMChannelStatus.Effekt[X] OF
                  EPortUp             : FMPortaUp(X);
                  EPortDown           : FMPortaDown(X);
                  EVibrato            : FMVibrato(X);
                  EVibr_VSlideUp      : FMVibr_VSlideUp(X);
                  EVibr_VSlideDn      : FMVibr_VSlideDn(X);
                  EVolumeDown         : FMVolumeDown(X);
                  EVolumeUp           : FMVolumeUp(X);
                  EPortToNote         : FMPortToNote(X);
                  EPort_VSlideUp      : FMPort_VSlideUp(X);
                  EPort_VSlideDn      : FMPort_VSlideDn(X);
                END;
            END;
        END;
      IF FMMusicCounter=0 THEN
        BEGIN
          FMPattern:=FMSong^.Arrangement^.At(FMPatternCounter);
          FOR X:=1 TO 9 DO
            BEGIN
              IF FMChannelStatus.Effekt[X]=EPatternDelay THEN
                IF FMChannelStatus.EWert[X]>0 THEN
                  BEGIN
                    DEC(FMChannelStatus.EWert[X]);
                    DEC(FMNoteCounter);
                    EXIT;
                  END;
              N:=FMPattern^.Spuren[X]^.Noten[FMNoteCounter];
              CASE N.Effekt OF
                  EPatBreak       : BEGIN
                                      FMNoteCounter:=64;
                                      FMChannelStatus.Effekt[X]:=EPatBreak;
                                    END;
                  ESetSpeed       : BEGIN
                                      FMNoteDelay:=N.EWert;
                                      FMChannelStatus.Effekt[X]:=ESetSpeed;
                                    END;
                  EPatternDelay   : BEGIN
                                      FMChannelStatus.EWert[X]:=N.EWert;
                                      FMChannelStatus.Effekt[X]:=EPatterndelay;
                                    END;
                END;
              IF N.Wert=NNoteOff THEN
                FMNoteOff(X)
              ELSE
                BEGIN
                  IF N.Wert=NNoNote THEN
                    BEGIN
                      CASE N.Effekt OF
                          ENoEffekt      : FMChannelStatus.Effekt[X]:=ENoEffekt;
                          ESetVolume     : FMSetVolume(X,N.EWert);
                          EVolumeDown,
                          EVolumeUp,
                          EPortUp,
                          EPortDown      : BEGIN
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                           END;
                          EVibrato,
                          EVibr_VSlideUp,
                          EVibr_VSlideDn : BEGIN
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                             VibFakt[X]:=VibFakt[X]*(-1);
                                           END;
                          EPortToNote,
                          EPort_VSlideUp,
                          EPort_VSlideDn : BEGIN
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                             IF PortHelp[X]>
                                                FMChannelStatus.CurrNoteNum[X] THEN
                                               PortFakt[X]:=1
                                             ELSE
                                               PortFakt[X]:=-1;
                                           END;
                        END;
                    END
                  ELSE
                    BEGIN
                      IF OldInst[X]<>N.Instrument THEN
                        BEGIN
                          FMSetInstrument(X,N.Instrument);
                          Oldinst[X]:=N.Instrument;
                        END;
                      CASE N.Effekt OF
                          ESetVolume     : BEGIN
                                             FMNoteOff(X);
                                             FMNoteOn(X,N.Wert,0);
                                             FMSetVolume(X,N.EWert);
                                           END;
                          ENoEffekt      : BEGIN
                                             FMNoteOff(X);
                                             FMNoteOn(X,N.Wert,InstSetting.Op2[X]);
                                           END;
                          EVolumeDown,
                          EVolumeUp,
                          EPortUp,
                          EPortDown      : BEGIN
                                             FMNoteOff(X);
                                             FMNoteOn(X,N.Wert,Instsetting.Op2[X]);
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                           END;
                          EVibrato,
                          EVibr_VSlideUp,
                          EVibr_VSlideDn : BEGIN
                                             FMNoteOff(X);
                                             FMNoteOn(X,N.Wert,Instsetting.Op2[X]);
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                             VibFakt[X]:=-1;
                                           END;
                          EPortToNote,
                          EPort_VSlideUp,
                          EPort_VSlideDn : BEGIN
                                             FMChannelStatus.Effekt[X]:=N.Effekt;
                                             FMChannelStatus.EWert[X]:=N.EWert;
                                             PortHelp2[X]:=N.Wert;
                                             PortHelp[X]:=FMGetNoteFineNum(N.Wert);
                                             IF PortHelp[X]>
                                                FMChannelStatus.CurrNoteNum[X] THEN
                                               PortFakt[X]:=1
                                             ELSE
                                               PortFakt[X]:=-1;
                                           END;
                        END;
                    END;
                END;
              FMChannelStatus.Effekt[X]:=N.Effekt;
            END;
        END;
    END;
END;

PROCEDURE FMStartMusic;
BEGIN
  IF (FMMusicPlay=FALSE) AND (FMSong^.Arrangement<>NIL) AND
     (FMSong^.Arrangement^.Count>0) THEN
    BEGIN
      FMMusicPlay:=TRUE;
      FMMusicPause:=FALSE;
      FMSetTimerFreq(FMSongTempo);
      FMEnableTimer;
    END;
END;

PROCEDURE FMStopMusic;
BEGIN
  IF (FMMusicPlay=TRUE) THEN
    BEGIN
      FMReset;
      FMDisableTimer;
    END;
END;

PROCEDURE FMPauseMusic;
BEGIN
  IF FMMusicPause=TRUE THEN
    BEGIN
      IF (FMSong^.Arrangement<>NIL) AND (FMSong^.Arrangement^.Count>0) THEN
        FMMusicPause:=FALSE
      ELSE
        FMReset;
    END
  ELSE
    FMMusicPause:=TRUE;
END;

{$F+}
PROCEDURE NewInt8Handler; INTERRUPT;
VAR
  Flags  : WORD;
BEGIN
  ASM CLI END;                              {Ints sperren (vs. Rekursion)   }
  TimerCounter:=TimerCounter-TimerVal;      {mu alter Timer-Handler auf-   }
  IF TimerCounter<=TimerVal THEN            {gerufen werden ? (18.2 Hz=$FFFF}
    BEGIN                                   {Warteschritte des Timer-Chips) }
      TimerCounter:=$FFFF;
      ASM
        pushf                               {alte Routine aufrufen          }
        call  [OldInt8]
      END;
    END
  ELSE
    BEGIN
      ASM
        push  ax                            {sonst nur Int-Controller       }
        mov   al,20h                        {zurcksetzen                   }
        out   20h,al
        pop   ax
      END;
    END;
  ASM
    pusha                                   {alle Register sichern          }
    push   es
    call   [PeriodicProc]                   {Musikroutine aufrufen          }
    pop    es                               {Register wiederherstellen      }
    popa
  END;
  ASM STI END;                              {Ints wieder erlauben           }
END;

PROCEDURE NewExit;
BEGIN
  ExitProc:=OldExit;                        {alte EXIT-Prozedur             }
  SetIntVec(8,OldInt8);
  RestoreTimer;                             {alten Timer wiederherstellen   }
  FMInit;                                   {Adlib rcksetzen               }
END;
{$F-}

BEGIN
  TimerCounter:=$FFFF;                      {Standard (18.2 Hz)             }
  GetIntVec(8,OldInt8);                     {alte TimerInt-Handler sichern  }
  Int8Handler:=@NewInt8Handler;             {neuer TimerInt-Handler         }
  PeriodicProc:=@MusicPlayer;               {Musikroutine                   }
  OldExit:=ExitProc;                        {alte EXIT-Prozedur sichern     }
  ExitProc:=@NewExit;                       {neue EXIT-Prozedur             }
  FMInit;                                   {Adlib rcksetzen/initialisieren}
END.
