{

             Programm: MusicMaker
              Version: 1.0
                Autor: Stephan Weinberger
                       (C) 1995 synthesis design

}

{M 60000,50000,655000}
{$G+}

USES App,Menus,Objects,Views,Drivers,Gadgets,MouseDlg,ColorSel,
     MsgBox,Memory,Dialogs,CompWin,StdDlg,Dos,InstEdit,Overlay,
     ArraDlg,ConvMOD,HelpFile,Crt,FMVoice,PlayWin,Beep;

CONST
  PrgVersionString  = '1.0';
  PrgNameString     = 'MusicMaker';
  PrgAutorString    = 'Stephan Weinberger';
  PrgCString        = '(C) 1995 synthesis design';

{$O App}
{$O Menus}
{$O Objects}
{$O Views}
{$O Gadgets}
{$O MouseDlg}
{$O ColorSel}
{$O MsgBox}
{$O Dialogs}
{$O CompWin}
{$O StdDlg}
{$O InstEdit}
{$O ArraDlg}
{$O ConvMOD}
{$O HelpFile}
{$O PlayWin}
{$O Beep}

TYPE
  pNewStatusLine   = ^tNewStatusLine;
  tNewStatusLine   = OBJECT(TStatusLine)
    FUNCTION         Hint(AHelpCtx: WORD): STRING;         Virtual;
  END;

  pMusicMakerApp   = ^tMusicMakerApp;
  tMusicMakerApp   = OBJECT(TApplication)
    Heap           : pHeapView;
    Clock          : pClockView;
    hWin           : pHelpWindow;
    Datei          : STRING;
    PlayWin        : pPlayWin;
    ArraWin        : pArraChangeDlg;
    CONSTRUCTOR      Init;
    DESTRUCTOR       Done;                                      Virtual;
    PROCEDURE        HandleEvent(VAR Event: TEvent);            Virtual;
    PROCEDURE        GetEvent(VAR Event: TEvent);               Virtual;
    PROCEDURE        Idle;                                      Virtual;
    PROCEDURE        InitStatusLine;                            Virtual;
    PROCEDURE        InitMenuBar;                               Virtual;
    PROCEDURE        OutOfMemory;                               Virtual;
    PROCEDURE        Colors;
    PROCEDURE        SpeichereSong(DateiName: STRING);
    PROCEDURE        LadeSong(DateiName: STRING);
    PROCEDURE        Info;
  END;

CONST
  cmInfo           = 101;
  cmColors         = 102;
  cmMouse          = 103;
  cmChangeDir      = 104;
  cmSBInfo         = 105;
  cmSBReset        = 106;
  cmHelpIndex      = 107;

  cmNew            = 110;
  cmOpen           = 111;
  cmSave           = 112;
  cmSaveAs         = 113;
  cmConvertMOD     = 114;

  cmNewPat         = 120;
  cmEditPat        = 121;
  cmRenPat         = 122;
  cmDelPat         = 123;
  cmOpenPat        = 124;
  cmSavePat        = 125;
  cmMoveInst       = 127;
  cmSetTrack2Inst  = 128;
  cmChangeInstInPat= 129;
  cmCopyTrack      = 130;
  cmInsertTrack    = 131;
  cmTransposeTrack = 133;
  cmChangeWhat     = 134;
  cmTransposeInst  = 135;

  cmNewInst        = 140;
  cmOpenInst       = 141;
  cmSaveInst       = 142;
  cmChangeInst     = 143;
  cmInstFromCMF    = 144;
  cmDelInst        = 145;

  cmChangeSpeed    = 152;
  cmSongTitle      = 153;
  cmSongAuthor     = 154;

  cmHelpOnHelp     = 200;
  cmSaveQuit       = 201;

  hcInfo           = 1101;
  hcColors         = 1102;
  hcMouse          = 1103;
  hcChangeDir      = 1104;
  hcSBInfo         = 1105;
  hcSBReset        = 1106;
  hcHelpIndex      = 1107;

  hcNew            = 1110;
  hcOpen           = 1111;
  hcSave           = 1112;
  hcSaveAs         = 1113;
  hcConvertMOD     = 1117;

  hcNewPat         = 1120;
  hcEditPat        = 1121;
  hcRenPat         = 1122;
  hcDelPat         = 1123;
  hcOpenPat        = 1124;
  hcSavePat        = 1125;
  hcMoveInst       = 1127;
  hcSetTrack2Inst  = 1128;
  hcChangeInstInPat= 1129;
  hcCopyTrack      = 1130;
  hcInsertTrack    = 1131;
  hcTransposeTrack = 1133;
  hcCopyPat        = 1134;
  hcInsertPat      = 1135;
  hcChangeWhat     = 1136;
  hcTransposeInst  = 1137;

  hcNewInst        = 1140;
  hcOpenInst       = 1141;
  hcSaveInst       = 1142;
  hcChangeInst     = 1143;
  hcInstFromCMF    = 1144;
  hcDelInst        = 1145;

  hcChangeSpeed    = 1152;
  hcSongTitle      = 1153;
  hcSongAuthor     = 1154;

  hcQuit           = 1200;
  hcClose          = 1201;
  hcResize         = 1202;
  hcZoom           = 1203;
  hcNext           = 1204;
  hcPrev           = 1205;

  hcDialog         = 30000;
  hcColorDialog    = 30001;
  hcMouseDialog    = 30002;
  hcChDirDialog    = 30003;
  hcFileDialog     = 30004;
  hcEndeDialog     = 30005;
  hcInstEdit       = 30007;
  hcChArraDialog   = 32002;
  hcHelpWindow     = 40000;
  hcHelpOnHelp     = 40001;


  PlayCommands     = [cmPlayStart];

FUNCTION tNewStatusLine.Hint;
VAR
  S      : STRING;
BEGIN
  S:='';
  CASE AHelpCtx OF
      hcInfo           : S:='Information ber das Programm';
      hcColors         : S:='ndert die Farben';
      hcMouse          : S:='ndert Mauseinstellungen';
      hcChangeDir      : S:='ndert das Standardverzeichnis';
      hcSBReset        : S:='Adlib-Reset durchfhren';
      hcHelpIndex      : S:='Zeigt Hilfe-Index';

      hcNew            : S:='Neues Stck erstellen';
      hcOpen           : S:='Stck von Disk/Platte laden';
      hcSave           : S:='Stck auf Disk/Platte speichern';
      hcSaveAs         : S:='Stck unter neuem Namen speichern';
      hcConvertMOD     : S:='Stck vom MOD- ins MMS-Format konvertieren';

      hcNewPat         : S:='Neuen Abschnitt erstellen';
      hcEditPat        : S:='Bestehenden Abschnitt ndern';
      hcRenPat         : S:='Bestehenden Abschnitt umbenennen';
      hcDelPat         : S:='Bestehenden Abschnitt lschen';
      hcOpenPat        : S:='Abschnitt von Disk/Platte laden';
      hcSavePat        : S:='Abschnitt auf Disk/Platte speichern';
      hcMoveInst       : S:='Instrument auf andere Spur legen';
      hcSetTrack2Inst  : S:='Spur auf Instrument setzen';
      hcChangeInstInPat: S:='Bestimmtes Instrument ndern';
      hcCopyTrack      : S:='Spur in Puffer kopieren';
      hcInsertTrack    : S:='Puffer in Spur schreiben';
      hcTransposeTrack : S:='Spur transponieren';
      hcCopyPat        : S:='Aktuellen Abschnitt in Puffer kopieren';
      hcInsertPat      : S:='Abschnitt aus Puffer einfgen';
      hcChangeWhat     : S:='nderungsmodus wechseln';
      hcTransposeInst  : S:='Bestimmtes Instrument transponieren';
      hcNewInst        : S:='Neues Instrument erstellen';
      hcOpenInst       : S:='SB-Instrument von Disk/Platte laden';
      hcSaveInst       : S:='SB-Instrument auf Disk/Platte speichern';
      hcChangeInst     : S:='SB-Instrument editieren';
      hcInstFromCMF    : S:='Instrument aus vorhandener CMF-Datei lesen';
      hcDelInst        : S:='Instrument lschen';

      hcChangeSpeed    : S:='Geschwindigkeit des Stckes ndern';
      hcSongTitle      : S:='Titel des Stckes ndern';
      hcSongAuthor     : S:='Komponisten des Stckes ndern';

      hcQuit           : S:='MusicMaker beenden';
      hcClose          : S:='Aktuelles Fenster schlieen';
      hcResize         : S:='Aktuelles Fenster verschieben';
      hcZoom           : S:='Aktuelles Fenster zoomen/verkleinern';
      hcNext           : S:='Nchstes Fenster aktivieren';
      hcPrev           : S:='Voriges Fenster aktivieren';
    END;
  Hint:=S;
END;

{********** tMusicMakerApp **********}

CONSTRUCTOR tMusicMakerApp.Init;
VAR
  F      : TDOSStream;
  S      : STRING;
  A      : WORD;
  R      : TRect;
BEGIN
  TApplication.Init;

  F.INIT('MUSICMAK.INI',stOpenRead);
  F.Read(S,255);
  IF F.Status=stOk THEN
    BEGIN
      Application^.GetPalette^:=S;
      F.Read(A,1);
      IF A=101 THEN
        MouseReverse:=TRUE
      ELSE
        MouseReverse:=FALSE;
      F.Read(DoubleDelay,2);
    END
  ELSE
    BEGIN
      BeepSound;
      MessageBox('Fehler beim Lesen von MUSICMAK.INI !',
        NIL, mfError + mfOkButton);
      DoneMemory;
    END;
  F.DONE;

  DoneMemory;
  ReDraw;

  FMSong:=NEW(pFMSong,INIT);
  Datei:='NONAME.MMS';
  FMSongTempo:=96;
  ChangeAll:=FALSE;

  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);

  GetExtent(R);
  R.A.X := R.B.X - 7; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);

  ArraWin:=NEW(pArraChangeDlg,Init);
  ArraWin^.HelpCtx:=hcChArraDialog;
  Desktop^.Insert(ArraWin);

  PlayWin:=NEW(pPlayWin,Init);
  DeskTop^.Insert(PlayWin);
  PlayWin^.HelpCtx:=hcPlayWin;

  hWin:=NIL;
END;

PROCEDURE tMusicMakerApp.InitMenuBar;
VAR
  R      : TRect;
BEGIN
  R.Assign(0,0,80,1);
  MenuBar:=NEW(PMenuBar,Init(R,
  NewMenu(
    NewSubMenu('~',0,
    NewMenu(
      NewItem('~1~ Farben...','',kbNoKey,cmColors,hcColors,
      NewItem('~2~ Maus...','',kbNoKey,cmMouse,hcMouse,
      NewLine(
      NewItem('~3~ Verzeichnis wechseln...','',kbNoKey,cmChangeDir,
      hcChangeDir,
      NewLine(
      NewItem('~4~ Status-Info...','',kbNoKey,cmSBInfo,hcSBInfo,
      NewItem('~5~ Adlib-Reset','',kbNoKey,cmSBReset,hcSBReset,
      NIL)))))))),
    NewSubMenu('~D~atei',0,
    NewMenu(
      NewItem('~1~ Neu','',kbNoKey,cmNew,hcNew,
      NewItem('~2~ ffnen...','F3',kbF3,cmOpen,hcOpen,
      NewItem('~3~ Speichern','F2',kbF2,cmSave,hcSave,
      NewItem('~4~ Speichern als...       ','',kbNoKey,cmSaveAs,hcSaveAs,
      NewLine(
      NewItem('~5~ MOD-Datei konvertieren...','',kbNoKey,cmConvertMOD,
      hcConvertMOD,
      NewLine(
      NewItem('~E~ Ende','ALT-X',kbAltX,cmQuit,hcQuit,
      NIL))))))))),
    NewSubMenu('~A~bschnitt',0,
    NewMenu(
      NewItem('~1~ Neu...','F8',kbF8,cmNewPat,hcNewPat,
      NewItem('~2~ Laden...','STRG-F3',kbCtrlF3,cmOpenPat,hcOpenPat,
      NewItem('~3~ Speichern... ','STRG-F2',kbCtrlF2,cmSavePat,hcSavePat,
      NewLine(
      NewItem('~4~ ndern...','F7',kbF7,cmEditPat,hcEditPat,
      NewItem('~5~ Umbenennen...','',kbNoKey,cmRenPat,hcRenPat,
      NewItem('~6~ Lschen...','',kbNoKey,cmDelPat,hcDelPat,
      NewLine(
      NewItem('~7~ Kopieren','',kbNoKey,cmCopyPat,hcCopyPat,
      NewItem('~8~ Einfgen','',kbNoKey,cmInsertPat,hcInsertPat,
      NIL))))))))))),
    NewSubMenu('~E~dit',0,
    NewMenu(
      NewSubMenu('~1~ Instrument',0,
      NewMenu(
        NewItem('~1~ Verschieben...','',kbNoKey,cmMoveInst,hcMoveInst,
        NewItem('~2~ Setzen...','',kbNoKey,cmSetTrack2Inst,hcSetTrack2Inst,
        NewItem('~3~ ndern...','',kbNoKey,cmChangeInstInPat,
        hcChangeInstInPat,
        NewItem('~4~ Transponieren...','',kbNokey,cmTransposeInst,
        hcTransposeInst,
        NIL))))),
      NewItem('~2~ Spur Transponieren...','',kbNoKey,cmTransposeTrack,
      hcTransposeTrack,
      NewItem('~3~ nderungsmodus...','',kbNoKey,cmChangeWhat,
      hcChangeWhat,
      NewLine(
      NewItem('~4~ Spur kopieren...','',kbNoKey,cmCopyTrack,hcCopyTrack,
      NewItem('~5~ Spur einfgen...','',kbNoKey,cmInsertTrack,hcInsertTrack,
      NIL))))))),
    NewSubMenu('~I~nstrument',0,
    NewMenu(
      NewItem('~1~ Neu','',kbNoKey,cmNewInst,hcNewInst,
      NewItem('~2~ Laden...','',kbNoKey,cmOpenInst,hcOpenInst,
      NewItem('~3~ Speichern...','',kbNoKey,cmSaveInst,hcSaveInst,
      NewItem('~4~ Lschen...','',kbNoKey,cmDelInst,hcDelInst,
      NewLine(
      NewItem('~5~ ndern...','',kbNoKey,cmChangeInst,hcChangeInst,
      NewItem('~6~ Lesen aus CMF...','',kbNoKey,cmInstFromCMF,
      hcInstFromCMF,
      NIL)))))))),
    NewSubMenu('A~r~rangement',0,
    NewMenu(
      NewItem('~1~ Tempo...','',kbNoKey,cmChangeSpeed,hcChangeSpeed,
      NewItem('~2~ Titel...','',kbNoKey,cmSongTitle,hcSongTitle,
      NewItem('~3~ Komponist...','',kbNoKey,cmSongAuthor,hcSongAuthor,
      NIL)))),
    NewSubMenu('~F~enster',0,
    NewMenu(
      NewItem('~1~ Schlieen','ALT-F3',kbAltF3,cmClose,hcClose,
      NewLine(
      NewItem('~2~ Verschieben','STRG-F5',kbCtrlF5,cmResize,hcResize,
      NewItem('~3~ Zoomen','F5',kbF5,cmZoom,hcZoom,
      NewLine(
      NewItem('~4~ Nchstes','F6',kbF6,cmNext,hcNext,
      NewItem('~5~ Voriges','SHIFT-F6',kbShiftF6,cmPrev,hcPrev,
      NIL)))))))),
    NewSubMenu('~H~ilfe',0,
    NewMenu(
      NewItem('~1~ Hilfe verwenden','STRG-F1',kbCtrlF1,cmHelpOnHelp,hcNoContext,
      NewItem('~2~ Hilfe-Index','SHIFT-F1',kbShiftF1,cmHelpIndex,hcHelpIndex,
      NewLine(
      NewItem('~3~ Info...','',kbNoKey,cmInfo,hcInfo,
      NIL))))),
    NIL)))))))))));
END;

PROCEDURE tMusicMakerApp.InitStatusLine;
VAR
  R      : TRect;
BEGIN
  R.Assign(0,24,80,25);
  StatusLine:=NEW(PNewStatusLine,Init(R,
    NewStatusDef(0,10000,
      NewStatusKey('~F1~ Hilfe',kbF1,cmHelp,
      NewStatusKey('~F10~ Men',kbF10,cmMenu,
      NIL)),
    NewStatusDef(10001,32000,
      NewStatusKey('~ESC~ Schlieen',kbESC,cmClose,
      NewStatusKey('~F1~ Hilfe',kbF1,cmHelp,
      NIL)),
    NewStatusDef(32001,39999,
      NewStatusKey('~F1~ Hilfe',kbF1,cmhelp,
      NewStatusKey('~F10~ Men',kbF10,cmMenu,
      NIL)),
    NewStatusDef(40000,$FFFF,
      NewStatusKey('~ESC~ Schlieen',kbESC,cmClose,
      NewStatusKey('~F5~ Zoomen',kbF5,cmZoom,
      NIL)),
    NIL))))));
END;

PROCEDURE tMusicMakerApp.OutOfMemory;
BEGIN
  BeepSound;
  MessageBox('Nicht genug Speicher frei !!',
  NIL, mfError + mfOkButton);
  DoneMemory;
END;

PROCEDURE tMusicMakerApp.Info;
VAR
  d  : PDialog;
  r  : TRect;
BEGIN
  r.Assign(0,0,40,11);
  d:=New(PDialog,Init(r,'Info'));
  WITH d^ DO
    BEGIN
      Options:=Options OR OfCentered;
      Flags:=$00;
      HelpCtx:=hcDialog;

      r.Assign(2,8,38,10);
      Insert(New(pButton,Init(r,'~O~K',cmok,BfDefault)));

      r.Assign(2,2,38,7);
      Insert(New(PStaticText,Init(r,
      ^c+PrgNameString+#13+^c+'Version '+PrgVersionString+#13+#13+
      ^c+PrgCString+#13+^c+PrgAutorString)));
    END;
  Desktop^.ExecView(d);
  Dispose(d,Done);
END;

PROCEDURE tMusicMakerApp.HandleEvent;
VAR
  r       : TRect;

FUNCTION SongSpeichernAls: WORD;
VAR
  d     : pFileDialog;
  s,s1  : STRING;
  s2,s3 : STRING;
  H     : WORD;
BEGIN
  s:='*.MMS';
  d:=New(pfiledialog,Init(s,'Stck speichern','Datei:',
  fdokbutton,100));
  d^.HelpCtx := hcFileDialog;
  H:=cmCancel;
  IF validview(d)<>NIL THEN
    BEGIN
      H:=Desktop^.ExecView(d);
      IF H<>cmCancel THEN
        BEGIN
          d^.getfilename(s);
          Dispose(d,Done);
          FSplit(s,s1,s2,s3);
          s:=s1+s2+'.MMS';
          SpeichereSong(s);
        END
      ELSE
        Dispose(d,Done);
    END;
  SongSpeichernAls:=H;
END;

FUNCTION SongSpeichern: WORD;
BEGIN
  IF datei='NONAME.MMS' THEN
    SongSpeichern:=SongSpeichernAls
  ELSE
    BEGIN
      SongSpeichern:=cmCancel;
      SpeichereSong(datei);
    END;
END;

PROCEDURE Mouse;
VAR
  D: PDialog;
  F: TDOSStream;
  A: WORD;
BEGIN
  D := New(PMouseDialog, Init);
  D^.HelpCtx:=hcMouseDialog;
  IF ValidView(D) <> NIL THEN
    BEGIN
      D^.SetData(MouseReverse);
      IF Desktop^.ExecView(D) <> cmCancel THEN
        BEGIN
          D^.GetData(MouseReverse);
          F.INIT('MUSICMAK.INI',stCreate);
          F.Write(Application^.GetPalette^,255);
          IF MouseReverse THEN
            A:=101
          ELSE
            A:=0;
          F.Write(A,1);
          F.Write(DoubleDelay,2);
          F.DONE;
        END;
    END;
END;

PROCEDURE WirklichBeenden(VAR Ev: TEvent);
VAR
  d  : pDialog;
  r  : trect;
  w  : word;
BEGIN
  BeepSound;
  r.assign(0,0,56,9);
  d:=new(pDialog,init(r,'Speichern ?'));
  with d^ do
    begin
      options:=options or ofcentered;
      HelpCtx:=hcEndeDialog;

      r.assign(1,1,55,5);
      insert(new(pstatictext,init(r,^c+'ACHTUNG !'+#13+
         ^c+'Sie sind dabei, MusicMaker zu beenden.'+#13+
         ^c+'Noch nicht gesicherte Daten werden zerstrt !'+#13+
         ^c+'Wollen Sie das Musikstck speichern ?')));

      r.assign(1,6,20,8);
      insert(new(pbutton,init(r,'~J~a',cmYes,bfnormal)));

      r.assign(20,6,35,8);
      insert(new(pbutton,init(r,'~N~ein',cmOk,bfdefault)));

      r.assign(35,6,55,8);
      insert(new(pbutton,init(r,'~A~bbruch',cmCancel,bfnormal)));
    end;

  w:=desktop^.execview(d);
  dispose(d,done);

  case w of
      cmOk     : begin
                   ev.what:=evcommand;
                   ev.command:=cmquit;
                 end;
      cmYes    : begin
                   ev.what:=evcommand;
                   ev.command:=cmSaveQuit;
                 end;
      cmcancel : begin
                   ev.what:=evnothing;
                   ev.command:=cmok;
                 end;
    end;
end;

PROCEDURE SongLaden;
VAR
  d   : pFileDialog;
  s   : STRING;
BEGIN
  s:='*.MMS';
  d:=New(pfiledialog,Init(s,'Stck laden','Datei:',
  fdopenbutton,100));
  d^.HelpCtx := hcFileDialog;
  IF validview(d)<>NIL THEN
    BEGIN
      IF Desktop^.ExecView(d)<>cmcancel THEN
        BEGIN
          d^.getfilename(s);
          Dispose(d,Done);
          LadeSong(s);
        END
      ELSE
        Dispose(d,Done);
    END;
END;

PROCEDURE ChangeSongTitle;
VAR
  S      : STRING[40];
BEGIN
  S:=FMSong^.SongTitle;
  IF InputBox('Titel des Stckes','~T~itel:',S,40)<>cmCancel THEN
    BEGIN
      FMSong^.SongTitle:=S;
    END;
END;

PROCEDURE ChangeSongAuthor;
VAR
  S      : STRING[40];
BEGIN
  S:=FMSong^.SongAuthor;
  IF InputBox('Autor des Stckes','~A~utor:',S,40)<>cmCancel THEN
    BEGIN
      FMSong^.SongAuthor:=S;
    END;
END;

PROCEDURE ChangeSongSpeed;
VAR
  R      : TRect;
  D      : PDialog;
  Z      : pZahl;
BEGIN
  R.Assign(0,0,20,7);
  D:=NEW(PDialog,Init(R,'Tempo'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;
      HelpCtx:=hcDialog;

      R.Assign(2,4,18,6);
      Insert(NEW(PButton,Init(R,'~O~K',cmOk,bfDefault)));

      R.Assign(3,2,17,3);
      Z:=NEW(pZahl,Init(R,200,20,FMSongTempo));
      Insert(Z);
    END;
  DeskTop^.ExecView(D);
  FMSongTempo:=Z^.Nummer;
  Dispose(D,Done);
END;

PROCEDURE NewSong;
VAR
  W   : WORD;
  E   : TEvent;
BEGIN
  w:=cmyes;
  IF FMSong^.Patterns^.Count>0 THEN
    BEGIN
      BeepSound;
      w:=Messagebox(^c+'Achtung: Aktuelle Daten werden gelscht !'+#13+
      ^c+'Trotzdem fortfahren ?',NIL,
      mfwarning+mfyesbutton+mfnobutton);
    END;

  IF w<>cmYes THEN Exit;

  E.What:=evBroadCast;
  E.Command:=cmpCloseAllWins;
  Application^.PutEvent(E);
  E.What:=evBroadCast;
  E.Command:=pcdUpdateArra;
  Application^.PutEvent(E);
  Dispose(FMSong,DONE);
  FMSong:=NEW(pFMSong,INIT);
  datei:='NONAME.MMS';
  FMReset;
END;

PROCEDURE SBStatus;
VAR
  d      : PDialog;
  r      : TRect;
  S1,S2,
  S3     : STRING;
  W      : WORD;
BEGIN
  r.Assign(0,0,70,8);
  d:=New(PDialog,Init(r,'Status'));
  WITH d^ DO
    BEGIN
      Options:=Options OR OfCentered;
      Flags:=$00;
      HelpCtx:=hcDialog;

      r.Assign(2,5,68,7);
      Insert(New(pButton,Init(r,'~O~K',cmok,BfDefault)));

      S1:=FMSong^.SongTitle;
      Str(FMSong^.Patterns^.Count,S2);
      IF NOT AdlibPresent THEN
        S3:='Keine Abdlib-Soundkarte gefunden !'
      ELSE
        IF FMMusicPause THEN
          S3:='PAUSE'
        ELSE
          IF FMMusicPlay THEN
            S3:='WIEDERGABE'
          ELSE
            S3:='STOP';

      r.Assign(2,1,25,4);
      Insert(New(PStaticText,Init(r,
      '      Name des Stckes:'+#13+
      ' Anzahl der Abschnitte:'+#13+
      '                Status:')));

      r.Assign(26,1,68,4);
      Insert(New(PStaticText,Init(r,S1+#13+S2+#13+S3)));
    END;
  Desktop^.ExecView(d);
  Dispose(d,Done);
END;

PROCEDURE SpeichereInstr;
VAR
  I      : WORD;
BEGIN
  I:=ChooseInstrument;
  IF I<>0 THEN
    SaveInstr(I);
END;

PROCEDURE LadeInstr;
VAR
  I      : WORD;
BEGIN
  I:=ChooseInstrument;
  IF I<>0 THEN
    LoadInstr(I);
END;

PROCEDURE SpeicherePattern;
VAR
  P      : pPattern;
BEGIN
  P:=ChoosePattern;
  IF P<>NIL THEN SavePat(P);
END;

PROCEDURE LadePattern;
VAR
  P,P1   : pPattern;
  Ok     : BOOLEAN;
  X      : INTEGER;
BEGIN
  P:=NEW(pPattern,Init);
  LoadPat(P);
  Ok:=TRUE;
  IF P<>NIL THEN
    BEGIN
      FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
        BEGIN
          P1:=FMSong^.Patterns^.At(X);
          IF P1^.Name=P^.Name THEN
            Ok:=FALSE;
        END;
      IF Ok=FALSE THEN
        BEGIN
          MessageBox('Der Name '+P^.Name+' ist schon vergeben !',NIL,
          mfError+mfOkButton);
          Dispose(P,Done);
          Exit;
        END;
      FMSong^.Patterns^.Insert(P);
      EditPattern(P);
    END;
END;

PROCEDURE ChangeDir;
VAR
  D      : PChDirDialog;
  W      : WORD;
BEGIN
  D := New(PChDirDialog, Init(cdNormal, 101));
  D^.HelpCtx := hcChDirDialog;
  IF ValidView(D) <> NIL THEN
    BEGIN
      Desktop^.ExecView(D);
      Dispose(D, Done);
    END;
  W:=IOResult;
END;

PROCEDURE ConvertMOD;
VAR
  d   : pFileDialog;
  s   : STRING;
  E   : TEvent;
BEGIN
  NewSong;
  IF FMSong^.Patterns^.Count<>0 THEN Exit;
  s:='*.MOD';
  d:=New(pfiledialog,Init(s,'MOD-Datei konvertieren','Datei:',
  fdokbutton,100));
  d^.HelpCtx := hcFileDialog;
  IF validview(d)<>NIL THEN
    BEGIN
      IF Desktop^.ExecView(d)<>cmcancel THEN
        BEGIN
          d^.getfilename(s);
          Dispose(d,Done);
          ReadMOD(s);
          E.What:=evBroadCast;
          E.Command:=pcdUpdateArra;
          Application^.PutEvent(E);
        END
      ELSE
        Dispose(d,Done);
    END;
END;

PROCEDURE SetChangeMode;
VAR
  D      : PDialog;
  RB     : PRadioButtons;
  R      : TRect;
BEGIN
  R.Assign(0,0,36,7);
  D:=NEW(PDialog,Init(R,'nderungsmodus'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;
      HelpCtx:=hcDialog;

      R.Assign(2,4,34,6);
      Insert(NEW(PButton,Init(R,'~O~K',cmOk,bfDefault)));

      R.Assign(2,1,34,3);
      RB:=NEW(PRadioButtons,Init(R,
        NewSItem('~A~lle Abschnitte ndern',
        NewSItem('~N~ur einen Abschnitt ndern',
        NIL))));
      RB^.Value:=1;
      IF ChangeAll THEN
        RB^.Value:=0;
      Insert(RB);
    END;
  DeskTop^.ExecView(D);
  IF RB^.Value=0 THEN
    ChangeAll:=TRUE
  ELSE
    ChangeAll:=FALSE;
  Dispose(D,Done);
END;

PROCEDURE SBReset;
BEGIN
  PlayWin^.Select;
  EnableCommands(PlayCommands);
  FMReset;
END;

PROCEDURE ReadInstFromCMF(Datei: STRING);
VAR
  D      : PDialog;
  R      : TRect;
  Z      : pZahl;
  Nr     : INTEGER;
  Inst   : WORD;
  IHelp  : CMFInstr;
  F      : TDOSStream;
  W,W2   : WORD;
  S      : STRING;
BEGIN
  F.Init(Datei,stOpenRead);
  F.Seek(36);
  F.Read(W,2);
  IF W>30 THEN W:=30;

  Inst:=ChooseInstrument;
  IF Inst=0 THEN
    BEGIN
      F.Done;
      W:=IOResult;
      Exit;
    END;

  R.Assign(0,0,26,7);
  D:=NEW(PDialog,Init(R,'Instrument Nr.'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(2,4,12,6);
      Insert(NEW(PButton,Init(R,'~O~K',cmOk,bfDefault)));
      R.Assign(12,4,24,6);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));

      R.Assign(6,2,20,3);
      Z:=NEW(pZahl,Init(R,W,1,1));
      Insert(Z);
    END;
  IF DeskTop^.ExecView(D)<>cmOK THEN
    BEGIN
      Dispose(D,Done);
      F.Done;
      W:=IOResult;
      Exit;
    END;
  Nr:=Z^.Nummer;
  Dispose(D,Done);

  F.Seek(6);
  F.Read(W,2);
  W2:=W+(Nr-1)*16;
  F.Seek(W2);
  F.Read(IHelp,16);
  F.Done;
  Str(Nr,S);
  FMSong^.Instruments[Inst]^.Name:=S+' aus '+Datei;
  Move(IHelp,FMSong^.Instruments[Inst]^.Instr1Mod,11);
  W:=IOResult;
END;

PROCEDURE InstFromCMF;
VAR
  D   : pFileDialog;
  S   : STRING;
BEGIN
  S:='*.CMF';
  D:=New(pfiledialog,Init(s,'Instrument lesen aus CMF','Datei:',
  fdokbutton,100));
  d^.HelpCtx := 20001;
  IF validview(d)<>NIL THEN
    BEGIN
      IF Desktop^.ExecView(d)<>cmcancel THEN
        BEGIN
          d^.getfilename(s);
          Dispose(d,Done);
          ReadInstFromCMF(s);
        END
      ELSE
        Dispose(d,Done);
    END;
END;

BEGIN
  CASE Event.What OF
      EvCommand:
        CASE Event.Command OF
          cmColors               : Colors;
          cmInfo                 : Info;
          cmMouse                : Mouse;
          cmSBInfo               : SBStatus;
          cmChangeDir            : ChangeDir;
          cmSBReset              : SBReset;

          cmNewPat               : MakePattern;
          cmEditPat              : EditPattern(NIL);
          cmRenPat               : RenamePattern;
          cmDelPat               : DeletePattern;
          cmCopyTrack            : CopyTrack;
          cmInsertTrack          : InsertTrack;
          cmSavePat              : SpeicherePattern;
          cmOpenPat              : LadePattern;
          cmMoveInst             : InstrumentVerschieben;
          cmChangeInstInPat      : InstrumentAendern;
          cmSetTrack2Inst        : InstrumentSetzen;
          cmTransposeInst        : InstrumentTransponieren;
          cmTransposeTrack       : TransposeTrack;
          cmConvertMOD           : ConvertMOD;
          cmChangeWhat           : SetChangeMode;

          cmSongTitle            : ChangeSongTitle;
          cmSongAuthor           : ChangeSongAuthor;
          cmChangeSpeed          : ChangeSongSpeed;

          cmSave                 : SongSpeichern;
          cmSaveAs               : SongSpeichernAls;
          cmOpen                 : SongLaden;
          cmNew                  : NewSong;

          cmNewInst              : NeuesInstrument;
          cmChangeInst           : EditInstrument(0);
          cmOpenInst             : LadeInstr;
          cmSaveInst             : SpeichereInstr;
          cmInstFromCMF          : InstFromCMF;
          cmDelInst              : LoescheInstrument;

          cmQuit                 : WirklichBeenden(Event);
        END;
    END;
  IF (Event.What=evCommand) AND (Event.Command=cmSaveQuit) THEN
    IF SongSpeichern<>cmCancel THEN
      Event.Command:=cmQuit;
  TApplication.HandleEvent(Event);
END;

PROCEDURE tMusicMakerApp.GetEvent;
VAR
  HFile      : PHelpFile;
  HelpStrm   : PDosStream;
  D          : DirStr;
  N          : NameStr;
  E          : ExtStr;
BEGIN
  TApplication.GetEvent(Event);
  IF (Event.What=evCommand) AND (Event.Command IN
     [cmHelp,cmHelpIndex,cmHelpOnHelp]) THEN
    BEGIN
      FSplit(ParamStr(0),D,N,E);
      IF D[Length(D)]='\' THEN DEC(D[0]);
      HelpStrm:=NEW(PDosStream,Init(FSearch('MUSICMAK.HLP',D),
        stOpenRead));
      IF HelpStrm^.GetSize>MemAvail THEN
        BEGIN
          Dispose(HelpStrm,Done);
          OutOfMemory;
          EXIT;
        END;
      HFile := New(PHelpFile, Init(HelpStrm));
      IF HelpStrm^.Status <> stOk THEN
        BEGIN
          MessageBox('Kann Hilfedatei MUSICMAK.HLP'+
          ' nicht ffnen !!', NIL,
          mfError + mfOkButton);
          Dispose(HFile, Done);
        END
      ELSE
        BEGIN
          CASE Event.Command OF
              cmHelpOnHelp : hWin:=NEW(PHelpWindow,INIT(HFile,hcNoContext));
              cmHelpIndex  : hWin:=NEW(PHelpWindow,INIT(HFile,hcHelpIndex));
            ELSE
              hWin:=NEW(PHelpWindow,INIT(HFile,GetHelpCtx));
            END;
          hWin^.HelpCtx:=hcHelpWindow;
          IF ValidView(hWin) <> NIL THEN
            BEGIN
              Application^.Execview(hWin);
              Dispose(hWin,Done);
              hWin:=NIL;
            END;
          ClearEvent(Event);
        END;
    END;
END;

PROCEDURE tMusicMakerApp.Idle;
BEGIN
  HelpCtx:=0;
  TApplication.Idle;
  Clock^.UpDate;
  Heap^.Update;
  PlayWin^.UpDate;
END;

PROCEDURE tMusicMakerApp.LadeSong;
VAR
  W      : WORD;
  F      : PBufStream;
  S      : STRING[23];
  S1     : STRING[31];
  X,Y,Z  : INTEGER;
  A,B    : INTEGER;
  N      : tNote;
  P      : pPattern;
  E      : TEvent;
  R      : INTEGER;
BEGIN
  w:=cmyes;
  IF FMSong^.Patterns^.Count>0 THEN
    BEGIN
      BeepSound;
      w:=Messagebox(^c+'Es werden gerade Abschnitte bearbeitet.'+#13+
      ^c+'Trotzdem fortfahren?',NIL,
      mfwarning+mfyesbutton+mfnobutton);
    END;

  IF w=cmyes THEN
    BEGIN
      F:=NEW(PBufStream,Init(DateiName,stOpen,5000));
      IF F^.Status=stOk THEN
        BEGIN
          {$I-}
          FMStopMusic;
          FMReset;
          E.What:=evBroadCast;
          E.Command:=cmpCloseAllWins;
          PutEvent(E);

          R:=FMSong^.LadeSong(F);
          IF R=-255 THEN
            BEGIN
              BeepSound;
              MessageBox(^c+'Datei enthlt kein'+#13+
              ^c+'MusicMaker-Stck.',NIL,mferror+mfokbutton);
              datei:='NONAME.MMS';
              FMSong^.SongTitle:='';
              Dispose(F,DONE);
              Exit;
            END;
          IF R=-254 THEN
            BEGIN
              OutOfMemory;
              Dispose(F,DONE);
              EXIT;
            END;
          IF R=-253 THEN
            BEGIN
              BeepSound;
              MessageBox(^c+'Falsche MMS-Version.',NIL,mferror+mfokbutton);
              datei:='NONAME.MMS';
              FMSong^.SongTitle:='';
              Dispose(F,DONE);
              EXIT;
            END;

          IF (R<>stOK) OR (IOResult<>0) THEN
            BEGIN
              BeepSound;
              MessageBox(^c+'Fehler beim lesen der Datei!',NIL,
              mfError+mfOkButton);
              Dispose(FMSong,DONE);
              FMSong:=NEW(pFMSong,INIT);
            END
          ELSE
            BEGIN
              datei:=dateiname;
              E.What:=evBroadCast;
              E.Command:=pcdUpdateArra;
              PutEvent(E);
            END;
        END;
        Dispose(F,Done);
        {$I+}
    END;
END;

PROCEDURE tMusicMakerApp.SpeichereSong;
VAR
  W      : WORD;
  Exists : BOOLEAN;
  S1,S2,
  S3     : STRING;
  F      : PBufStream;

  PROCEDURE MakeBAK(d: STRING);
  VAR
    dat   : FILE;
    dat1  : FILE;
    a,b,c : STRING;
    w     : word;
  BEGIN
    {$I-}
    FSplit(d,a,b,c);
    Assign(dat,a+b+'.BAK');
    Erase(dat);
    Assign(dat1,d);
    Rename(dat1,a+b+'.BAK');

    w:=ioresult;
    {$I+}
  END;

BEGIN
  {$I-}
  w:=cmyes;
  exists:=FALSE;
  FSplit(dateiname,s1,s2,s3);
  IF FSearch(s2+s3,s1)<>'' THEN
    BEGIN
      exists:=TRUE;
      BeepSound;
      w:=MessageBox(^c+'Die Datei '+dateiname+' existiert bereits.'#13+
      ^c+'berschreiben ?',NIL,
      mfwarning+mfyesbutton+mfnobutton);
    END;

  IF w=cmyes THEN
    BEGIN
      IF exists THEN
        MakeBAK(Dateiname);
      F:=NEW(PBufStream,INIT(DateiName,stCreate,5000));

      IF (FMSong^.SpeichereSong(F)<>stOK) OR (IOResult<>0) THEN
        BEGIN
          BeepSound;
          MessageBox(^c+'Fehler beim schreiben der Datei!',NIL,
          mfError+mfOkButton);
        END;
      Dispose(F,DONE);
      {$I+}
    END;
  datei:=dateiname;
END;

PROCEDURE tMusicMakerApp.Colors;

FUNCTION DialogColors(Next: PColorGroup): PColorGroup;
BEGIN
  DialogColors:=ColorGroup('Dialoge',
  ColorItem('Rahmen-Passiv',     32,
  ColorItem('Rahmen-Aktiv',      33,
  ColorItem('Rahmen-Icons',      34,
  ColorItem('Rollbalken',        35,
  ColorItem('Rollbalken-Icons',  36,
  ColorItem('Text',              37,

  ColorItem('Label normal',      38,
  ColorItem('Label gewhlt',     39,
  ColorItem('Label shortcut',    40,

  ColorItem('Button normal',     41,
  ColorItem('Button standard',   42,
  ColorItem('Button gewhlt',    43,
  ColorItem('Button nicht whlb.',44,
  ColorItem('Button shortcut',   45,
  ColorItem('Button Schatten',   46,

  ColorItem('Schalter normal',   47,
  ColorItem('Schalter gewhlt',  48,
  ColorItem('Schalter shortcut', 49,

  ColorItem('Eingabe normal',    50,
  ColorItem('Eingabe gewhlt',   51,
  ColorItem('Eingabe Pfeil',     52,

  ColorItem('Liste normal',       57,
  ColorItem('Liste fokusiert',    58,
  ColorItem('Liste gewhlt',      59,
  ColorItem('Liste Trennstrich',  60,

  ColorItem('Combo-Box button',   53,
  ColorItem('Combo-Box Seite',    54,
  ColorItem('Combo-Box bar',      55,
  ColorItem('Combo-Box bar-icons',56,

  ColorItem('Datei-Info',         61,
  NIL)))))))))))))))))))))))))))))),Next);
END;

FUNCTION CompColors(Next: PColorGroup): PColorGroup;
BEGIN
  CompColors:=ColorGroup('Abschnitt',
  ColorItem('Rahmen-Passiv',     64,
  ColorItem('Rahmen-Aktiv',      65,
  ColorItem('Rahmen-Icons',      66,
  ColorItem('Rollbalken',        67,
  ColorItem('Rollbalken-Icons',  68,
  ColorItem('Label',             70,
  ColorItem('Label gewhlt',     71,
  ColorItem('Label Shortcut',    72,
  ColorItem('Button',            73,
  ColorItem('Button Schatten',   78,
  ColorItem('Nummernfeld',       84,
  ColorItem('Spur',              89,
  ColorItem('Spur hervorgehoben',90,
  NIL))))))))))))),Next);
END;

FUNCTION DesktopColors(Next: PColorGroup): PColorGroup;
BEGIN
  DesktopColors:=ColorGroup('Desktop',
  ColorItem('Farbe',             1,
  NIL),Next);
END;

FUNCTION MenuColors(Next: PColorGroup): PColorGroup;
BEGIN
  MenuColors:=ColorGroup('Mens',
  ColorItem('Normal',            2,
  ColorItem('nicht mglich',     3,
  ColorItem('Shortcut',          4,
  ColorItem('gewhlt',           5,
  ColorItem('gew. nicht mglich',6,
  ColorItem('Shortcut gewhlt',  7,
  NIL)))))),Next);
END;

FUNCTION HelpColors(Next: PColorGroup): PColorGroup;
BEGIN
  HelpColors:=ColorGroup('Hilfe',
  ColorItem('Rahmen-Passiv',      128,
  ColorItem('Rahmen-Aktiv',       129,
  ColorItem('Rahmen-Icons',       130,
  ColorItem('Rollbalken',         131,
  ColorItem('Rollbalken-Icons',   132,
  ColorItem('Text',               133,
  ColorItem('Schlsselwort',      134,
  ColorItem('gew. Schlsselwort', 135,
  NIL)))))))),Next);
END;

VAR
  D      : PColorDialog;
  F      : TDOSStream;
  A      : BYTE;
BEGIN
  D := New(PColorDialog, Init('',
  DesktopColors(
  MenuColors(
  DialogColors(
  CompColors(
  HelpColors(
  NIL)))))));
  D^.HelpCtx:=hcColorDialog;

  IF ExecuteDialog(D, Application^.GetPalette)<>cmCancel THEN
    BEGIN
      DoneMemory;  { Dispose all group buffers }
      Redraw;      { Redraw application with new palette }
      F.INIT('MUSICMAK.INI',stCreate);
      F.Write(Application^.GetPalette^,255);
      IF MouseReverse THEN
        A:=101
      ELSE
        A:=0;
      F.Write(A,1);
      F.Write(DoubleDelay,2);
      F.DONE;
    END;
END;

DESTRUCTOR tMusicMakerApp.Done;
VAR
  A      : INTEGER;
BEGIN
  Dispose(FMSong,DONE);
  TApplication.Done;
END;


VAR
  Prog   : tMusicMakerApp;
  P      : POINTER;

BEGIN
  WriteLn;
  WriteLn(PrgNameString+' '+PrgVersionString);
  WriteLn(PrgCString);
  WriteLn;
  OvrInit('MUSICMAK.OVR');
  IF OvrResult = OvrNotFound THEN
    BEGIN
      BeepSound;
      WriteLn('FEHLER: Overlay-Datei MUSICMAK.OVR konnte nicht eingebunden werden !');
      WriteLn('FEHLERSTATUS: KRITISCH ! Programm kann ohne Overlay-Datei nicht'+#13' ausgefhrt werden.');
      Halt(1);
    END;
  OvrSetBuf(Trunc(MemAvail/3.5));
  OvrInitEMS;
  IF OvrResult = OvrOK THEN
    OvrSetBuf(100000);
  Write('Overlay-Puffer: ',OvrGetBuf);
  IF OvrResult = OvrOK THEN
    WriteLn(' im EMS-Speicher.')
  ELSE
    WriteLn(' im DOS-Speicherbereich.');
  CASE OvrResult OF
      OvrNoEMSDriver : BEGIN
                         BeepSound;
                         WriteLn('FEHLER: Kein EMS-Treiber gefunden !');
                         WriteLn('FEHLERSTATUS: UNKRITISCH ! Benutze normales RAM als Overlay-Puffer.');
                         WriteLn;
                       END;
      OvrNoEMSMemory : BEGIN
                         BeepSound;
                         WriteLn('FEHLER: Kein EMS-Speicher frei !');
                         WriteLn('FEHLERSTATUS: UNKRITISCH ! Benutze normales RAM als Overlay-Puffer.');
                         WriteLn;
                       END;
    END;

  Delay(1000);

  RegisterObjects;
  RegisterHelpFile;

  Prog.Init;
  Prog.Run;
  Prog.Done;

  WriteLn;
  WriteLn(PrgNameString+' '+PrgVersionString);
  WriteLn(PrgCString);
  WriteLn;
END.

