program moerassenspel;
{ Geschreven door Patrick Kooman, 1997 }
uses crt, graph, dos;
type
   moerassentabel = array[1..20,1..20] of boolean; { Nodig voor wel / geen moeras}
var
   moeras    : moerassentabel;
   posX      : integer;  { Horizontale en verticale }
   posY      : integer;  { positie van de speler. }
   posXoud   : integer;  { Nodig om speler terug te zetten op de vorige positie }
   posYoud   : integer;  { als hij/zij in een moeras is gelopen, en om het pad te tekenen.}
   aantal    : integer;  { Bevat het aantal omliggende moerassen.}
   toets     : char;     { Leest de gewenste richting uit. }
   richting  : char;     { Hierin staat de richting die nodig is om het juiste pad te tekenen.}
   kar       : char;     { Wordt gebruikt bij de readkey's.}
   moerassen : integer;  { Aantal te plaatsen moerassen (hangt af van de moeilijksheidgraad).}
   graad     : integer;  { Hierin staat de moeilijkheidsgraad.}
   zetten    : integer;  { Bevat het aantal gedane zetten.}
   levens    : integer;  { Bevat het aantal resterende levens.}
   GR{aad}     : string; { Nodig omdat 'outtextxy' alleen strings kan neerzetten.}
   MO{oeras}   : string; { " " }
   OM{liggend} : string; { " " }
   ZE{tten}    : string; { " " }
   LE{vens}    : string; { " " }
   stop         : boolean; { Nodig als je op <ESC> hebt gedrukt, of als je levens op zijn.}
   VerlaatSpel  : boolean; { Nodig als je het huidige spel hebt beindigd.}
   MagLopen     : boolean; { Het hangt hier vanaf of het zinvol is om 'doezet' aan te roepen.}
   RondGespeeld : boolean; { Wordt true als je het veld op graad 5 hebt gehaald.'}
   Help         : boolean; { Nodig bij 'TekenPad'.}
   driver       : integer; { Nodig voor 'initgraph'.}
   mode         : integer; { " " }
   oud_adres    : pointer; { Nodig voor interrupt-procedure 'TekenPoort'.}
   doffer       : boolean; { Nodig}
   RGBteller    : integer;
{ Deze procedure tekent een pixel op een -door random- berekende positie
  en werkt in combinatie met de procedure 'intro'.}
procedure TekenPixel (kleur : word);
begin
     putpixel (random(641),random(481),kleur) { Zet een pixel op een willekeurige positie
                                              (0 - 640) en (0 - 480) in de meegegeven kleur.}
     { De maximale uitkomst van random is de waarde achter 'random' - 1.}
end;

{ Deze procedure maakt het startscherm van het spel.}
procedure Intro;
var
   i : longint;
begin
  Randomize;                         { Haal een waarde uit de systeemklok.}
  setusercharsize(3,2,5,0);          { Stel een eigen letterformaat in. }
  for i := 1 to 20000 do             { Zet willekeurig 20000 stipjes over het gehele scherm.}
     TekenPixel (green);             { Roep 'TekenPixel' aan.}
  settextstyle(triplexfont, horizdir,usercharsize);{ Stel het lettertype in.}
  outtextxy (85,100,'HET MOERASSENSPEL');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (245,425,'Druk op een toets');
  repeat
     for i := 1 to 3000 do    { Zet willekeurig 3000 zwarte stipjes en dan}
        TekenPixel (black);   { 400 groene stipjes. Er worden minder groene}
     for i := 1 to 400 do     { gezet omdat er al 20000 staan. Als je ook 3000}
        TekenPixel (green);   { groene stipje zou plaatsen zou het scherm steeds}
  setusercharsize(3,2,5,0);   { groener worden.}
  outtextxy (85,100,'HET MOERASSENSPEL');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (245,425,'Druk op een toets');
  until keypressed            { Net zo lang tot er op <RETURN> gedrukt wordt.}
end;

{ Deze functie telt of er genoeg moerassen neergelegd zijn.
  Zie voor meer uitleg de procedure 'LegMoerassen'.}
function AantalMoerassen : integer;
var
   x,y : integer;
   faantal : integer;
begin
   faantal := 0;
   for x := 1 to 20 do
      for y := 1 to 20 do
      if moeras[x,y] then
         inc (faantal,1);
   AantalMoerassen := faantal
end;

{ Deze procedure vult de array 'moeras' met het benodigde
  aantal moerassen. De functie 'AantalMoerassen' wordt aangeroepen
  omdat -vooral bij een groot aantal neer te leggen moerassen- de
  kans groot is dat random een keer dezelfde uitkomst geeft. Zou je
  dus bijvoorbeeld een 'for-lus' gebruiken bv. for i := 1 to 100, dan
  hou je misschien maar 90 true's (=moerassen) over. Nu wordt random
  net zo vaak aangeroepen totdat het huidige aantal true's in de array
  gelijk is aan het aantal neer te leggen moerassen. }
procedure LegMoerassen;
var
   x,y      : integer;
   uitkomst1,uitkomst2 : integer;
begin
   randomize;
   while AantalMoerassen < moerassen do
   begin
      uitkomst1 := random (21);
      uitkomst2 := random (21);{ Het volgende if-statement zorgt ervoor dat de in en uitgang vrij blijven.}
      if not ((uitkomst1=1) and (uitkomst2=1)) and not (((uitkomst1=2) and (uitkomst2=1)) or
         ((uitkomst1=1) and (uitkomst2=2))) and not ((uitkomst1=20) and (uitkomst2=20)) and not
         (((uitkomst1=19) and (uitkomst2=20)) or ((uitkomst1=20) and (uitkomst2=19))) then
      moeras [uitkomst1,uitkomst2] := true
   end
end;

procedure TekenPoort; interrupt;
begin
   if RGBteller = 61 then
      doffer := true;
   if doffer and (RGBteller > 30) then
   begin
      dec (RGBteller,1);
      if RGBteller mod 2 = 0 then
         setRGBpalette (blue,0,0,RGBteller)
   end
   else
   begin
      doffer := false;
      inc (RGBteller,1);
      if RGBteller mod 2 = 0 then
         setRGBpalette (blue,0,0,RGBteller)
   end
end;

{ Deze procedure maakt het veld. Het volgende spreekt allemaal voor zich.
  ( Als je bekent bent met de unit 'graph') }
procedure MaakVeld;
var
   x,y,i : integer;
begin
   setfillstyle (solidfill,darkgray); { Zet de vul-kleur op donkergrijs.}
   bar (11,21,409,459);                { Teken rechthoek.}
   y := 20; x := 10;
   for i := 1 to 21 do
   begin
      line (x,y,x,460);               { Teken lijn.}
      inc (x,20)                      { Verhoog x met 20.}
   end;
   x := 10;
   for i := 1 to 21 do
   begin
      line (x,y,409,y);
      inc (y,22)
   end
end;

{ Deze procedure tekent een moeras als je er in bent gelopen.
  Invoerparameters : pposX : Horizontale positie waar begonnen moet
                             worden met tekenen.
                     pposY : Verticale positie waar begonnen moet
                             worden met tekenen.}
procedure TekenMoeras (pposX : integer;
                       pposY : integer);
begin
   setfillstyle (solidfill,green);
   setcolor (black);
   bar (pposX,pposY,pposX+18,pposY+20);
   rectangle (pposX+2,pposY+2,pposX+16,pposY+18);
   setcolor (white)
end;

{ Deze procedure wordt aangeroepen als je weggezakt bent,
  of als je op <F2> drukt (vals speelt!).
  De hele array 'moeras' wordt doorlopen. Als er een true gevonden
  wordt, wordt aan de hand van de bijbehorende positie in de tabel
  de horizontale en vertical positie berekent die nodig zijn om
  naar de procedure 'Tekenmoeras' te sturen.}
procedure ToonMoerassen;
var
   pposX,pposY  : integer;
   x,y : integer;
begin
   for x := 1 to 20 do             { Doorloop de hele tabel (=veld) van }
      for y := 1 to 20 do          { linksboven naar rechtonder in kolommen }
      if moeras[x,y] then          { van boven naar beneden.}
      begin
         pposX := 11 + (x-1) * 20;  { De posities moeten -1 omdat de getekende }
         pposY := 21 + (y-1) * 22; { moerassen anders op het scherm 1 positie }
         TekenMoeras (pposX,pposY) { te ver naar rechts en naar beneden staan als in de array.}
      end
end;

{ Deze procedure verbergt de moerassen een tijdje nadat
  je op <F2> hebt gedrukt. }
procedure VerbergMoerassen;
var
   pposX,pposY  : integer;
   x,y : integer;
begin
   setfillstyle (solidfill,darkgray);
   for x := 1 to 20 do
      for y := 1 to 20 do
      if moeras[x,y] then
      begin
         pposX := 11 + (x-1) * 20;
         pposY := 21 + (y-1) * 22;
         bar (pposX,pposY,pposX+18,pposY+20) { Teken een vakje, zodat het }
      end                                    { moeras niet meer te zien is.}
end;

{ Deze functie kijkt of wel of niet in een moeras bent gelopen.
  Als dit zo is, dan wordt deze 'verwijderd' uit de tabel (=veld).}
function ZakWeg : boolean;
var
   x,y : integer;
begin
   x := posX+1;y := posY+1; { +1 is nodig omdat je je op het scherm 1 positie verder }
   ZakWeg := moeras[x,y];     { bevindt dan volgens het programma. Dit is nodig voor }
   moeras[x,y] := false       { de tekeningen die hier vanuit worden bepaald. Deze zouden}
end;                          { anders steeds 1 positie te ver getekend worden.}

{ Deze procedure tekent een pad, zodat je ziet waar je hebt gelopen.
  Invoerparameters  pposXoud, : De vorige positie van de speler.
                    pposYoud    De computer weet natuurlijk niet vanzelf
                                waar je vandaan komt.
                    prichting : Dit heb ik meer gedaan voor de sier.
                                Per richting staan de voetsporen anders.}
procedure TekenPad (pposXoud  : integer;
                    pposYoud  : integer;
                    prichting : char);
begin
   pposXoud := 11 + pposXoud * 20;
   pposYoud := 21 + pposYoud * 22;
   setfillstyle (solidfill,brown); { Zet de vulkleur op bruin.}
   setcolor (darkgray);            { Zet de tekenkleur op donkergrijs.}
   bar (pposXoud,pposYoud,pposXoud+18,pposYoud+20); { Teken bruin vakje.}
   if not Help then  { Als help uit staat, dan staan er voetstappen.}
   case richting of  { Deze worden getekent met twee ellipsen.}
     'R' : begin ellipse (pposXoud+6,pposYoud+7,0,360,5,2); { Rechtsaf.}
           ellipse (pposXoud+11,pposYoud+14,0,360,5,2);end;
     'L' : begin ellipse (pposXoud+11,pposYoud+7,0,360,5,2); { Linksaf.}
           ellipse (pposXoud+6,pposYoud+14,0,360,5,2); end;
     'O' : begin ellipse (pposXoud+5,pposYoud+12,0,360,2,5); { Beneden.}
           ellipse (pposXoud+13,pposYoud+9,0,360,2,5);end;
     'B' : begin ellipse (pposXoud+13,pposYoud+12,0,360,2,5);{ Boven.}
           ellipse (pposXoud+5,pposYoud+9,0,360,2,5);end;
     end
   else { Als help aan staat, dan staat er op de pad hoeveel moerassen er}
      outtextxy (pposXoud+5,pposYoud+7,OM); { omheen liggen, zodat je nog eens }
   pposXoud := 0; pposYoud := 0; { terug kunt kijken naar 'nullen' als je vastzit.}
   setcolor (white)
end;

{ Deze procedure tekent de speler op het moment dat je je weer verplaatst.
  Invoerparameters : pposX, : De positie van de speler.
                     pposY                             }
procedure TekenSpeler (pposX : integer;
                       pposY : integer);
begin
   pposX := 11 + pposX * 20;
   pposY := 21 + pposY * 22;
   setfillstyle (solidfill,lightblue);
   setcolor (white);
   bar (pposX,pposY,pposX+18,pposY+20);
   circle (pposX+9,pposY+10,8);
   pposX := 0;pposY := 0;
   setcolor (white)
end;

{ Deze procedure brengt een irritant piepje ten gehore wanneer je
  in een moeras loopt.}
procedure beep;
begin
   sound (500);   { Geluid aan.}
   delay (1000);  { 0.5 seconde.}
   nosound        { Geluid uit.}
end;

{ Deze procedure 'verzorgt' je zet.
  Invoerparameters : pposX, : De nieuwe positie van de speler.
                     pposY                                    }
procedure DoeZet (pposX : integer;
                  pposY : integer);
begin
   inc (zetten,1);
   if ZakWeg then      { Roep de functie 'ZakWeg' aan om te kijken}
   begin               { of je niet in een moeras bent gelopen.}
      dec (levens,1);               { Zoja, dan 1 leven minder, }
      beep;                         { piepje laten horen, }
      pposX := 11 + posX * 20;       { horizontale positie op veld bepalen, }
      pposY := 21 + posY * 22;      { verticale positie op veld bepalen, }
      TekenMoeras (pposX,pposY);    { moeras tekenen, }
      TekenSpeler (posXoud,posYoud);{ speler tekenen op vorige positie, }
      posX := posXoud;              { en tot slot de positie vervangen}
      posY := posYoud               { door de oude positie. }
   end
   else                 { Niets aan de hand.}
   begin
      TekenSpeler (posX,posY);            { Teken speler.}
      TekenPad (posXoud,posYoud,richting) { Teken pad op oude positie.}
   end;
   setcolor (white)
end;

{ Deze procedure kijkt hoeveel moerassen er om je heen liggen.
  Uitvoerparameters : paantal : Het aantal moerassen dat om je heen ligt.}
function Omliggend : integer;
var
   x,y     : integer;
   paantal : integer;
begin
   paantal := 0;
   x := posX + 1; y := posY + 1;
   if (x > 1) and (moeras[x-1,y]) then inc (paantal,1);
   if (x < 20) and (moeras[x+1,y]) then inc (paantal,1);
   if (y > 1) and (moeras[x,y-1]) then inc (paantal,1);
   if (y < 20) and (moeras[x,y+1]) then inc (paantal,1);
   Omliggend := paantal
end;

{ Deze procedure zet in het 'info-blok' het aantal moerassen dat
  zich in het veld bevindt. Deze wordt alleen aangeroepen aan het
  begin van een spel en als de moeilijkheidsgraad hoger wordt.}
procedure HoeveelMoerassen;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,44,564,64);
   str (moerassen,MO);      { Converteer integer 'moerassen' naar string 'M'}
   str (graad,GR);          { Converteer integer 'graag' naar string 'G'}
   outtextxy (461,51,MO+' (graad '+GR+')') { Outtext kan alleen maar strings weergeven.}
end;

{ Deze procedure zet in het 'info-blok' hoeveel moerassen er om je
  heen liggen. De procedure 'Omliggend' wordt hier aangeroepen.
  Na iedere zet wordt deze procedure aangeroepen.}
procedure HoeGevaarlijk;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,88,472,108);
   str (Omliggend,OM);  { Roep functie 'Omliggend' aan.}
   outtextxy (461,95,OM);
   aantal := 0
end;

{ Deze procedure zet in het 'info-blok' hoeveel zetten je hebt gedaan.
  Dit heeft geen invloed op het spel, maar ik vond het gewoon wel een
  leuk extraatje. Ook deze procedure wordt na elke zet aangeroepen.}
procedure AantalZetten;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,132,508,152);
   str (zetten,ZE);
   outtextxy (461,139,ZE)
end;

{ Deze procedure zet in het 'info-blok' hoeveel levens je nog hebt.}
procedure AantalLevens;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,178,471,196);
   str (levens,LE);
   outtextxy (461,185,LE)
end;

{ Deze procedure wordt aangeroepen als je op <ESC> drukt.}
procedure Einde (var pstop : boolean);
begin
   outtextxy (465,424,'EINDE SPEL (J/N)?');
   repeat
      kar := readkey
   until kar in ['j','J','n','N'];
   if kar in ['j','J'] then pstop := true;
   setfillstyle (solidfill,darkgray);
   bar (430,394,630,460)
end;

{ Deze procedure wordt aangeroepen als je het huidige spel
  bendigd of als je levens op zijn.
  Uitvoerparameters : pVerlaatSpel : Wel of niet het spel verlaten.}
procedure NietMeer (var pVerlaatSpel : boolean);
begin
   repeat
      kar := readkey
   until kar in ['j','J','n','N'];
   if kar in ['n','N'] then pVerlaatSpel := true
end;

{ Deze procedure leest de moeilijksgraad in aan het begin
  van een nieuw spel.
  Uitvoerparameter : pgraad : de graad [1..5], maar nu als cijfer. }
procedure LeesGraad (var pgraad : integer);
var
   error : integer;    { Hier komt het foutnummer in als 'str' mislukt.}
begin
   repeat
      kar := readkey
   until kar in ['1'..'5'];
   outtextxy (355,245,kar);
   val (kar,pgraad,error);
   delay (1000)
end;

{ Deze procedure, zoals de naam al zegt, verfrist het speelveld.
  Alles wordt op de beginwaarde ingesteld en het veld
  met de daarin liggende moerassen wordt gemaakt.}
procedure VerfrisVeld;
var
   x,y : integer;
begin
   moerassen := graad * 25; { 25 moerassen per niveau erbij.}
   MaakVeld;
   for x := 1 to 20 do          { Maak de tabel weer helemaal leeg.}
      for y := 1 to 20 do
         moeras[x,y] := false;
   LegMoerassen;
   posX := 0;
   posY := 0;
   zetten := 0;
   levens := 3;
   TekenSpeler (posX,posY);
   setfillstyle (solidfill,blue);
   bar (391,439,409,459);
   RGBteller := 60;
   setintvec($1c,@TekenPoort);  { Zet de interrupt-procedure 'TekenPoort' 'aan'.}
   HoeveelMoerassen;
   HoeGevaarlijk;
   AantalZetten;
   AantalLevens;
   Help := false
end;

{ Deze procedure wordt aangeroepen als je het veld op graad 5 hebt gehaald.}
procedure Gefeliciteerd;
begin
   setfillstyle (solidfill, darkgray);
   bar (0,0,640,480);
   setcolor (darkgray);
   setfillstyle (solidfill,green);
   FillEllipse (75,300,60,70);          { Teken de ballonnen. }
   FillEllipse (75,374,5,5);
   setfillstyle (solidfill,red);
   FillEllipse (175,100,60,70);
   FillEllipse (175,174,5,5);
   setfillstyle (solidfill,5);
   FillEllipse (275,250,60,70);
   FillEllipse (275,324,5,5);
   setfillstyle (solidfill,blue);
   FillEllipse (375,150,60,70);
   FillEllipse (375,224,5,5);
   setfillstyle (solidfill,brown);
   FillEllipse (475,250,60,70);
   FillEllipse (475,324,5,5);
   setfillstyle (solidfill,yellow);
   FillEllipse (575,120,60,70);
   FillEllipse (575,194,5,5);
   setcolor (black);
   line (75,380,77,480);                { Tekent touwtjes.}
   line (175,180,177,300);
   line (275,330,277,450);
   line (375,230,377,350);
   line (475,330,477,450);
   line (575,200,577,350);
   delay (2000);
   setcolor (white);
   setusercharsize (2,2,1,0);
   settextstyle(triplexfont, horizdir,usercharsize);
   outtextxy (215,80,'Gefeliciteerd !!!');
   outtextxy (100,220,'U heeft het moerassenspel');
   outtextxy (218,270,'rondgespeeld.');
   setusercharsize (1,2,1,0);
   settextstyle (triplexfont,horizdir,usercharsize);
   delay (3000);
   outtextxy (245,420,'Druk op een toets');
   kar := readkey;
   setfillstyle (solidfill,black);
   bar (0,0,640,480)
end;

procedure EindPlaatje;
begin
  setfillstyle (solidfill, black);
  bar (0,0,640,480);
  setcolor (green);
  setusercharsize(3,2,5,0);          { Stel een eigen letterformaat in. }
  settextstyle(triplexfont, horizdir,usercharsize);{ Stel het lettertype in.}
  outtextxy (85,50,'HET MOERASSENSPEL');
  setusercharsize (2,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (75,250,'Ontworpen en geschreven door :');
  outtextxy (200,350,'P.Kooman,1997');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  delay (3000);
  outtextxy (245,425,'Druk op een toets');
  kar := readkey
end;

{ Deze procedure tekent het scherm rechts in het veld.}
procedure InfoScherm;
begin
   setfillstyle (solidfill,darkgray);
   settextstyle (defaultfont,horizdir,0);
   bar (0,0,640,480);
   setfillstyle (solidfill,brown);
   bar (431,21,629,217);
   rectangle (430,20,630,218);
   outtextxy (445,28,'AANTAL MOERASSEN');
   outtextxy (445,72,'OMLIGGENDE MOERASSEN');
   outtextxy (445,116,'AANTAL ZETTEN');
   outtextxy (445,161,'AANTAL LEVENS');
   bar (431,241,629,305);
   rectangle (430,240,630,306);
   outtextxy (445,259,'F1 = HELP, F2 = CHEAT');
   outtextxy (445,281,'ESC = EINDE SPEL');
   rectangle (455,43,565,65);
   rectangle (455,87,473,109);
   rectangle (455,131,509,153);
   rectangle (455,177,472,197)
end;

begin
   initgraph (driver, mode,'c:\moeras\drivers');{ Zet het scherm in de grafische modus.}
   if graphresult <> 0 then halt; { Als er geen grafische kaart aanwezig is, dan einde programma.}
   Intro;                         { Roep de procedure voor het opstartscherm aan.}
   getintvec($1c,oud_adres);
   repeat                         { Begin hoofdlus.}
      InfoScherm;                 { Roep de procedure voor het Infoscherm aan.}
      MaakVeld;                   { Roep de procedure om het veld te tekenen aan.}
      setfillstyle (solidfill,darkgray); { Stelt het vulpatroon -nodig voor 'bar'- in.}
      bar (456,44,564,64);        { Teken een donkergrijs rechthoek.}
      bar (456,88,472,108);
      bar (456,132,508,152);
      bar (456,178,471,196);
      setfillstyle (solidfill,blue);
      bar (211,208,409,272);
      rectangle (210,207,410,273); { Teken een omlijnende rand.}
      outtextxy (215,215,'GEEF DE MOEILIJKSGRAAD ');
      outtextxy (215,245,'         (1-5) :');
      setintvec ($1c,oud_adres);
      LeesGraad (graad);   { Roep de procedure aan waar je de moeilijksheidgraad inleest.}
      VerfrisVeld;         { Roep de procedure aan die alle waarden op de beginstand zet e.d.}
      stop := false;
      repeat               { Begin sublus 1.}
         posXoud := posX;  { Bewaar de oude positie. Nodig om het pad neer te leggen }
         posYoud := posY;  { en om de speler te tekenen als die in een moeras is gelopen.}
         MagLopen := true; { Nodig zodat 'DoeZet niet onnodig wordt aangeroepen.}
         toets := #0;      { Speciale toetsen geven hebben twee codes: een #0 en dan de toetscode.}
         toets := readkey; { Hier die toetscode uitlezen.}
         case toets of     { Kijk wat er is ingetoets.}
           #75 : if posX > 0 then { Pijltje naar links.}
                 begin
                    dec (posX,1);
                    richting := 'L' { Nodig voor het detail in de procedure 'LegPad'.}
                 end
                 else
                    MagLopen := false; { Als je tegen de muur aanstaat hoeft de procedure 'DoeZet' niet .}
           #77 : if posX < 19 then { Pijltje naar rechts.}
                 begin
                    inc (posX,1);
                    richting := 'R'
                 end
                 else
                    MagLopen := false;
           #72 : if posY > 0 then { Pijltje omhoog.}
                 begin
                    dec (posY,1);
                    richting := 'B'
                  end
                  else
                     MagLopen := false;
           #80 : if posY < 19 then { Pijltje omlaag.}
                 begin
                    inc (posY,1);
                    richting := 'O'
                 end
                 else
                    MagLopen := false;
           #60 : begin                { F2 (cheat).}
                    ToonMoerassen;    { Roep de procedure aan die laat zien waar de moerassen liggen.}
                    delay (3000);     { Pauzeer.}
                    VerbergMoerassen; { Roep de procedure aan die de -nog niet zichtbare- moerassen weer onzichtbaar maakt.}
                    MagLopen := false
                 end;
           #59 : begin                { F1 (help).}
                    setfillstyle (solidfill,brown); { Maak het vak. }
                    bar (431,395,629,459);
                    rectangle (430,394,630,460);
                    if Help then
                    begin
                       Help := false;
                       outtextxy (485,424,'HELP IS UIT');
                    end
                    else
                    begin
                       Help := true;
                       outtextxy (485,424,'HELP IS AAN')
                    end;
                    delay (1000); { Wacht even. }
                    setfillstyle (solidfill,darkgray); { Maak het vak weer grijs (=weg) .}
                    bar (430,394,630,460);
                    MagLopen := false
                 end;
           #27 : begin                { Escape.}
                    setfillstyle (solidfill,brown);
                    bar (431,395,629,459);
                    rectangle (430,394,630,460);
                    Einde (stop);     { Roep de procedure 'einde' aan, om te vragen of je wilt stoppen.}
                    MagLopen := false
                 end;
           else MagLopen := false;   { Bij iedere andere toets zowiese niet verplaatsen.}
           end;
           if MagLopen then  { Als je mag lopen (niet tegen een muur loopt) dan...}
           begin
              DoeZet (posX,posY);
              HoeGevaarlijk;     { Roep de procedure aan die kijkt hoeveel moerassen er om je heen liggen.}
              AantalZetten;      { Roep de procedure aan die laat zien hoeveel zetten je reeds hebt gedaan.}
              AantalLevens       { Roep de procedure aan die het aantal resterende levens toont.}
           end;
           if (posX = 19) and (posY = 19) then { Als je rechtsonderstaat (veld geheeld) dan...}
              if graad < 5 then  { Als je nog niet in het laatste veld zat dan...}
              begin
                 inc (graad,1);  { Verhoog de graad met 1.}
                 VerfrisVeld     { Stel alle waarden weer op nul.}
              end
              else               { Indien je wel in het laatste veld zat dan...}
              begin
                 setintvec ($1c,oud_adres);
                 Gefeliciteerd;  { Roep de procedure aan die de felicitatie verzorgt.}
                 stop := true;   { Nu stop je zowieso met het huidige spel.}
                 RondGespeeld := true; { Rondgespeeld .}
                 Intro
              end;
      until (levens = 0) or stop; { Sub-lus 1 afsluiten als je levens op zijn, of als je }
      if not RondGespeeld then
      begin
         setintvec ($1c,oud_adres);
         setfillstyle (solidfill,blue);
         setRGBpalette (blue,0,0,60);
         bar (391,439,409,459);
         stop := false;
         ToonMoerassen;
         setfillstyle (solidfill,brown);
         bar (431,395,629,459);
         rectangle (430,394,630,460);
         outtextxy (490,413,'EINDE SPEL');
         outtextxy (455,435,'NOG EEN KEER (J/N)?');
         NietMeer (VerlaatSpel);
         setfillstyle (solidfill,darkgray);
         bar (430,394,630,460)
      end;
      RondGespeeld := false;
      setfillstyle (solidfill,black);
      bar (0,0,640,480)
   until VerlaatSpel;
   setintvec ($1c,oud_adres);
   EindPlaatje;
   closegraph
end.
