program swampgame;
{ By Patrick Kooman, 1997 

  While reading my own English I sometimes have the idea that it's
  not perfect. Though I hope you all understand it, and can
  learn from this program. Enjoy the game!!!}

uses crt, graph, dos;
type
   fieldarray = array[1..20,1..20] of boolean; { Needed for swamp/no swamp}
var
   field     : fieldarray; { This is basic of the whole game : in this you walk.}
   posX      : integer;  { horizontal and vertical }
   posY      : integer;  { position of the player. }
   posXold   : integer;  { Necessairy to re-put player at previous position }
   posYold   : integer;  { when he/she has walked into a swamp, and alse to draw the path.}
   number    : integer;  { Holds the number of surrounding swamps.}
   key       : char;     { Reads the players way from the key-board. }
   way       : char;     { Holds the way witch is needed to draw the right path.}
   ch        : char;     { Is used by the readkey's.}
   swamps    : integer;  { Number of swamps to place (depents on the level).}
   level     : integer;  { Holds the level you're playing.}
   moves     : integer;  { Holds the number of moves you've made.}
   lives     : integer;  { Holds the remaining lives.}
   LE{vel}   : string; { Necessairy because 'outtextxy' can only put strings.}
   SW{amp}   : string; { " " }
   SU{rrounding} : string; { " " }
   MO{ves}       : string; { " " }
   LI{ves}       : string; { " " }
   stop          : boolean; { Needed if you've pressed <ESC>, or if you ran out of lives.}
   LeaveGame     : boolean; { Becomes true if you want to exit the game.}
   AllowedToWalk : boolean; { It depents on this if it's usesfull to call 'DoMove'.}
   Completed     : boolean; { Becomes 'true' if you've played the field on level 5.'}
   Help          : boolean; { Needed in 'DrawPath'.}
   driver        : integer; { Needed for 'initgraph'.}
   mode          : integer; { " " }
   old_adres     : pointer; { Needed for interrupt-procedure 'DrawGate'.}
   dark          : boolean; { " " }
   RGBcounter    : integer;
   XToCenter     : integer; { Needed to center the words in 'Intro','LastPicure' and 'Congratulations'.}

{ These procedure draws a pixel on a -random generated- position en
  'cooperates' with 'Intro'.}
procedure SetPixel (color : word);
begin
     putpixel (random(641),random(481),color) { Puts a pixel at a random position
                                              (0 - 640) en (0 - 480) in the received color.}
     { The maximum result of 'random' is the value followed at 'random' - 1.}
end;

{ This procedure makes the introscreen of the game.}
procedure Intro;
var
   i : longint;
begin
  Randomize;                         { Gets a value from the systemclock.}
  setusercharsize(3,2,5,0);          { Form your own charsize. }
  for i := 1 to 20000 do             { Puts 20000 dots all over your screen.}
     SetPixel (green);               { Call 'SetPixel'.}
  settextstyle(triplexfont, horizdir,usercharsize);{ Set char size.}
  SetTextJustify (CenterText,TopText); { The text will be centered now.}
  outtextxy (XToCenter, 100,'THE SWAMPGAME');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (XToCenter, 425,'Press any key');
  repeat
     for i := 1 to 3000 do  { Puts 3000 black dots followed by}
        SetPixel (black);   { 400 green dots. Why less green ones ? }
     for i := 1 to 400 do   { Because there are allready 20000 of them. If you'd alse put 3000}
        SetPixel (green);   { green dots, the screen would become greener and greener}
  setusercharsize(3,2,5,0); { Try out if you don't believe this.}
  outtextxy (XToCenter, 100,'THE SWAMPGAME');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (XToCenter, 425,'Press any key');
  until keypressed;         { Don't stop until you press a key.}
  SetTextJustify (LeftText,TopText)
end;

{ This function counts if enough swamps are placed yet.
  For further explenation see 'PlaceSwamps'}
function NumberOfSwamps : integer;
var
   x,y : integer;
   fnumber : integer;
begin
   fnumber := 0;
   for x := 1 to 20 do
      for y := 1 to 20 do
      if field[x,y] then   { Increase fnumber, if true (=swamp).}
         inc (fnumber,1);
   NumberOfSwamps := fnumber
end;

{ This procedure fills the array 'field' with the needed swamps.
  The function 'NumberOfSwamps' is called because -especialy when 
  a great number of swamps has to be placed- there's a great chance
  that 'random' comes up with same results. Should you use for example
  a 'for-loop' witch goes from 1 to 100 you'd probably get a number of 
  true's (=swamps) between 90 and 95. That's not really fair, is it?
  At this way 'random' is called untill enough true's (=swamps) are placed.} 
procedure PlaceSwamps;
var
   x,y      : integer;
   result1,result2 : integer;
begin
   randomize;
   while NumberOfSwamps < swamps do
   begin
      result1 := random (21);
      result2 := random (21);{ The next if-statement keeps the entree and the exit free.}
      if not ((result1=1) and (result2=1)) and not (((result1=2) and (result2=1)) or
         ((result1=1) and (result2=2))) and not ((result1=20) and (result2=20)) and not
         (((result1=19) and (result2=20)) or ((result1=20) and (result2=19))) then
      field [result1,result2] := true
   end
end;

{ This procedure is set on interrupt 1 and gives the gate a 'spookie' image.}
procedure DrawGate; interrupt;
begin
   if RGBcounter = 63 then { If blue is brightest, it may become dark again.}
      dark := true;
   if dark and (RGBcounter > 30) then { Not to dark though.}
   begin
      dec (RGBcounter,1);
      if RGBcounter mod 2 = 0 then
         setRGBpalette (blue,0,0,RGBcounter) { Makes the gate darker.}
   end
   else { if not dark and (RGBcounter < 31) then }
   begin
      dark := false;
      inc (RGBcounter,1);
      if RGBcounter mod 2 = 0 then
         setRGBpalette (blue,0,0,RGBcounter) { Makes the gate lighter.}
   end
end;

{ This procedure makes the playfield.}
procedure DrawField;
var
   x,y,i : integer;
begin
   setfillstyle (solidfill,darkgray); { Sets the fill-color to darkgray.}
   bar (11,21,409,459);               { Draw bar.}
   y := 20; x := 10;
   for i := 1 to 21 do
   begin
      line (x,y,x,460);               { Draw line.}
      inc (x,20)                      { Increase x with 20.}
   end;
   x := 10;
   for i := 1 to 21 do
   begin
      line (x,y,409,y);
      inc (y,22)
   end
end;

{ This procedure is called when you've walked into a swamp and
  also when 'ShowSwamps' has been called.}
procedure DrawSwamp (pposX : integer;
                     pposY : integer);
begin
   setfillstyle (solidfill,green);
   setcolor (black);
   bar (pposX,pposY,pposX+18,pposY+20); 
   rectangle (pposX+2,pposY+2,pposX+16,pposY+18); { Draws four lines.}
   setcolor (white)
end;

{ This procedure will be called when you've pressed <F2>,
  (cheat!).
  It goes through the array 'field', and if a true is found,
  the position will be computed and send to 'DrawSwamp'.}
procedure ShowSwamps;
var
   pposX,pposY  : integer;
   x,y : integer;
begin
   for x := 1 to 20 do             { Goes trough the array 'field' }
      for y := 1 to 20 do          
      if field[x,y] then
      begin
         pposX := 11 + (x-1) * 20; { Positions -1 because otherwise the }
         pposY := 21 + (y-1) * 22; { swamps are beeing put 1 position }
         DrawSwamp (pposX,pposY)   { too far to the right and downwards.}
      end                          { compared to the array.}     
end;

{ This procedure hides the swamps a little while after
  you've pressed <F2>.}
procedure HideSwamps;
var
   pposX,pposY  : integer;
   x,y : integer;
begin
   setfillstyle (solidfill,darkgray);
   for x := 1 to 20 do
      for y := 1 to 20 do
      if field[x,y] then
      begin
         pposX := 11 + (x-1) * 20;
         pposY := 21 + (y-1) * 22;
         bar (pposX,pposY,pposX+18,pposY+20) { Draws a gray bar so that the }
      end                                    { swamps becomes invisible again.}
end;

{ This function looks if you've walked into a swamp.
  If this has happened the swamp will be removed from 'field'.}
function Sink : boolean;
var
   x,y : integer;
begin
   x := posX+1;y := posY+1; { +1 because, compared to 'field' on the screen }
   Sink := field[x,y];     { you're one position more to the left and one }
   field[x,y] := false       { position too high.}
end;

{ These procedure draws a path, with makes you see where you've walked.
  In:               pposXold, : Player's previous position.
                    pposYold    Of course the computer doesn't know
                                where you came from.
                    pway      : I've done this just to make it more detailed.
                                There are four types of footprints to be drawn.}
procedure DrawPath (pposXold  : integer;
                    pposYold  : integer;
                    pway      : char);
begin
   pposXold := 11 + pposXold * 20;
   pposYold := 21 + pposYold * 22;
   setfillstyle (solidfill,brown); { Sets the fill-color to brown.}
   setcolor (darkgray);            { Sets the draw-color to gray.}
   bar (pposXold,pposYold,pposXold+18,pposYold+20); { Draw little brown box.}
   if not Help then  { If help is disabled, footprints are beeing drawned.}
   case way of  { These are formed out of two ellipses.}
     'R' : begin ellipse (pposXold+6,pposYold+7,0,360,5,2);  { To the right.}
           ellipse (pposXold+11,pposYold+14,0,360,5,2);end;
     'L' : begin ellipse (pposXold+11,pposYold+7,0,360,5,2); { To the Left.}
           ellipse (pposXold+6,pposYold+14,0,360,5,2); end;
     'O' : begin ellipse (pposXold+5,pposYold+12,0,360,2,5); { Down.}
           ellipse (pposXold+13,pposYold+9,0,360,2,5);end;
     'B' : begin ellipse (pposXold+13,pposYold+12,0,360,2,5);{ Up.}
           ellipse (pposXold+5,pposYold+9,0,360,2,5);end;
     end
   else { If help is enabled, the path sais by how many swamp you where surrounded there}
      outtextxy (pposXold+5,pposYold+7,SU); { so you can look back to see where it is save }
   pposXold := 0; pposYold := 0; { to try a move.}
   setcolor (white)
end;

{ This procedure draws the player at the moment you move (and not into a swamp).
  In:                pposX, : Players new position.
                     pposY                             }
procedure DrawPlayer (pposX : integer;
                      pposY : integer);
begin
   pposX := 11 + pposX * 20;
   pposY := 21 + pposY * 22;
   setfillstyle (solidfill,lightblue);
   setcolor (white);
   bar (pposX,pposY,pposX+18,pposY+20);
   circle (pposX+9,pposY+10,8);
   pposX := 0;pposY := 0;
   setcolor (white)
end;

{ This procedure produces an annoying sound if you walk into a swamp.}
procedure beep;
begin
   sound (500);   { Sound on.}
   delay (1000);  { 0.5 second.}
   nosound        { Sound off.}
end;

{ This procedure 'does' your move.
  In:                pposX, : Player's new position.
                     pposY                                    }
procedure DoMove (pposX : integer;
                  pposY : integer);
begin
   inc (moves,1);
   if Sink then      { Call function 'Sink' to see if you've sank into a swamp}
   begin
      dec (lives,1);               { If you have then take 1 live,}
      beep;                        { annoy with 'beep', }
      pposX := 11 + posX * 20;     { compute positions to draw swamp, }
      pposY := 21 + posY * 22;
      DrawSwamp (pposX,pposY);     { draw swamp, }
      DrawPlayer (posXold,posYold);{ draw player at previous position, }
      posX := posXold;             { replace positions with previos positions.}
      posY := posYold
   end
   else                              { Nothing to worrie about.}
   begin
      DrawPlayer (posX,posY);        { Draw player.}
      DrawPath (posXold,posYold,way) { Draw path at previous position.}
   end;
   setcolor (white)
end;

{ This function looks how many swamp are around you.}
function Surrounding : integer;
var
   x,y     : integer;
   pnumber : integer;
begin
   pnumber := 0;
   x := posX + 1; y := posY + 1;
   if (x > 1) and (field[x-1,y]) then inc (pnumber,1);
   if (x < 20) and (field[x+1,y]) then inc (pnumber,1);
   if (y > 1) and (field[x,y-1]) then inc (pnumber,1);
   if (y < 20) and (field[x,y+1]) then inc (pnumber,1);
   Surrounding := pnumber
end;

{ This procedures shows in the 'info-screen' how many
  swamps are in the field. It's only called when you
  start new a game, and when the level has increased.}
procedure HowmanySwamps;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,44,564,64);
   str (swamps,SW);      { Convert integer 'swamps' to string 'M'}
   str (level,LE);          { Convert integer 'level' to string 'G'}
   outtextxy (461,51,SW+' (level '+LE+')') { 'Outtext' can only display strings.}
end;

{ This procedure shows in the 'info-screen' how many swamps are
  around you. The function 'surrounding' is called from here.
  This procedure is called after every move.}
procedure HowDangerous;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,88,472,108);
   str (Surrounding,SU);  { Call function 'Surrounding'.}
   outtextxy (461,95,SU);
   number := 0
end;

{ This procedure shows in the 'info-screen' how many moves
  you've done. This has no influence on the game, but i thought
  it might be a little extra. Of course also this procedure is
  called after every move.}
procedure NumberOfMoves;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,132,508,152);
   str (moves,MO);
   outtextxy (461,139,MO)
end;

{ This procedure shows in the 'info-screen' how many lives you still have.
  it's called after every move.}
procedure NumberOfLives;
begin
   setfillstyle (solidfill,darkgray);
   bar (456,178,471,196);
   str (lives,LI);
   outtextxy (461,185,LI)
end;

{ This procedure will be called if you've pressed <ESC>.}
procedure EndGame (var pstop : boolean);
begin
   outtextxy (460,424,'END OF GAME (Y/N)?');
   repeat
      ch := readkey
   until ch in ['y','Y','n','N'];
   if ch in ['y','Y'] then pstop := true;
   setfillstyle (solidfill,darkgray);
   bar (430,394,630,460)
end;

{ This procedure will be called if you've ended the game,
  or if you've ran out of lives.}
procedure ExitGame (var pLeaveGame : boolean);
begin
   repeat
      ch := readkey
   until ch in ['y','Y','n','N'];
   if ch in ['n','N'] then
      pLeaveGame := true
end;

{ This procedure reads the level you want to start in.
  out:    plevel : the level [1..5], but converted to a number.}
procedure ReadLevel (var plevel : integer);
var
   error : integer;    { Hier komt het foutnummer in als 'str' mislukt.}
begin
   repeat
      ch := readkey
   until ch in ['1'..'5'];
   outtextxy (355,245,ch);
   val (ch,plevel,error); { convert character to a integer.}
   delay (1000)
end;

{ This procedure refreshes the playfield. Everything is put to
  basic values, and the field with it's swamps is beeing made.}
procedure RefreshField;
var
   x,y : integer;
begin
   swamps := level * 25; { 25 swamps more each level.}
   DrawField;
   for x := 1 to 20 do          { Delete all swamps.}
      for y := 1 to 20 do
         field[x,y] := false;
   PlaceSwamps;
   posX := 0;
   posY := 0;
   moves := 0;
   lives := 3;
   DrawPlayer (posX,posY);
   setfillstyle (solidfill,blue);
   bar (391,439,409,459);
   RGBcounter := 62; { brightest -1}
   setintvec($1c,@DrawGate);  { Enable procedure 'DrawGate'.}
   HowmanySwamps;
   HowDangerous;
   NumberOfMoves;
   NumberOfLives;
   Help := false { help disabled.}
end;

{ This procedure will be called if you've gone through level 5.}
procedure Congratulations;
begin
   setfillstyle (solidfill, darkgray);
   bar (0,0,640,480);
   setcolor (darkgray);
   setfillstyle (solidfill,green);
   FillEllipse (75,300,60,70);          { Draw balloons. }
   FillEllipse (75,374,5,5);
   setfillstyle (solidfill,red);
   FillEllipse (175,100,60,70);
   FillEllipse (175,174,5,5);
   setfillstyle (solidfill,5);
   FillEllipse (275,250,60,70);
   FillEllipse (275,324,5,5);
   setfillstyle (solidfill,blue);
   FillEllipse (375,150,60,70);
   FillEllipse (375,224,5,5);
   setfillstyle (solidfill,brown);
   FillEllipse (475,250,60,70);
   FillEllipse (475,324,5,5);
   setfillstyle (solidfill,yellow);
   FillEllipse (575,120,60,70);
   FillEllipse (575,194,5,5);
   setcolor (black);
   line (75,380,77,480);                { Draw little ropes.}
   line (175,180,177,300);
   line (275,330,277,450);
   line (375,230,377,350);
   line (475,330,477,450);
   line (575,200,577,350);
   delay (2000);
   setcolor (white);
   setusercharsize (2,2,1,0);
   SetTextJustify (CenterText,TopText);
   settextstyle(triplexfont, horizdir,usercharsize);
   outtextxy (XToCenter, 50,'CONGRATULATIONS !!!');
   outtextxy (XToCenter, 200,'YOU HAVE COMPLETED');
   outtextxy (XToCenter, 250,'THE SWAMPGAME');
   setusercharsize (1,2,1,0);
   settextstyle (triplexfont,horizdir,usercharsize);
   delay (3000);
   outtextxy (XToCenter, 420,'Press any key');
   ch := readkey;
   setfillstyle (solidfill,black);
   bar (0,0,640,480)
end;

{ This procedure is called when 'leavegame' is true.}
procedure LastPicture;
begin
  setfillstyle (solidfill, black);
  bar (0,0,640,480);
  setcolor (green);
  setusercharsize(3,2,5,0);          { Stel een eigen letterformaat in. }
  settextstyle(triplexfont, horizdir,usercharsize);{ Stel het lettertype in.}
  SetTextJustify (CenterText,TopText);
  outtextxy (XToCenter, 30,'THE SWAMPGAME');
  setusercharsize (2,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  outtextxy (XToCenter, 250,'Designed and written by :');
  outtextxy (XToCenter, 320,'P.Kooman,1997');
  setusercharsize (1,2,1,0);
  settextstyle(triplexfont, horizdir,usercharsize);
  delay (3000);
  outtextxy (XToCenter, 425,'Press any key');
  ch := readkey
end;

{ This procedure draws the info-screen. }
procedure InfoScreen;
begin
   setfillstyle (solidfill,darkgray);
   settextstyle (defaultfont,horizdir,0);
   bar (0,0,640,480);
   setfillstyle (solidfill,brown);
   bar (431,21,629,217);
   rectangle (430,20,630,218);
   outtextxy (450,28,'SWAMPS');
   outtextxy (450,72,'SURROUNDING SWAMPS');
   outtextxy (450,116,'MOVES');
   outtextxy (450,161,'LIVES');
   bar (431,241,629,305);
   rectangle (430,240,630,306);
   outtextxy (445,259,'F1 = HELP, F2 = CHEAT');
   outtextxy (445,281,'ESC = END GAME');
   rectangle (455,43,565,65);
   rectangle (455,87,473,109);
   rectangle (455,131,509,153);
   rectangle (455,177,472,197)
end;

begin
   initgraph (driver, mode,'c:\..\bgi');{ Go graphic.}
   if graphresult <> 0 then halt; { I'm sorry, but you can't run the program without a graphic videocard.}
   XToCenter := succ (GetMaxX) div 2;
   setRGBpalette (blue,0,0,60);
   Intro;
   getintvec($1c,old_adres);
   repeat                         { Start mainloop.}
      InfoScreen;
      DrawField;
      setfillstyle (solidfill,darkgray);
      bar (456,44,564,64);        { Draws gray bars.}
      bar (456,88,472,108);
      bar (456,132,508,152);
      bar (456,178,471,196);
      setfillstyle (solidfill,blue);
      bar (211,208,409,272);
      rectangle (210,207,410,273);
      outtextxy (215,215,'WITCH LEVEL TO START IN ');
      outtextxy (215,245,'         (1-5) :');
      ReadLevel (level);
      RefreshField;
      stop := false;
      repeat               { Start sub-loop.}
         posXold := posX;  { Store old position. Needed to draw the path }
         posYold := posY;  { and to draw player after walking into a swamp.}
         AllowedToWalk := true; { Makes sure 'DoMove' isn't called for nothing.}
         key := #0;      { Prepare for special key.}
         key := readkey; { Read key-code.}
         case key of     { Interpret key.}
           #75 : if posX > 0 then { Left arrow.}
                 begin
                    dec (posX,1);
                    way := 'L' { Needed in 'DrawPath'.}
                 end
                 else
                    AllowedToWalk := false; { If you're against a wall,'DoMove' is a waist of time.}
           #77 : if posX < 19 then { Right arrow.}
                 begin
                    inc (posX,1);
                    way := 'R'
                 end
                 else
                    AllowedToWalk := false;
           #72 : if posY > 0 then { Up arrow.}
                 begin
                    dec (posY,1);
                    way := 'B'
                  end
                  else
                     AllowedToWalk := false;
           #80 : if posY < 19 then { Down arrow.}
                 begin
                    inc (posY,1);
                    way := 'O'
                 end
                 else
                    AllowedToWalk := false;
           #60 : begin             { F2 (cheat).}
                    ShowSwamps;    { Makes swamps visible...}
                    delay (3000);  { for a while (depent on your computer, Pentium is really short).}
                    HideSwamps;    { Makes swamps invisible again.}
                    AllowedToWalk := false
                 end;
           #59 : begin             { F1 (help).}
                    setfillstyle (solidfill,brown); { Draw box. }
                    bar (431,395,629,459);
                    rectangle (430,394,630,460);
                    if Help then
                    begin
                       Help := false;
                       outtextxy (483,424,'HELP DISABLED');
                    end
                    else
                    begin
                       Help := true;
                       outtextxy (483,424,'HELP ENABLED')
                    end;
                    delay (1000);
                    setfillstyle (solidfill,darkgray); { Makes box invisible.}
                    bar (430,394,630,460);
                    AllowedToWalk := false
                 end;
           #27 : begin            { Escape.}
                    setfillstyle (solidfill,brown);
                    bar (431,395,629,459);
                    rectangle (430,394,630,460);
                    EndGame (stop);   { Call EndGame to ask if you want to end.}
                    AllowedToWalk := false
                 end;
           else AllowedToWalk := false; { 'Illegal key ? Don't do anything at all.}
           end;
           if AllowedToWalk then  { If you're can move then...}
           begin
              DoMove (posX,posY);
              HowDangerous;   { Write new situation to info-screen.}
              NumberOfMoves;
              NumberOfLives
           end;
           if (posX = 19) and (posY = 19) then { Field completed...}
              if level < 5 then  { if you weren't in the last level...}
              begin
                 inc (level,1);  { increase level.}
                 RefreshField    { prepares for next field.}
              end
              else               { Game Completed !!!}
              begin
                 setintvec ($1c,old_adres); { Disable interrupt.}
                 setRGBpalette (blue,0,0,63);
                 Congratulations;
                 stop := true;
                 Completed := true;
                 Intro    { Restart game.}
              end;
      until (lives = 0) or stop; { Exit sub-loop if you're out of lives or if you want to end game. }
      if not Completed then      { or if you've completed the game.}
      begin
         setintvec ($1c,old_adres);
         setfillstyle (solidfill,blue);
         setRGBpalette (blue,0,0,63);
         bar (391,439,409,459);
         stop := false;
         ShowSwamps;   { Here you see how you should have walked.}
         setfillstyle (solidfill,brown);
         bar (431,395,629,459);
         rectangle (430,394,630,460);
         outtextxy (489,413,'END OF GAME');
         outtextxy (464,435,'PLAY AGAIN (Y/N)?');
         ExitGame (LeaveGame);
         setfillstyle (solidfill,darkgray);
         bar (430,394,630,460)
      end;
      Completed := false;
      setfillstyle (solidfill,black);
      bar (0,0,640,480)
   until LeaveGame; { Until you really want to quit the game.}
   setintvec ($1c,old_adres);
   LastPicture;
   closegraph  { Be nice to your videocard.}
end.
