program jewel;

uses crt, screen;

const
    JewelChr = '';
    JewelChance = 20;
    MatchBackGround = 0;
    MatchForeGround = 31;

type
    FieldRowType = array [1..21] of integer;
    FieldType = array [1..30] of FieldRowType;

var
    Field       : FieldType;
    Colors,
    Rows,
    Cols,
    LeftX,
    RightX,
    TopY,
    BotY,
    BlockCol,
    BlockEndRow,
    SpeedDelay,
    Lives,
    Level,
    i           : integer;
    Score       : LongInt;
    Pause       : boolean;
    Escape      : boolean;
    Mono        : boolean;


function RandomColor : integer;

begin
    case random (Colors) of
        0 : RandomColor:= 1;
        1 : RandomColor:= 2;
        2 : RandomColor:= 4;
        3 : RandomColor:= 7;
        4 : RandomColor:= 14;
        5 : RandomColor:= 11;
        6 : RandomColor:= 13;
        7 : RandomColor:= 9;
        8 : RandomColor:= 12;
        9 : RandomColor:= 15;
  	end;
end;


procedure InitField;

var row, col : integer;

begin
    for row:= 1 to Rows do
        for col:= 1 to Cols do
            Field [col][row]:= 0;
end;


procedure InitVars;

var pos, i, Result : integer;

begin
    Val (ParamStr (1), i, Result);
    if Result = 0 then SpeedDelay:= i else
    begin
            Writeln ('Usage: jewel <CpuSpeedFactor> [ m ] [<Level> [<Columns> [<Rows> [<Colors>]]]]');
            Writeln;
            if ParamCount = 0 then
            begin
                Writeln ('CpuSpeedFactor necessary, 0 for XT until approx. 15000 for AT486.');
                Writeln ('m              force monochrome mode');
                Writeln ('Level          delay of speedups (default = 100)');
                Writeln ('Columns        number of columns (default = 6 )');
                Writeln ('Rows           number of rows    (default = 20)');
                Writeln ('Colors         number of colors  (default = 5 )');
                Writeln;
                Writeln ('Jewel: Try to get three same colors in an horizontal, vertical or diagonal');
                Writeln ('       row. Switch colors with Up, move with Left & Right, force placement');
                Writeln ('       with Down. P is pause, Esc is quit. jewel -help for numberinfo.');
            end
            else
            begin
                Writeln ('CpuSpeedFactor determines the number of times the keyboard is scanned');
                Writeln ('               for an event. 0 means actually 1 time per movedown of block.');
                Writeln ('Level          score is increased by 10000 div level each time a match');
                Writeln ('               occurred. The cpuspeedfactor is decreased with cpuspeedfactor');
                Writeln ('               div level each time a new block is generated.');
                Writeln ('Defaults:      The default values appear to be the closest to the original');
                Writeln ('               jewel as was written for the XWindows System.');
            end;
            Halt (1);
    end;

    if ParamStr (2) = 'm' then
    begin
        Mono:= true;
        pos:= 3;
    end
    else
    begin
        Mono:= false;
        pos:= 2;
    end;

    Val (ParamStr (pos), i, Result);
    if Result = 0 then Level:= i else Level:= 100;

    Val (ParamStr (pos + 1), i, Result);
    if Result = 0 then Cols:= i else Cols:= 6;
    if Cols > 30 then
    begin
    	Writeln ('Please keep it funny, max number of columns is 30');
        Halt (1);
    end;

    Val (ParamStr (pos + 2), i, Result);
    if Result = 0 then Rows:= i else Rows:= 20;
    if Rows > 21 then
    begin
    	Writeln ('I want to fit on the screen indeed, keep rows below 22.');
        Halt (1);
    end;

    Val (ParamStr (pos + 3), i, Result);
    if Result = 0 then Colors:= i else Colors:= 5;
    if Colors > 10 then
    begin
    	Writeln ('Pfew, so much colors cannot be distinguished I guess, keep it <= 10');
    	Halt (1);
    end;

    Escape:= false;
    Pause:= false;
    Score:= 0;
    Lives:= 3;
end;


procedure InitScreen;

var x, y : integer;

begin
    TextColor (6);

    TopY:= ((25 - Rows) div 2);
    BotY:= TopY + Rows - 1;
    LeftX:= 40 - Cols;
    RightX:= 39 + Cols;

    GotoXY (LeftX, TopY - 1);
    for x:= 1 to Cols * 2 + 1 do
        Write (Chr (196));
    GotoXY (LeftX, BotY + 1);
    for x:= 1 to Cols * 2 + 1 do
        Write (Chr (196));
    for y:= TopY - 1 to BotY + 1 do
    begin
        GotoXY (LeftX - 1, y);
        Write (Chr (179));
        GotoXY (RightX + 1, y);
        Write (Chr (179));
    end;
    GotoXY (39 - Cols, TopY - 1);
    Write (Chr (218));
    GotoXY (40 + Cols, TopY - 1);
    Write (Chr (191));
    GotoXY (39 - Cols, BotY + 1);
    Write (Chr (192));
    GotoXY (40 + Cols, BotY + 1);
    Write (Chr (217));
end;


procedure RefreshScreen (Map : Fieldtype);

var row, col, x, y : integer;

begin
    row:= 1;
    col:= 1;
    x:= LeftX;
    y:= TopY;
    while (y <= BotY) do
    begin
        while (x < RightX) do
        begin
            GotoXY (x, y);
            if not mono then
            begin
                TextColor (Map [col][row]);
                Write (JewelChr);
            end
            else
            begin
                if Map [col][row] = 0 then Write  ('  ') else
                begin
                    Write (Chr (Map [col][row] + 64));
                    Write (Chr (Map [col][row] + 64));
                end;
            end;
            x:= x + 2;
            col:= col + 1;
        end;
        y:= y + 1;
        row:= row + 1;
        x:= LeftX;
        col:= 1;
    end;
    TextColor (5);
    GotoXY (LeftX + 1, TopY - 1);
	Write (Score);
end;


function GenerateNewBlock : boolean;

var midCol, i : integer;

begin
    Randomize;
    midCol:= (Cols div 2) + 1;
    if Field [midCol][3] <> 0 then GenerateNewBlock:= false else
    begin
        if Random (JewelChance) = 0 then
            for i:= 1 to 3 do Field [midCol][i]:= 24
        else
            for i:= 1 to 3 do Field [midCol][i]:= RandomColor;
        GenerateNewBlock:= true;
    end;
    BlockCol:= midCol;
    BlockEndRow:= 3;
end;


function MoveBlockDown (Col, startRow, endRow : integer; checkflag : boolean)
    : boolean;

var i : integer;

begin
    if endRow = Rows then
        MoveBlockDown:= false
    else
    begin
        if checkflag and (Field [Col][endRow + 1] <> 0) then
            MoveBlockDown:= false
        else
        begin
            for i:= endRow + 1 downto startRow + 1 do
                Field [Col][i]:= Field [Col][i - 1];
            Field [Col][startRow]:= 0;
            MoveBlockDown:= true;
        end;
    end;
end;


procedure SwapBlockColors;

var i : integer;

begin
    i:= Field [BlockCol][BlockEndRow - 2];
    Field [BlockCol][BlockEndRow - 2]:= Field [BlockCol][BlockEndRow - 1];
    Field [BlockCol][BlockEndRow - 1]:= Field [BlockCol][BlockEndRow];
    Field [BlockCol][BlockEndRow]:= i;
end;


procedure ForceBlockDown;

begin
    while MoveBlockDown (BlockCol, BlockEndRow - 2, BlockEndRow, true) do
        inc (BlockEndRow);
end;


procedure MoveBlockLeft;

var i : integer;

begin
    if BlockCol > 1 then
    begin
        if (Field [BlockCol - 1][BlockEndRow] = 0) and
           (Field [BlockCol - 1][BlockEndRow - 1] = 0) and
           (Field [BlockCol - 1][BlockEndRow - 2] = 0) then
        begin
            BlockCol:= BlockCol - 1;
            for i:= BlockEndRow - 2 to BlockEndRow do
            begin
                Field [BlockCol][i]:= Field [BlockCol + 1][i];
                Field [BlockCol + 1][i]:= 0;
            end;
        end;
    end;
end;


procedure MoveBlockRight;

var i : integer;

begin
    if BlockCol < Cols then
    begin
        if (Field [BlockCol + 1][BlockEndRow] = 0) and
           (Field [BlockCol + 1][BlockEndRow - 1] = 0) and
           (Field [BlockCol + 1][BlockEndRow - 2] = 0) then
        begin
            BlockCol:= BlockCol + 1;
            for i:= BlockEndRow - 2 to BlockEndRow do
            begin
                Field [BlockCol][i]:= Field [BlockCol - 1][i];
                Field [BlockCol - 1][i]:= 0;
            end;
        end;
    end;
end;


procedure GetKeyboardEvent;

var Ch : char;

begin
    if KeyPressed then
    begin
    	Ch:= ReadKey;
        case Ch of
        	Chr (0) :
			        begin
            			case ReadKey of
                			Chr (72) : begin              (* up *)
                            			SwapBlockColors;
                            			RefreshScreen (Field);
                           			   end;
                			Chr (80) : begin              (* down *)
                            			ForceBlockDown;
                            			RefreshScreen (Field);
                           			   end;
                			Chr (75) : begin              (* left *)
                            			MoveBlockLeft;
                            			RefreshScreen (Field);
                           			   end;
                			Chr (77) : begin              (* right *)
                            			MoveBlockRight;
                            			RefreshScreen (Field);
                           			   end;
            			end;
        			end;
            Chr (27) : Escape:= true;
            Chr (112): if Pause then Pause:= false else Pause:= true;
            Chr (80) : if Pause then Pause:= false else Pause:= true;
        end;
    end;
end;


function MatchesFound : boolean;

var i, j, k, BlockRow, color, startmatch, endmatch : integer;
    MatchField : Fieldtype;    (* here we mark all matching jewels *)
    found : boolean;

begin
    found:= false;

    (* initialize the Matchfield *)
    for j:= 1 to Rows do
    	for i:= 1 to Cols do
        	MatchField [i][j]:= MatchBackGround;

    if Field [BlockCol][BlockEndRow] = 24 then  (* we have a jewel here! *)
    begin
        if BlockEndRow < Rows then
        begin
            color:= Field [BlockCol][BlockEndRow + 1];
            for j:= 1 to Rows do
                for i:= 1 to Cols do
                    if (Field [i][j] = color) or (Field [i][j] = 24) then
                        MatchField [i][j]:= MatchForeground;
        end
        else
            for BlockRow:= BlockEndRow downto BlockEndRow - 2 do
                MatchField [BlockCol][BlockRow]:= MatchForeground;
        found:= true;
    end

    else
    begin
        for BlockRow:= BlockEndRow downto BlockEndRow - 2 do
        begin
            color:= Field [BlockCol][BlockRow];

            (* Look for vertical matches, first downwards, then upwards *)
            j:= BlockRow + 1;
            while ((j <= Rows) and (Field [BlockCol][j] = color)) do
                Inc (j);
            j:= j - 1;
            endmatch:= j;
            while ((j >= 1) and (Field [BlockCol][j] = color)) do
                j:= j - 1;
            startmatch:= j + 1;
            if (endmatch - startmatch > 1) and (color <> 0) then
            begin
                for j:= startmatch to endmatch do
                    MatchField [BlockCol][j]:= MatchForeGround;
                found:= true;
            end;

            (* Look for horizontal matches, first rightwards, then to the left*)
            i:= BlockCol + 1;
            while ((i <= Cols) and (Field [i][BlockRow] = color)) do
                Inc (i);
                i:= i - 1;
            endmatch:= i;
            while ((i >= 1) and (Field [i][BlockRow] = color)) do
                i:= i - 1;
            startmatch:= i + 1;
            if (endmatch - startmatch > 1) and (color <> 0) then
            begin
                for i:= startmatch to endmatch do
                    MatchField [i][BlockRow]:= MatchForeGround;
                found:= true;
            end;

            (* look for diagonal matches, first rightdownwards, then leftup *)
            j:= BlockRow + 1;
                i:= BlockCol + 1;
            while ((j <= Rows) and (i <= Cols) and (Field [i][j] = color)) do
            begin
                Inc (i);
                Inc (j);
            end;
            i:= i - 1;
            j:= j - 1;
            endmatch:= i;
                while ((j >= 1) and (i >= 1) and (Field [i][j] = color)) do
            begin
                i:= i - 1;
                j:= j - 1;
            end;
                startmatch:= i + 1;
            if (endmatch - startmatch > 1) and (color <> 0) then
            begin
                for i:= startmatch to endmatch do
                    MatchField [i][i - (BlockCol - BlockRow)]:= MatchForeGround;
                found:= true;
            end;

            (* look for diagonal matches, first leftdownwards, then rightup *)
            j:= BlockRow + 1;
            i:= BlockCol - 1;
            while ((j <= Rows) and (i >= 1) and (Field [i][j] = color)) do
            begin
                i:= i - 1;
                Inc (j);
            end;
            i:= i + 1;
            j:= j - 1;
            endmatch:= i;
            while ((j >= 1) and (i <= Cols) and (Field [i][j] = color)) do
            begin
                Inc (i);
                j:= j - 1;
            end;
            startmatch:= i - 1;
            if (startmatch - endmatch > 1) and (color <> 0) then
            begin
                for i:= startmatch downto endmatch do
                    MatchField [i][(BlockCol + BlockRow) - i]:= MatchForeGround;
                found:= true;
            end;
        end;

    end;

    (* handle the first row (there are no blocks above to move down) *)
    for i:= 1 to Cols do
    	if MatchField [i][1] = MatchForeGround then
			Field [i][1]:= 0;

    (* scan Matchfield and move at each encounter upper blocks down *)
    for j:= 2 to Rows do
    	for i:= 1 to Cols do
        	if MatchField [i][j] = MatchForeGround then
            begin
				MoveBlockDown (i, 1, j - 1, false);
                if (i = BlockCol) and (BlockEndRow < Rows) then
                	Inc (BlockEndRow);
                RefreshScreen (Field);
                Score:= Score + (10000 div Level);
            end;

    MatchesFound:= found;
end;


procedure WriteLives;

begin
    TextColor (5);
    GotoXY (RightX - 1, TopY - 1);
    Write (Lives);
end;


procedure WriteScore;

begin
    TextColor (5);
    Write ('Jewel for DOS 1.0  Jan 1993   ');
    TextColor (2);
    Writeln ('Total score : ', Score);
    TextColor (7);
    Writeln ('');
end;


begin
    SaveScreen;
    InitVars;
    InitScreen;
    while (Lives > 0) do
    begin
        InitField;
        WriteLives;
        RefreshScreen (Field);
        while (GenerateNewBlock) and (not Escape) do
        begin
            RefreshScreen (Field);
            while MoveBlockDown (BlockCol, BlockEndRow - 2, BlockEndRow, true)
                  and (not Escape) do
            begin
                Inc (BlockEndRow);
                RefreshScreen (Field);
                i:= 0;
                repeat
                    GetKeyboardEvent;
                    Inc (i);
                until (i > SpeedDelay) and (not Pause);
            end;
            repeat until not MatchesFound;
            if SpeedDelay > 0 then
                SpeedDelay:= SpeedDelay - (SpeedDelay div Level);
        end;
        Lives:= Lives - 1;
    end;
    RestoreScreen;
    WriteScore;
end.

