program Mode43;

(* Mode 43 gives you a graphical environment for your dos command line
 * so it will be possible to have more than the standard 25 lines
 * available for all graphical adaptors (including Hercules and CGA)
 *
 * problems:
 * It needs a certain amount of memory below which it cannot execute
 * your DOS commands. When a command causes output to stderr, it cannot
 * be handled by Mode43, so it will cause undetermined lines on screen.
 *
 * hints:
 * Note that, by using other fonts, you can set a UserCharSize and
 * vary the number of lines on screen endlessly
 *)
 
uses Dos, Crt, Graph, BGIDriv;
const Cursor = #95;
      ForceCrtCh = '!';
var Ch : Char;
    Xwidth, Ywidth : Word;
    Cmd, CurDir : String;

{$M $9000,$9000,$9000} 
procedure NextLine; forward;

procedure Abort (Str : String);
begin
     Writeln ('error: ', Str);
     Halt (0);
end;

procedure Init;
var Driver, Mode : integer;
begin
     Detectgraph (Driver, Mode);
     case Driver of
     CGA :
     if RegisterBGIdriver(@CGADriverProc) < 0 then Abort ('CGA not supported');
     MCGA..EGAMono, VGA :
     if RegisterBGIdriver(@EGAVGADriverProc) < 0 then Abort ('EGA/VGA not supported');
     IBM8514, HercMono : 
     if RegisterBGIdriver(@HercDriverProc) < 0 then Abort ('Hercules not supported');
     ATT400 :
     if RegisterBGIdriver(@ATTDriverProc) < 0 then Abort ('ATT not supported');
     PC3270 :
     if RegisterBGIdriver(@PC3270DriverProc) < 0 then Abort ('PC3270 not supported');
     else Abort ('Graphics driver could not be found');
     end;                                                                
     InitGraph(Driver, Mode, '');
     if GraphResult < 0 then Abort ('Graphics driver could not be initialized');
     SetTextStyle(DefaultFont, HorizDir, 1);
     SetTextJustify(LeftText, TopText);
     SetFillStyle (0, 0);
     SetColor (1);
     Xwidth:= TextWidth ('X');
     Ywidth:= TextHeight ('X');
     MoveTo (0, 0);
     OutText (ConCat ('Mode 43 ...  prepend ', ForceCRTCh, ' to force CRT mode for this command, ESC to return . . .'));
     NextLine;
     NextLine;
     GetDir (0, CurDir);
     OutText (Concat (CurDir, '>', Cursor));
     Cmd:= '';
end;
 
procedure BackSpace;
begin
     if GetX < Xwidth*2 + TextWidth (CurDir) then exit;
     MoveTo (GetX - Xwidth, GetY);
     Bar (GetX, GetY, GetX + Xwidth - 1, GetY + Ywidth - 1);
end;

procedure NextLine;
var P : Pointer;
    SaveY : Word;
begin
     if GetY > GetMaxY - YWidth*2 - (GetMaxY mod YWidth) then
     begin
          GetMem (P, ImageSize (0, Ywidth, GetMaxX, GetMaxY));
          GetImage (0, Ywidth, GetMaxX, GetMaxY, P^);
          Bar (0, GetMaxY - Ywidth - (GetMaxY mod YWidth), GetMaxX, GetMaxY);
          PutImage (0, 0, P^, AndPut);
          MoveTo (0, GetY);
          FreeMem (P, ImageSize (0, Ywidth, GetMaxX, GetMaxY));
     end
     else
         MoveTo (0, GetY + Ywidth);
end;

procedure LoadFile (Name : String);
var F : Text;
    Str  : String;
begin
     {$I-}
     assign (F, Name);
     reset (F);
     if IOResult > 0 then exit;
     {$I+}
     while not eof (F) do
     begin
          readln (F, Str);
          OutTextXY (0, GetY, Str);
          NextLine;
     end;
end;

procedure ExecuteCmd;
var i : integer;
begin
     if Cmd[1] = ForceCRTCh then
     begin
          RestoreCRTMode;
          for i:= 1 to Ord (Cmd[0]) - 1 do Cmd[i]:= Cmd[i+1];
          Cmd[0]:= Chr (Ord (Cmd[0]) - 1);
          Swapvectors;
          Exec (GetEnv ('comspec'), Concat (' /c ', Cmd));
          Swapvectors;
          SetGraphmode (GetGraphMode);
          SetFillStyle (0, 0);
     end
     else
     begin
          Swapvectors;
          Exec (GetEnv ('comspec'), Concat (' /c ', Cmd, '> $'));
          Swapvectors;
          LoadFile ('$');
          Exec (GetEnv ('comspec'), ' /c del $ > nul');
     end;
     NextLine;
     if DosError <> 0 then
     begin
          OutText ('mode43: Error executing your command (memory problem?)');
          NextLine;
     end;
     GetDir (0, CurDir);
     OutText (Concat (CurDir, '>'));
     Cmd:= '';
end;

begin
     Init;
     repeat
           Ch:= ReadKey;
           BackSpace;
           if GetX > GetMaxX - Xwidth then NextLine;
           case Ord (Ch) of
           8: begin
                   BackSpace;
                   if Ord (Cmd[0]) > 0 then Cmd[0]:= Chr (Ord (Cmd[0]) - 1);
              end;
           13: begin
                    NextLine;
                    ExecuteCmd;
               end;
           27: begin
                    CloseGraph;
                    Halt(0);
               end;
           else
               begin
                    OutText (Ch);
                    Cmd:= Concat (Cmd, Ch);
               end;
           end;
           OutText (Cursor);
     until false;
end.
