unit comport;

interface

uses comm_tp4;

type ComportObj = object
                        port : byte;

                        constructor init;
                        function open (po, baud, par, data, stop : byte) : boolean;
                        procedure cwrite (ch : char);
                        procedure swrite (s : pchar);
                        function cread (var ch : char) : boolean;
                        destructor done;

                     end;

implementation

constructor ComportObj.init;
begin
end;

function ComportObj.open (po, baud, par, data, stop : byte) : boolean;
(*  Initialize COM port in format (port, byte, parity, data, stop)
    where:  port = 1..8 in (COM1:,COM2: etc.)
            bytes= 0..9 in (110,150,300,600,1200,2400,4800,9600,19200,38400)
            data = 5..8
            parity = 0,1,3 in (none, odd, even)
            stop = 0..1
*)
begin
     port:= po;
     SetupCOMPort (port, baud, data, par, stop);
     InstallInt (port);
     if not (IntInstalled[port]) then open:= false else open:= true;
end;

procedure ComportObj.cwrite (ch : char);
begin
     if (IntInstalled[port]) then IWriteCOM (port, ch);
end;

procedure ComportObj.swrite (s : pchar);
var i : word;
begin
     i:= 0;
     if (not IntInstalled[port]) then exit;
     while not (s[i] = chr (0)) do
     begin
          IWriteCOM (port, s[i]);
          inc (i);
     end;
end;

function ComportObj.cread (var ch : char) : boolean;
begin
     cread:= false;
     if not (IntInstalled[port]) then exit;
     DisableInts;
     if (InTail [port] <> InHead [port]) then
     begin
          ch := chr (InBuffer [port, InHead [port]]);
          InHead [port]:= (InHead [port] + 1) MOD (MaxInSize + 1);
          cread:= true;
     end;
     EnableInts;
end;

destructor ComportObj.done;
begin
end;

end.
