//===========================================================================
//
// File: comctlex.h
//
// Purpose:
//   This file provide function and structure declarations for some of the
//   undocumented functions in COMCTL32.DLL. For more details on how to use
//   these functions and the latest copy of this file, visit the following
//   website - http://www.geocities.com/SiliconValley/4942/
//
// Notes:
//   * Certain functions included in this file are only available on NT. For
//     these functions there are two sets of prototypes - a function pointer
//     typedef for run-time linking with GetProcAddress, and a standard
//     function declaration that can be used in explicit function calls 
//     (i.e. load-time linking). If you intend your application to run on 
//     Windows 95 as well as Windows NT, you should always use run-time 
//     linking. If your application is only intended for use on NT you can 
//     make use of the standard function declarations by #defining NTONLY.
//
//===========================================================================

#ifndef _INC_COMCTLEX
#define _INC_COMCTLEX

//
// Define API decoration for direct importing of DLL references.
//
#ifndef WINCOMMCTRLAPI
#if !defined(_COMCTL32_) && defined(_WIN32)
#define WINCOMMCTRLAPI DECLSPEC_IMPORT
#else
#define WINCOMMCTRLAPI
#endif
#endif // WINCOMMCTRLAPI

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif // __cplusplus

//===========================================================================
//
// Dynamic Pointer Array Routines
//
//===========================================================================

// DPA handle structure
typedef struct {
  int     nItems;
  LPVOID *lpItems; 
  HANDLE  hHeap;
  int     nCapacity;
  int     nDelta;
} * HDPA;

WINCOMMCTRLAPI HDPA WINAPI DPA_Create(int nDelta);

WINCOMMCTRLAPI HDPA WINAPI DPA_CreateEx(int nDelta, HANDLE hHeap);

WINCOMMCTRLAPI HDPA WINAPI DPA_Clone(HDPA hSource, HDPA hDest);

WINCOMMCTRLAPI BOOL WINAPI DPA_Destroy(HDPA hArray);

WINCOMMCTRLAPI int WINAPI DPA_InsertPtr(HDPA hArray, int nPosition, 
  LPVOID lpItem);

WINCOMMCTRLAPI BOOL WINAPI DPA_SetPtr(HDPA hArray, int nPosition, 
  LPVOID lpItem);

WINCOMMCTRLAPI BOOL WINAPI DPA_Grow(HDPA hArray, int nCapacity);

WINCOMMCTRLAPI LPVOID WINAPI DPA_GetPtr(HDPA hArray, int nPosition);

WINCOMMCTRLAPI LPVOID WINAPI DPA_DeletePtr(HDPA hArray, int nPosition);

WINCOMMCTRLAPI BOOL WINAPI DPA_DeleteAllPtrs(HDPA hArray);

// DPA_Search and DPA_Sort callback function
typedef int (CALLBACK *LPFNDPACOMPARE)(LPVOID lpItem1, LPVOID lpItem2,
  LPARAM lParam);

// DPA_Search flags
#define DPAF_LINEAR_SEARCH  0x00 
#define DPAF_BINARY_SEARCH  0x01 
#define DPAF_BINARY_INSERT  0x07 

WINCOMMCTRLAPI int WINAPI DPA_Search(HDPA hArray, LPVOID lpItem, 
  int nStartPos, LPFNDPACOMPARE lpfnCompare, LPARAM lParam, DWORD dwFlags);

WINCOMMCTRLAPI BOOL WINAPI DPA_Sort(HDPA hArray, LPFNDPACOMPARE lpfnCompare, 
  LPARAM lParam);

WINCOMMCTRLAPI int WINAPI DPA_GetPtrIndex(HDPA hArray, LPVOID lpItem);

//===========================================================================
//
// Dynamic Structure Array Routines
//
//===========================================================================

// DSA handle structure
typedef struct {
  int     nItems;
  LPVOID  lpItems; 
  int     nCapacity;
  int     nItemSize;
  int     nDelta;
} * HDSA;

WINCOMMCTRLAPI HDSA WINAPI DSA_Create(int nItemSize, int nDelta);

WINCOMMCTRLAPI BOOL WINAPI DSA_Destroy(HDSA hArray);

WINCOMMCTRLAPI int WINAPI DSA_InsertItem(HDSA hArray, int nPosition, 
  LPVOID lpItem);

WINCOMMCTRLAPI BOOL WINAPI DSA_SetItem(HDSA hArray, int nPosition, 
  LPVOID lpItem);

WINCOMMCTRLAPI BOOL WINAPI DSA_GetItem(HDSA hArray, int nPosition, 
  LPVOID lpBuffer);

WINCOMMCTRLAPI LPVOID WINAPI DSA_GetItemPtr(HDSA hArray, int nPosition);

WINCOMMCTRLAPI BOOL WINAPI DSA_DeleteItem(HDSA hArray, int nPosition);

WINCOMMCTRLAPI BOOL WINAPI DSA_DeleteAllItems(HDSA hArray);

//===========================================================================
//
// MRU Routines
//
//===========================================================================

// CreateMRUList structure
typedef struct {
  DWORD   cbSize;
  DWORD   nMaxItems;
  DWORD   dwFlags;
  HKEY    hKey;
  LPCSTR  lpszSubKey;
  PROC    lpfnCompare;
} CREATEMRULISTA, * LPCREATEMRULISTA;
typedef const CREATEMRULISTA * LPCCREATEMRULISTA;

typedef struct {
  DWORD   cbSize;
  DWORD   nMaxItems;
  DWORD   dwFlags;
  HKEY    hKey;
  LPCWSTR lpszSubKey;
  PROC    lpfnCompare;
} CREATEMRULISTW, * LPCREATEMRULISTW;
typedef const CREATEMRULISTW * LPCCREATEMRULISTW;

#ifdef UNICODE
typedef CREATEMRULISTW CREATEMRULIST;
typedef LPCREATEMRULISTW LPCREATEMRULIST;
typedef LPCCREATEMRULISTW * LPCCREATEMRULIST;
#else
typedef CREATEMRULISTA CREATEMRULIST;
typedef LPCREATEMRULISTA LPCREATEMRULIST;
typedef LPCCREATEMRULISTA * LPCCREATEMRULIST;
#endif // UNICODE

// CreateMRUList flags
#define MRUF_STRING_LIST  0
#define MRUF_BINARY_LIST  1
#define MRUF_DELAYED_SAVE 2 

WINCOMMCTRLAPI HANDLE WINAPI CreateMRUListA(LPCCREATEMRULISTA lpCreateInfo);

WINCOMMCTRLAPI void WINAPI FreeMRUList(HANDLE hList);

WINCOMMCTRLAPI int WINAPI AddMRUStringA(HANDLE hList, LPCSTR lpszString);

WINCOMMCTRLAPI int WINAPI AddMRUData(HANDLE hList, LPCVOID lpData, 
  DWORD cbData);

WINCOMMCTRLAPI BOOL WINAPI DelMRUString(HANDLE hList, int nItemPos);

WINCOMMCTRLAPI int WINAPI EnumMRUListA(HANDLE hList, int nItemPos, 
  LPVOID lpBuffer, DWORD nBufferSize);

WINCOMMCTRLAPI int WINAPI FindMRUStringA(HANDLE hList, LPCSTR lpszString, 
  LPINT lpRegNum);

WINCOMMCTRLAPI int WINAPI FindMRUData(HANDLE hList, LPCVOID lpData, 
  DWORD cbData, LPINT lpRegNum);

#ifdef NTONLY

WINCOMMCTRLAPI HANDLE WINAPI CreateMRUListW(LPCCREATEMRULISTW lpCreateInfo);

WINCOMMCTRLAPI int WINAPI AddMRUStringW(HANDLE hList, LPCWSTR lpszString);

WINCOMMCTRLAPI int WINAPI EnumMRUListW(HANDLE hList, int nItemPos, 
  LPVOID lpBuffer, DWORD nBufferSize);

WINCOMMCTRLAPI int WINAPI FindMRUStringW(HANDLE hList, LPCWSTR lpszString, 
  LPINT lpRegNum);

#else

typedef HANDLE (WINAPI * LPFNCREATEMRULISTW)(LPCCREATEMRULISTW);

typedef int (WINAPI * LPFNADDMRUSTRINGW)(HANDLE, LPCWSTR);

typedef int (WINAPI * LPFNENUMMRULISTW)(HANDLE, int, LPVOID, DWORD);

typedef int (WINAPI * LPFNFINDMRUSTRINGW)(HANDLE, LPCWSTR, LPINT);

#endif // !NTONLY

#ifdef UNICODE
#define CreateMRUList  CreateMRUListW
#define AddMRUString   AddMRUStringW
#define EnumMRUList    EnumMRUListW
#define FindMRUString  FindMRUStringW
#else
#define CreateMRUList  CreateMRUListA
#define AddMRUString   AddMRUStringA
#define EnumMRUList    EnumMRUListA
#define FindMRUString  FindMRUStringA
#endif // !UNICODE

//===========================================================================
//
// Shared Memory Routines
//
// Note that the memory allocated by these functions is only shareable on
// Windows 95. On Windows NT the functions are just stubs that call the 
// equivalent LocalXXX functions.
//
//===========================================================================

WINCOMMCTRLAPI LPVOID WINAPI Alloc(ULONG cb);

WINCOMMCTRLAPI LPVOID WINAPI ReAlloc(LPVOID pv, ULONG cb);

WINCOMMCTRLAPI BOOL WINAPI Free(LPVOID pv);

WINCOMMCTRLAPI ULONG WINAPI GetSize(LPVOID pv);

//===========================================================================
//
// String Manipulation Routines
//
//===========================================================================

WINCOMMCTRLAPI LPSTR WINAPI StrChrA(LPCSTR pszStart, CHAR cMatch);

WINCOMMCTRLAPI LPSTR WINAPI StrChrIA(LPCSTR pszStart, CHAR cMatch);

WINCOMMCTRLAPI LPSTR WINAPI StrRChrA(LPCSTR pszStart, LPCSTR pszEnd, 
  CHAR cMatch);

WINCOMMCTRLAPI LPSTR WINAPI StrRChrIA(LPCSTR pszStart, LPCSTR pszEnd, 
  CHAR cMatch);

WINCOMMCTRLAPI LPSTR WINAPI StrStrA(LPCSTR pszStart, LPCSTR pszSrch);

WINCOMMCTRLAPI LPSTR WINAPI StrStrIA(LPCSTR pszStart, LPCSTR pszSrch);

WINCOMMCTRLAPI LPSTR WINAPI StrRStrIA(LPCSTR pszStart, LPCSTR pszEnd, 
  LPCSTR pszSrch);

WINCOMMCTRLAPI int WINAPI StrCSpnA(LPCSTR pszStart, LPCSTR pszSet);

WINCOMMCTRLAPI int WINAPI StrCSpnIA(LPCSTR pszStart, LPCSTR pszSet);

WINCOMMCTRLAPI int WINAPI StrCmpNA(LPCSTR pszStr1, LPCSTR pszStr2, 
  int nChar);

WINCOMMCTRLAPI int WINAPI StrCmpNIA(LPCSTR pszStr1, LPCSTR pszStr2, 
  int nChar);

WINCOMMCTRLAPI int WINAPI StrToIntA(LPCSTR pszStr);

WINCOMMCTRLAPI LPWSTR WINAPI StrChrW(LPCWSTR pszStart, WCHAR cMatch);

WINCOMMCTRLAPI LPWSTR WINAPI StrChrIW(LPCWSTR pszStart, WCHAR cMatch);

WINCOMMCTRLAPI LPWSTR WINAPI StrRChrW(LPCWSTR pszStart, LPCWSTR pszEnd, 
  WCHAR cMatch);

WINCOMMCTRLAPI LPWSTR WINAPI StrRChrIW(LPCWSTR pszStart, LPCWSTR pszEnd, 
  WCHAR cMatch);

WINCOMMCTRLAPI LPWSTR WINAPI StrStrW(LPCWSTR pszStart, LPCWSTR pszSrch);

WINCOMMCTRLAPI LPWSTR WINAPI StrStrIW(LPCWSTR pszStart, LPCWSTR pszSrch);

WINCOMMCTRLAPI LPWSTR WINAPI StrRStrIW(LPCWSTR pszStart, LPCWSTR pszEnd, 
  LPCWSTR pszSrch);

WINCOMMCTRLAPI int WINAPI StrCSpnW(LPCWSTR pszStart, LPCWSTR pszSet);

WINCOMMCTRLAPI int WINAPI StrCSpnIW(LPCWSTR pszStart, LPCWSTR pszSet);

WINCOMMCTRLAPI int WINAPI StrCmpNW(LPCWSTR pszStr1, LPCWSTR pszStr2, 
  int nChar);

WINCOMMCTRLAPI int WINAPI StrCmpNIW(LPCWSTR pszStr1, LPCWSTR pszStr2, 
  int nChar);

WINCOMMCTRLAPI int WINAPI StrToIntW(LPCWSTR pszStr);

#ifdef UNICODE
#define StrChr    StrChrW
#define StrChrI   StrChrIW
#define StrRChr   StrRChrW
#define StrRChrI  StrRChrIW
#define StrStr    StrStrW
#define StrStrI   StrStrIW
#define StrRStrI  StrRStrIW
#define StrCSpn   StrCSpnW
#define StrCSpnI  StrCSpnIW
#define StrCmpN   StrCmpNW
#define StrCmpNI  StrCmpNIW
#define StrToInt  StrToIntW
#else
#define StrChr    StrChrA
#define StrChrI   StrChrIA
#define StrRChr   StrRChrA
#define StrRChrI  StrRChrIA
#define StrStr    StrStrA
#define StrStrI   StrStrIA
#define StrRStrI  StrRStrIA
#define StrCSpn   StrCSpnA
#define StrCSpnI  StrCSpnIA
#define StrCmpN   StrCmpNA
#define StrCmpNI  StrCmpNIA
#define StrToInt  StrToIntA
#endif // !UNICODE

//===========================================================================

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _INC_COMCTLEX

