{$I-,M 4096,0,600000 }

program Disco_Sistema_Zeus;

{
        Realizado por Daniel Lancha Garcia
}

type
    Sector=array[1..512]of byte;
    Cilindro=array[1..18]of sector;
    Pista=array[1..2]of cilindro;
    pPista=^Pista;
    disco=array[1..80]of pPista;
    fat=array[1..9]of Sector;

Function Grabar_Pista(n:byte;p:pPista):boolean;
var s,o:word;cara,ok:byte;
begin

     for cara:=1 to 10 do
     asm
        xor     ax,ax
        xor     dx,dx
        int     13h
        mov     ok,ah
     end;
     if ok=0 then
      begin
      for cara:=1 to 2 do
       begin
        s:=seg(p^[cara,1,1]);
        o:=ofs(p^[cara,1,1]);
        asm
           push es
           mov es,s
           mov bx,o
           mov ch,n
           mov cl,1
           xor dl,dl
           mov dh,cara
           dec ch
           dec dh
           mov ax,0312h
           int 13h
           pop es
        end;
       end;
      Grabar_Pista:=True;
      end
     else Grabar_Pista:=False;
end;

Function Grabar_Disco(n:byte;var d:disco):boolean;
var b:byte;
begin
     Grabar_Disco:=False;
     for b:=1 to n do
      if (Grabar_Pista(b,d[b])) then
       Grabar_Disco:=True;
end;

Procedure Inicia_Raiz(var d:disco;t:longint);
var s:string;
    i:integer;
    b:byte;
begin
     s:='-BOOT ZEUS-';
     for i:=1 to 11 do
      d[1]^[2,2,i]:=ord(s[i]);
     d[1]^[2,2,12]:=8;
     d[1]^[2,2,24]:=$24;
     d[1]^[2,2,23]:=$AF;
     s:='ZEUS    EXE';
     for i:=1 to 11 do
      d[1]^[2,2,i+32]:=ord(s[i]);
     d[1]^[2,2,12+32]:=1;
     d[1]^[2,2,24+32]:=$24;
     d[1]^[2,2,23+32]:=$AF;
     d[1]^[2,2,27+32]:=5;
     b:=(t AND 255);
     d[1]^[2,2,29+32]:=b;
     b:=((t SHR 8) AND 255);
     d[1]^[2,2,30+32]:=b;
     b:=((t SHR 16) AND 255);
     d[1]^[2,2,31+32]:=b;
     b:=((t SHR 24) AND 255);
     d[1]^[2,2,32+32]:=b;
end;

Procedure Inicia_Fat(var f:fat);
var i,j:integer;
begin
     for i:=1 to 9 do
      for j:=1 to 512 do
       f[i,j]:=0;
     f[1,1]:=$F0;
     f[1,2]:=$FF;
     f[1,3]:=$FF;
end;

Procedure Copia_Fat(var f:fat;var d:disco);
var i:integer;
begin
     for i:=1 to 512 do
      begin
       d[1]^[1,2,i]:=f[1,i];
       d[1]^[1,11,i]:=f[1,i];
      end;
end;

Procedure Escribir_Fat(pos,valor:word;var f:fat);
var o,s:word;
begin
     s:=seg(f);
     o:=ofs(f);
     asm
        mov     bx,o
        mov     es,s
        mov     ax,pos
        mov     dx,valor
        add     bx,ax
        shr     ax,1
        pushf
        add     bx,ax
        mov     ax,es:[bx]
        popf
        jc      @poke_fat_imp
        and     ax,1111000000000000b
        jmp     @poke_fat_ok
 @poke_fat_imp:
        and     ax,0000000000001111b
        mov     cl,4
        shl     dx,cl
 @poke_fat_ok:
        or      ax,dx
        mov     es:[bx],ax
     end;
end;


Procedure Borrar_Pista(p:pPista);
var i,j,k:integer;
begin
    for k:=1 to 2 do
     for j:=1 to 18 do
      for i:=1 to 512 do
        p^[k,j,i]:=0;
end;

    {*****   PROGRAMA PRINCIPAL   *****}

Var
   d:disco;
   f:fat;
   pista_boot,pista_vacia:pPista;
   Fichero_Bootsector:file of sector;
   Fichero_ZEUS:file of Pista;
   tmp:file of byte;
   i,j,k,numero_pistas:integer;
   longitud:longint;
   c:char;


Begin
    Writeln;Writeln(' DISCO SISTEMA ZEUS !!!! ');
    Writeln('             Creado por Daniel Lancha Garcia');Writeln;
    if ParamCount>0 then
     begin
      assign(Fichero_Bootsector,ParamStr(1));
       if ParamCount>1 then
        begin
         assign(Fichero_ZEUS,ParamStr(2));
         assign(tmp,ParamStr(2));
         end
         else
          begin
           assign(Fichero_ZEUS,'ZEUS.EXE');
           assign(tmp,'ZEUS.EXE');
          end;
     end
      else
       begin
        assign(Fichero_Bootsector,'BOOTSECT.COM');
        assign(Fichero_ZEUS,'ZEUS.EXE');
        assign(tmp,'ZEUS.EXE');
       end;
    FileMode:=0;
    reset(Fichero_Bootsector);
    reset(Fichero_ZEUS);
    reset(tmp);
    if (IOResult <> 0) then
     begin
          Writeln(' Error en Apertura de ficheros !!');
          Writeln(' Modo de empleo:');Writeln;
          Writeln('      SISTEMA [BOOTSECT.COM] [ZEUS.EXE]');
          Writeln(' Estos nombres estan por Omision');Writeln;
          Close(Fichero_Bootsector);
          Close(Fichero_ZEUS);
          Close(tmp);
          halt(1);
     end;
    Writeln('Esta operacion destruira todos los datos del disco.');
    Write('Desea continuar?(S/N)');
    Readln(c);
    if UpCase(c)='S' THEN
    BEGIN
         Writeln('Por favor inserte un disco formateado en la unidad A ( 1.44 )');
         Write(' Pulse ENTER cuando este preparado');Readln;
         Writeln;Write('Haciendo disco sistema ZEUS . Por favor espere ...');
         longitud:=filesize(tmp);
         close(tmp);
         new(pista_vacia);
         new(pista_boot);
         Borrar_Pista(pista_vacia);
         Borrar_Pista(pista_boot);
         Inicia_Fat(f);
         numero_pistas:=1+(filesize(Fichero_ZEUS));
         for i:=1 to numero_pistas do
          begin
           new(d[i+1]);
           Borrar_Pista(d[i+1]);
           read(Fichero_ZEUS,d[i+1]^);
          end;
         for i:=5 to 4+(longitud div 512) do
          Escribir_Fat(i,i+1,f);
         if i<5 then i:=5
          else inc(i);
         Escribir_Fat(i,$0FFF,f);
         read(Fichero_Bootsector,pista_boot^[1,1]);
         d[1]:=pista_boot;
         pista_boot^[1,1,38]:=numero_pistas;
         Copia_Fat(f,d);
         Inicia_Raiz(d,longitud);
         Grabar_Disco(1+numero_pistas,d);
         for i:=1 to numero_pistas do
          dispose(d[i]);
         dispose(pista_vacia)
    END
     ELSE
         close(tmp);
    close(Fichero_ZEUS);
    close(Fichero_Bootsector);
End.