/* **************************************************************************
*                                                                           *
*  CMOS.CPP                                                                 *
*                                                                           *
*  14-03-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la CMOS                                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "aal\cmos.h"
#include "kernel\kernel.h"

extern PCkeKernel _import Kernel;
DWORD _import CLI();
VOID _import STI( DWORD );

#define CMOSControl		0x70
#define CMOSData			0x71

// **************************************************************************
// Prepara l'objecte
CCMOS::CCMOS() : CkeType( CID_CMOS )
	{
	}

// **************************************************************************
// Destructor de la classe
CCMOS::~CCMOS()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CCMOS::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_CMOS )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Indica si hi ha coprocessador matematic installat
BOOL CCMOS::MathProcessor()
	{
	Kernel->OutByte( CMOSControl, 0x14 );
	return (Kernel->InByte( CMOSData ) & 2 ? TRUE : FALSE);
	}

// **************************************************************************
// Retorna el tipus de disquetera de la unitat 0
BYTE CCMOS::Drive0Type()
	{
	Kernel->OutByte( CMOSControl, 0x10 );
	return (BYTE) (Kernel->InByte( CMOSData ) >> 4);
	}

// **************************************************************************
// Retorna el tipus de disquetera de la unitat 1
BYTE CCMOS::Drive1Type()
	{
	Kernel->OutByte( CMOSControl, 0x10 );
	return (BYTE) (Kernel->InByte( CMOSData ) & 0x0f);
	}

// **************************************************************************
// Retorna l'hora de la CMOS
TAAL_TIME CCMOS::Time()
	{
	TAAL_TIME time;
	time.dwAll = 0;

	DWORD flags = CLI();

	do	{ // Comprovem que la CMOS no estigui actualitzant el rellotge
		Kernel->OutByte( CMOSControl, RTC_FREQ_SELECT );
		} while( Kernel->InByte( CMOSData ) & RTC_UIP );

	Kernel->OutByte( CMOSControl, RTC_HOURS ); // Obtenim l'hora
	time.Parts.cHour = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_MINUTES ); // Obtenim els minuts
	time.Parts.cMinute = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_SECONDS ); // Obtenim els segons
	time.Parts.cSecond = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_CONTROL ); // Si el rellotge s de 12hr.
	if( !(Kernel->InByte( CMOSData ) & RTC_24H) && time.Parts.cHour & 0x80 )
		time.Parts.cHour = (BYTE) ((time.Parts.cHour & 0x7f) + 12); // Transformem l'hora a 24hr.

	Kernel->OutByte( CMOSControl, RTC_CONTROL ); // Si les dades es guarden en BCD
	if( !(Kernel->InByte( CMOSData ) & RTC_DM_BINARY) )
		{
		time.Parts.cHour = BCD_TO_BIN( time.Parts.cHour ); // Transformem BCD a binari pur
		time.Parts.cMinute = BCD_TO_BIN( time.Parts.cMinute );
		time.Parts.cSecond = BCD_TO_BIN( time.Parts.cSecond );
		}

	STI( flags );

	return time;
	}

// **************************************************************************
// Retorna la data de la CMOS
TAAL_DATE CCMOS::Date()
	{
	TAAL_DATE date;
	date.dwAll = 0;

	DWORD flags = CLI();

	Kernel->OutByte( CMOSControl, RTC_YEAR ); // Obtenim l'any (2 dgits)
	date.Parts.wYear = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, 0x32 ); // Obtenim el segle (en realitat sn els 2 dgits superiors)
	BYTE cCentury = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_MONTH ); // Obtenim el mes
	date.Parts.cMonth = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_DAY_OF_MONTH ); // Obtenim el dia
	date.Parts.cDay = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_DAY_OF_WEEK ); // Obtenim el dia de la setmana
	date.Parts.cDayOfWeek = Kernel->InByte( CMOSData );

	Kernel->OutByte( CMOSControl, RTC_CONTROL ); // Si les dades es guarden en BCD
	if( !(Kernel->InByte( CMOSData ) & RTC_DM_BINARY) )
		{
		date.Parts.cMonth = BCD_TO_BIN( date.Parts.cMonth ); // Fem la transformaci
		date.Parts.cDay = BCD_TO_BIN( date.Parts.cDay );
		date.Parts.cDayOfWeek = BCD_TO_BIN( date.Parts.cDayOfWeek );
		date.Parts.wYear = (WORD) BCD_TO_BIN( date.Parts.wYear );
		date.Parts.wYear += (WORD) (BCD_TO_BIN( cCentury ) * 100); // Afegim el segle
		}
	else
		date.Parts.wYear += (WORD) (cCentury * 100); // Afegim el segle

	STI( flags );

	return date;
	}

// **************************************************************************
// Posa l'hora a la CMOS
// Com a entrada ha de rebre:
// Time	- Estructura amb l'hora, minuts i segons
VOID CCMOS::Time( TAAL_TIME time )
	{
	DWORD flags = CLI();

	Kernel->OutByte( CMOSControl, RTC_CONTROL ); // Si les dades es guarden en BCD
	if( !(Kernel->InByte( CMOSData ) & RTC_DM_BINARY) )
		{
		Kernel->OutByte( CMOSControl, RTC_HOURS ); // Posem l'hora
		Kernel->OutByte( CMOSData, BIN_TO_BCD( time.Parts.cHour ) );

		Kernel->OutByte( CMOSControl, RTC_MINUTES ); // Els minuts
		Kernel->OutByte( CMOSData, BIN_TO_BCD( time.Parts.cMinute ) );

		Kernel->OutByte( CMOSControl, RTC_SECONDS ); // Els segons
		Kernel->OutByte( CMOSData, BIN_TO_BCD( time.Parts.cSecond ) );
		}
	else // Les dades es guarden en binari pur
		{
		Kernel->OutByte( CMOSControl, RTC_HOURS ); // Posem l'hora
		Kernel->OutByte( CMOSData, time.Parts.cHour );

		Kernel->OutByte( CMOSControl, RTC_MINUTES ); // Els minuts
		Kernel->OutByte( CMOSData, time.Parts.cMinute );

		Kernel->OutByte( CMOSControl, RTC_SECONDS ); // Els segons
		Kernel->OutByte( CMOSData, time.Parts.cSecond );
		}

	STI( flags );
	}

// **************************************************************************
// Posa la data a la CMOS
// Com a entrada ha de rebre:
// Date	- Estructura amb el dia de la setmana, dia, mes i any
VOID CCMOS::Date( TAAL_DATE date )
	{
	DWORD flags = CLI();
// Segle -BUG
	Kernel->OutByte( CMOSControl, RTC_CONTROL ); // Si les dades es guarden en BCD
	if( !(Kernel->InByte( CMOSData ) & RTC_DM_BINARY) )
		{
		Kernel->OutByte( CMOSControl, RTC_YEAR ); // Any
		Kernel->OutByte( CMOSData, BIN_TO_BCD( date.Parts.wYear ) );

		Kernel->OutByte( CMOSControl, RTC_MONTH ); // Mes
		Kernel->OutByte( CMOSData, BIN_TO_BCD( date.Parts.cMonth ) );

		Kernel->OutByte( CMOSControl, RTC_DAY_OF_MONTH ); // Dia
		Kernel->OutByte( CMOSData, BIN_TO_BCD( date.Parts.cDay ) );

		Kernel->OutByte( CMOSControl, RTC_DAY_OF_WEEK ); // Dia de la setmana -BUG
		Kernel->OutByte( CMOSData, BIN_TO_BCD( date.Parts.cDayOfWeek ) );
		}
	else // Les dades es guarden en binari pur
		{
		Kernel->OutByte( CMOSControl, RTC_YEAR ); // Any
		Kernel->OutByte( CMOSData, date.Parts.wYear );

		Kernel->OutByte( CMOSControl, RTC_MONTH ); // Mes
		Kernel->OutByte( CMOSData, date.Parts.cMonth );

		Kernel->OutByte( CMOSControl, RTC_DAY_OF_MONTH ); // Dia
		Kernel->OutByte( CMOSData, date.Parts.cDay );

		Kernel->OutByte( CMOSControl, RTC_DAY_OF_WEEK ); // Dia de la setmana -BUG
		Kernel->OutByte( CMOSData, date.Parts.cDayOfWeek );
		}

	STI( flags );
	}

