/* **************************************************************************
*                                                                           *
*  DMA.CPP                                                                  *
*                                                                           *
*  10-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Manipulaci del xip Direct Memory Access                                 *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "aal\dma.h"
#include "kernel\kernel.h"

extern PCkeKernel _import Kernel;
DWORD _import CLI();
VOID _import STI( DWORD );

// **************************************************************************
// Constructor de la classe
CDMA::CDMA() : CkeType( CID_DMA )
	{
	// Tots els canals lliures
	for( BYTE cChannel = 0; cChannel < DMA_CHANNELS; cChannel++ )
		ReservedChannel[ cChannel ] = NULL;

	Kernel->OutByte( DMA1StatCmd, 4 );	// Inhibim el 'master'
	Kernel->OutByte( DMA2StatCmd, 4 );

	Kernel->OutByte( DMA1Clear, 0 );	 	// Reinicialitzem el 'master'
	Kernel->OutByte( DMA2Clear, 0 );

	Kernel->OutByte( DMA1StatCmd, 0 );	// Totes les comandes per defecte
	Kernel->OutByte( DMA2StatCmd, 0 );

	Kernel->OutByte( DMA1Mode, 0x40 );	// Canal 0 DMA 1
	Kernel->OutByte( DMA2Mode, 0xC0 );	// Canal 0 DMA 2 'Cascade Mode'

	Kernel->OutByte( DMA1Mode, 0x41 );	// Canal 1 DMA 1 i 2
	Kernel->OutByte( DMA2Mode, 0x41 );

	Kernel->OutByte( DMA1Mode, 0x42 );	// Canal 2 DMA 1 i 2
	Kernel->OutByte( DMA2Mode, 0x42 );

	Kernel->OutByte( DMA1Mode, 0x43 );	// Canal 3 DMA 1 i 2
	Kernel->OutByte( DMA2Mode, 0x43 );

	Kernel->OutByte( DMA1ClrMode, 0 );	// Activem tots els canals de DMA 1
	Kernel->OutByte( DMA2ClrMode, 0 );	// Activem tots els canals de DMA 2
	}

// **************************************************************************
// Destructor de la classe
CDMA::~CDMA()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CDMA::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_DMA )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Reserva un canal a un procs
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal que es vol reservar
// Process  	- Procs que demana el canal
VOID CDMA::ReserveChannel( BYTE cChannel, PCkeProcess pProcess )
	{
// control d'errors -BUG
	if( cChannel < DMA_CHANNELS ) // El canal ha de ser vlid
		{
		if( ReservedChannel[ cChannel ] == NULL ) // I tamb ha d'estar lliure
			ReservedChannel[ cChannel ] = pProcess; // Ja el podem reservar
		}
	}

// **************************************************************************
// Allibera un canal
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Process  	- Procs que vol alliberar el canal
VOID CDMA::FreeChannel( BYTE cChannel, PCkeProcess pProcess )
	{
// control d'errors -BUG
	if( cChannel < DMA_CHANNELS )
		{
		if( ReservedChannel[ cChannel ] == pProcess ) // L'ha d'haver reservat ell mateix
			ReservedChannel[ cChannel ] = NULL; // L'allibera
		}
	}

// **************************************************************************
// Inicia la transferncia de dades
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Process  	- Procs que demana la transferncia
// Mode     	- Mode de transferncia (no autoinit, single mode, ...)
// Type     	- Tipus de transferncia (IN, OUT, VERIFY)
// Address  	- Adrea fsica de memria per a la transferncia
// Size     	- Nombre de 'bytes' a transferir
VOID CDMA::TransferData( BYTE cChannel, PCkeProcess pProcess, BYTE cMode, BYTE cType, DWORD dwAddress, DWORD dwSize )
	{
// control d'errors -BUG
	if( cChannel < DMA_CHANNELS ) // El canal ha de ser correcte
		{
		if( ReservedChannel[ cChannel ] == pProcess ) // Tamb ha d'estar reservat pel procs que vol realitzar la transferncia
			{
			if( cMode < 4 ) // El mode ha de ser correcte
				{
				BYTE cValue = (BYTE) (cMode << 6); // Preparem el valor a enviar al controlador

				if( cType == 1 ) // 'In'?
					cValue |= (BYTE) 4;
				else if( cType == 2 )
					cValue |= (BYTE) 8;

				DWORD flags = CLI();

				if( cChannel < 4 ) // Enviem el valor al controlador adient
					Kernel->OutByte( DMA1RCmdWbm, (BYTE) (4 | cChannel) ); // Posem mscara per a DRQ
				else
					Kernel->OutByte( DMA2RCmdWbm, (BYTE) (4 | (cChannel - 4)) );

				SetMode( cChannel, cValue ); // Seleccionem el mode
				ClearFlipFlop( cChannel ); // Inicialitzem el 'flip flop'
				SetAddress( cChannel, dwAddress ); // Seleccionem l'adrea
				SetCount( cChannel, dwSize ); // Indiquem el tamany

				if( cChannel < 4 )
					Kernel->OutByte( DMA1RCmdWbm, (BYTE) cChannel ); // Esborrem mscara per a DRQ
				else
					Kernel->OutByte( DMA2RCmdWbm, (BYTE) (cChannel - 4) );

				STI( flags );
				}
			}
		}
	}

// **************************************************************************
// Activa un canal DMA especfic
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
VOID CDMA::Enable( BYTE cChannel )
	{
	if( cChannel <= 3 ) // Primer DMA
		Kernel->OutByte( DMA1MskBts, cChannel );
	else // Segon DMA
		Kernel->OutByte( DMA2MskBts, (BYTE) (cChannel & 3) );
	}

// **************************************************************************
// Desactiva un canal DMA especfic
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
VOID CDMA::Disable( BYTE cChannel )
	{
	if( cChannel <= 3 ) // Primer DMA
		Kernel->OutByte( DMA1MskBts, (BYTE) (cChannel | 4) );
	else // Segon DMA
		Kernel->OutByte( DMA2MskBts, (BYTE) ((cChannel & 3) | 4) );
	}

// **************************************************************************
// Esborra el 'flip flop' del DMA
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
VOID CDMA::ClearFlipFlop( BYTE cChannel )
	{
	if( cChannel <= 3 ) // Primer DMA
		Kernel->OutByte( DMA1FF, 0 );
	else // Segon DMA
		Kernel->OutByte( DMA2FF, 0 );
	}

// **************************************************************************
// Selecciona el mode per a un canal DMA especfic
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Mode     	- Mode que es vol seleccionar
VOID CDMA::SetMode( BYTE cChannel, BYTE cMode )
	{
	if( cChannel <= 3 ) // Primer DMA
		Kernel->OutByte( DMA1Mode, cMode | cChannel );
	else // Segon DMA
		Kernel->OutByte( DMA2Mode, (BYTE) (cMode | (cChannel & 3)) );
	}

// **************************************************************************
// Selecciona el registre de pgina
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Page     	- Pgina que es vol seleccionar
VOID CDMA::SetPage( BYTE cChannel, BYTE cPage )
	{
	switch( cChannel )
		{
		case 0: // De 64KB. en 64KB.
			Kernel->OutByte( DMAPage0, cPage );
			break;
		case 1:
			Kernel->OutByte( DMAPage1, cPage );
			break;
		case 2:
			Kernel->OutByte( DMAPage2, cPage );
			break;
		case 3:
			Kernel->OutByte( DMAPage3, cPage );
			break;
		case 5: // De 128KB. en 128KB.
			Kernel->OutByte( DMAPage5, (BYTE) (cPage & 0xfe) );
			break;
		case 6:
			Kernel->OutByte( DMAPage6, (BYTE) (cPage & 0xfe) );
			break;
		case 7:
			Kernel->OutByte( DMAPage7, (BYTE) (cPage & 0xfe) );
			break;
		}
	}

// **************************************************************************
// Selecciona l'adrea fsica per a una transferncia
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Addr     	- Adrea fsica
VOID CDMA::SetAddress( BYTE cChannel, DWORD dwAddr )
	{
	SetPage( cChannel, (BYTE) (dwAddr >> 16) ); // Seleccionem la part superior de l'adrea

	if( cChannel <= 3 )
		{ // Part inferior de l'adrea (de 128 KB. en 128KB.)
		Kernel->OutByte( (WORD) (((cChannel & 3) << 1) + IO_DMA1_BASE), (BYTE) (dwAddr & 0xff) );
		Kernel->OutByte( (WORD) (((cChannel & 3) << 1) + IO_DMA1_BASE), (BYTE) ((dwAddr >> 8) & 0xff) );
		}
	else
		{ // Part inferior de l'adrea (de 128KB. en 128KB.)
		Kernel->OutByte( (WORD) (((cChannel & 3) << 2) + IO_DMA2_BASE), (BYTE) ((dwAddr >> 1) & 0xff) );
		Kernel->OutByte( (WORD) (((cChannel & 3) << 2) + IO_DMA2_BASE), (BYTE) ((dwAddr >> 9) & 0xff) );
		}
	}

// **************************************************************************
// Selecciona el nombre de 'bytes' a transferir
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
// Count    	- Nombre de 'bytes'
VOID CDMA::SetCount( BYTE cChannel, DWORD dwCount )
	{
	dwCount--; // Comptem el zero

	if( cChannel <= 3 )
		{ // Primer DMA
		Kernel->OutByte( (WORD) (((cChannel & 3) << 1) + 1 + IO_DMA1_BASE), (BYTE) (dwCount & 0xff) );
		Kernel->OutByte( (WORD) (((cChannel & 3) << 1) + 1 + IO_DMA1_BASE), (BYTE) ((dwCount >> 8) & 0xff) );
		}
	else
		{ // Segon DMA (compte en 'words')
		Kernel->OutByte( (WORD) (((cChannel & 3) << 2) + 2 + IO_DMA2_BASE), (BYTE) ((dwCount >> 1) & 0xff) );
		Kernel->OutByte( (WORD) (((cChannel & 3) << 2) + 2 + IO_DMA2_BASE), (BYTE) ((dwCount >> 9) & 0xff) );
		}
	}

// **************************************************************************
// Obt el residu per a un canal DMA especfic
// Com a entrada ha de rebre:
// Channel  	- Identificador del canal
DWORD CDMA::GetResidue( BYTE cChannel )
	{
	// Calculem el port
	WORD io_port = ((cChannel <= 3) ? (WORD) (((cChannel & 3) << 1) + 1 + IO_DMA1_BASE)
			: (WORD) (((cChannel & 3) << 2) + 2 + IO_DMA2_BASE));

	WORD wCount;
	// Obtenim el compte
	wCount = (WORD) (1 + Kernel->InByte( io_port ));
	wCount += (WORD) (Kernel->InByte( io_port ) << 8);

	// Retornem el compte sempre en 'bytes'
	return (cChannel <= 3) ? wCount : (wCount << 1);
	}

