/* **************************************************************************
*                                                                           *
*  Interrup.CPP                                                             *
*                                                                           *
*  18-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Architecture Abstraction Library Interrupts                              *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "aal\interrup.h"
#include "kernel\kernel.h"
#include "errors.h"
#include "aal\aal.h"
#include "aal\asm.h"
#include "kernel\system.h"

extern PCkeKernel _import Kernel;
extern DWORD _import Mode;

// **************************************************************************
// Interrupci 'hardware' no gestionada per cap procs
// Com a entrada ha de rebre:
// Int      	- Identificador de la interrupci
VOID UnhandledInterrupt( BYTE cInt )
	{
	(System->Console())->OutText( TEXT( "Unhandled" ) ); // Missatge d'error

	(System->AAL())->EOI( cInt );
	}

// **************************************************************************
// Interrupci del rellotge (cada 10 ms.)
VOID TimerTick()
	{
	Kernel->TimerTick( 10, (BOOL) Mode ); // Passem al 'Kernel'
//	EOI realitzat per el 'Kernel'
	}

