/* **************************************************************************
*                                                                           *
*  Video.CPP                                                                *
*                                                                           *
*  11-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de video de l'Akula                                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\char\private\video.h"
#include "sys\sys.h"
#include "string.h"
#include "sys\asm.h"
#include "kernel\boxdef.h"
#include "sys\console.h"
#include "kernel\kernel.h"
#include "drivers\messages.h"
#include "sys\timer.h"
#include "aal\aal.h"
#include "kernel\system.h"
#include "errors.h"

// *********************************** DEFINES
#define VIDEO_LOG						0xB8000
#define VIDEO_PHYS					0xB8000

#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	1

#define DRIVER_LEVEL		0

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
PCsysModule SYSModule = NULL; 	// Per a la comunicaci amb el nivell sistema
PCsysConsole pcons;		 			// Per al missatge de presentaci i depuraci
PCVideo pcurrent = NULL;			// Pantalla virtual activa

BOOL DispatchMessage( TMSG& );

// *********************************** FUNCIONS
void main()
	{
	CHAR str[ 80 ];

	SYSModule = new CsysModule; // Ens preparem per a comunicar-nos amb SYS.EXE

	PTDriver driver = (PTDriver) malloc( sizeof( TDriver ) );
	driver->cLevel = DRIVER_LEVEL; // Preparem l'estructura de registre
	SYSModule->RegisterDriver( driver ); // Registrem el controlador

	pcons = new CsysConsole; // Preparem la pantalla de depuraci

	sprintf( str, TEXT( "Video  Driver ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( DRIVER_DIR );

	if( !pparent )
		{
		pcons->OutText( TEXT( "VIDEO - Error: no pot accedir a DRIVER_DIR\r\n" ) );
		while( 1 )
			{}
		}

	CsysMailBox box( pparent, nVIDEO_MAILBOX ); // Preparem la nostra bstia

	Kernel->OutByte( CRTCPort1, CRTCAddHi ); // Enviem el cursor a 0,0
	Kernel->OutByte( CRTCPort2, 0 );
	Kernel->OutByte( CRTCPort1, CRTCAddLo );
	Kernel->OutByte( CRTCPort2, 0 );

	TMSG msg;

	SYSModule->DriverReady(); // Indiquem al sistema que ja estem preparats

	while( 1 )
		{
		box.WaitMessage( &msg ); // Esperem i tractem peticions
		DispatchMessage( msg );
		}
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador de video
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
BOOL DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Mapegem l'espai d'adreces del flux que fa la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case DRV_CREATEINSTANCE_VID:
			{
			msg.dwParam1 = (DWORD) new CVideo();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_DESTROYINSTANCE_VID:
			{
			sprintf( str, TEXT( "Rebut DestroyInstance (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			delete( (PCVideo) msg.dwParam1 );

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GOTOXY_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->GotoXY( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff) );
			}
			break;

		case DRV_CLEAR_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->Clear();
			}
			break;

		case DRV_OUTTEXT_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->OutText( (PSTR) msg.dwParam2 );

			free( (PVOID) msg.dwParam2 );
			}
			break;

		case DRV_GETCHAR_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetChar( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff) );

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETCHAR_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->SetChar( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff), (BYTE) ((msg.dwParam2 >> 16) & 0xff) );
			}
			break;

		case DRV_GETATTRIBUTE_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetAttribute( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff) );

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETATTRIBUTE_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->SetAttribute( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff), (BYTE) ((msg.dwParam2 >> 16) & 0xff) );
			}
			break;

		case DRV_GETCOLOR_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetColor();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETCOLOR_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->SetColor( (BYTE) (msg.dwParam2 & 0xff) );
			}
			break;

		case DRV_GETBKCOLOR_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetBkColor();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETBKCOLOR_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->SetBkColor( (BYTE) (msg.dwParam2 & 0xff) );
			}
			break;

		case DRV_GETX_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetX();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETY_VID:
			{
			msg.dwParam1 = ((PCVideo) msg.dwParam1)->GetY();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_ACTIVATE_VID:
			{ // Missatge assncron
			if( msg.dwParam1 != (DWORD) pcurrent )
				{
				if( pcurrent )
					pcurrent->Deactivate();

				pcurrent = (PCVideo) msg.dwParam1;
				pcurrent->Activate();
				}
			}
			break;

		case DRV_SETCARET_VID:
			{ // Missatge assncron
			((PCVideo) msg.dwParam1)->SetCaret( (BOOL) msg.dwParam2 );
			}
			break;

		default:
			sprintf( str, TEXT( "VIDEO.DRV - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostra espai d'adreces

	return FALSE; // Sempre retornem FALSE
	}

// **************************************************************************
// Constructor de la classe
CVideo::CVideo() : CkeType( CID_VideoDriver )
	{
	bshowcaret	= TRUE;				// Per defecte, hi ha cursor
	cattribute	= LIGHTGRAY;		// Per defecte, gris sobre negre
	pscreen		= (PWORD) buffer;	// Pantalla virtual
	Clear();								// Esborrem la pantalla

	if( !pcurrent ) // Si no hi ha cap pantall activa, copiem el contingut de la pantalla fsica a la pantalla virtual
		Kernel->MemCopy( (PBYTE) VGA_BUFFER, (PBYTE) buffer, DISPLAY_SIZE * 2 );
	}

// **************************************************************************
// Destructor de la classe
CVideo::~CVideo()
	{
	}

// **************************************************************************
// Activem la pantalla virtual (passa a ser la pantalla fsica)
VOID CVideo::Activate()
	{
	// Copiem el contingut de la pantalla virtual a la fsica
	Kernel->MemCopy( (PBYTE) buffer, (PBYTE) VGA_BUFFER, DISPLAY_SIZE * 2 );
	pscreen = (PWORD) VGA_BUFFER; // A partir d'ara, les referncies sn cap a la pantalla fsica
	GotoXY( cposx, cposy ); // Movem el cursor a la posici adient
	}

// **************************************************************************
// Desactivem la pantalla virtual (deixa de ser la pantalla fsica)
VOID CVideo::Deactivate()
	{
	// Copiem el contingut de la pantalla fsica a la virtual
	Kernel->MemCopy( (PBYTE) VGA_BUFFER, (PBYTE) buffer, DISPLAY_SIZE * 2 );
	pscreen = (PWORD) buffer; // A partir d'ara, les referncies sn cap a la pantalla virtual
	}

// **************************************************************************
// Mou el cursor lgic (i si cal, el fsic) a una certa posici de la pantalla
// Com a entrada ha de rebre:
// X        	- Columna
// Y        	- Fila
VOID CVideo::GotoXY( BYTE X, BYTE Y )
	{
	cposx = X; // Canviem la posici del cursor lgic
	cposy = Y;

	if( pcurrent == this && bshowcaret ) // Si s la pantalla activa i t cursor
		{ // Canviem la posici del cursor fsic
		WORD pos = (WORD) (X + (Y * WIDE));

		Kernel->OutByte( CRTCPort1, CRTCCurLo );
		Kernel->OutByte( CRTCPort2, (BYTE) (pos & 0xff) );
		Kernel->OutByte( CRTCPort1, CRTCCurHi );
		Kernel->OutByte( CRTCPort2, (BYTE) (pos >> 8) );
		}
	}

// **************************************************************************
// Retorna la columna actual del cursor
BYTE CVideo::GetX()
	{
	return cposx;
	}

// **************************************************************************
// Retorna la fila actual del cursor
BYTE CVideo::GetY()
	{
	return cposy;
	}

// **************************************************************************
// Esborra la pantalla virtual amb l'atribut actual
VOID CVideo::Clear()
	{
	for( DWORD pos = 0; pos < DISPLAY_SIZE; pos++ )
			pscreen[ pos ] = (WORD) (cattribute << 8);

	GotoXY( 0, 0 ); // Passem a la posici 0,0
	}

// **************************************************************************
// Presenta una cadena de carcters en la pantalla virtual
// Com a entrada ha de rebre:
// str      	- Cadena de carcters
VOID CVideo::OutText( PSTR str )
	{
	while( *str ) // Per a tota la cadena
		{
		switch( *str )
			{
			case '\r': // Retorn de carro
				cposx = 0;
				break;

			case '\n': // Nova lnia
				cposy++;
				break;

			default: // Qualsevol altre carcter
				pscreen[ cposx + cposy * WIDE ] = (WORD) (*str |(cattribute << 8));
				cposx++;
				break;
			}

		str++;

		if( cposx >= WIDE ) // Controlem la columna
				{
				cposx = 0;
				cposy++;
				}

		if( cposy >= HEIGHT ) // Controlem la fila
				{
				PWORD copia = pscreen;
				WORD pos;

				// Passem la pantalla una lnia amunt
				for( pos = 0; pos < WIDE * (HEIGHT - 1); pos++ )
					pscreen[ pos ] = copia[ pos + WIDE ];
				// Nova lnia per sota amb l'atribut actual
				for( pos = WIDE * (HEIGHT - 1); pos < DISPLAY_SIZE; pos++ )
					pscreen[ pos ] = (WORD) (cattribute << 8);

				cposy = HEIGHT - 1;
				}
		}

	GotoXY( cposx, cposy ); // Canviem la posici del cursor
	}

// **************************************************************************
// Obt el carcter que est en una posici concreta de la pantalla virtual
// Com a entrada ha de rebre:
// X        	- Columna
// Y        	- Fila
CHAR CVideo::GetChar( BYTE X, BYTE Y )
	{
	return (CHAR) (pscreen[ X + Y * WIDE ] & 0xff);
	}

// **************************************************************************
// Selecciona el carcter d'una posici concreta de la pantalla virtual
// Com a entrada ha de rebre:
// X        	- Columna
// Y        	- Fila
// Character	- Nou carcter
VOID CVideo::SetChar( BYTE X, BYTE Y, CHAR cCharacter )
	{
	pscreen[ X + Y * WIDE ] = (WORD) ((pscreen[ X + Y * WIDE ] & 0xff00) | cCharacter);
	}

// **************************************************************************
// Retorna l'atribut d'una posici concreta de la pantalla virtual
// Com a entrada ha de rebre:
// X        	- Columna
// Y        	- Fila
BYTE CVideo::GetAttribute( BYTE X, BYTE Y )
	{
	return (BYTE) (pscreen[ X + Y * WIDE ] >> 8);
	}

// **************************************************************************
// Selecciona l'atribut (color) d'una posici concreta de la pantalla virtual
// Com a entrada ha de rebre:
// X        	- Columna
// Y        	- Fila
// Attribute	- Color nou
VOID CVideo::SetAttribute( BYTE X, BYTE Y, BYTE cAttribute )
	{
	pscreen[ X + Y * WIDE ] = (WORD) ((pscreen[ X + Y * WIDE ] & 0xff) | (cAttribute << 8));
	}

// **************************************************************************
// Obt el color principal que s'est utilitzant
BYTE CVideo::GetColor()
	{
	return (BYTE) (cattribute & 0x0f);
	}

// **************************************************************************
// Obt el color de fons que s'est utilitzant
BYTE CVideo::GetBkColor()
	{
	return (BYTE) (cattribute >> 4);
	}

// **************************************************************************
// Selecciona el nou color principal
// Com a entrada ha de rebre:
// Color    	- Codi del color principal
VOID CVideo::SetColor( BYTE cColor )
	{
	cattribute = (BYTE) ((cattribute & 0xf0) | cColor);
	}

// **************************************************************************
// Selecciona el nou color de fons
// Com a entrada ha de rebre:
// Color    	- Codi del color a aplicar com a fons
VOID CVideo::SetBkColor( BYTE cColor )
	{
	cattribute = (BYTE) ((cattribute & 0x0f) | (cColor << 4));
	}

// **************************************************************************
// Selecciona el nou estat per al cursor
// Com a entrada ha de rebre:
// Show     	- Indica si hi ha d'haver cursor o no
VOID CVideo::SetCaret( BOOL bShow )
	{
	bshowcaret = bShow;
	GotoXY( cposx, cposy );
	}

