/* **************************************************************************
*                                                                           *
*  FCB.CPP                                                                  *
*                                                                           *
*  25-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control de fitxers globals                        *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\private\fcb.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// FileSize 	- Tamany del fitxer
// DirBlock 	- Bloc que cont la seva entrada de directori
// DirEntry 	- Desplaament cap a l'entrada de directori
// FirstBlock	- Primer bloc del fitxer
// FileSystem	- Sistema de fitxers que controla el fitxer
// Name      	- Nom del fitxer
// SharedMode	- Mode de compartici per al fitxer
CGlobalFile::CGlobalFile( DWORD dwFileSize, DWORD dwDirBlock, DWORD dwDirEntry, DWORD dwFirstBlock, PCFileSystem pFileSystem, PSTR sName, BYTE )
	{
	dwfilesize 		= dwFileSize;
	dwdirblock		= dwDirBlock;
	dwdirentry		= dwDirEntry;
	dwfirstblock	= dwFirstBlock;
	pfs 				= pFileSystem;
	sname 			= sName;
	}

// **************************************************************************
// Destructor de la classe
CGlobalFile::~CGlobalFile()
	{
	}

// **************************************************************************
// Bloqueja una zona del fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// Position 	- Posici del fitxer on comena la zona
// Size     	- Nombre de 'bytes' de la zona
// Mode     	- Mode del bloqueig
VOID CGlobalFile::Lock( PCkeProcess pProc, DWORD dwPosition, DWORD dwSize, DWORD )
	{
// Comprovar que no existeixi i no es solapi -BUG
	PCLock pitem = pfilelocks;
	BOOL bFound = FALSE;

	while( pitem && !bFound )
		{
		if( pitem->Position() <= dwPosition && pitem->Position() + pitem->Size() >= dwPosition )
			bFound = TRUE;

		if( pitem->Position() > dwPosition && pitem->Position() < dwPosition + dwSize )
			bFound = TRUE;

		pitem = (PCLock) pitem->GetNext();
		}

	if( bFound )
		{
		// Error -BUG
		return;
		}

	PCLock pfirst;

	pfirst = new CLock( this, pProc, dwPosition, dwSize );

	pfirst->SetPrev( NULL );
	pfirst->SetNext( pfilelocks );
	pfilelocks->SetPrev( pfirst );
	pfilelocks = pfirst;
	}

// **************************************************************************
// Desbloqueja una zona del fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// Position 	- Posici del fitxer on comena la zona
// Size     	- Nombre de 'bytes' de la zona
VOID CGlobalFile::Unlock( PCkeProcess pProc, DWORD dwPosition, DWORD dwSize )
	{
// Cercar el 'lock' i esborrar-lo
	PCLock pitem = pfilelocks;

	while( pitem && pitem->Position() != dwPosition )
		pitem = (PCLock) pitem->GetNext();

	if( pitem && pitem->Process() == pProc && pitem->Size() == dwSize )
		delete( pitem );
//	else
		// Error -BUG
	}

// **************************************************************************
// Llegeix dades des del fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// Buffer   	- Posici de memria des d'on comencem a escriure
// Bytes    	- Nombre de 'bytes' a llegir
DWORD CGlobalFile::Read( PCkeProcess pProc, DWORD dwPos, PVOID pAddress, DWORD dwSize )
	{
	return pfs->ReadFile( pProc, this, dwPos, (DWORD) pAddress, dwSize );
	}

// **************************************************************************
// Escriu dades en el fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// Buffer   	- Posici de memria des d'on comencem a llegir
// Bytes    	- Nombre de 'bytes' a escriure
DWORD CGlobalFile::Write( PCkeProcess pProc, DWORD dwPos, PVOID pAddress, DWORD dwSize )
	{
	return pfs->WriteFile( pProc, this, dwPos, (DWORD) pAddress, dwSize );
	}

// **************************************************************************
// Escriu els canvis en el fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
VOID CGlobalFile::Flush( PCkeProcess pProc )
	{
	pfs->FlushFile( pProc, this );
	}

// **************************************************************************
// Obt l'hora de creaci
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CGlobalFile::GetCreationTime( PTFILETIME pTime )
	{
	pfs->GetCreationTime( this, pTime );
	}

// **************************************************************************
// Obt l'hora d'ltim accs
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CGlobalFile::GetLastAccessTime( PTFILETIME pTime )
	{
	pfs->GetLastAccessTime( this, pTime );
	}

// **************************************************************************
// Obt l'hora d'ltima escriptura
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CGlobalFile::GetLastWriteTime( PTFILETIME pTime )
	{
	pfs->GetLastWriteTime( this, pTime );
	}

// **************************************************************************
// Obt la data de creaci
// Com a entrada ha de rebre:
// Date     	- Data
VOID CGlobalFile::GetCreationDate( PTFILEDATE pDate )
	{
	pfs->GetCreationDate( this, pDate );
	}

// **************************************************************************
// Obt la data d'ltim accs
// Com a entrada ha de rebre:
// Date     	- Data
VOID CGlobalFile::GetLastAccessDate( PTFILEDATE pDate )
	{
	pfs->GetLastAccessDate( this, pDate );
	}

// **************************************************************************
// Obt la data d'ltima escriptura
// Com a entrada ha de rebre:
// Date     	- Data
VOID CGlobalFile::GetLastWriteDate( PTFILEDATE pDate )
	{
	pfs->GetLastWriteDate( this, pDate );
	}

// **************************************************************************
// Canvia l'hora de creaci
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CGlobalFile::SetCreationTime( PTFILETIME pTime )
	{
	pfs->SetCreationTime( this, pTime );
	}

// **************************************************************************
// Canvia l'hora d'ltim accs
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CGlobalFile::SetLastAccessTime( PTFILETIME pTime )
	{
	pfs->SetLastAccessTime( this, pTime );
	}

// **************************************************************************
// Canvia l'hora de l'ltima escriptura
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CGlobalFile::SetLastWriteTime( PTFILETIME pTime )
	{
	pfs->SetLastWriteTime( this, pTime );
	}

// **************************************************************************
// Canvia la data de creaci
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CGlobalFile::SetCreationDate( PTFILEDATE pDate )
	{
	pfs->SetCreationDate( this, pDate );
	}

// **************************************************************************
// Canvia la data de l'ltim accs
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CGlobalFile::SetLastAccessDate( PTFILEDATE pDate )
	{
	pfs->SetLastAccessDate( this, pDate );
	}

// **************************************************************************
// Canvia la data de l'ltima escriptura
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CGlobalFile::SetLastWriteDate( PTFILEDATE pDate )
	{
	pfs->SetLastWriteDate( this, pDate );
	}

// **************************************************************************
// Consulta els atributs del fitxer
DWORD CGlobalFile::GetAttributes( PCkeProcess pProc )
	{
	return pfs->GetAttributes( pProc, this );
	}

// **************************************************************************
// Canvia els atributs al fitxer
// Com a entrada ha de rebre:
// Attributes	- Nous atributs per al fitxer
VOID CGlobalFile::SetAttributes( PCkeProcess pProc, DWORD dwAttributes )
	{
	pfs->SetAttributes( pProc, this, dwAttributes );
	}

// **************************************************************************
// Retorna el bloc on comena el fitxer
DWORD CGlobalFile::FirstBlock()
	{
	return dwfirstblock;
	}

// **************************************************************************
// Retorna el bloc on es troba la seva entrada de directori
DWORD CGlobalFile::DirectoryBlock()
	{
	return dwdirblock;
	}

// **************************************************************************
// Retorna el desplaament cap a la seva entrada de directori
DWORD CGlobalFile::DirectoryEntry()
	{
	return dwdirentry;
	}

// **************************************************************************
// Retorna el tamany del fitxer (en 'bytes')
DWORD CGlobalFile::FileSize()
	{
	return dwfilesize;
	}

