/* **************************************************************************
*                                                                           *
*  FUB.CPP                                                                  *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control de fitxers d'usuari                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\private\fub.h"
#include "sys\grantedr.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Proc     	- Procs que gestiona l'objecte fitxer
// FCB      	- Objecte FCB relacionat amb el fitxer
// Rights   	- Drets del procs sobre el fitxer
CUserFile::CUserFile( PCkeProcess pProc, PCGlobalFile pFCB, BYTE cRights )
	{
	pproc			= pProc;
	pfcb			= pFCB;
	dwposition	= 0L;
	prights		= new CsysGrantedRights();

	switch( cRights )
		{
		case READONLY:
			prights->Read();
			break;

		case WRITEONLY:
			prights->Write();
			break;

		case READWRITE:
			prights->Read();
			prights->Write();
			break;
		}
	}

// **************************************************************************
// Destructor de la classe
CUserFile::~CUserFile()
	{
	delete( prights );
	}

// **************************************************************************
// Bloqueja una zona del fitxer
// Com a entrada ha de rebre:
// Position 	- Posici del fitxer on comena la zona
// Size     	- Nombre de 'bytes' de la zona
// Mode     	- Mode del bloqueig
VOID CUserFile::Lock( DWORD dwPosition, DWORD dwSize, DWORD dwMode )
	{
	pfcb->Lock( pproc, dwPosition, dwSize, dwMode );
	}

// **************************************************************************
// Desbloqueja una zona del fitxer
// Com a entrada ha de rebre:
// Position 	- Posici del fitxer on comena la zona
// Size     	- Nombre de 'bytes' de la zona
VOID CUserFile::Unlock( DWORD dwPosition, DWORD dwSize )
	{
	pfcb->Unlock( pproc, dwPosition, dwSize );
	}

// **************************************************************************
// Llegeix dades des del fitxer
// Com a entrada ha de rebre:
// Buffer   	- Posici de memria des d'on comencem a escriure
// Bytes    	- Nombre de 'bytes' a llegir
DWORD CUserFile::Read( PVOID pBuffer, DWORD dwBytes )
	{
	DWORD dwdelta = pfcb->Read( pproc, dwposition, pBuffer, dwBytes );
	dwposition += dwdelta;
	return dwdelta;
	}

// **************************************************************************
// Escriu dades en el fitxer
// Com a entrada ha de rebre:
// Buffer   	- Posici de memria des d'on comencem a llegir
// Bytes    	- Nombre de 'bytes' a escriure
DWORD CUserFile::Write( PVOID pBuffer, DWORD dwBytes )
	{
	DWORD dwdelta = pfcb->Write( pproc, dwposition, pBuffer, dwBytes );
	dwposition += dwdelta;
	return dwdelta;
	}

// **************************************************************************
// Posiciona l'apuntador del fitxer en el lloc especificat
// Com a entrada ha de rebre:
// Bytes    	- Valor en 'bytes' relatiu al segon parmetre
// From     	- Indica des d'on: principi, posici actual o final
DWORD CUserFile::Seek( LONG lBytes, BYTE cFrom )
	{
	BOOL berror = FALSE;

	switch( cFrom )
		{
		case SEEK_SET:
			if( lBytes <= pfcb->FileSize() )
				dwposition = lBytes;
			else
				berror = TRUE;
			break;

		case SEEK_CUR:
			if( lBytes + dwposition <= pfcb->FileSize() )
				dwposition += lBytes;
			else
				berror = TRUE;
			break;

		case SEEK_END:
			if( lBytes > 0 )
				berror = TRUE;
			else
				dwposition = pfcb->FileSize() + lBytes;
			break;
		}

	return dwposition;
	}

// **************************************************************************
// Escriu els canvis en el fitxer
VOID CUserFile::Flush()
	{
	pfcb->Flush( pproc );
	}

// **************************************************************************
// Obt l'hora de creaci
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CUserFile::GetCreationTime( PTFILETIME pTime )
	{
	pfcb->GetCreationTime( pTime );
	}

// **************************************************************************
// Obt l'hora d'ltim accs
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CUserFile::GetLastAccessTime( PTFILETIME pTime )
	{
	pfcb->GetLastAccessTime( pTime );
	}

// **************************************************************************
// Obt l'hora d'ltima escriptura
// Com a entrada ha de rebre:
// Time     	- Hora
VOID CUserFile::GetLastWriteTime( PTFILETIME pTime )
	{
	pfcb->GetLastWriteTime( pTime );
	}

// **************************************************************************
// Obt la data de creaci
// Com a entrada ha de rebre:
// Date     	- Data
VOID CUserFile::GetCreationDate( PTFILEDATE pDate )
	{
	pfcb->GetCreationDate( pDate );
	}

// **************************************************************************
// Obt la data d'ltim accs
// Com a entrada ha de rebre:
// Date     	- Data
VOID CUserFile::GetLastAccessDate( PTFILEDATE pDate )
	{
	pfcb->GetLastAccessDate( pDate );
	}

// **************************************************************************
// Obt la data d'ltima escriptura
// Com a entrada ha de rebre:
// Date     	- Data
VOID CUserFile::GetLastWriteDate( PTFILEDATE pDate )
	{
	pfcb->GetLastWriteDate( pDate );
	}

// **************************************************************************
// Canvia l'hora de creaci
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CUserFile::SetCreationTime( PTFILETIME pTime )
	{
	pfcb->SetCreationTime( pTime );
	}

// **************************************************************************
// Canvia l'hora d'ltim accs
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CUserFile::SetLastAccessTime( PTFILETIME pTime )
	{
	pfcb->SetLastAccessTime( pTime );
	}

// **************************************************************************
// Canvia l'hora de l'ltima escriptura
// Com a entrada ha de rebre:
// Time     	- Nova hora
VOID CUserFile::SetLastWriteTime( PTFILETIME pTime )
	{
	pfcb->SetLastWriteTime( pTime );
	}

// **************************************************************************
// Canvia la data de creaci
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CUserFile::SetCreationDate( PTFILEDATE pDate )
	{
	pfcb->SetCreationDate( pDate );
	}

// **************************************************************************
// Canvia la data de l'ltim accs
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CUserFile::SetLastAccessDate( PTFILEDATE pDate )
	{
	pfcb->SetLastAccessDate( pDate );
	}

// **************************************************************************
// Canvia la data de l'ltima escriptura
// Com a entrada ha de rebre:
// Date     	- Nova data
VOID CUserFile::SetLastWriteDate( PTFILEDATE pDate )
	{
	pfcb->SetLastWriteDate( pDate );
	}

// **************************************************************************
// Consulta els atributs del fitxer
DWORD CUserFile::GetAttributes()
	{
	return pfcb->GetAttributes( pproc );
	}

// **************************************************************************
// Canvia els atributs al fitxer
// Com a entrada ha de rebre:
// Attributes	- Nous atributs per al fitxer
VOID CUserFile::SetAttributes( DWORD dwAttributes )
	{
	pfcb->SetAttributes( pproc, dwAttributes );
	}

