/* **************************************************************************
*                                                                           *
*  Video.CPP                                                                *
*                                                                           *
*  14-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de video de l'Akula                                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\char\video.h"
#include "drivers\messages.h"
#include "kernel\mailbox.h"
#include "kernel\mem.h"
#include "string.h"
#include "kernel\system.h"

#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
extern PCkeSystem _import System;

CdrvVideo::CdrvVideo() : CdrvCharDevice( VIDEO_MAILBOX )
	{
	id = CID_VideoDriver;

	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CREATEINSTANCE_VID;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	pvideoinstance = (PVOID) msg.dwParam1;
	}

CdrvVideo::~CdrvVideo()
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_DESTROYINSTANCE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

VOID CdrvVideo::GotoXY( BYTE X, BYTE Y )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GOTOXY_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

VOID CdrvVideo::Clear()
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CLEAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

VOID CdrvVideo::OutText( PSTR sString )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );
	PSTR str = (PSTR) malloc( strlen( sString )+1 );
	strcpy( str, sString );

	TMSG msg;

	msg.dwMessage	= DRV_OUTTEXT_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) str;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

CHAR CdrvVideo::GetChar( BYTE X, BYTE Y )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETCHAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (CHAR) msg.dwParam1;
	}

VOID CdrvVideo::SetChar( BYTE X, BYTE Y, CHAR cCharacter )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETCHAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8) + (cCharacter << 16));
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

BYTE CdrvVideo::GetAttribute( BYTE X, BYTE Y )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETATTRIBUTE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CdrvVideo::SetAttribute( BYTE X, BYTE Y, BYTE cAttribute )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETATTRIBUTE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8) + (cAttribute << 16));
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

BYTE CdrvVideo::GetColor()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CdrvVideo::GetBkColor()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETBKCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CdrvVideo::SetColor( BYTE cColor )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) cColor;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

VOID CdrvVideo::SetBkColor( BYTE cColor )
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETBKCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) cColor;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

BYTE CdrvVideo::GetX()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETX_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CdrvVideo::GetY()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETY_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

PVOID CdrvVideo::GetInternalPointer()
	{
	return pvideoinstance;
	}

VOID CdrvVideo::Activate()
	{
//	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_ACTIVATE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	}

VOID CdrvVideo::SetCaret( BOOL bShow )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETCARET_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) bShow;
	msg.pReply		= 0; //box;

	pobject->PostMessage( &msg );
	}

