/* **************************************************************************
*                                                                           *
*  Command.CPP                                                              *
*                                                                           *
*  07-05-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Intrpret de comandes de Fnix                                           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "command.h"
#include "fenix\fenix.h"
#include "fenix\mailbox.h"
#include "fenix\mem.h"
#include "fenix\asm.h"
#include "string.h"
#include "fenix\video.h"
#include "fenix\keyb.h"
#include "fenix\mutex.h"
#include "fenix\timer.h"
#include "lang.h"

// *********************************** DEFINES
#define MAX_CMDLINE	80
#define NUM_COMMANDS	4

#define DO_CLS			0
#define DO_EXIT		1
#define DO_HELP		2
#define DO_RUN			3

PSTR sCommands[ NUM_COMMANDS ] =
	{
	TEXT( "CLS\r" ),
	TEXT( "EXIT\r" ),
	TEXT( "HELP\r" ),
	TEXT( "RUN " )
	};

PCfnxModule Fenix;
PCfnxKeyboard pKeyb;
PCfnxVideo pVideo;
CHAR sCmdLine[ MAX_CMDLINE + 1 ];

VOID DisplayPrompt();
VOID Status();
VOID EditLine( PSTR, DWORD );
VOID Do( DWORD );

void main()
	{
	Fenix = new CfnxModule(); // Inicialitzem les estructures internes

	pVideo = new CfnxVideo(); // Generem una pantalla virtual
	pKeyb = new CfnxKeyboard( pVideo );
	pKeyb->Activate(); // Fem que sigui la pantalla activa

	DisplayPrompt(); // Presentem el 'prompt' de l'intrpret

	while( TRUE )
		{
		Fenix->MemSet( sCmdLine, MAX_CMDLINE, 0 ); // Inicialitzem el 'buffer' de la lnia de comandes
		EditLine( sCmdLine, MAX_CMDLINE ); // Obtenim la comanda

		if( strlen( sCmdLine ) > 2 ) // Si hem introdut alguna cosa a ms de "\r\n"
			{
			toupper( sCmdLine ); // Transformem a majscules

			DWORD dwCommand = 0;
			BOOL bFound = FALSE;

			while( dwCommand < NUM_COMMANDS && !bFound ) // Cerquem la comanda
				{
				if( strncmp( sCmdLine, sCommands[ dwCommand ], strlen( sCommands[ dwCommand ] ) ) == 0 )
					bFound = TRUE; // L'hem trobada
				else
					dwCommand++; // Passem a la segent
				}

			if( bFound )
				Do( dwCommand ); // Executem la comanda
			else
				pVideo->OutText( sNOT_A_COMMAND ); // No s'ha reconegut la comanda
			}

		DisplayPrompt(); // Presentem el 'prompt'
		}
	}

// Obt una lnia de text des de teclat (fins a ENTER o MaxLength)
VOID EditLine( PSTR sString, DWORD dwMaxLength )
	{
	BOOL bExit = FALSE;
	DWORD dwOffset = 0, dwSize = 0;

	BYTE x =	pVideo->GetX(); // Obtenim la posici actual
	BYTE y =	pVideo->GetY();

	while( !bExit )
		{
		DWORD ch = pKeyb->GetChar(); // Obtenim un carcter

		if( ch ) // Si s un carcter vlid
			{
			ch = ch & 0xff; // Noms ens interessa el component ASCII

			if( ch == 8 ) // 'Backspace'
				{
				if( dwOffset ) // Si no estem al principi
					{
					if( dwOffset < dwSize ) // Si no estem al final, copiem la resta de la cadena
						Fenix->MemCopy( (PBYTE) (sString + dwOffset), (PBYTE) (sString + dwOffset - 1), dwSize - dwOffset + 1 );
					else // Si estem al final, esborrem l'ltim carcter
						{
						sString[ dwOffset - 1 ] = 0;
						dwSize--;
						}

					dwOffset--;
					}
				}
			else
			if( ch == 13 ) // 'ENTER'
				{
				sString[ dwSize] = '\r'; // Ho transformem en "\r\n\0"
				sString[ dwSize + 1 ] = '\n';
				sString[ dwSize + 2 ] = 0;
				bExit = TRUE; // Ja podem sortir
				}
			else
			if( ch > 31 ) // Qualsevol carcter que no sigui de control
				{
				sString[ dwOffset ] = (CHAR) ch; // Afegim el nou carcter
				dwOffset++;
				}

			if( dwOffset > dwSize ) // Si estem ms enll del final de la cadena
				{
				dwSize = dwOffset; // Fem ms gran la cadena
				sString[ dwSize ] = 0; // Per sempre acabada en '\0'
				}

			if( dwSize >= dwMaxLength - 3 && !bExit ) // Si superem el lmit de tamany i no hem polsat "ENTER"
				{
				sString[ dwMaxLength - 3 ] = '\r'; // Afegim automticament un "ENTER"
				sString[ dwMaxLength - 2 ] = '\n';
				sString[ dwMaxLength - 1 ] = 0;
				bExit = TRUE; // I sortim
				}

			pVideo->GotoXY( x, y ); // Anem al principi de la lnia
			pVideo->OutText( sString ); // Presentem la cadena de carcters

			if( !bExit ) // Si no hem de sortir
				{
				pVideo->OutText( TEXT( " " ) ); // Esborrem qualsevol carcter que hi hagi desprs de la cadena
				DWORD xx = x + dwOffset; // Calculem la nova posici del cursor
				BYTE yy = (BYTE) (y + xx / 80);
				pVideo->GotoXY( (BYTE) (xx % 80), yy ); // Situem el cursor
				}
			}
		}
	}

// Aquesta funci presenta l'indicador de l'intrpret de comandes
VOID DisplayPrompt()
	{
	pVideo->OutText( TEXT( ">" ) );
	}

// Executa la comanda especificada
VOID Do( DWORD dwCommand )
	{
	switch( dwCommand )
		{
		case DO_CLS: // Esborrem la pantalla
			pVideo->Clear();
			break;

		case DO_EXIT: // Aturem l'ordinador
			{
			pVideo->OutText( sEXIT ); // Presentem el missatge de sortida
			Fenix->Sleep( 1500 ); // Fem una pausa
			pVideo->GotoXY( 0, 0 ); // Situem el cursor on quedi b
			Fenix->Shutdown( 0 ); // Tanquem el sistema
			break;
			}

		case DO_HELP: // Presentem informaci sobre l'intrpret
			pVideo->OutText( sCOMMANDS_HELP1 );
			pVideo->OutText( sCOMMANDS_HELP2 );
			pVideo->OutText( sCOMMANDS_HELP3 );
			pVideo->OutText( sCOMMANDS_HELP4 );
			pVideo->OutText( sCOMMANDS_HELP5 );
			pVideo->OutText( sCOMMANDS_HELP6 );
			break;

		case DO_RUN: // Executem un programa
			sCmdLine[ 2 + strlen( (PSTR) (sCmdLine + 4) ) ] = 0; // La lnia ha d'acabar en '\0' no en "\r\n\0"
			Fenix->Exec( (PSTR) (sCmdLine + 4) ); // Demanem al Fnix que executi el programa
			break;

		default: // No s'hauria de donar mai
			pVideo->OutText( sFATAL_ERROR );
		}
	}

