/* **************************************************************************
*                                                                           *
*  Command.CPP                                                              *
*                                                                           *
*  03-04-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Intrpret de comandes de Fnix                                           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "command.h"
#include "fenix\fenix.h"
#include "fenix\mailbox.h"
#include "fenix\mem.h"
#include "fenix\asm.h"
#include "string.h"
#include "fenix\video.h"
#include "fenix\keyb.h"
#include "fenix\mutex.h"
#include "fenix\timer.h"
#include "lang.h"

// *********************************** DEFINES
#define MAX_CMDLINE	80
#define NUM_COMMANDS	4

#define DO_CLS			0
#define DO_EXIT		1
#define DO_HELP		2
#define DO_RUN			3

PSTR sCommands[ NUM_COMMANDS ] =
	{
	TEXT( "CLS\r" ),
	TEXT( "EXIT\r" ),
	TEXT( "HELP\r" ),
	TEXT( "RUN " )
	};

PCfnxModule Fenix;
PCdrvKeyboard pKeyb;
PCdrvVideo pVideo;
PCfnxMutex pVideoMutex;
CHAR sCmdLine[ MAX_CMDLINE + 1 ];

VOID DisplayPrompt();
VOID Status();
VOID EditLine( PSTR, DWORD );
VOID Do( DWORD );

void main()
	{
	Fenix = new CfnxModule(); // Inicialitzem les estructures internes

	pVideo = new CdrvVideo(); // Generem una pantalla virtual
	pKeyb = new CdrvKeyboard( pVideo );
	pKeyb->Activate(); // Fem que sigui la pantalla activa

	pVideoMutex = new CfnxMutex( NULL );
//	Fenix->CreateThread( (DWORD) Status, 0x4000, 0x3000 );

	pVideoMutex->Wait();
	pVideo->GotoXY( 0, 1 );
	pVideoMutex->Release();
	DisplayPrompt();

	while( TRUE )
		{
		Fenix->MemSet( sCmdLine, MAX_CMDLINE, 0 );
		EditLine( sCmdLine, MAX_CMDLINE );

		if( strlen( sCmdLine ) > 2 )
			{
			toupper( sCmdLine );

			DWORD dwCommand = 0;
			BOOL bFound = FALSE;

			while( dwCommand < NUM_COMMANDS && !bFound )
				{
				if( strncmp( sCmdLine, sCommands[ dwCommand ], strlen( sCommands[ dwCommand ] ) ) == 0 )
					bFound = TRUE;
				else
					dwCommand++;
				}

			if( bFound )
				Do( dwCommand );
			else
				{
				pVideoMutex->Wait();
				pVideo->OutText( sNOT_A_COMMAND );
				pVideoMutex->Release();
				}
			}

		DisplayPrompt();
		}
	}

VOID EditLine( PSTR sString, DWORD dwMaxLength )
	{
	BOOL bExit = FALSE;
	DWORD dwOffset = 0, dwSize = 0;

	pVideoMutex->Wait();
	BYTE x =	pVideo->GetX();
	BYTE y =	pVideo->GetY();
	pVideoMutex->Release();

	while( !bExit )
		{
		DWORD ch = pKeyb->GetChar();

		if( ch )
			{
			ch = ch & 0xff;

			if( ch == 8 )
				{
				if( dwOffset )
					{
					if( dwOffset < dwSize )
						Fenix->MemCopy( (PBYTE) (sString + dwOffset), (PBYTE) (sString + dwOffset - 1), dwSize - dwOffset + 1 );
					else
						{
						sString[ dwOffset - 1 ] = 0;
						dwSize--;
						}

					dwOffset--;
					}
				}
			else
			if( ch == 13 )
				{
				sString[ dwSize] = '\r';
				sString[ dwSize + 1 ] = '\n';
				sString[ dwSize + 2 ] = 0;
				bExit = TRUE;
				}
			else
			if( ch > 31 )
				{
				sString[ dwOffset ] = (CHAR) ch;
				dwOffset++;
				}

			if( dwOffset > dwSize )
				{
				dwSize = dwOffset;
				sString[ dwSize ] = 0;
				}

			if( dwSize >= dwMaxLength - 3 && !bExit )
				{
				sString[ dwMaxLength - 3 ] = '\r';
				sString[ dwMaxLength - 2 ] = '\n';
				sString[ dwMaxLength - 1 ] = 0;
				bExit = TRUE;
				}

			pVideoMutex->Wait();
			pVideo->GotoXY( x, y );
			pVideo->OutText( sString );

			if( !bExit )
				{
				pVideo->OutText( TEXT( " " ) );
				DWORD xx = x + dwOffset;
				BYTE yy = (BYTE) (y + xx / 80);
				pVideo->GotoXY( (BYTE) (xx % 80), yy );
				}

			pVideoMutex->Release();
			}
		}
	}

VOID DisplayPrompt()
	{
	pVideoMutex->Wait();
	pVideo->OutText( TEXT( ">" ) );
	pVideoMutex->Release();
	}

VOID Status()
	{
	TTIME time;
	TDATE date;
	CHAR str[ 84 ];

	PCfnxMailBox mbox = new CfnxMailBox();
	new CfnxTimer( 1000, mbox, NULL );

	TMSG msg;

	while( TRUE )
		{
		pVideoMutex->Wait();

		time = Fenix->GetTime();
		date = Fenix->GetDate();

		if( time.Parts.cSecond % 2 )
			sprintf( str, TEXT( "%2u/%02u/%04u%s%2u:%02u" ), date.Parts.cDay, date.Parts.cMonth, date.Parts.wYear, sTITLE, time.Parts.cHour, time.Parts.cMinute );
		else
			sprintf( str, TEXT( "%2u/%02u/%04u%s%2u %02u" ), date.Parts.cDay, date.Parts.cMonth, date.Parts.wYear, sTITLE, time.Parts.cHour, time.Parts.cMinute );

		BYTE x = pVideo->GetX();
		BYTE y = pVideo->GetY();
		BYTE bkcolor = pVideo->GetBkColor();
		BYTE color = pVideo->GetColor();
		pVideo->SetBkColor( GREEN );
		pVideo->SetColor( WHITE );
		pVideo->GotoXY( 0, 0 );
		pVideo->OutText( str );
		pVideo->GotoXY( x, y );
		pVideo->SetBkColor( bkcolor );
		pVideo->SetColor( color );

		pVideoMutex->Release();

		mbox->WaitMessage( &msg );
		}
	}

VOID Do( DWORD dwCommand )
	{
	switch( dwCommand )
		{
		case DO_CLS:
			pVideoMutex->Wait();
			pVideo->Clear();
			pVideo->GotoXY( 0, 1 );
			pVideoMutex->Release();
			break;

		case DO_EXIT:
			{
			pVideoMutex->Wait();
			pVideo->OutText( sEXIT );
			pVideoMutex->Release();
			Fenix->Sleep( 1500 );
			pVideo->GotoXY( 0, 0 );
			Fenix->Shutdown( 0 );
			break;
			}

		case DO_HELP:
			pVideoMutex->Wait();
			pVideo->OutText( sCOMMANDS_HELP1 );
			pVideo->OutText( sCOMMANDS_HELP2 );
			pVideo->OutText( sCOMMANDS_HELP3 );
			pVideo->OutText( sCOMMANDS_HELP4 );
			pVideo->OutText( sCOMMANDS_HELP5 );
			pVideo->OutText( sCOMMANDS_HELP6 );
			pVideoMutex->Release();
			break;

		case DO_RUN:
			sCmdLine[ 2 + strlen( (PSTR) (sCmdLine + 4) ) ] = 0;
			Fenix->Exec( (PSTR) (sCmdLine + 4) );
			break;

		default:
			pVideoMutex->Wait();
			pVideo->OutText( sFATAL_ERROR );
			pVideoMutex->Release();
		}
	}

