/* **************************************************************************
*                                                                           *
*  Test.CPP                                                                 *
*                                                                           *
*  28-05-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Aplicaci de prova per al Fnix                                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "consts.h"
#include "fenix\fenix.h"
#include "fenix\mailbox.h"
#include "fenix\mem.h"
#include "fenix\asm.h"
#include "string.h"
#include "fenix\video.h"
#include "fenix\keyb.h"
#include "fenix\timer.h"
#include "fenix\mutex.h"
#include "fenix\driver.h"
#include "fenix\fub.h"

PCfnxModule Fenix;
PCfnxKeyboard pKeyb;
PCfnxVideo pVideo;
PCfnxMutex MutexObj; // Per a la demostraci d'exclusi mtua

VOID Thread1(); // Segon flux que competir per un recurs compartit

void main()
	{
	Fenix = new CfnxModule(); // Inicialitzem les estructures internes

	pVideo = new CfnxVideo(); // Generem una nova pantalla virtual
	pVideo->SetCaret( FALSE ); // Sense cursor
	pKeyb = new CfnxKeyboard( pVideo ); // Necessitem aquest objecte
	pKeyb->Activate(); // Activem la nova consola

	{ // Demostraci d'accs a fitxers
	PCfnxUserFile file = new CfnxUserFile( TEXT( "C:\\AUTOEXEC.BAT" ), READONLY, DENYNONE );
	// Llegim un fragment del fitxer que acabem d'obrir
	BYTE buff[ 200 ];
	DWORD bytes = file->Read( &buff, 199 );

	delete file; // Tanquem el fitxer

	CHAR str[ 230 ];
	DWORD c, m = 0;
	BYTE x = 0;
	// Preparem una cadena de carcters per presentar el fitxer per pantalla
	for( c = 0; c < bytes; c++ )
		{
		if( buff[ c ] == 27 ) // Final de fitxer
			break;
		else
			{ // Limitem el text a les primeres 39 columnes
			if( buff[ c ] == 0x0a )
				x = 0;
			else
				x++;

			if( x == 39 )
				{
				x = 0;
				str[ m ] = 0x0d;
				str[ m+1 ] = 0x0a;
				m += 2;
				}

			str[ m ] = (CHAR) buff[ c ];
			m++;
			}
		}

	str[ m ] = 0; // Finalitzem amb zero

	pVideo->GotoXY( 0, 6 ); // Presentem per pantalla
	pVideo->OutText( TEXT( "File access Demo: AUTOEXEC.BAT\r\n\n" ) );
	pVideo->OutText( str );
	}

	{ // Demostraci d'accs a un dispositiu sense conixer-ne el tipus
	CHAR str[ 80 ];
	CHAR str2[ 65 ];
	BYTE var;

	// Accedirem al gestor de la 'cache' (per no com un dispositiu de blocs)
	PCfnxDriver driver = new CfnxDriver( TEXT( "\\Driver\\Cache" ) );

	driver->DriverName( str2, 64 ); // Obtenim el nom del controlador
	sprintf( str, TEXT( "Driver Name: %s" ), str2 );
	pVideo->GotoXY( 40, 6 );
	pVideo->OutText( TEXT( "Driver access demonstration" ) );
	pVideo->GotoXY( 40, 8 );
	pVideo->OutText( str );
	driver->DeviceName( str2, 64 ); // Obtenim el nom del dispositiu
	sprintf( str, TEXT( "Device Name: %s" ), str2 );
	pVideo->GotoXY( 40, 9 );
	pVideo->OutText( str );
	var = driver->Version(); // Obtenim la versi del controlador
	sprintf( str, TEXT( "Version    : %d.%d" ), (var >> 4), (var & 0x0f) );
	pVideo->GotoXY( 40, 10 );
	pVideo->OutText( str );
	var = driver->Level(); // Obtenim el nivell en el que est el controlador
	sprintf( str, TEXT( "Level      : %d" ), var );
	pVideo->GotoXY( 40, 11 );
	pVideo->OutText( str );

	delete driver; // Ja no necessitarem ms aquest objecte
	}

	MutexObj = new CfnxMutex( NULL ); // Generem el 'mutex'
	Fenix->CreateThread( (DWORD) Thread1, 0x4000, 0x3000 ); // Generem el segon flux

	// Inicialitzem les variables
	BYTE x = 0;
	CHAR c = '2';
	CHAR str[ 3 ];
	sprintf( str, TEXT( "%c" ), c );

	while( TRUE ) // Repetim
		{
		if( x == 0 ) // Obtenim el control del 'mutex' quan comencem la lnia
			MutexObj->Wait();

		pVideo->GotoXY( x, 3 ); // Situem el cursor lgic
		pVideo->OutText( str ); // Escrivim el valor o l'espai

		x++; // Passem al segent

		if( x == 80 ) // Si hem arribat a l'ltima columna
			{
			x = 0; // Tornem a la primera
			MutexObj->Release(); // Alliberem el 'mutex'

			if( c == '2' ) // Canviem el carcter que volem escriure
				c = ' ';
			else
				c = '2';

			sprintf( str, TEXT( "%c" ), c ); // Regenerem la cadena de carcters
			}

		Fenix->Sleep( 250 ); // Esperem 250ms.
		}
	}

// Aquest flux fa el mateix que el bucle que acabem de veure, per en una lnia de la pantalla
// diferent, i amb el carcter '1'
VOID Thread1()
	{
	BYTE x = 0;
	CHAR c = '1';
	CHAR str[ 3 ];
	sprintf( str, TEXT( "%c" ), c );

	while( TRUE )
		{
		if( x == 0 )
			MutexObj->Wait();

		pVideo->GotoXY( x, 1 );
		pVideo->OutText( str );

		x++;

		if( x == 80 )
			{
			x = 0;
			MutexObj->Release();

			if( c == '1' )
				c = ' ';
			else
				c = '1';

			sprintf( str, TEXT( "%c" ), c );
			}

		Fenix->Sleep( 250 );
		}
	}

