/* **************************************************************************
*                                                                           *
*  AcToken.CPP                                                              *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica de seguretat per a usuaris i grups                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\actoken.h"
#include "string.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxAccessToken::CfnxAccessToken( PVOID pAccessToken ) : CfnxType( CID_AccessToken )
	{
	paccesstoken = pAccessToken;
	}

CfnxAccessToken::~CfnxAccessToken()
	{
	}

BOOL CfnxAccessToken::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_AccessToken )
		return TRUE;
	else
		return CfnxType::ClassCheck( Cuid );
	}

PVOID CfnxAccessToken::GetInternalPointer()
	{
	return paccesstoken;
	}

VOID CfnxAccessToken::LongName( PSTR sLongName, DWORD dwMaxSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sLongName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETLONGNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Name( PSTR sName, DWORD dwMaxSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CfnxAccessToken::None()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNONE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::LockMemory()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETLOCKMEMORY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::IncreaseQuota()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETINCREASEQUOTA_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::LoadDriver()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETLOADDRIVER_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Systemtime()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSYSTEMTIME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::IncreaseBasePriority()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETINCREASEBASEPRIORITY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::CreatePageFile()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATEPAGEFILE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Backup()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETBACKUP_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Restore()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETRESTORE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Shutdown()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSHUTDOWN_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Debug()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETDEBUG_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxAccessToken::Audit()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETAUDIT_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CfnxAccessToken::LongName( PSTR sLongName )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLONGNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sLongName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Name( PSTR sName )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::None( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNONE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::LockMemory( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLOCKMEMORY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::IncreaseQuota( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETINCREASEQUOTA_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::LoadDriver( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLOADDRIVER_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Systemtime( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSYSTEMTIME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::IncreaseBasePriority( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETINCREASEBASEPRIORITY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::CreatePageFile( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETCREATEPAGEFILE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Backup( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETBACKUP_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Restore( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETRESTORE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Shutdown( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSHUTDOWN_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Debug( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETDEBUG_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxAccessToken::Audit( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETAUDIT_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

