/* **************************************************************************
*                                                                           *
*  FUB.CPP                                                                  *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control de fitxers d'usuari                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\fub.h"
#include "drivers\messages.h"
#include "fenix\asm.h"
#include "errors.h"

CfnxUserFile::CfnxUserFile( PSTR sName, BYTE cMode, BYTE cShare )
	{
	pfsmail = (PVOID) FindObject( sName );

	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = (DWORD) cMode;
	data.dwParam3 = (DWORD) cShare;
	data.dwParam4 = 0; // process

	TMSG msg;

	msg.dwMessage	= DRV_OPENFILE_FS;
	msg.dwParam1	= (DWORD) pfsmail;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	DWORD temp = msg.dwParam1;

	if( !temp )
		dwstatus = FIL_NOFILE;
	else
		dwstatus = OK;

	msg.dwMessage	= DRV_CREATEUSERFILE_FCB;
	msg.dwParam1	= temp;
	msg.dwParam2	= 0; // proc -BUG
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CfnxUserFile::~CfnxUserFile()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_CLOSEFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::Lock( DWORD dwBegin, DWORD dwSize, DWORD dwProtection )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = dwBegin;
	data.dwParam2 = dwSize;
	data.dwParam3 = dwProtection;

	TMSG msg;

	msg.dwMessage	= DRV_LOCKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::Unlock( DWORD dwBegin, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = dwBegin;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_UNLOCKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CfnxUserFile::Read( PVOID pBuffer, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) pBuffer;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxUserFile::Write( PVOID pBuffer, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) pBuffer;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITEFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxUserFile::Seek( LONG lBytes, BYTE cFrom )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) lBytes;
	data.dwParam2 = (DWORD) cFrom;

	TMSG msg;

	msg.dwMessage	= DRV_SEEKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CfnxUserFile::Flush()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_FLUSHFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetCreationTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETCREATIONTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetLastAccessTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETACCESSTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetLastWriteTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETWRITETIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetCreationDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETCREATIONDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetLastAccessDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETACCESSDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::GetLastWriteDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETWRITEDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetCreationTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETCREATIONTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetLastAccessTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETACCESSTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetLastWriteTime( PTFILETIME pTime )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETWRITETIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetCreationDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETCREATIONDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetLastAccessDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETACCESSDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetLastWriteDate( PTFILEDATE pDate )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETWRITEDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUserFile::SetAttributes( DWORD dwAttributes )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_SETATTRIBUTES_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwAttributes;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CfnxUserFile::GetAttributes()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETATTRIBUTES_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pfsmail, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

PVOID CfnxUserFile::GetInternalPointer()
	{
	return pobject;
	}

DWORD CfnxUserFile::Status()
	{
	return dwstatus;
	}

