/* **************************************************************************
*                                                                           *
*  MailBox.CPP                                                              *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de 'mailboxes'                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "string.h"

CfnxMailBox::CfnxMailBox( PCfnxObject pParent, PSTR sName ) : CfnxResource()
	{
	id = CID_MailBox;

	if( pParent )
		pobject = ::CreateMailBox( sName, pParent->GetInternalPointer() );
	else
		pobject = ::CreateMailBox( sName, NULL );
	}

CfnxMailBox::CfnxMailBox( PVOID pParent, PSTR sName ) : CfnxResource()
	{
	id = CID_MailBox;

	pobject = ::CreateMailBox( sName, pParent );
	}

CfnxMailBox::~CfnxMailBox()
	{
	::DestroyMailBox( pobject );
	}

BOOL CfnxMailBox::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_MailBox )
		return TRUE;
	else
		return CfnxResource::ClassCheck( Cuid );
	}

VOID CfnxMailBox::PostMessage( PTMSG pMessage )
	{
/*
	PWORD pant = (PWORD) 0xb8000;
	PSTR str = TEXT( "CfnxMailBox::PostMessage entra " );
	DWORD x = 0;
	while( str[ x ] )
		{
		pant[ x ] = (WORD)(str[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	::PostMessage( pobject, pMessage );
/*
	PSTR str2 = TEXT( "CfnxMailBox::PostMessage surt " );
	x = 0;
	while( str2[ x ] )
		{
		pant[ x+80 ] = (WORD)(str2[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	}

BOOL CfnxMailBox::WaitMessage( PTMSG pMessage )
	{
/*
	PWORD pant = (PWORD) 0xb8000;
	PSTR str = TEXT( "CfnxMailBox::WaitMessage entra " );
	DWORD x = 0;
	while( str[ x ] )
		{
		pant[ x ] = (WORD)(str[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	return ::WaitMessage( pobject, pMessage );
/*
	PSTR str2 = TEXT( "CfnxMailBox::WaitMessage surt " );
	x = 0;
	while( str2[ x ] )
		{
		pant[ x+80 ] = (WORD)(str2[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
	return FALSE;
*/
	}

BOOL CfnxMailBox::PeekMessage( PTMSG pMessage )
	{
	return ::PeekMessage( pobject, pMessage );
	}

DWORD CfnxMailBox::WaitingMessages()
	{
	return ::WaitingMessages( pobject );
	}

