/* **************************************************************************
*                                                                           *
*  PCB.CPP                                                                  *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Procs des del punt de vista del mdul System                            *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\pcb.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\thread.h"
#include "fenix\fenix.h"

CfnxProcess::CfnxProcess( PVOID pObject )	: CfnxResource( pObject )
	{
	id = CID_Process;
	}

/*
CfnxProcess::CfnxProcess( PVOID pParent, PSTR sName )	: CfnxResource()
	{
	id = CID_Process;

	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_PROCESS;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CfnxProcess::CfnxProcess( PCfnxObject pParent, PSTR sName ) : CfnxResource()
	{
	id = CID_Process;

	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_PROCESS;
	msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}
*/
CfnxProcess::~CfnxProcess()
	{
	}

PCfnxUser CfnxProcess::User()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETUSER_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CfnxUser( (PVOID) msg.dwParam1 );
	}

PVOID CfnxProcess::Map( PCfnxRegion pRegion, DWORD dwProtection )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;

	data.dwParam1 = (DWORD) pRegion->GetInternalPointer();
	data.dwParam2 = dwProtection;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (PVOID) msg.dwParam1;
	}

VOID CfnxProcess::Unmap( PCfnxRegion pRegion )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_UNMAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pRegion->GetInternalPointer();
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CfnxProcess::TryToMap( PCfnxRegion pRegion, PVOID pAddress, DWORD dwProtection )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;

	data.dwParam1 = (DWORD) pRegion;
	data.dwParam2 = dwProtection;
	data.dwParam3 = (DWORD) pAddress;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CfnxProcess::Commit( PVOID pAddress, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;

	data.dwParam1 = (DWORD) pAddress;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCfnxThread CfnxProcess::Thread()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETFIRSTTHREAD_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CfnxThread( (PVOID) msg.dwParam1 );
	}

BYTE CfnxProcess::BasePriority()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETBASEPRIORITY_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CfnxProcess::BasePriority( BYTE cPriority )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETBASEPRIORITY_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cPriority;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CfnxProcess::PrivilegeLevel()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPRIVILEGELEVEL_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

