/* **************************************************************************
*                                                                           *
*  Resource.CPP                                                             *
*                                                                           *
*  13-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a tots els recursos                                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\resource.h"
#include "errors.h"
#include "fenix\fenix.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"

// **************************************************************************
// Constructor de la classe
CfnxResource::CfnxResource( PVOID pObject ) : CfnxObject( pObject )
	{
	id = CID_Resource;
	}

// **************************************************************************
// Destructor de la classe
CfnxResource::~CfnxResource()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxResource::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Resource )
		return TRUE;
	else
		return CfnxObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'estat del recurs
BYTE CfnxResource::Status()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSTATUS_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

// **************************************************************************
// Modifica l'estat del recurs
// Com a entrada ha de rebre:
// Status	  	- Nou estat del recurs
VOID CfnxResource::Status( BYTE cStatus )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSTATUS_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cStatus;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Allibera el recurs
VOID CfnxResource::Release()
	{
	::ReleaseResource( pobject );
/*
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_RELEASE_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
*/
	}

// **************************************************************************
// Espera l'alliberaci del recurs
VOID CfnxResource::Wait()
	{
	::WaitResource( pobject );
/*
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_WAIT_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
*/
	}

// **************************************************************************
// Comprova si el recurs est lliure i si ho est, el reserva (retornant TRUE)
BOOL CfnxResource::Check()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CHECK_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

