/* **************************************************************************
*                                                                           *
*  SymLink.CPP                                                              *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels enllaos simblics en el directori d'objectes               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\symlink.h"
#include "errors.h"
#include "fenix\fenix.h"
#include "fenix\asm.h"
#include "fenix\mailbox.h"

// **************************************************************************
// Constructor de la classe
CfnxSymbolicLink::CfnxSymbolicLink( PVOID pParent, PSTR sName ) : CfnxObject()
	{
	id = CID_SymbolicLink;

	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CfnxSymbolicLink::CfnxSymbolicLink( PCfnxObject pParent, PSTR sName ) : CfnxObject()
	{
	id = CID_SymbolicLink;

	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

// **************************************************************************
// Destructor de la classe
CfnxSymbolicLink::~CfnxSymbolicLink()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxSymbolicLink::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SymbolicLink )
		return TRUE;
	else
		return CfnxObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nom al que fa referencia l'enlla
VOID CfnxSymbolicLink::NewName( PSTR sName, DWORD dwMaxSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Modifica el nom al que fa referencia l'enlla
// Com a entrada ha de rebre:
// sNewName   	- Nou nom
VOID CfnxSymbolicLink::NewName( PSTR sNewName )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNAME_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) sNewName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

