/* **************************************************************************
*                                                                           *
*  Thread.CPP                                                               *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti dels fluxos                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\thread.h"
#include "fenix\fenix.h"
#include "fenix\asm.h"
#include "fenix\mailbox.h"

CfnxThread::CfnxThread( PVOID pObject ) : CfnxResource( pObject )
	{
	id = CID_Thread;
	}

CfnxThread::~CfnxThread()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxThread::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Thread )
		return TRUE;
	else
		return CfnxResource::ClassCheck( Cuid );
	}

DWORD CfnxThread::ErrorCode()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxThread::KernelTime()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETKERNELTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxThread::UserTime()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETUSERTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CfnxThread::ErrorCode( DWORD dwCode )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwCode;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCfnxThread CfnxThread::NextInProc()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNEXTINPROCESS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CfnxThread( (PVOID) msg.dwParam1 );
	}

PCfnxThread CfnxThread::NextInAll()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNEXTINALL_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CfnxThread( (PVOID) msg.dwParam1 );
	}

BYTE CfnxThread::Priority()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPRIORITY_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CfnxThread::Priority( BYTE cPriority )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETPRIORITY_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cPriority;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCfnxProcess CfnxThread::Process()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPROCESS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CfnxProcess( (PVOID) msg.dwParam1 );
	}

DWORD CfnxThread::CreationTime()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATIONTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxThread::ExitStatus()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETEXITSTATUS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CfnxThread::Exit( DWORD dwCode )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETEXITSTATUS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwCode;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

