/* **************************************************************************
*                                                                           *
*  Video.CPP                                                                *
*                                                                           *
*  13-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de video de l'Fenix                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\video.h"
#include "fenix\messages.h"
#include "fenix\mailbox.h"
#include "fenix\mem.h"
#include "string.h"
#include "fenix\mem.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxVideo::CfnxVideo() : CfnxCharDevice( VIDEO_MAILBOX )
	{
	id = CID_VideoDriver;

	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_CREATEINSTANCE_VID;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );
	box->WaitMessage( &msg );
	delete box;

	pvideoinstance = (PVOID) msg.dwParam1;
	}

CfnxVideo::~CfnxVideo()
	{
	TMSG msg;

	msg.dwMessage	= DRV_DESTROYINSTANCE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= 0; //box;

	PostMessage( pobject, &msg );
	}

VOID CfnxVideo::GotoXY( BYTE X, BYTE Y )
	{
	TMSG msg;

	msg.dwMessage	= DRV_GOTOXY_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

VOID CfnxVideo::Clear()
	{
	TMSG msg;

	msg.dwMessage	= DRV_CLEAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

VOID CfnxVideo::OutText( PSTR sString )
	{
	PSTR str = (PSTR) malloc( strlen( sString ) * sizeof( CHAR ) + 1 );
	strcpy( str, sString );

	TMSG msg;

	msg.dwMessage	= DRV_OUTTEXT_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) str;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

CHAR CfnxVideo::GetChar( BYTE X, BYTE Y )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETCHAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (CHAR) msg.dwParam1;
	}

VOID CfnxVideo::SetChar( BYTE X, BYTE Y, CHAR cCharacter )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETCHAR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8) + (cCharacter << 16));
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

BYTE CfnxVideo::GetAttribute( BYTE X, BYTE Y )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETATTRIBUTE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8));
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CfnxVideo::SetAttribute( BYTE X, BYTE Y, BYTE cAttribute )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETATTRIBUTE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) (X + (Y << 8) + (cAttribute << 16));
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

BYTE CfnxVideo::GetColor()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CfnxVideo::GetBkColor()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETBKCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CfnxVideo::SetColor( BYTE cColor )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) cColor;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

VOID CfnxVideo::SetBkColor( BYTE cColor )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETBKCOLOR_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) cColor;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

BYTE CfnxVideo::GetX()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETX_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CfnxVideo::GetY()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETY_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

PVOID CfnxVideo::GetInternalPointer()
	{
	return pvideoinstance;
	}

VOID CfnxVideo::Activate()
	{
	TMSG msg;

	msg.dwMessage	= DRV_ACTIVATE_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= 0;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

VOID CfnxVideo::SetCaret( BOOL bShow )
	{
	TMSG msg;

	msg.dwMessage	= DRV_SETCARET_VID;
	msg.dwParam1	= (DWORD) pvideoinstance;
	msg.dwParam2	= (DWORD) bShow;
	msg.pReply		= Fenix->NULLMailBox();

	PostMessage( pobject, &msg );
	}

