/* **************************************************************************
*                                                                           *
*  ASM.CPP                                                                  *
*                                                                           *
*  18-03-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Codi en 'Assembler' del 'kernel'                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\asm.h"
#include "kernel\interrup.h"

#pragma option -a2
// El processador necessita aquestes variables ordenades d'aquesta manera i
// amb aliniaci de WORD
WORD size = 0;
DWORD addr = 0;

DWORD tss = 0;
WORD tsssel = 0;
#pragma option -a4

DWORD _export Mode = 0; // Mode actual del flux en execuci
TRegisters int_regs; // Registres (utilitzat per a Panic)
WORD wltr; // Selector del TSS per a les funcions LTR i STR

// **************************************************************************
// Retarda l'execuci del flux en increments de 15 microsegons (no permet canvis de context)
// Com a entrada ha de rebre:
// Count			- Nombre de microsegons a esperar dividit per 15
VOID MicroDelay( DWORD )
	{
	asm
		{
		mov ecx, [ebp + 8] // Obtenir el compte de temps
		or ecx, ecx
		je MDL01				 // Sortim si ens indiquen 0
MDL00:
		in al, 61h			 // Obtenim dades des del 'System Status Port'
		and al, 10h			 // Comprovem el 'bit' de refresc
		cmp ah, al			 // Comprovem si ha canviat des de l'ltim cop
		je MDL00				 // Encara no ha canviat
		mov ah, al			 // Canvi! Guardem el valor nou en AH
		loop MDL00			 // ECX cops
MDL01:
		}
	}

// **************************************************************************
// Envia una certa quantitat de 'words' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Address  	- Indica l'adrea inicial de la zona a transferir
// Bytes    	- Especifica el nombre de 'bytes' a transferir
VOID outwords( WORD, PBYTE, DWORD )
	{
	asm
		{
		mov dx, word ptr [ebp + 8]		// Obtenim els parmetres
		mov esi, dword ptr [ebp + 12]
		mov ecx, dword ptr [ebp + 16]
		shr ecx, 1							// Volem el compte en paraules, no 'bytes'
		cld
		rep outsw
		}
	}

// **************************************************************************
// Obt una certa quantitat de 'words' des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Address  	- Indica l'adrea inicial de la zona que obt les dades
// Bytes    	- Especifica el nombre de 'bytes' a transferir
VOID inwords( WORD, PBYTE, DWORD )
	{
	asm
		{
		mov dx, word ptr [ebp + 8]		// Obtenim els parmetres
		mov edi, dword ptr [ebp + 12]
		mov ecx, dword ptr [ebp + 16]
		shr ecx, 1							// Volem el compte en paraules
		cld
		rep insw
		}
	}

// **************************************************************************
// Inhibeix les interrupcions tot retornant el valor dels 'flags' anteriors
DWORD CLI()
	{
	asm pushfd
	asm cli
	asm pop eax

	return _EAX;
	}

// **************************************************************************
// Posa els 'flags' tal i com se li indica en el parmetre
// Com a entrada ha de rebre:
// Flags			- Indica el valor que volem que tinguin els 'flags'
VOID STI( DWORD flags )
	{
	asm mov eax, flags
	asm push eax
	asm popfd
	}

// **************************************************************************
// Obt els parmetres de la GDT actual (tamany i posici)
VOID SGDT()
	{
	asm sgdt qword ptr size
	}

// **************************************************************************
// Obt els parmetres de l'IDT actual (tamany i posici)
VOID SIDT()
	{
	asm sidt qword ptr size
	}

// **************************************************************************
// Selecciona una nova LDT
// Com a entrada ha de rebre:
// Table			- Adrea cap al selector que indica quina ser la nova LDT
VOID LLDT( PWORD pTable )
	{
	asm lldt word ptr [pTable]
	}

// **************************************************************************
// Obt l selector de la LDT actual
// Com a entrada ha de rebre:
// Table			- Adrea cap a la posici de memria on guardarem el selector
VOID SLDT( PWORD pTable )
	{
	asm sldt word ptr [pTable]
	}

// **************************************************************************
// Selecciona un nou TSS com a actual en execuci (s'utilitza per a la 1 tasca)
VOID LTR()
	{
	asm mov ax, word ptr [wltr]
	asm ltr ax
	}

// **************************************************************************
// Obt el selector del TSS actual
VOID STR()
	{
	asm str word ptr [wltr]
	}

// **************************************************************************
// Obt el valor actual del registre CR0
DWORD GetCR0()
	{
	asm mov eax, cr0
	return _EAX;
	}

// **************************************************************************
// Canvia el valor del registre CR0
// Com a entrada ha de rebre:
// Value			- Valor nou per a CR0
VOID SetCR0( DWORD dwValue )
	{
	asm mov eax, dword ptr [dwValue]
	asm mov cr0, eax
	}

// **************************************************************************
// Obt el valor actual del registre CR2 (adrea lgica que ha provocat una fallada de pgina)
DWORD GetCR2()
	{
	asm mov eax, cr2
	return _EAX;
	}

// **************************************************************************
// Obt el valor actual de CR3 (Adrea fsica del directori de pgines actual)
DWORD GetCR3()
	{
	asm mov eax, cr3
	return _EAX;
	}

// **************************************************************************
// Selecciona un nou directori de pgines
// Com a entrada ha de rebre:
// Value 		- Valor per al registre CR3
VOID SetCR3( DWORD dwValue )
	{
	asm mov eax, dword ptr [dwValue]
	asm mov cr3, eax
	}

// **************************************************************************
// Buida la 'cache' de pgines del processador
VOID CacheCR3()
	{
	asm mov eax, cr3
	asm mov cr3, eax
	}

// **************************************************************************
// Obt el valor actual dels 'flags'
DWORD GetEFLAGS()
	{
	asm pushfd
	asm pop eax
	return _EAX;
	}

// **************************************************************************
// Selecciona un nou valor per als 'flags'
// Com a entrada ha de rebre:
// Flags			- Indica el nou valor
VOID SetEFLAGS( DWORD dwFlags )
	{
	asm mov eax, dwFlags
	asm push eax
	asm popfd
	}

// **************************************************************************
// Envia un 'byte' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID outpb( WORD wPort, BYTE cByte )
	{
	asm mov al, cByte
	asm mov dx, wPort
	asm out dx, al
	}

// **************************************************************************
// Envia una 'word' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID outpw( WORD wPort, WORD wWord )
	{
	asm mov ax, wWord
	asm mov dx, wPort
	asm out dx, ax
	}

// **************************************************************************
// Envia un 'dword' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID outpd( WORD wPort, DWORD dwDWord )
	{
	asm mov eax, dwDWord
	asm mov dx, wPort
	asm out dx, eax
	}

// **************************************************************************
// Retorna el 'byte' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
BYTE inpb( WORD wPort )
	{
	asm mov dx, wPort
	asm in al, dx
	return _AL;
	}

// **************************************************************************
// Retorna la 'word' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
WORD inpw( WORD wPort )
	{
	asm mov dx, wPort
	asm in ax, dx
	return _AX;
	}

// **************************************************************************
// Retorna el 'dword' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
DWORD inpd( WORD wPort )
	{
	asm mov dx, wPort
	asm in eax, dx
	return _EAX;
	}

// **************************************************************************
// Realitza una crida a una rutina l'adrea de la qual es passa com a paretre
// Com a entrada ha de rebre:
// pos  			- Indica l'adrea de memria on comena la rutina
VOID Call( DWORD pos )
	{
	asm call dword ptr [pos]
	}

// **************************************************************************
// Realitza un canvi de context
VOID JumpTSS()
	{
	asm jmp fword ptr [tss]
	}

// **************************************************************************
// Retorna el tipus de CPU sobre el qual s'executa el sistema
DWORD CpuType()
	{
	asm
		{
		pushfd				// Obtenim els 'flags'
		pop eax
		mov ebx, eax
		xor eax, 200000h	// Aquest 'bit' indica si el processador t la instrucci CPUID
		push eax
		popfd					// Fem el canvi
		pushfd
		pop eax				// Obtenim el nou valor
		push ebx				// Tornem al valor anterior
		popfd

		xor eax, ebx
		jnz ID				// Com que hem pogut canviar-lo, suporta CPUID
		mov eax, 3			// Com que no hem pogut canviar-lo, suposem un Intel 386
		jmp fi
ID:
		mov eax, 1
		db 0fh, 0a2h		// CPUID
		and eax, 0f00h
		shr eax, 8			// A partir d'aquest 'bit' hi ha el codi de processador
fi:
		}

	return _EAX;
	}

// **************************************************************************
// Prepara l'estructura de registres per a la funci Panic
VOID PrepareRegisters()
	{
	asm mov ebp, esp
	asm add ebp, 4		// Correcci necessria
	asm
		{
		mov eax, dword ptr [ebp]
		mov dword ptr [int_regs.EDI], eax
		mov eax, dword ptr [ebp+4]
		mov dword ptr [int_regs.ESI], eax
		mov eax, dword ptr [ebp+8]
		mov dword ptr [int_regs.EBP], eax
		mov eax, dword ptr [ebp+16]
		mov dword ptr [int_regs.EBX], eax
		mov eax, dword ptr [ebp+20]
		mov dword ptr [int_regs.EDX], eax
		mov eax, dword ptr [ebp+24]
		mov dword ptr [int_regs.ECX], eax
		mov eax, dword ptr [ebp+28]
		mov dword ptr [int_regs.EAX], eax
		mov eax, dword ptr [ebp+36]
		mov dword ptr [int_regs.EIP], eax
		mov ax, word ptr [ebp+40]
		mov word ptr [int_regs.CS], ax
		and ax, 3
		or ax, ax
		je Preplevel0
		mov ax, word ptr [ebp+52]
		mov word ptr [int_regs.SS], ax
		mov eax, dword ptr [ebp+48]
		mov dword ptr [int_regs.ESP], eax
		jmp Prepstackend
Preplevel0:
		mov ax, ss
		mov word ptr [int_regs.SS], ax
		mov eax, dword ptr [ebp+12]
		add eax, 4
		mov dword ptr [int_regs.ESP], eax
Prepstackend:
		mov ax, ds
		mov word ptr [int_regs.DS], ax
		mov ax, es
		mov word ptr [int_regs.ES], ax
		mov ax, fs
		mov word ptr [int_regs.FS], ax
		mov ax, gs
		mov word ptr [int_regs.GS], ax
		mov eax, dword ptr [ebp+44]
		mov dword ptr [int_regs.EFLAGS], eax
		}
	}

// **************************************************************************
// Prepara l'estructura de registres quan a la pila hi ha un codi d'error
VOID PrepareRegistersWithError()
	{
	asm mov ebp, esp
	asm add ebp, 4
	asm
		{
		mov eax, dword ptr [ebp]
		mov dword ptr [int_regs.EDI], eax
		mov eax, dword ptr [ebp+4]
		mov dword ptr [int_regs.ESI], eax
		mov eax, dword ptr [ebp+8]
		mov dword ptr [int_regs.EBP], eax
		mov eax, dword ptr [ebp+16]
		mov dword ptr [int_regs.EBX], eax
		mov eax, dword ptr [ebp+20]
		mov dword ptr [int_regs.EDX], eax
		mov eax, dword ptr [ebp+24]
		mov dword ptr [int_regs.ECX], eax
		mov eax, dword ptr [ebp+28]
		mov dword ptr [int_regs.EAX], eax
		mov eax, dword ptr [ebp+40]
		mov dword ptr [int_regs.EIP], eax
		mov ax, word ptr [ebp+44]
		mov word ptr [int_regs.CS], ax
		and ax, 3
		or ax, ax
		je Errlevel0
//		mov ax, word ptr [ebp+56] -BUG
		mov word ptr [int_regs.SS], ax
//		mov eax, dword ptr [ebp+52] -BUG
		mov dword ptr [int_regs.ESP], eax
		jmp Errstackend
Errlevel0:
		mov ax, ss
		mov word ptr [int_regs.SS], ax
		mov eax, dword ptr [ebp+12]
		add eax, 4
		mov dword ptr [int_regs.ESP], eax
Errstackend:
		mov ax, ds
		mov word ptr [int_regs.DS], ax
		mov ax, es
		mov word ptr [int_regs.ES], ax
		mov ax, fs
		mov word ptr [int_regs.FS], ax
		mov ax, gs
		mov word ptr [int_regs.GS], ax
		mov eax, dword ptr [ebp+48]
		mov dword ptr [int_regs.EFLAGS], eax
		}
	asm mov ecx, dword ptr [ebp+36]
	}

// **************************************************************************
// RSI de les interrupcions no controlades per ning
VOID UnhandledInterrupt()
	{
	asm pop ebx // El compilador fa 'push ebx', nosaltres hem de fer el contrari
	asm iretd
	}

// **************************************************************************
// RSI de les interrupcions de 0 a 30h
VOID INT0()
	{
	asm pushad

	PrepareRegisters();
	Division();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1()
	{
	asm pushad

	PrepareRegisters();
	Trap();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2()
	{
	asm pushad

	PrepareRegisters();
	NMI();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT3()
	{
	asm pushad

	PrepareRegisters();
	DebugInt();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT4()
	{
	asm pushad

	PrepareRegisters();
	Overflow();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT5()
	{
	asm pushad

	PrepareRegisters();
	Bound();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT6()
	{
	asm pushad

	PrepareRegisters();
	Opcode();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT7()
	{
	asm pushad

	PrepareRegisters();
	MathProcessor();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT8()
	{
	asm pushad

	PrepareRegistersWithError();
	DoubleFault();

	asm popad
	asm pop ebx
	asm add esp, 4		// Codi d'error
	asm iretd
	}

VOID INT9()
	{
	asm pushad

	PrepareRegisters();
	MathProcSegment();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INTA()
	{
	asm mov ebp, esp
	asm mov ecx, dword ptr [ebp+4]

	BadTSS( _ECX );

	asm pop ebx
	asm add esp, 4
	asm iretd
	}

VOID INTB()
	{
	asm pushad

	PrepareRegistersWithError();
	Segment( _ECX );

	asm popad
	asm pop ebx
	asm add esp, 4
	asm iretd
	}

VOID INTC()
	{
	asm pushad

	PrepareRegistersWithError();
	StackException( _ECX );

	asm popad
	asm pop ebx
	asm add esp, 4
	asm iretd
	}

VOID INTD()
	{
	asm pushad

	PrepareRegistersWithError();
	GPFault( _ECX );

	asm popad
	asm pop ebx
	asm add esp, 4
	asm iretd
	}

VOID INTE()
	{
	asm pushad

	PrepareRegistersWithError();
	PageFault( _ECX );

	asm popad
	asm pop ebx
	asm add esp, 4
	asm iretd
	}

VOID INTF()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x0f );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT10()
	{
	asm pushad

	PrepareRegisters();
	MathProcError();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT11()
	{
	asm pushad

	PrepareRegisters();
	Unalignment();

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT12()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x12 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT13()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x13 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT14()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x14 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT15()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x15 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT16()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x16 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT17()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x17 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT18()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x18 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT19()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x19 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1A()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1a );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1B()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1b );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1C()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1c );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1D()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1d );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT1E()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1e );

	asm pop ebx
	asm iretd
	}

VOID INT1F()
	{
	asm pushad

	PrepareRegisters();
	Reserved( (BYTE) 0x1f );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT20()
	{
	asm pushad

	asm
		{
		mov ebp, esp
		mov eax, [ebp+40]
		and eax, 3
		or eax, eax
		je continueINT
		mov eax, 1
continueINT:
		mov dword ptr Mode, eax
		}

	Reserved( (BYTE) 0x20 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT21()
	{
	asm pushad

	Reserved( (BYTE) 0x21 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT22()
	{
	asm pushad

	Reserved( (BYTE) 0x22 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT23()
	{
	asm pushad

	Reserved( (BYTE) 0x23 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT24()
	{
	asm pushad

	Reserved( (BYTE) 0x24 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT25()
	{
	asm pushad

	Reserved( (BYTE) 0x25 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT26()
	{
	asm pushad

	Reserved( (BYTE) 0x26 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT27()
	{
	asm pushad

	Reserved( (BYTE) 0x27 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT28()
	{
	asm pushad

	Reserved( (BYTE) 0x28 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT29()
	{
	asm pushad

	Reserved( (BYTE) 0x29 );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2A()
	{
	asm pushad

	Reserved( (BYTE) 0x2a );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2B()
	{
	asm pushad

	Reserved( (BYTE) 0x2b );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2C()
	{
	asm pushad

	Reserved( (BYTE) 0x2c );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2D()
	{
	asm pushad

	Reserved( (BYTE) 0x2d );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2E()
	{
	asm pushad

	Reserved( (BYTE) 0x2e );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT2F()
	{
	asm pushad

	Reserved( (BYTE) 0x2f );

	asm popad
	asm pop ebx
	asm iretd
	}

VOID INT30()
	{
	asm pushad
	asm mov ebp, esp

	SystemCall( _EAX, _EBX, _ECX );
	asm mov dword ptr [ebp+28], eax

	asm popad
	asm pop ebx
	asm iretd
	}

