/* **************************************************************************
*                                                                           *
*  Kernel.CPP                                                               *
*                                                                           *
*  13-05-97                                                    BUILD:0008   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Kernel del sistema Eros ver 1.00                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel.h"
#include "errors.h"
#include "kernel\mem.h"
#include "string.h"
#include "kernel\version.h"
#include "kernel\asm.h"
#include "kernel\eflags.h"
#include "kernel\timer.h"
#include "kernel\selector.h"
#include "common.h"

#define SYS_HEAPRESERVE		0x00100000
#define SYS_HEAPCOMMIT		0x00000000
#define SYS_STACKRESERVE	0x00100000
#define SYS_STACKCOMMIT		0x00001000

// *********************************** GLOBALS
#ifdef _DEBUG
DWORD _export DebugLevel = 1;	// Utilitzat com a ajuda durant la depuraci
#endif

extern WORD wltr;
PCTSS ptss;						// TSS de la tasca 'Idle'
WORD idletask;					// Selector del TSS de la tasca 'Idle'
DWORD idletime;				// Temps que porta el processador en la tasca 'Idle'
PCkeSystem _export System;	// Objecte 'System'
PCkeKernel _export Kernel;	// Objecte 'Kernel'

// *********************************** FUNCIONS
BOOL DllEntryPoint()	// Punt d'entrada al 'Kernel'
	{
// No podem generar els objectes com a globals, de manera que el construm ara
// i creem uns apuntadors cap a ells, que son exportats.
	static CkeSystem sys;	// Primer el 'System'
	static CkeKernel ker;

	DWORD flags = CLI();	// Obtenim el 'flags' actuals (les interrupcions ja estan inhibides
	CEFLAGS EFlags( flags ); // Utilitzem la classe EFlags per a canviar els 'flags'
	EFlags.IF( TRUE ); // Volem les interrupcions habilitades
	flags = EFlags.Flags();	// Obtenim els nous 'flags'
	STI( flags ); // Donem al processador els nous 'flags'

// Creem el TSS inicial (Idle)
	PTDescriptor ptdesc;
	wltr = (System->GDT())->CreateDescriptor(); // Nou descriptor per el TSS

	{
	ptdesc = (System->GDT())->Descriptor( wltr );
	CDescriptor desc( ptdesc );
	WORD tsssize = (WORD) sizeof( TTSS );	// Tamany d'un TSS
	DWORD tssbase = (DWORD) malloc( tsssize );	// Resevem memria per el TSS
	desc.Base( tssbase );	// Posici on comena el segment
	desc.Limit( tsssize - 1 );	// Tamany - 1 perqu comencem a comptar des de 0
	desc.Granularity( FALSE );	// s un segment amb granularitat de 'byte'
	desc.Present( TRUE );
	}

	ptss = new CTSS( ptdesc );	// Volem un objecte TSS
	ptss->Clear();	// L'inicialitzem

	WORD OSData;	// Volem el selector de dades

	{
	CSelector selector;
	selector.Index( 2 );	// ndex cap a les dades
	selector.RPL( 0 );	// Del sistema operatiu (nivell 0)
	selector.Table( SELECTOR_GDT );	// De la GDT
	OSData = selector.Selector();	// Aquest s el selector
	}

	ptss->Set( TSS_FREE );	// El TSS ha d'estar lliure
	ptss->PDBR( 0x80000 );	// Directori de pgines inicial del sistema -BUG
	ptss->IOMap( (WORD) 0xffff );	// Volem un mapa d'E/S nul

	// Pila per a la tasca 'Idle' -BUG
	ptss->SetStack( 0, OSData, (DWORD) 0x70000 + (PAGE_SIZE - 1) );

	wltr = (WORD) (wltr << 3);	// El selector t els 3 bits ms baixos iguals a 0
	idletask = wltr;
	LTR();	// Carreguem la primera tasca

	PTModule mod = (PTModule) MODULE16_OFFSET;	// Accedim al primer mdul carregat

	PCkeObject pprocessdir = System->FindObject( PROCESS_DIR ); // Cerquem el directori dels processos
	// Creem el primer procs: El primer mdul carregat per DOSLoad, que sol ser SYS.EXE
	new CkeProcess( mod[ 0 ].sName, mod[ 0 ].dwEntryPoint, SYS_HEAPRESERVE, SYS_HEAPCOMMIT, SYS_STACKRESERVE, SYS_STACKCOMMIT, pprocessdir, MODE_KERNEL );

	while( 1 )	// Aquesta ser la tasca 'Idle'
		{
//		Kernel->Idle();	// Quan no hi ha cap flux en execuci, hi ha temps lliure
		}
	}

// **************************************************************************
// Constructor de la classe
CkeKernel::CkeKernel() : CkeType( CID_Kernel )
	{
	Kernel = this;	// Inicialitzem l'objecte global 'Kernel'

	idletime = 0;	// Inicialitzem el comptador de temps inactiu
	cquantum = 1;	// Quantum de la tasca 'Idle' en comenar

// Hem d'inicialitzar la taula d'alarmes (timers)
	for( DWORD index = 0; index < KERNEL_TIMERS; index++ )
		{
		timer[ index ].pTimer		= NULL;
		timer[ index ].lMillisecs	= 0;
		}

	// El sistema ha de conixer les zones ocupades durant la crrega inicial
	PCkeRegion pRegion = new CkeRegion( NULL, 0x300000, 0, NULL ); // Tamany de: 'Kernel', AAL i 'System'
	pvad = new CkeVAD( (PVOID) 0x80000000, NULL, pRegion, 0, NULL, NULL );
	pRegion = new CkeRegion( NULL, 0x200000, 0, NULL );
	PCkeVAD pvad2 = new CkeVAD( (PVOID) 0x80400000, NULL, pRegion, 0, pvad, NULL ); // 'Heap' del 'System'
	pvad->SetNext( pvad2 ); // Hem d'enllaar els VADs
	pRegion = new CkeRegion( NULL, 0x400000, 0, NULL );
	PCkeVAD pvad3 = new CkeVAD( (PVOID) 0x80800000, NULL, pRegion, 0, pvad2, NULL ); // Controladors de dispositius
	pvad2->SetNext( pvad3 );

	// Necessitem el directori arrel
	PCkeObjectDirectory pRoot = (PCkeObjectDirectory) System->FindObject( TEXT( "\\" ) );
// Hem de crear els directoris del Kernel
	new CkeObjectDirectory( pRoot, nSHUTDOWN_DIR );		// \Shutdown
	new CkeObjectDirectory( pRoot, nMUTEX_DIR );			// \Mutex
	new CkeObjectDirectory( pRoot, nSEMAPHORE_DIR );	//	\Semaphore
	new CkeObjectDirectory( pRoot, nPROCESS_DIR );		//	\Process
	new CkeObjectDirectory( pRoot, nMAILBOX_DIR );		//	\Mailbox
	new CkeObjectDirectory( pRoot, nDRIVER_DIR );		//	\Driver
	new CkeObjectDirectory( pRoot, nFILESYSTEM_DIR );	// \FileSystem
	}

// **************************************************************************
// Destructor de la classe
CkeKernel::~CkeKernel()
	{
// No s cridat mai
	TRACE( TEXT( "BUG CkeKernel::~CkeKernel cridat BUG!!!!" ) );
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeKernel::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Kernel )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Indica la versi del 'kernel' que s'est executant
DWORD CkeKernel::Version()
	{
	return KERNEL_VERSION;
	}

// **************************************************************************
// Indica l'arquitectura sobre la que funciona aquest 'kernel' (versi del processador)
DWORD CkeKernel::Architecture()
	{
#if _M_IX86 < 400
	return KERNEL_ARCH_INTEL386;
#elif _M_IX86 < 500
	return KERNEL_ARCH_INTEL486;
#elif _M_IX86 < 600
	return KERNEL_ARCH_INTELPENTIUM;
#else
	return KERNEL_ARCH_INTELPENTIUMPRO;
#endif
	}

// **************************************************************************
// Selecciona la nova tasca (flux) que s'ha d'executar
BOOL CkeKernel::Scheduler( BOOL bInterrupt )
	{
	DWORD	flags = CLI();	// No volem ser interromputs

	PCkeThread old = System->Running();	// Obtenim el flux en execuci
	PCkeThread young = System->Ready();	// Obtenim el flux a executar

	if( old )	// Si no estem executant el flux 'Idle'
		{
		old->LastQuantum( cquantum );	// Guardem el valor de quantum utilitzat

		if( young && !cquantum )	// Si hi ha un flux preparat i el quantum ha finalitzat
			System->Ready( old );	// Deixem el flux antic a la llista de preparats
		}

	cquantum = 10;	// 10 * 10 = 100 ms. de quantum

	if( young )	// Si hi ha un nou flux preparat
		{
		PCkeThreadList list = System->ReadyList();	// Hem d'accedir a la llista de preparats
		list->Delete( young );	// per a treure'n el flux

		System->Running( young, bInterrupt );	// 'Continuem' l'execuci del nou flux
		STI( flags );  // Tornem a permetre les interrupcions
		return TRUE; // Indiquem que hi ha hagut un intercanvi de tasques
		}
	else	// No hi ha un flux preparat
		{
		if( bInterrupt )	// Si estem en temps d'interrupci
			{
			(System->AAL())->EOI( 0 );	// Finalitzem la interrupci 'hardware'
			STI( flags );	// Habilitem les interrupcions
			return FALSE;	// No hi ha hagut intercanvi
			}
		else	// No estem en temps d'interrupci
			{
			System->Running( NULL, FALSE );	// Executem el flux 'Idle'
			STI( flags );	// Habilitem les interrupcions
			return TRUE;	// Hi ha hagut intercanvi
			}
		}
	}

// **************************************************************************
// Exclou una regi de memria fsica de ser reservada
// Com a entrada ha de rebre:
// Address		- Selecciona l'adrea per a la regi
// Region 		- Indica la regi que s'ha d'excloure
VOID CkeKernel::ExcludePhysicalMemoryRegion( PVOID pAddress, PCkeRegion pRegion )
	{
	CHECK_CLASS( pRegion, CID_Region, TEXT( "CkeKernel::ExcludePhysicalMemoryRegion->pRegion no s del tipus pRegion" ) );

// Comprovar que tota la zona de memria est lliure
	PCkePAT pPAT = System->PAT();
	DWORD dwSize = pRegion->VirtualSize();

	DWORD flags = CLI(); // Inhabilitem les interrupcions

	if( pPAT->IsRegionFree( (DWORD) pAddress, dwSize ) )
		{
// Reservar la zona
/*
		Tot aix...
		pPAT->Region( (DWORD) pAddress, pRegion );
		pPAT->Offset( (DWORD) pAddress, dwOffset );
		pPAT->Age( (DWORD) pAddress, 0 );
		pPAT->UsageCount( (DWORD) pAddress, 0 );
		pPAT->Flags( (DWORD) pAddress, INITIALIZED_PAGE );
		pPAT->Owner( (DWORD) pAddress, RESERVED_PAGE );
		...es pot resumir aix:
		pPAT->MakePage( (DWORD) pAddress + dwOffset, pRegion, dwOffset, 0L );
*/
		for( DWORD dwOffset = 0; dwOffset < dwSize; dwOffset += PAGE_SIZE )
			pPAT->MakePage( (DWORD) pAddress + dwOffset, pRegion, dwOffset, 0L );

		SETERRORCODE( OK );	// No hi ha error
		}
	else
		SETERRORCODE( MEM_REGIONNOTFREE );	// Hi ha un error

	STI( flags ); // Habilitem les interrupcions
	}

// **************************************************************************
// Allibera una regi de memoria previament exclosa
// Com a entrada ha de rebre:
// Address		- Indica l'adrea fsica a partir de la qual s'inclou
// Size     	- Indica el tamany de la regi
VOID CkeKernel::IncludePhysicalMemoryRegion( PVOID pAddress, DWORD dwSize )
	{
// Comprovar que tota la zona estigui reservada
	PCkePAT pPAT = System->PAT();

	DWORD flags = CLI(); // Inhabilitem les interrupcions

	if( pPAT->IsRegionReserved( (DWORD) pAddress, dwSize ) )
		{
// Alliberar-la
		for( DWORD dwOffset = 0; dwOffset < dwSize; dwOffset += PAGE_SIZE )
			pPAT->FreePage( (DWORD) pAddress + dwOffset );

		SETERRORCODE( OK );	// No hi ha cap error
		}
	else
		SETERRORCODE( MEM_REGIONNOTRESERVED ); // Hi ha un problema

	STI( flags );	// Habilitem les interrupcions
	}

// **************************************************************************
// Atura l'ordinador de manera segura
VOID CkeKernel::Shutdown()
	{
// Aturar l'ordinador
	CLI();
	while( TRUE )	{}
	}

// **************************************************************************
// Ajuda a l'AAL en la realitzaci de l'EOI per a una certa interrupci
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupci per la que es realitza l'EOI
VOID CkeKernel::EOIHelper( BYTE )
	{
// En els processadors d'Intel no es requereix cap operaci
	}

// **************************************************************************
// Copia una regi de memria a una altra rpidament (no es poden solapar)
// Com a entrada ha de rebre:
// Source		- Identifica l'adrea origen
// Destination	- Indica l'adrea dest
// Size			- Tamany de la zona a copiar
VOID CkeKernel::MemCopy( PBYTE pSource, PBYTE pDestination, DWORD dwSize )
	{
	while( dwSize )
		{
		*pDestination = *pSource;
		pDestination++;
		pSource++;
		dwSize--;
		}
	}

// **************************************************************************
// Copia una regi de memria a una altra, tenint en compte el solapament
// Com a entrada ha de rebre:
// Source		- Identifica l'adrea origen
// Destination	- Indica l'adrea dest
// Size			- Tamany de la zona a copiar
VOID CkeKernel::MemMove( PBYTE pSource, PBYTE pDestination, DWORD dwSize )
	{
	if( pDestination < pSource )
		{
		while( dwSize )	// Com MemCopy
			{
			*pDestination = *pSource;
			pDestination++;
			pSource++;
			dwSize--;
			}
		}
	else
		{
		while( dwSize )	// Des de posicions altes fins a baixes
			{
			*(pDestination + dwSize) = *(pSource + dwSize);
			dwSize--;
			}
		}
	}

// **************************************************************************
// Omple una zona de memria amb un cert valor
// Com a entrada ha de rebre:
// Address		- Identifica l'adrea d'origen de la zona
// Size     	- Indica el tamany de la zona
// Value			- Especifica el valor que s'ha d'utilitzar
VOID CkeKernel::MemSet( PBYTE pAddress, DWORD dwSize, BYTE cValue )
	{
	while( dwSize )
		{
		*pAddress = cValue;
		pAddress++;
		dwSize--;
		}
	}

// **************************************************************************
// Retorna el resultat de la comparaci entre dues zones de memria
// Com a entrada ha de rebre:
// Address1		- Identifica l'adrea de la primera zona
// Address2 	- Identifica l'adrea de la segona zona
// Size			- Indica el nombre de 'bytes' a comparar
LONG CkeKernel::MemCompare( PBYTE pAddress1, PBYTE pAddress2, DWORD dwSize )
	{
// Comparem fins a la primera diferncia o tota la zona
	while( *pAddress1 == *pAddress2 && dwSize > 1 )
		{
		pAddress1++;
		pAddress2++;
		dwSize--;
		}

// Si el 'byte' actual s el mateix, les zones sn idntiques
	if( *pAddress1 == *pAddress2 )
		return 0;
// sin, les zones sn diferents
	if( *pAddress1 < *pAddress2 )
		return -1;

	return 1;
	}

// **************************************************************************
// Envia un 'byte' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID CkeKernel::OutByte( WORD wPort, BYTE cValue )
	{
	outpb( wPort, cValue );
	}

// **************************************************************************
// Envia una 'word' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID CkeKernel::OutWord( WORD wPort, WORD wValue )
	{
	outpw( wPort, wValue );
	}

// **************************************************************************
// Envia un 'dword' al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Identifica el port a utilitzar
// Value    	- Indica el valor a enviar
VOID CkeKernel::OutDWord( WORD wPort, DWORD dwValue )
	{
	outpd( wPort, dwValue );
	}

// **************************************************************************
// Retorna el 'byte' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
BYTE CkeKernel::InByte( WORD wPort )
	{
	return inpb( wPort );
	}

// **************************************************************************
// Retorna la 'word' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
WORD CkeKernel::InWord( WORD wPort )
	{
	return inpw( wPort );
	}

// **************************************************************************
// Retorna el 'dword' llegit des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
DWORD CkeKernel::InDWord( WORD wPort )
	{
	return inpd( wPort );
	}

// **************************************************************************
// Escriu els 'word's cap al port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
// Address		- Adrea de memria en la que es troben les dades
// Size 			- Quantitat de 'bytes' a transferir (o words? -BUG)
VOID CkeKernel::OutWords( WORD wPort, PBYTE pAddress, DWORD dwSize )
	{
	outwords( wPort, pAddress, dwSize );
	}

// **************************************************************************
// Omple una zona amb els 'word's llegits des del port d'E/S especificat
// Com a entrada ha de rebre:
// Port 			- Indica el port a utilitzar
// Address		- Adrea de memria en la que es guarden les dades
// Size 			- Quantitat de 'bytes' a transferir (o words? -BUG)
VOID CkeKernel::InWords( WORD wPort, PBYTE pAddress, DWORD dwSize )
	{
	inwords( wPort, pAddress, dwSize );
	}

// **************************************************************************
// Afegeix una alarma al sistema
// Com a entrada ha de rebre:
// Timer			- Apuntador cap a l'objecte Timer a afegir
VOID CkeKernel::AddTimer( PCkeTimer pTimer )
	{
	DWORD index = 0;	// Comenarem a cercar del del primer element

	DWORD flags = CLI();	// No volem ser interromputs

	while( index < KERNEL_TIMERS && timer[ index ].pTimer )	// Cerquem un 'timer' lliure
		index++;

	if( timer[ index ].pTimer == NULL )
		{
		timer[ index ].pTimer = pTimer;	// Preparem la nova alarma
		timer[ index ].lMillisecs = pTimer->Time();
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( KER_OUTOFTIMERS );	// No queden alarmes lliures

	STI( flags );
	}

// **************************************************************************
// Elimina una alarma del sistema
// Com a entrada ha de rebre:
// Timer			- Apuntador cap a l'objecte Timer a eliminar
VOID CkeKernel::DestroyTimer( PCkeTimer pTimer )
	{
	DWORD index = 0;	// Comencem des del primer

	DWORD flags = CLI();

	while( index < KERNEL_TIMERS && timer[ index ].pTimer != pTimer )	// Cerquem l'alarma
		index++;

	if( timer[ index ].pTimer == pTimer )
		{
		timer[ index ].pTimer = NULL;	// Esborrem l'alarma
		timer[ index ].lMillisecs = 0;
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( KER_BADTIMER );	// L'alarma especificada no existeix

	STI( flags );
	}

// **************************************************************************
// Cridat des de l'AAL quan hi ha un 'tick' del rellotge
// Com a entrada ha de rebre:
// Millisecs	- Quantitat de milisegons que han passat des de l'ltim 'tick'
// Mode 			- Mode en el que s'est executant la tasca actual
VOID CkeKernel::TimerTick( LONG lMillisecs, BOOL bMode )
	{
// Comprovem totes les alarmes
	for( DWORD index = 0; index < KERNEL_TIMERS; index++ )
		{
		if( timer[ index ].lMillisecs > 0 )	// Tenen valor zero les alarmes lliures
			{
			timer[ index ].lMillisecs -= lMillisecs;	// Descomptem els milisegons transcorreguts

			if( timer[ index ].lMillisecs <= 0 ) // Si ha passat el temps indicat
				{
				timer[ index ].lMillisecs = timer[ index ].pTimer->Time(); // Activem l'alarma
				timer[ index ].pTimer->Release(); // Recarreguem el comptador
				}
			}
		}

	PCkeThread pthread = System->Running();	// Obtenim el flux en execuci

	if( pthread ) // Si no s el flux 'Idle'
		{
		if( bMode == MODE_KERNEL )	// Si estem en mode nucli, incrementem el temps de 'kernel'
			pthread->AddKernelTime( (DWORD) lMillisecs );
		else 	// Si estem en mode usuari, incrementem el temps de 'user'
			pthread->AddUserTime( (DWORD) lMillisecs );
		}
	else	// Estem executant el flux 'Idle', incrementem el seu temps
		idletime += (DWORD) lMillisecs;

	System->AddTickTime( (DWORD) lMillisecs );	// El sistema controla el temps total

	cquantum--;	// Ha passat una nova fracci de quantum

	if( !cquantum )	// S'ha acabat el quantum
		{
		Scheduler( TRUE ); // Planifiquem (en temps d'interrupci)
		return; // El planificador ja fa l'EOI
		}

	(System->AAL())->EOI( 0 );	// Realitzem l'EOI
	}

// **************************************************************************
// Funci cridada quan no hi ha cap flux preparat
VOID CkeKernel::Idle()
	{
	}

// **************************************************************************
// Retorna el temps que ens hem passat en la tasca 'Idle'
DWORD CkeKernel::IdleTime()
	{
	return idletime;
	}

// **************************************************************************
// Un flux vol mapejar l'espai d'adreces d'un altre flux
// Com a entrada ha de rebre:
// Thread   	- Apuntador cap al flux del qual en volem l'espai d'adreces
VOID CkeKernel::MapThreadSpace( PCkeThread pThread )
	{
// Modificar l'entrada PDBR en el TSS del flux que s'executa
	DWORD flags = CLI();
	PCTSS pctss = (System->Running())->TSS();	// TSS del flux en execuci
	DWORD pdbr = (pThread->TSS())->PDBR();	// PDBR del flux del qual en volem mapejar l'espai d'adreces

	if( pctss->PDBR() != pdbr )	// Si ja est mapejat, no perdem el temps
		{
		pctss->PDBR( pdbr );	// Seleccionem el nou PDBR tant en el TSS
		SetCR3( pdbr );		// com en el CR3 (PDBR actual)
		}

	STI( flags );
	}

// **************************************************************************
// Mapejar l'espai d'adreces d'un procs que no t cap flux (l'estem creant)
// Com a entrada ha de rebre:
// Proc     	- Procs del qual en volem l'espai d'adreces
VOID CkeKernel::MapProcessSpace( PCkeProcess pProc )
	{
// Modificar l'entrada PDBR en el TSS del flux que s'executa
	DWORD flags = CLI();
	PCTSS pctss = (System->Running())->TSS();
	DWORD pdbr = pProc->PDBR();

	if( pctss->PDBR() != pdbr )
		{
		pctss->PDBR( pdbr );
		SetCR3( pdbr );
		}

	STI( flags );
	}

// **************************************************************************
// Tornem al nostre espai d'adreces propi
VOID CkeKernel::UnmapSpace()
	{
// Modificar l'entrada PDBR en el TSS del flux que s'executa
	DWORD flags = CLI();
	PCTSS pctss = (System->Running())->TSS();
	DWORD pdbr = ((System->Running())->Process())->PDBR();

	if( pctss->PDBR() != pdbr )
		{
		pctss->PDBR( pdbr );
		SetCR3( pdbr );
		}

	STI( flags );
	}

// **************************************************************************
// Retorna el primer VAD del 'Kernel' i 'System' (sn comuns)
PCkeVAD CkeKernel::VAD()
	{
	return pvad;
	}

