/* **************************************************************************
*                                                                           *
*  Callback.CPP                                                             *
*                                                                           *
*  04-04-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la implementaci de 'CallBacks'                             *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\callback.h"
#include "errors.h"
#include "messages.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
CkeCallback::CkeCallback( PCkeMailBox pMailBox, PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeResource( pParent, sName, bTemp )
	{
	id = CID_Callback;

	pmailbox = pMailBox;
	}

// **************************************************************************
// Destructor de l'objecte
CkeCallback::~CkeCallback()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeCallback::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Callback )
		return TRUE;
	else
		return CkeResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Envia un missatge cap a la bstia de la 'callback'
VOID CkeCallback::Release()
	{
	TMSG msg;	// Preparem el missatge
	msg.dwMessage	=	SM_CALLBACK;
	msg.dwParam1	= (DWORD) this;
	msg.dwParam2	= 0;
	msg.pReply    	= NULL;

	pmailbox->PostMessage( &msg ); // Enviem el missatge
	}

// **************************************************************************
// Funcions no suportades per aquesta classe
VOID CkeCallback::Wait()
	{
	SETERRORCODE( UNSUPPORTED_FUNC );
	}

