/* **************************************************************************
*                                                                           *
*  Console.CPP                                                              *
*                                                                           *
*  04-04-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la pantalla des del 'Kernel'                                  *
*                                                                           *
************************************************************************** */

#include "kernel\console.h"
#include "errors.h"

#define PANTALLA_VGA			0xB8000L	/* Adrea de la pantalla en mode text */
// Dimensions de la pantalla en mode text
#define AMPLADA            80
#define ALCADA             25

PWORD CkeConsole::pantalla = (PWORD) PANTALLA_VGA;

// **************************************************************************
// Constructor de la classe
CkeConsole::CkeConsole()
	{
	pos_x = 0;
	pos_y = 0;
	wattrib = TEXT_NORMAL;
	}

// **************************************************************************
// Destructor de la classe
CkeConsole::~CkeConsole()
	{
	}

// **************************************************************************
// Escriu el text indicat per pantalla
// Com a entrada ha de rebre:
// str      	- Cadena de carcters a escriure
VOID CkeConsole::OutText( PSTR str )
	{
	while( *str ) // Mentre quedin carcters per a escriure
		{
		switch( *str )
			{
			case '\r':	// Retorn de carro
				pos_x = 0;
				break;

			case '\n':	// Lnia nova
				pos_y++;
				break;

			default:	// Qualsevol altre carcter
				pantalla[ pos_x + pos_y * AMPLADA ] = (WORD) (*str | wattrib);
				pos_x++;
				break;
			}

		str++; // Carcter segent de la cadena

		if( pos_x >= AMPLADA ) // Si intentem anar ms a la dreta del que permet la pantalla
				{
				pos_x = 0; // Primera columna, lnia segent
				pos_y++;
				}

		if( pos_y >= ALCADA ) // Si intentem anar ms avall del que permet la pantalla
				{
				scrollup(); // Hem de mostrar una nova lnia buida
				pos_y = ALCADA - 1; // Posici vertical = ltima lnia
				}
		}
	}

// **************************************************************************
// Selecciona la nova possici del cursor dins la pantalla
// Com a entrada ha de rebre:
// x        	- Columna desitjada
// y        	- Fila desitjada
VOID CkeConsole::GotoXY( BYTE x, BYTE y )
	{
	if( x < AMPLADA && y < ALCADA ) // Si estan dintre dels lmits, canviem la posici del cursor
		{
		pos_x = x;
		pos_y = y;
		}
	}

// **************************************************************************
// Esborra la pantalla pintant-la amb gris sobre negre
VOID CkeConsole::Clear()
	{
	// Inicialitzem la memria de pantalla (gris sobre negre)
	for( DWORD pos = 0; pos < AMPLADA * ALCADA; pos++ )
			pantalla[ pos ] = 0x700;

	pos_x = pos_y = 0; // Posici actual del cursor
	}

// **************************************************************************
// Desplaa el contingut de la pantalla una lnia cap amunt
VOID CkeConsole::scrollup()
	{
	PWORD copia = pantalla;
	WORD pos;

	// Totes les lnies menys la primera, una lnia amunt
	for( pos = 0; pos < AMPLADA * (ALCADA - 1); pos++ )
		pantalla[ pos ] = copia[ pos + AMPLADA ];

	// Nova lnia, buida
	for( pos = AMPLADA * (ALCADA - 1); pos < AMPLADA * ALCADA; pos++ )
		pantalla[ pos ] = wattrib;
	}

