/* **************************************************************************
*                                                                           *
*  CRX.CPP                                                                  *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes CCR0 i CCR3 per a la utilitzaci d'aquests registres             *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\crx.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\system.h"

// CR0

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// dwCR	- Cont el valor de CR0 inicial
CCR0::CCR0( DWORD dwCR ) : CkeType( CID_CR0 )
	{
	CR0( dwCR );
	}

// **************************************************************************
// Destructor de l'objecte
CCR0::~CCR0()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CCR0::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_CR0 )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Carrega el CR0 virtual de l'objecte al CR0 de l'i386
VOID CCR0::SetHard()
	{
	SetCR0( cr0.DWord.CR0 );
	}

// **************************************************************************
// Carrega el CR0 de l'i386 al CR0 de l'objecte
VOID CCR0::GetHard()
	{
	cr0.DWord.CR0 = GetCR0();
	}

// **************************************************************************
// Retorna el valor del CR0 de l'objecte
DWORD CCR0::CR0()
	{
	return cr0.DWord.CR0;
	}

// **************************************************************************
// Carrega un nou valor en el CR0 de l'objecte
// Com a entrada ha de rebre:
// dwCR	- Conte el valor de CR0 nou
VOID CCR0::CR0( DWORD dwCR )
	{
	cr0.DWord.CR0	= dwCR;
	}

// **************************************************************************
// Totes aquestes funcions retornen algun bit del CR0 de l'objecte

// -- Protection Enabled
BOOL CCR0::PE()
	{
	return cr0.DWord.Bits.PE;
	}

// -- Math Processor
BOOL CCR0::MP()
	{
	return cr0.DWord.Bits.MP;
	}

// -- Emulate (emulaci del coprocessador matemtic)
BOOL CCR0::EM()
	{
	return cr0.DWord.Bits.EM;
	}

// -- Task-Switched
BOOL CCR0::TS()
	{
	return cr0.DWord.Bits.TS;
	}

// -- Extension Type (0 - i387 / 1 - 80287)
BOOL CCR0::ET()
	{
	return cr0.DWord.Bits.ET;
	}

// -- Pagination
BOOL CCR0::PG()
	{
	return cr0.DWord.Bits.PG;
	}

// **************************************************************************
// Totes aquestes funcions modifiquen algun bit del CR0 de l'objecte

VOID CCR0::PE( BOOL bit )
	{
	cr0.DWord.Bits.PE	= bit;
	}

VOID CCR0::MP( BOOL bit )
	{
	cr0.DWord.Bits.MP	= bit;
	}

VOID CCR0::EM( BOOL bit )
	{
	cr0.DWord.Bits.EM	= bit;
	}

VOID CCR0::TS( BOOL bit )
	{
	cr0.DWord.Bits.TS	= bit;
	}

VOID CCR0::ET( BOOL bit )
	{
	cr0.DWord.Bits.ET	= bit;
	}

VOID CCR0::PG( BOOL bit )
	{
	cr0.DWord.Bits.PG	= bit;
	}


// CR3

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// dwCR	- Cont el valor de CR3 inicial
CCR3::CCR3( DWORD dwCR ) : CkeType( CID_CR3 )
	{
	CR3( dwCR );
	}

// **************************************************************************
// Destructor de l'objecte
CCR3::~CCR3()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CCR3::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_CR3 )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Carrega el CR3 de l'objecte al CR3 de l'i386
VOID CCR3::SetHard()
	{
	SetCR3( cr3.DWord.CR3 );
	}

// **************************************************************************
// Carrega el CR3 de l'i386 al CR3 de l'objecte
VOID CCR3::GetHard()
	{
	cr3.DWord.CR3 = GetCR3();
	}

// **************************************************************************
// Retorna el valor del CR3 de l'objecte
DWORD CCR3::CR3()
	{
	return cr3.DWord.CR3;
	}

// **************************************************************************
// Assigna un nou valor al CR3 de l'objecte
// Com a entrada ha de rebre:
// dwCR	- Cont el valor de CR3 nou
VOID CCR3::CR3( DWORD dwCR )
	{
	cr3.DWord.CR3	= dwCR;
	}

// **************************************************************************
// Retorna l'adrea fsica del directori de pgines
DWORD CCR3::PDBR()
	{
	return cr3.DWord.Bits.PDBRLo + (((DWORD) cr3.DWord.Bits.PDBRHi) << 16);
	}

// **************************************************************************
// Selecciona l'adrea fsica del nou directori de pgines
// Com a entrada ha de rebre:
// dwPDBR	- Adrea fsica del directori de pgines
VOID CCR3::PDBR( DWORD dwPDBR )
	{
	cr3.DWord.Bits.PDBRLo	= (WORD) dwPDBR;
	cr3.DWord.Bits.PDBRHi	= (WORD) (dwPDBR >> 16);
	}

