/* **************************************************************************
*                                                                           *
*  Debug.CPP                                                                *
*                                                                           *
*  17-01-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a ajudar a la depuraci del sistema i dels programes          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\debug.h"
#include "errors.h"
#include "string.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
CkeDebug::CkeDebug() : CkeType( CID_Debug )
	{
	}

// **************************************************************************
// Destructor de l'objecte
CkeDebug::~CkeDebug()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeDebug::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Debug )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Realitza la comprovaci de tipus en temps d'execuci
// Com a entrada ha de rebre:
// Type     	- Objecte sobre el qual es fa la comprovaci
// id       	- Identificador esperat
// Error    	- Cadena de caracters que s'ha d'enviar en cas d'error
VOID CkeDebug::CheckPanic( PCkeType pType, CUID id, PSTR sError )
	{
	if( pType->ClassID() != id )
		Trace( sError );
// Hauria d'aturar l'execuci? -BUG
	}

// **************************************************************************
// Realitza la funci de traa
// Com a entrada ha de rebre:
// str      	- Cadena de caracters que s'ha d'enviar
VOID CkeDebug::Trace( PSTR str )
	{
	(System->Console())->OutText( str );	// Presenta el text per pantalla
	(System->Console())->OutText( TEXT( "\r\n" ) );

#ifdef _DEBUG
#ifndef _FAST_DEBUG
	for( DWORD pausa = 0L; pausa < 0x2000000; pausa++ );
	for( DWORD pausa = 0L; pausa < 0x2000000; pausa++ );
#else
	for( DWORD pausa = 0L; pausa < 0x1000000; pausa++ );
#endif
#endif
	}

// **************************************************************************
// Presenta una certa zona de la memria
// Com a entrada ha de rebre:
// Address  	- Adrea de memria on comena el volcat
// Size     	- 'Bytes' que volem volcar
VOID CkeDebug::MemoryDump( PBYTE pAddress, DWORD dwSize )
	{
	CHAR lin[ 82 ], str[ 10 ];
	dwSize = ROUND_UP( dwSize, 0x10 ); // En mltiples de 16 'bytes'

	for( DWORD pos = 0; pos < dwSize / 0x10; pos++ )
		{
		// Primer l'adrea
		sprintf( lin, TEXT( "%08x " ), (DWORD) (pAddress + pos * 16) );

		for( DWORD sub = 0; sub < 0x10; sub++ )
			{ // Cada un dels 'bytes' del bloc de 16 'bytes'
			sprintf( str, TEXT( "%02x " ), (DWORD) pAddress[ pos * 16 + sub ] );
			strcat( lin, str );
			}

		for( DWORD sub = 0; sub < 16; sub++ )
			{ // Els carcters que son alfanumrics es presenten tamb
			if( isalpha( (CHAR) pAddress[ pos * 16 + sub ] ) )
				sprintf( str, TEXT( "%c" ), (CHAR) pAddress[ pos * 16 + sub ] );
			else // Els carcters de control es presenten com un punt
				sprintf( str, TEXT( "." ) );

			strcat( lin, str );
			}

		strcat( lin, TEXT( "\r\n" ) ); // Nova lnia
		(System->Console())->OutText( lin );	// Presenta el text per pantalla
		}
	 }

