/* **************************************************************************
*                                                                           *
*  Gate.CPP                                                                 *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les portes en general                           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\gate.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// pDescr	- Apunta al descriptor de la CallGate
CGate::CGate( PTDescriptor pDescr ) : CDescriptor( pDescr )
	{
	id	= CID_Gate;
	}

// **************************************************************************
// Destrueix l'objecte
CGate::~CGate()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CGate::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Gate )
		return TRUE;
	else
		return CDescriptor::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nombre de dobles paraules que pren com a parmetres
BYTE CGate::Params()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return ((PTGate) pdesc)->Flags.Bits.Params;
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Retorna el selector amb el que est relacionada la CallGate
WORD CGate::Selector()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return ((PTGate) pdesc)->Selector;
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Retorna l'offset dintre del selector on comena la rutina
DWORD CGate::Offset()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return ((PTGate) pdesc)->OffsetLo + (((DWORD) ((PTGate) pdesc)->OffsetHi) << 16);
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Prepara l'objecte per a utilitzar p dobles paraules com a parmetres
// Com a entrada ha de rebre:
// p	- Nombre de dobles paraules que formen els parmetres
VOID CGate::Params( BYTE p )
	{
	if( binitialized )
		{
		((PTGate) pdesc)->Flags.Bits.Params = p;
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara l'objecte per a utilitzar el selector s
// Com a entrada ha de rebre:
// s	- Selector que s'ha de buscar per a executar la crida
VOID CGate::Selector( WORD s )
	{
	if( binitialized )
		{
		((PTGate) pdesc)->Selector = s;
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara l'objecte per a utilitzar off com a nou offset dins el selector
// Com a entrada ha de rebre:
// off	- Offset dins el selector on esta la rutina
VOID CGate::Offset( DWORD off )
	{
	if( binitialized )
		{
		((PTGate) pdesc)->OffsetLo = (WORD) off;
		((PTGate) pdesc)->OffsetHi = (WORD) (off >> 16);
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara el descriptor
// Com a entrada ha de rebre:
// Desc	- Apuntador cap al descriptor
VOID CGate::Descriptor( PTDescriptor pDesc )
	{
	CDescriptor::Descriptor( pDesc );
	}

