/* **************************************************************************
*                                                                           *
*  Interrup.CPP                                                             *
*                                                                           *
*  13-03-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Rutines de servei d'interrupci (del 'kernel')                           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\interrup.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\kernel.h"
#include "string.h"
#include "kernel\system.h"
#include "kernel\callnum.h"
#include "kernel\mem.h"

extern PCkeKernel _export Kernel;
extern DWORD _export Mode;
#ifdef _DEBUG
extern DWORD DebugLevel;
#endif
extern BOOL bSpecialMemory;

// **************************************************************************
// Per a totes les interrupcions no assignades a cap funci, s'utilitza aquesta
VOID Reserved( BYTE cInterrupt )
	{
	DWORD point = System->Interrupt( cInterrupt );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			{
			CHAR str[ 80 ];
			sprintf( str, TEXT( "S'ha rebut la interrupci %u i el sistema no pot continuar" ), (WORD) cInterrupt );
			System->Panic( str );
			}
		}
	}

// **************************************************************************
// Excepci de divisi per zero
VOID Division()
	{
#ifdef _DEBUG
	TRACE( TEXT( "DivisionInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_DIVISION );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha intentat dividir per zero i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de 'trap' de depuraci pas a pas
VOID Trap()
	{
#ifdef _DEBUG
	TRACE( TEXT( "TrapInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_TRAP );

	if( point )
		Call( point );
//	else
//		Continuar el flux que ha provocat la interrupci
	}

// **************************************************************************
// Interrupci no enmascarable
VOID NMI()
	{
#ifdef _DEBUG
	TRACE( TEXT( "NMIInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_NMI );

	if( point )
		Call( point );
	else
//		Aturar l'ordinador
		System->Panic( TEXT( "S'ha rebut una NMI i no es pot continuar" ) );
	}

// **************************************************************************
// Excepci de depuraci
VOID DebugInt()
	{
#ifdef _DEBUG
	TRACE( TEXT( "DebugInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_DEBUG );

	if( point )
		Call( point );
//	else
//		Continuar el flux que ha provocat la interrupci
	}

// **************************************************************************
// Excepci de desbordament
VOID Overflow()
	{
#ifdef _DEBUG
	TRACE( TEXT( "OverflowInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_OVERFLOW );

	if( point )
		Call( point );
//	else
//		Continuar el flux que ha provocat la interrupci
	}

// **************************************************************************
// Excepci de sortida de lmits
VOID Bound()
	{
#ifdef _DEBUG
	TRACE( TEXT( "BoundInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_BOUND );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha provocat una excepci de lmit (BOUND) i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de codi d'operaci erroni
VOID Opcode()
	{
#ifdef _DEBUG
	TRACE( TEXT( "OpcodeInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_OPCODE );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{
			CHAR str[ 150 ];
			sprintf( str, TEXT( "El flux de %s (%08x) ha intentat executar una instrucci no reconeguda pel processador i no pot continuar." ), (pthread->Process())->Name(), pthread );
			System->Panic( str );
			delete pthread;
			}
		else
			System->Panic( TEXT( "El sistema ha intentat executar una instrucci no reconeguda pel processador i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci del processador matemtic
VOID MathProcessor()
	{
#ifdef _DEBUG
	TRACE( TEXT( "MathProcessorInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_MATHPROCESSOR );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{
			CHAR str[ 150 ];
			sprintf( str, TEXT( "Un flux de %s (%08xh) ha provocat una interrupci del processador matemtic i no pot continuar." ), (pthread->Process())->Name(), pthread );
			System->Panic( str );
			delete pthread;
			}
		else
			System->Panic( TEXT( "El sistema ha provocat un error d'emulaci del coprocessador matemtic i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de doble falta
VOID DoubleFault()
	{
#ifdef _DEBUG
	TRACE( TEXT( "DoubleFaultInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_DOUBLEFAULT );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{
			CHAR str[ 150 ];
			sprintf( str, TEXT( "Un flux de %s (%08xh) ha provocat una doble falta i no pot continuar." ), (pthread->Process())->Name(), pthread );
			System->Panic( str );
			delete pthread;
			}
		else
			System->Panic( TEXT( "El sistema ha provocat una doble falta i no pot continuar." ) );
		}
	}

// **************************************************************************
// Excepci de segment del processador matemtic
VOID MathProcSegment()
	{
#ifdef _DEBUG
	TRACE( TEXT( "MathProcSegmentInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_MATHPROCSEGMENT );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha provocat un error de segment en el coprocessador matemtic i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de TSS incorrecte
VOID BadTSS( DWORD /* zero */ )
	{
#ifdef _DEBUG
	TRACE( TEXT( "BadTSSInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_BADTSS );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{
			System->Panic( TEXT( "Un flux ha provocat un error en un canvi de context i no pot continuar" ) );
			delete pthread;
			}
		else
			System->Panic( TEXT( "El sistema ha provocat un error en un canvi de context i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de segment no present
VOID Segment( DWORD )
	{
#ifdef _DEBUG
	TRACE( TEXT( "SegmentInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_SEGMENT );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha provocat un error en intentar accedir a un segment no present i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de pila
VOID StackException( DWORD )
	{
#ifdef _DEBUG
	TRACE( TEXT( "StackExceptionInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_STACK );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha provocat un error en la pila i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de protecci general
VOID GPFault( DWORD Error )
	{
#ifdef _DEBUG
	TRACE( TEXT( "GPFaultInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_GENERALPROT );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{
			CHAR str[ 150 ];
			sprintf( str, TEXT( "El flux de %s (%08x) ha provocat un error de protecci general i no pot continuar. El codi d'error s: %X" ), (pthread->Process())->Name(), pthread, Error );
			System->Panic( str );
			delete pthread;
			}
		else
			{
			CHAR str[ 110 ];
			sprintf( str, TEXT( "El sistema ha provocat un error de protecci general i no pot continuar\r\nEl codi d'error s: %X" ), Error );
			System->Panic( str );
			}
		}
	}

// **************************************************************************
// Excepci de fallada de pgina
VOID PageFault( DWORD Error )
	{
#ifdef _DEBUG
	TRACE( TEXT( "PageFaultInterrupt!" ) );
#ifdef _FAST_DEBUG
	for( DWORD p = 0; p < 0x4000000; p++ );
#endif
#endif
	DWORD point = System->Interrupt( SYSINT_PAGE );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			{	// -BUG
			CHAR str[ 150 ];
			sprintf( str, TEXT( "El flux de %s (%08x) ha provocat una fallada de pgina i no pot continuar. El codi d'error s: %X" ), (pthread->Process())->Name(), pthread, Error );
			System->Panic( str );
			delete pthread;
			}
		else
			{
			CHAR str[ 100 ];
			sprintf( str, TEXT( "El sistema ha provocat una fallada de pgina i no pot continuar\r\nEl codi d'error s: %X" ), Error );
			System->Panic( str );
			}
		}
	}

// **************************************************************************
// Excepci d'error del processador matemtic
VOID MathProcError()
	{
#ifdef _DEBUG
	TRACE( TEXT( "MathProcErrorInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_MATHPROCERROR );

	if( point )
		Call( point );
	else
		{
//		Destruir el flux que ha provocat la interrupci
		PCkeThread pthread = System->Running();

		if( pthread )
			delete pthread;
		else
			System->Panic( TEXT( "El sistema ha provocat un error en el coprocessador matemtic i no pot continuar" ) );
		}
	}

// **************************************************************************
// Excepci de dades no alineades
VOID Unalignment()
	{
#ifdef _DEBUG
	TRACE( TEXT( "UnalignmentInterrupt!" ) );
#endif
	DWORD point = System->Interrupt( SYSINT_UNALIGNMENT );

	if( point )
		Call( point );
//	else
//		Continuar el flux que ha provocat la interrupci
	}

// **************************************************************************
// Interrupci de crida al sistema
// Com a entrades ha de rebre:
// eax		- Codi de la crida al sistema
// ebx		- Primer parmetre de la funci
// ecx		- Segon parmetre de la funci
DWORD SystemCall( DWORD eax, DWORD ebx, DWORD ecx )
	{
	switch( eax )
		{
		case SYSCALL_FINDOBJECT: // Cercar l'objecte amb nom: ebx
			return (DWORD) System->FindObject( (PSTR) ebx );

		case SYSCALL_CREATEMAILBOX: // Crear una bstia en la memria global
			{
			DWORD flags = CLI();
			bSpecialMemory = TRUE;
			DWORD pos = (DWORD) new CkeMailBox( (PCkeObject) ecx, (PSTR) ebx );
			bSpecialMemory = FALSE;
			STI( flags );
			return pos;
			}

		case SYSCALL_DESTROYMAILBOX: // Destruir la bstia
			delete( (PCkeObject) ebx );
			break;

		case SYSCALL_POSTMESSAGE: // Enviar un missatge a una bstia
			((PCkeMailBox) ebx)->PostMessage( (PTMSG) ecx );
			break;

		case SYSCALL_WAITMESSAGE: // Esperar un missatge
			return ((PCkeMailBox) ebx)->WaitMessage( (PTMSG) ecx );

		case SYSCALL_PEEKMESSAGE: // Comprovar missatges
			return ((PCkeMailBox) ebx)->PeekMessage( (PTMSG) ecx );

		case SYSCALL_WAITINGMESSAGES: // Obtenir el compte de missatges d'una bstia
			return ((PCkeMailBox) ebx)->WaitingMessages();

		case SYSCALL_MALLOC: // Reservar ebx 'bytes' de memria
			return (DWORD) malloc( ebx );

		case SYSCALL_FREE: // Alliberar l'element ebx
			free( (PVOID) ebx );
			break;

		case SYSCALL_GETRUNNINGTHREAD: // Obtenir el flux en execuci
			return (DWORD) System->Running();

		case SYSCALL_WAITRESOURCE: // Esperar a un recurs
			((PCkeResource) ebx)->Wait();
			break;

		case SYSCALL_RELEASERESOURCE: // Alliberar un recurs
			((PCkeResource) ebx)->Release();
			break;

		default: // Qualsevol altra crida s errnia
				TRACE( TEXT( "SystemCall amb parmetres erronis" ) );
		}

	return 0;
	}

